
#define NON_PORTABLE
#include <HwrMiscFlags.h>
#undef NON_PORTABLE

#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include "memmap.h"
#include "printf.h"
#include "entry.h"
#include "misc.h"
#include "heap.h"



bool hwMaybeGetRomToken(uint32_t name, const void **dataP, uint16_t *szP)
{
	return false;
}

void hwGetMiscFlags(uint16_t *miscFlagsP, uint16_t *extMiscFlagsP)
{
	if (miscFlagsP)
		*miscFlagsP = hwrMiscFlagHasMiscFlagExt | hwrMiscFlagHasCradleDetect | hwrMiscFlagNoRTCBug | hwrMiscFlagHasMbdIrDA;
	
	if (extMiscFlagsP)
		*extMiscFlagsP = hwrMiscFlagExt115KIrOK | hwrMiscFlagExtHasLiIon;
}

void machInit(uint32_t stage, const void* data)
{
	if (stage == STAGE_SETUP_HEAPS) {
		
		loge("initing our heap\n");
		
		kheapRegisterHeap(HAL_STATIC_MEM_BASE, HAL_STATIC_MEM_SIZE, MEM_USABLE_AS_STACK | MEM_USABLE_FOR_DMA | MEM_USABLE_FOR_EXEC | MEM_FAST);
	}
}

int32_t cpuGetClockRate(enum ClockRateDevice dev)
{
	switch (dev) {
		case CpuClockRate:
		case TimerClockRate:
			return CPU_CLOCK_RATE;
		
		default:
			return-1;
	}
}

bool hwPwrCtl(uint32_t selector, const uint32_t *newValP, uint32_t *oldValP)
{
	return false;
}

Err machinePaceDispatch(EmulStateRef ref, uint16_t call, Err *ret68kP)
{
	return sysErrNotAllowed;
}


