#ifndef _HW_CPU_H_
#define _HW_CPU_H_

#include "CortexEmuCpu.h"
#include "hw/CortexEmu/osTimerIface.h"

#define SYSTICK_CLOCKS_PER_TIMER_TICK					16384							//better be a constant power of 2 or else bad bad bad slow int64 division
#define CPU_CLOCK_RATE									8192000
#define TIMER_TICKS_PER_MSEC							((CPU_CLOCK_RATE + 500) / 1000)

#define CPU_NUM_IRQS									16

static inline void cpuPutchar(char ch)
{
	*(volatile char*)0x4fffffff = (uint8_t)ch;
}

#endif
