
//should match what entry.c for this machien actually configures

#ifdef LIVE_IN_HIGH_RAM
	#define ALL_RAM_BASE	0xd0000000
#else
	#define ALL_RAM_BASE	0x70000000
#endif

#define CPU_HARDWIRED_UI_THREAD_JIT_TC_BASE		(ALL_RAM_BASE + 0x00000000)
#define CPU_HARDWIRED_UI_THREAD_JIT_TC_SIZE		0x00020000

#ifdef HUGE_DYN_RAM
	#define CPU_DYN_RAM_BASE						(ALL_RAM_BASE + 0x00020000)
	#define CPU_DYN_RAM_SIZE						0x009E0000	//10M - 128K
	
	#define CPU_STORAGE_RAM_BASE					(ALL_RAM_BASE + 0x00A00000)
	#define CPU_STORAGE_RAM_SIZE					0x00200000	//2M
#else
	#define CPU_DYN_RAM_BASE						(ALL_RAM_BASE + 0x00020000)
	#define CPU_DYN_RAM_SIZE						0x00260000	//2.5M - 128K
	
	#define CPU_STORAGE_RAM_BASE					(ALL_RAM_BASE + 0x00280000)
	#define CPU_STORAGE_RAM_SIZE					0x00980000	//9.5M
#endif

#define CPU_ROM_BASE							(ALL_RAM_BASE + 0x00C00000)	//we relocate it there
#define CPU_ROM_SIZE							0x00400000

#define CPU_HARDWIRED_VRAM_ADDR					0x20010000
#define CPU_HARDWIRED_VRAM_SIZE					0x0012C000	//enough for 3x with dia or 4x without dia

#define HAL_STATIC_MEM_BASE						0x2013C000
#define HAL_STATIC_MEM_SIZE						0x00044000

