#ifndef _PALMCARD_H_
#define _PALMCARD_H_


#include <stdbool.h>
#include <stdint.h>

#ifndef _ISLOCAL_
	#define _ISLOCAL_
#endif

bool palmcardSdioSetup(uint8_t *firstFreeSmP, uint8_t *firstFreePioInstrP, uint8_t *firstFreeDmaChP, uint8_t nDmaCh, uint8_t nPioSms, uint8_t nPioInstrs);
bool palmcardIrSetup(uint8_t *firstFreeSmP, uint8_t *firstFreePioInstrP, uint8_t *firstFreeDmaChP, uint8_t nDmaCh, uint8_t nPioSms, uint8_t nPioInstrs);


enum SdReadRet {
	SdReadOK,
	SdReadTimeout,
	SdReadCrcErr,
	SdReadFramingError,
};

enum SdWriteRet {
	SdWriteOK,
	SdWriteCrcError,
	SdWriteCardError,
	SdWriteDataTxTimeout,
	SdWriteFramingError,
	SdWriteBusyTimeout,
};

enum SdCmdRet {
	SdCmdOK,
	SdCmdRespTimeout,
	SdCmdRespCrcErr,
};

//exported by sdio module
typedef void (*RepalmSdioInsertNotifCbk)(bool isInsertedNow);
_ISLOCAL_ uint32_t repalmSdioSetSpeed(uint32_t newMaxRate);
_ISLOCAL_ enum SdCmdRet repalmSdioCmd(uint_fast8_t cmd, uint32_t param, uint8_t *replyOutP, uint_fast8_t nReplyBits, bool doCrcCheck);
_ISLOCAL_ bool repalmSdioBusyWait(uint32_t maxClocks);
_ISLOCAL_ enum SdReadRet repalmSdioDataRx(uint8_t* dst, uint32_t nBlocks, uint32_t blockSz, uint32_t maxClocksPerBlock);
_ISLOCAL_ enum SdWriteRet repalmSdioDataTx(const uint8_t* src, uint32_t nBlocks, uint32_t blockSz, uint32_t maxClocksPerBlock);
_ISLOCAL_ bool repalmSdioInsertNotifCfg(RepalmSdioInsertNotifCbk cbk);	//also returns current state

//exported by IrDA (IR) and palmcardComms(UART) for serial comms
enum UartPort {
	UartPortCradleSerial,
	UartPortIrDA,
};

union UartCfg {
	struct {
		uint32_t baudrate	:24;
		uint32_t charBits	:2;	//{5,6,7,8}
		uint32_t stopBits	:2;	//{0.5, 1, 1.5, 2}
		uint32_t parEna		:1;
		uint32_t parEven	:1;
		uint32_t rxEn		:1;	//this and next off for port OFF
		uint32_t txEn		:1;
	};
	uint32_t raw32;
};
#define UART_BIT_MASK_PAR_ERR		0x0100
#define UART_BIT_MASK_BRK_RXED		0x0200
#define UART_BIT_MASK_FRM_ERR		0x0400
#define UART_BIT_MASK_RX_OVERRUN	0x0800

#define UART_STA_BIT_TX_FIFO_EMPTY	0x00000001
#define UART_STA_BIT_TX_FIFO_FULL	0x00000002
#define UART_STA_BIT_RX_FIFO_EMPTY	0x00000004

typedef void (*RepalmUartRxF)(void *userData, uint16_t *rawBuf, uint32_t nItems);
_ISLOCAL_ bool repalmUartConfig(enum UartPort which, union UartCfg *cfg, RepalmUartRxF rxf, void *userData);		//cfg modified to what you got
_ISLOCAL_ uint32_t repalmUartTx(enum UartPort which, const uint8_t *data, uint32_t len, bool block);				//call with NULL data and nonzero len to send break, NULL data and zero len to stop break
_ISLOCAL_ uint32_t repalmUartGetSta(enum UartPort which);

_ISLOCAL_ void palmcardFlashSpiAccess(const uint8_t *tx, uint8_t *rx, uint32_t nBytes);


//power control
bool repalmDalPwrCtl(uint32_t sel, const uint32_t *newV, uint32_t *oldP);
#define PWR_SEL_SD_CARD				0


#endif

