#ifndef _PALMCARD_COMMS_H_
#define _PALMCARD_COMMS_H_

#include "palmcard.h"
#include <stdbool.h>
#include <stdint.h>


void palmcardCommsInit(uint8_t *firstFreeSmP, uint8_t *firstFreePioInstrP, uint8_t *firstFreeDmaChP, uint8_t nDmaCh, uint8_t nPioSms, uint8_t nPioInstrs);		//only when irqs are already available

void palmcardCommsSetScreenDataPtr(const void *data, uint32_t numPixels, uint_fast8_t bpp);

void palmcardCommsUpdateIrqSta(uint_fast16_t mIrqsToSet, uint_fast16_t mIrqsToClear);
uint_fast16_t palmcardCommsGetPendingIrqs(void);

uint_fast16_t palmcardCommsGetDeviceState(void);			//may not have been received by the other side yet, no way to know when it will be unless you also send an irq
void palmcardCommsSetDeviceState(uint_fast16_t newState);

//hw flags
uint16_t palmcardCommsGetHwFlags(void);						//negative if no report has been RXed, else the report, which may or may not include PCC_HW_IDENTIFIED

//uart comms
bool palmcardCommsSerialConfig(union UartCfg *cfg, RepalmUartRxF rxf, void *userData);		//cfg modified to what you got
uint32_t palmcardCommsSerialTx(const uint8_t *data, uint32_t len, bool block);
uint32_t palmcardCommsSerialGetSta(void);

//simple sound
void palmcardCommsSendSimpleSoundReq(uint16_t freq, uint16_t amp);

//power
void palmcardCommsSleep(void);	//when this returns, 68k should be asleep

//externally provided
void palmcardCommsExtPenReport(int16_t x, int16_t y);
void palmcardCommsExtBtnReport(uint_fast8_t state);
void palmcardCommsExtBattReport(uint16_t sample, uint16_t Vref);
void palmcardCommsExtNeedAudioData(uint16_t *dst);


#endif
