#define CPU_ROM_BASE							0x10040000	//4MB of ROM (in ram) after a 256KB loader NOT in palmos format (and thus we cannot tell palmos about it)
#define CPU_ROM_SIZE							0x003c0000

#define CPU_FLASH_1_BASE						0xb0000000	//32M of flash in the cpu
#define CPU_FLASH_1_SIZE						0x02000000
#define CPU_FLASH_1_PA							0x00000000

#define CPU_FLASH_2_BASE						0xb2000000	//32M of flash external to the cpu. we always map this much. what we report is another story
#define CPU_FLASH_2_SIZE						0x02000000
#define CPU_FLASH_2_PA							0x04000000

#define CPU_DYN_RAM_BASE						0x28000000	//12M of dyn ram
#define CPU_DYN_RAM_SIZE						0x00c00000
#define CPU_DYN_RAM_PA							0xa0100000

#define CPU_STORAGE_RAM_BASE					0x30000000	//51M of storage ram. we always map this much. what we report is another story
#define CPU_STORAGE_RAM_SIZE					0x03300000
#define CPU_STORAGE_RAM_PA						0xa0d00000

#define CPU_HARDWIRED_VRAM_ADDR					0x70000000	//320x240*2 plus clut 256x2 slop
#define CPU_HARDWIRED_VRAM_SIZE					0x00030000
#define CPU_HARDWIRED_VRAM_PA					0xa0000000

#define CPU_CACHE_CLEAN_BASE					0xf0000000	//mapped to nowhere
#define CPU_CACHE_CLEAN_SIZE					0x00100000
#define CPU_CACHE_CLEAN_PA						0xf0000000

#define CPU_MINIDCACHE_CLEAN_BASE				0xf0100000	//mapped to rom so we can not waste ram
#define CPU_MINIDCACHE_CLEAN_SIZE				0x00100000
#define CPU_MINIDCACHE_CLEAN_PA					0x00000000

#define CPU_PAGETABLE_BASE						0xffff0000	//vectors (first page), pagetables (last 32K)
#define CPU_PAGETABLE_SIZE						0x00010000
#define CPU_PAGETABLE_PA						0xa00f0000

#define CPU_DMA_MEM_START						0x00004000	//in the above area
#define CPU_DMA_MEM_SIZE						0x00004000

#define CPU_KERNEL_GLOBALS_BASE					0xfff00000
#define CPU_KERNEL_GLOBALS_SIZE					0x000a0000
#define CPU_KERNEL_GLOBALS_PA					0xa0050000

#define CPU_SLEEP_STATE_BASE					0xf0f0f000
#define CPU_SLEEP_STATE_SIZE					0x00001000
#define CPU_SLEEP_STATE_PA						0xa0031000

//for identity map at bringup
#define CPU_IDENT_MAP_1_BASE					0xa0000000
#define CPU_IDENT_MAP_1_SIZE					0x04000000

#define CPU_IDENT_MAP_2_BASE					0x00000000
#define CPU_IDENT_MAP_2_SIZE					0x02000000

//Phys mem:
//0x00000000 + 0x00030000 = VRAM
//0x00030000 + 0x00001000 = dcache cleaning address
//0x00031000 + 0x00001000 = sleep state
//0x00032000 + 0x0001f000 = <FREE>
//0x00050000 + 0x000a0000 = KERNEL GLOBALS
//0x000f0000 + 0x00010000 = PAGETABLE + VECTORS + DMA REGION
//0x00100000 + 0x00c00000 = DYN RAM
//0x00d00000 + 0x03300000 = STORE RAM


//0xA0031000 = sleep page

