//should match what entry.c for this machine actually configures

#define CPU_HARDWIRED_UI_THREAD_JIT_TC_BASE		0x20000000	//SRAM1 is TC for UI thread (almost all 160K of it)
#define CPU_HARDWIRED_UI_THREAD_JIT_TC_SIZE		0x00027D00	//we save 378 bytes for fast callouts

#define CPU_STORAGE_RAM_BASE					0x60200000
#define CPU_STORAGE_RAM_SIZE					0x00600000	//6M

#define CPU_HARDWIRED_VRAM_ADDR					0x60000000

#ifdef FAKE_HI_RES

	#define CPU_HARDWIRED_VRAM_SIZE					0x00044800	//enough to fit 320x320x2, rounded up to 0x38000 PLUS 160x160x2 (for resizing dest)
	#define CPU_HARDWIRED_VTMP1_SIZE				0x000190D0	//for screen compression/swapping, must fit: visor screen * (257+256) / 256 + 1
	#define CPU_HARDWIRED_VTMP2_SIZE				0x00032000	//for screen change detection, must fit framebuffer

#else

	#define CPU_HARDWIRED_VRAM_SIZE					0x0000E000	//enough to fit 160x160x2
	#define CPU_HARDWIRED_VTMP1_SIZE				0x000190D0	//for screen compression/swapping, must fit: visor screen * (257+256) / 256 + 1
	#define CPU_HARDWIRED_VTMP2_SIZE				0x0000C800	//for screen change detection, must fit framebuffer
	
#endif


#define CPU_HARDWIRED_VTMP1_SPACE				(CPU_HARDWIRED_VRAM_ADDR + CPU_HARDWIRED_VRAM_SIZE)
#define CPU_HARDWIRED_VTMP2_SPACE				(CPU_HARDWIRED_VTMP1_SPACE + CPU_HARDWIRED_VTMP1_SIZE)
#define CPU_DYN_RAM_BASE						(CPU_HARDWIRED_VTMP2_SPACE + CPU_HARDWIRED_VTMP2_SIZE)
#define CPU_DYN_RAM_SIZE						(CPU_STORAGE_RAM_BASE - CPU_DYN_RAM_BASE)

#define CPU_ROM_BASE							0x08000000	//2MB of ROM in flash
#define CPU_ROM_SIZE							0x00200000

//DAL's .data and .bss live in SRAM2:			0x20027D00 and are 16K+768b (in sram 1 for fast callouts)

#define HAL_STATIC_MEM_BASE						0x2002C000	//executable, stack usable
#define HAL_STATIC_MEM_SIZE						0x00023FFC	//144K - 4 bytes that we use for mailboxs

#define HAL_CCM_MEM_BASE						0x10000000	//nonexecutable, stack usable
#define HAL_CCM_MEM_SIZE						0x00010000	//64K

//for disp
#define DISP_MPU_REG							6
void mpuRegCfg(uint32_t idx, uint32_t addr, uint32_t cfg);
