#ifndef _HW_CPU_H_
#define _HW_CPU_H_

#include "stm32f429xx.h"


#define MPU_RASR_ENA_Msk MPU_RASR_ENABLE_Msk		//arm renamed it



#define SYSTICK_CLOCKS_PER_TIMER_TICK					2								//better be a constant power of 2 or else bad bad bad slow int64 division
#define CPU_CLOCK_RATE									192000000
#define TIMER_TICKS_PER_MSEC							((CPU_CLOCK_RATE + 500) / 1000)


#define CPU_NUM_IRQS									91

static inline void cpuPutchar(char ch)
{
	volatile uint32_t* buf = (volatile uint32_t*)0x2002FFFC;
	uint32_t maxWait = 1000000;
	
	while ((buf[0] & 0x80000000) && maxWait--);
	buf[0] = 0x80000000 | (uint8_t)ch;
}



#endif
