#ifndef _HW_CPU_H_
#define _HW_CPU_H_

#include "platform.h"
#include "xscale.h"



#define CPU_CLOCK_RATE									400000000
#define TIMER_TICKS_PER_MSEC							(3686)
#define CPU_NUM_IRQS									(32 + 90 - 2)	//irqs + gpios

#define SYSTICK_CLOCKS_PER_TIMER_TICK					1		//timekeeping and interrupt timer at same rate

//t3 debugs via hwuart


static inline void cpuPutcharEx(char ch)
{
	struct PxaUart *uart = platPeriphP2V(PXA_BASE_HWUART);
	
	
	while (!(uart->LSR & 0x20));	//wait for TDRQ
	uart->THR = ch;
}

static inline void cpuPutchar(char ch)
{
	if (ch == '\n')
		cpuPutcharEx('\r');
	
	cpuPutcharEx(ch);
}

#endif
