#ifndef _K_IRQS_H_
#define _K_IRQS_H_

#include <stdint.h>
#include "dal.h"

typedef uint8_t irq_state_t;


static inline irq_state_t irqsAllOff(void)
{
	return 0;	
}

static inline irq_state_t irqsAllOn(void)
{
	return 0;	
}

static inline void irqsRestoreState(irq_state_t sta)
{
	(void)sta;	
}

static inline bool cpuIrqGetHandler(uint32_t irqNo, HalIrqHandlerF *curHandlerP, void** curUserDataP) { return false; } 
static inline bool cpuIrqSetHandler(uint32_t irqNo, HalIrqHandlerF newHandler, void* newUserData) { return false; } 
static inline bool cpuIrqSetState(uint32_t irqNo, bool on) { return false; } 

#define CPU_NUM_IRQS									1	//why not?




#endif
