#ifndef _KERNEL_H_
#define _KERNEL_H_

#include <stdint.h>
#include "kernelCommon.h"
#include "hyper.h"
#include "mach.h"


#define KERN_MAILBOX_STORAGE_NEEDS(depth)	4			//we do not use user-allocted storage in the virtual world (we could, but it is easier not to)

kstatus_t KTaskGetTid(tid_t* tidOutP);
kstatus_t KTaskGetInfo(tid_t tid, struct KernTaskInfo* ti);
kstatus_t KTaskCreate(uint32_t tag, void* pc, void* stackMem, uint32_t stackSz, void* exinf, uint16_t prio, bool priv, tid_t* tidOutP);
kstatus_t KTaskDestroy(tid_t tid);
kstatus_t KTaskStart(tid_t tid, void* param);
kstatus_t KTaskSuspend(tid_t tid);		//XXXX: PalmOS kernel allows nestes suspends (like recursive mutex)
kstatus_t KTaskResume(tid_t tid);
kstatus_t KTaskWait(int32_t msec);
kstatus_t KTaskWaitClr(void);
kstatus_t KTaskWake(tid_t tid);
kstatus_t KTaskDelay(int32_t msec);
kstatus_t KTaskSwitching(bool on);

kstatus_t KMutexCreate(uint32_t tag, bool recursive, mutex_t* mutexHandleOut);
kstatus_t KMutexDestroy(mutex_t mut);
kstatus_t KMutexReserve(mutex_t mut, int32_t timeout);
kstatus_t KMutexRelease(mutex_t mut);

kstatus_t KSemaphoreCreate(uint32_t tag, uint32_t initialVal, sema_t* semaHandleOut);
kstatus_t KSemaphoreDestroy(sema_t sem);
kstatus_t KSemaphoreWait(sema_t sem, int32_t timeout);
kstatus_t KSemaphorePost(sema_t sem);

kstatus_t KMailboxCreate(uint32_t tag, uint32_t depth, void* storage, mbx_t* mbxHandleOutP);
kstatus_t KMailboxDestroy(mbx_t mbx, void** storageP);
kstatus_t KMailboxSend(mbx_t mbx, uint32_t msg);
kstatus_t KMailboxWait(mbx_t mbx, uint32_t* msgP, int32_t timeout);

kstatus_t KTimerCreate(uint32_t tag, KernTimerCbk cbk, void* cbkData, tmr_t *tmrHandleOutP);
kstatus_t KTimerDestroy(tmr_t tmr);
kstatus_t KTimerSet(tmr_t tmr, uint32_t msec);

kstatus_t KEventGroupCreate(uint32_t tag, uint32_t initialState, evtgrp_t* evtGrpHandleOut);
kstatus_t KEventGroupDestroy(evtgrp_t evtGrp);
kstatus_t KEventGroupClear(evtgrp_t evtGrp, uint32_t bitsToClear);
kstatus_t KEventGroupSignal(evtgrp_t evtGrp, uint32_t bitsToSet);
kstatus_t KEventGroupRead(evtgrp_t evtGrp, uint32_t* curstateOutP);
kstatus_t KEventGroupWait(evtgrp_t evtGrp, uint32_t wantedEvents, uint32_t *returnedEventsP, int32_t timeout, bool wantAnd);

kstatus_t KGetUptimeMsec(uint32_t* secsP);

kstatus_t KRtcGet(uint32_t* rtcValP);
kstatus_t KRtcSet(uint32_t rtcVal);
kstatus_t KRtcSetAlarm(uint32_t rtcVal);

kstatus_t KSetStorageRamWriteable(bool allowStorageRamWrites);


#endif

