#include "hwTimer.h"
#include "printf.h"
#include "timers.h"
#include <stdio.h>
#include "irqs.h"
#include "cpu.h"



static uint64_t gTicks = 0;


void SysTick_Handler(void)
{
	gTicks += 0x01000000;
}

uint64_t timerGetTime(void)
{
	uint64_t ret;
	uint32_t retLo;
	
	do {
		ret = gTicks;
		asm volatile("":::"memory");
		retLo = SysTick->VAL;
		asm volatile("":::"memory");
	} while (ret != gTicks);
	
	return ret + (0x01000000 - retLo);
}

void timersInit(void)
{
	timersCommonInit();
	
	SysTick->LOAD = 0x00FFFFFF;
	SysTick->VAL = 0;
	SysTick->CTRL = 7;
}

