#include <oscall.h>
#include <ral_export.h>


#ifdef BUILDING_FOR_BIG_ARM
	#pragma GCC target ("arm")
#endif

//ALL DEVICES
	void __attribute__((naked)) repalmDalGetClockRate() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_GET_CLOCK_RATE):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalGetTimerVal() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_GET_TIMER_VAL):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalGetAdcVal() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_GET_ADC_VALUE):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalPwrCtl() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_PWR_CTL):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}


//LEGACY-MMU devices
	void __attribute__((naked)) repalmPlatPeriphP2V() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_PLAT_PERIPH_P2V):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmPlatDmaBufAlloc() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_DMA_BUF_ALLOC):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmPlatDmaBufFree() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_DMA_BUF_FREE):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	

//VIRTUAL ONLY
	void __attribute__((naked)) repalmDalHyperCall() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_HYPER_FORWARDER):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}


//REMOTEIO COMMON

	void __attribute__((naked)) remoteioCommsUpdateStart() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_UPDATE_START):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}

	void __attribute__((naked)) remoteioCommsCopyMsgToSram() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_COPY_TO_SRAM):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) remoteioCommsCopyMsgFromSram() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_COPY_FROM_SRAM):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) remoteioCommsSerInit() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_SER_INIT):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) remoteioCommsSerOp() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_SER_OP):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) remoteioCommsSerTx() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_SER_TX):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) remoteioCommsSerDeinit() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_SER_DEINIT):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) remoteioCommsGetBufSzs() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_REMOTEIO_GET_BUF_SZS):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}

//RP2040 - PalmCard
	void __attribute__((naked)) repalmSdioSetSpeed() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_SDIO_SET_SPEED):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmSdioCmd() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_SDIO_CMD):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmSdioBusyWait() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_SDIO_BUSY_WAIT):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmSdioDataRx() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_SDIO_DATA_RX):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmSdioDataTx() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_SDIO_DATA_TX):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmSdioInsertNotifCfg() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_SDIO_INSERT_NOTIF_CFG):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmUartConfig() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_UART_CONFIG):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmUartTx() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_UART_TX):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) repalmUartGetSta() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_UART_GET_STA):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	void __attribute__((naked)) palmcardFlashSpiAccess() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_SPI_FLASH_OP):::"r0","r1","r2","r3","r12","lr","cc","memory");
	} 
	
	
	
	

//RP2040 - Waveshare
	void __attribute__((naked)) repalmGetSdioPioInfo() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_GET_SD_PIO_INFO):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}