#include <ral.h>
#include "sbar.h"
#include "pace.h"
#include "printf.h"
#include "private.h"
#include "patching.h"
#include <Graffiti.h>
#include "rePalmSbarPublic.h"


#define SUPPORT_PINS_V_1_0
#define SUPPORT_PINS_V_1_1
//#define SUPPORT_PINS_V_2_0

//pace shadows windows and forms and many other things
//we need this patch and some other things to get native form pointer from a shadow

static bool pFrmValidatePtr(FormPtr frm)
{
	struct Globals *g = globalsGet();
	
	if (g->nativeFormP) {
		*g->nativeFormP = frm;
		g->nativeFormP = NULL;
	}
	
	return g->ot_pFrmValidatePtr(frm);
}
DEF_UI_PATCH_PARTIAL(pFrmValidatePtr, 0x2F8);

static bool pWinValidateHandle(WinHandle wh)
{
	struct Globals *g = globalsGet();
	
	if (g->nativeWinP) {
		*g->nativeWinP = wh;
		g->nativeWinP = NULL;
	}
	
	return g->ot_pWinValidateHandle(wh);
}
DEF_BOOT_PATCH_PARTIAL(pWinValidateHandle, 0xC5C);

static FormPtr sbarPrvGetNativeFormFromShadow(EmulStateRef emulState, FormPtr shadowFrm)
{
	uint32_t i, t = (uintptr_t)shadowFrm;
	struct Globals *g = globalsGet();
	PaceTrapHandler handler;
	FormPtr ret = NULL;
	
	if (!shadowFrm)
		return NULL;
	
	if (g->nativeFormP)
		loge("bad state 1\n");
	
	if (errNone != PceGet68KTrapHandler(emulState, 0x327, &handler)) //sysTrapFrmValidatePtr
		SysFatalAlert("Failed to get handler");
	
	g->nativeFormP = &ret;
	
	emulState->a[7] -= 4;
	for (i = 0; i < 4; i++, t >>= 8)
		((uint8_t*)(emulState->a[7]))[3 - i] = t;
	handler(emulState);
	emulState->a[7] += 4;
	
	if (g->nativeFormP || !ret)
		loge("bad state 2\n");

	return ret;
}

static WinHandle sbarPrvGetNativeWindowFromShadow(EmulStateRef emulState, WinHandle shadowWin)
{
	uint32_t i, t = (uintptr_t)shadowWin;
	struct Globals *g = globalsGet();
	PaceTrapHandler handler;
	WinHandle ret = NULL;
	
	if (!shadowWin)
		return NULL;
	
	if (g->nativeWinP)
		loge("bad state 1\n");
	
	if (errNone != PceGet68KTrapHandler(emulState, 0x326, &handler)) //sysTrapWinValidateHandle
		SysFatalAlert("Failed to get handler");
	
	g->nativeWinP = &ret;
	
	emulState->a[7] -= 4;
	for (i = 0; i < 4; i++, t >>= 8)
		((uint8_t*)(emulState->a[7]))[3 - i] = t;
	handler(emulState);
	emulState->a[7] += 4;
	
	if (g->nativeWinP || !ret)
		loge("bad state 2\n");

	return ret;
}

static void sbarPrvPinsDispatch68K(EmulStateRef emulState)
{
	uint32_t dummy, *ud;
	uint16_t ret = 0;
	
	(void)dummy;	//shut the compiler up if building pins-1.0-only dia
	(void)ret;
	(void)ud;
	
	switch (emulState->d[2]) {
#ifdef SUPPORT_PINS_V_1_0
		case pinPINSetInputAreaState:
			ret = sbarPINSetInputAreaState(PceReadInt16From68KStack(emulState, 0));
			goto commom_set_u16_return;
		
		case pinPINGetInputAreaState:
			ret = sbarPINGetInputAreaState();
			goto commom_set_u16_return;
		
		case pinPINSetInputTriggerState:
			ret = sbarPINSetInputTriggerState(PceReadInt16From68KStack(emulState, 0));
			goto commom_set_u16_return;
			
		case pinPINGetInputTriggerState:
			ret = sbarPINGetInputTriggerState();
			goto commom_set_u16_return;
#endif

#ifdef SUPPORT_PINS_V_2_0
		case pinPINAltInputSystemEnabled:
			PceSet68KInt8ReturnResult(emulState, sbarPINAltInputSystemEnabled());
			goto common_just_return;
		
		case pinPINGetCurrentPinletName:
			PceSet68KPtrReturnResult(emulState, sbarPINGetCurrentPinletName());
			goto common_just_return;
		
		case pinPINSwitchToPinlet:
			ret = sbarPINSwitchToPinlet((const char*)PceReadInt32From68KStack(emulState, 0), PceReadInt16From68KStack(emulState, 4));
			goto commom_set_u16_return;
			
		case pinPINCountPinlets:
			ret = sbarPINCountPinlets();
			goto commom_set_u16_return;
			
		case pinPINGetPinletInfo:
			ud = (uint32_t*)PceReadInt32From68KStack(emulState, 4);
			ret = sbarPINGetPinletInfo(PceReadInt16From68KStack(emulState, 0), PceReadInt16From68KStack(emulState, 2), ud ? &dummy : NULL);
			goto common_write_u32_then_set_error;
			
		case pinPINSetInputMode:
			sbarPINSetInputMode(PceReadInt16From68KStack(emulState, 0));
			goto common_just_return;
			
		case pinPINGetInputMode:
			ret = sbarPINGetInputMode();
			goto commom_set_u16_return;
		
		case pinPINClearPinletState:
			sbarPINClearPinletState();
			goto common_just_return;
			
		case pinPINShowReferenceDialog:
			sbarPINShowReferenceDialog();
			goto common_just_return;
		
#endif

#ifdef SUPPORT_PINS_V_1_0
		case pinWinSetConstraintsSize:
			ret = sbarWinSetConstraintsSize(sbarPrvGetNativeWindowFromShadow(emulState, (WinHandle)PceReadInt32From68KStack(emulState, 0)),	//winHandle
											(int16_t)PceReadInt16From68KStack(emulState, 4),	//minH
											(int16_t)PceReadInt16From68KStack(emulState, 6),	//prefH
											(int16_t)PceReadInt16From68KStack(emulState, 8),	//maxH
											(int16_t)PceReadInt16From68KStack(emulState, 10),	//minW
											(int16_t)PceReadInt16From68KStack(emulState, 12),	//prefW
											(int16_t)PceReadInt16From68KStack(emulState, 14));	//maxW
			goto commom_set_u16_return;
		
		case pinFrmSetDIAPolicyAttr:
			ret = sbarFrmSetDIAPolicyAttr((struct PalmForm*)sbarPrvGetNativeFormFromShadow(emulState, (FormPtr)PceReadInt32From68KStack(emulState, 0)), (uint16_t)PceReadInt16From68KStack(emulState, 4));
			goto commom_set_u16_return;
		
		case pinFrmGetDIAPolicyAttr:
			ret = sbarFrmGetDIAPolicyAttr((struct PalmForm*)sbarPrvGetNativeFormFromShadow(emulState, (FormPtr)PceReadInt32From68KStack(emulState, 0)));
			goto commom_set_u16_return;
#endif

#ifdef SUPPORT_PINS_V_1_1

		case pinStatHide:
			ret = sbarStatHide();
			goto commom_set_u16_return;
		
		case pinStatShow:
			ret = sbarStatShow();
			goto commom_set_u16_return;
		
		case pinStatGetAttribute:
			ud = (uint32_t*)PceReadInt32From68KStack(emulState, 2);
			ret = sbarStatGetAttribute(PceReadInt16From68KStack(emulState, 0), ud ? &dummy : NULL, false);
			goto common_write_u32_then_set_error;
				
		case pinSysGetOrientation:
			ret = sbarSysGetOrientation();
			goto commom_set_u16_return;
		
		case pinSysSetOrientation:
			ret = sbarSysSetOrientation(PceReadInt16From68KStack(emulState, 0));
			goto commom_set_u16_return;
			
		case pinSysGetOrientationTriggerState:
			ret = sbarSysGetOrientationTriggerState();
			goto commom_set_u16_return;
		
		case pinSysSetOrientationTriggerState:
			ret = sbarSysSetOrientationTriggerState(PceReadInt16From68KStack(emulState, 0));
			goto commom_set_u16_return;

#endif	//SUPPORT_PINS_V_1_1
		
		default:
			loge("Unknown PINS selector called: %u\n", emulState->d[2]);
			ret = sysErrParamErr;
			goto commom_set_u16_return;
	}
	
//most common case: set 16-bit rsult

common_write_u32_then_set_error:
	if (ud)
		PceWriteInt32To68KMemory(emulState, ud, 0, dummy);

commom_set_u16_return:
	PceSet68KInt16ReturnResult(emulState, ret);

common_just_return:
	return;
}

static void install68kHandler(void)
{
	if (errNone != PceSet68KTrapHandler(PceGetSystemEmulState(), 0x470, sbarPrvPinsDispatch68K)) //sysTrapPinsDispatch
		SysFatalAlert("Failed to set up DIA's 68K handler");
}

static Err sbarPrvPaceSbarNotifCreate(EmulStateRef ref)
{
	const struct SbarNotifStateDescr *states68k = (const struct SbarNotifStateDescr*)PceReadInt32From68KStack(ref, 8);
	LocalID handlerApp = (LocalID)PceReadInt32From68KStack(ref, 2);
	bool holdSupported = (bool)PceReadInt8From68KStack(ref, 20);
	void *userData = (void*)PceReadInt32From68KStack(ref, 24);
	bool manualDraw = (bool)PceReadInt8From68KStack(ref, 22);
	uint8_t numStates = PceReadInt8From68KStack(ref, 6);
	uint16_t width = PceReadInt16From68KStack(ref, 18);
	int32_t order = PceReadInt32From68KStack(ref, 14);
	uint8_t group = PceReadInt8From68KStack(ref, 12);
	struct SbarNotifStateDescr *statesArm; 
	void *notif;
	uint32_t i;
	
	statesArm = MemChunkNew(0, numStates ? sizeof(struct SbarNotifStateDescr) * numStates : 1, 0x200);
	for (i = 0; i < numStates; i++) {
		
		statesArm[i].normalImg = (struct BitmapType*)PceReadInt32From68KMemory(ref, (uint32_t*)&states68k[i].normalImg, 0);
		statesArm[i].activeImg = (struct BitmapType*)PceReadInt32From68KMemory(ref, (uint32_t*)&states68k[i].activeImg, 0);
	}
	notif = sbarNotifCreate(handlerApp, numStates, statesArm, group, order, width, holdSupported, manualDraw, userData);
	MemChunkFree(statesArm);
	
	PceSet68KPtrReturnResult(ref, notif);
	return errNone;
}

static Err sbarPrvPaceLibHandler(EmulStateRef ref, void* param, uint16_t call)
{
	struct Globals *g = globalsGet();
	
	if(call == 0) {
		((void**)param)[5] = MY_DB_NAME;
		return errNone;
	}
	else if (call != 1) {
		
		switch (call) {
			
			case sysLibTrapClose:
				PceWriteInt16To68KMemory(ref, (uint16_t*)PceReadInt32From68KStack(ref, 2), 0, --g->num68kUsers);
				PceSet68KInt16ReturnResult(ref, errNone);
				break;
			
			case sysLibTrapOpen:
				g->num68kUsers++;
				//fallthrough
			case sysLibTrapSleep:
			case sysLibTrapWake:
				PceSet68KInt16ReturnResult(ref, errNone);
				break;
			
			case sysLibTrapSbarNotifCreate:
				return sbarPrvPaceSbarNotifCreate(ref);
			
			case sysLibTrapSbarNotifDestroy:
				PceSet68KInt8ReturnResult(ref, sbarNotifDestroy((void*)PceReadInt32From68KStack(ref, 2)));
				break;
			
			case sysLibTrapSbarNotifSetState:
				PceSet68KInt8ReturnResult(ref, sbarNotifSetState((void*)PceReadInt32From68KStack(ref, 2), (uint8_t)PceReadInt8From68KStack(ref, 6)));
				break;
			
			case sysLibTrapSbarNotifRequestRedraw:
				PceSet68KInt8ReturnResult(ref, sbarNotifRequestRedraw((void*)PceReadInt32From68KStack(ref, 2)));
				break;
			
			case sysLibTrapSbarNotifGetColor:
				PceSet68KInt32ReturnResult(ref, sbarNotifGetColor((uint16_t)PceReadInt16From68KStack(ref, 2)));
				break;

			default:
				return sysErrNotAllowed;
		}
	}
	
	return errNone;
}

uint32_t __attribute__((used)) PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	if (cmd == RAL_CMD_LOAD) {
		uint32_t osVer, dummy;
	
		if (errNone != FtrGet(sysFtrCreator, sysFtrNumROMVersion, &osVer))
			SysFatalAlert("Cannot get OS version");
		
		if (errNone == FtrGet(pinCreator, pinFtrAPIVersion, &dummy)) {
			logw("PINS feature seems present. Not installing\n");
			return 0;
		}
		
		if (osVer >= 0x05100000 && osVer < 0x05400000) {
			//not tested below 5.1, likely to not work at all, *MIGHT* work in 5.4
			
			uint32_t ver = 0;
			
			#ifdef SUPPORT_PINS_V_1_0
				ver = pinAPIVersion1_0;
			#endif
			#ifdef SUPPORT_PINS_V_1_1
				ver = pinAPIVersion1_1;
			#endif
			#ifdef SUPPORT_PINS_V_2_0
				ver = pinAPIVersion2_0;
			#endif
			
			if (!sbarPrvInit(osVer < 0x05100000, osVer >= 0x05400000)) {
				logw("sbar init failed, continuing in fake mode\n");
				globalsGet()->fakeEnabled = 1;
			}
			
			sbarPrvInstallPatches();
			install68kHandler();
			
			//tell everyone
			FtrSet(pinCreator, pinFtrAPIVersion, ver);
			FtrSet(sysFtrCreator, sysFtrNumInputAreaFlags, grfFtrInputAreaFlagDynamic | grfFtrInputAreaFlagLiveInk | grfFtrInputAreaFlagCollapsible);
		}
	}
	else if (cmd == REPALM_LAUNCH_CODE_BUTTON_TAPPED) {
		
		sbarPrvNotifTapped(cmdPBP);
	}
	else if (cmd == RAL_CMD_GET_PACE_ENTRY) {
		
		*(void**)cmdPBP = &sbarPrvPaceLibHandler;
	}

	return errNone;
}

#ifdef SUPPORT_PINS_V_1_0

	static uint16_t pFrmGetDIAPolicyAttr(struct PalmForm* form)
	{
		return sbarFrmGetDIAPolicyAttr(form);
	}
	DEF_UI_PATCH(pFrmGetDIAPolicyAttr, 0x570);

	static Err pFrmSetDIAPolicyAttr(struct PalmForm* form, uint16_t policy)
	{
		return sbarFrmSetDIAPolicyAttr(form, policy);
	}
	DEF_UI_PATCH(pFrmSetDIAPolicyAttr, 0x574);

	static uint16_t pPINGetInputAreaState(void)
	{
		return sbarPINGetInputAreaState();
	}
	DEF_BOOT_PATCH(pPINGetInputAreaState, 0xDC0);

	static uint16_t pPINGetInputTriggerState(void)
	{
		return sbarPINGetInputTriggerState();
	}
	DEF_BOOT_PATCH(pPINGetInputTriggerState, 0xDC8);

	static Err pPINSetInputAreaState(uint16_t state)
	{
		return sbarPINSetInputAreaState(state);
	}
	DEF_BOOT_PATCH(pPINSetInputAreaState, 0xDC4);

	static Err pPINSetInputTriggerState(uint16_t state)
	{
		return sbarPINSetInputTriggerState(state);
	}
	DEF_BOOT_PATCH(pPINSetInputTriggerState, 0xDCC);

	static Err pWinSetConstraintsSize(WinHandle winHandle, Coord minH, Coord prefH, Coord maxH, Coord minW, Coord prefW, Coord maxW)
	{
		return sbarWinSetConstraintsSize(winHandle, minH, prefH, maxH, minW, prefW, maxW);
	}
	DEF_BOOT_PATCH(pWinSetConstraintsSize, 0xE00);

#endif	//SUPPORT_PINS_V_1_0


#ifdef SUPPORT_PINS_V_1_1

	static Err pStatGetAttribute(uint16_t selector, uint32_t *dataP)
	{
		return sbarStatGetAttribute(selector, dataP, true);
	}
	DEF_BOOT_PATCH(pStatGetAttribute, 0xDF4);

	static Err pStatShow(void)
	{
		return sbarStatShow();
	}
	DEF_BOOT_PATCH(pStatShow, 0xDF8);

	static Err pStatHide(void)
	{
		return sbarStatHide();
	}
	DEF_BOOT_PATCH(pStatHide, 0xDFC);

	static uint16_t pSysGetOrientation(void)
	{
		return sbarSysGetOrientation();
	}
	DEF_BOOT_PATCH(pSysGetOrientation, 0xE24);

	static Err pSysSetOrientation(uint16_t orientation)
	{
		return sbarSysSetOrientation(orientation);
	}
	DEF_BOOT_PATCH(pSysSetOrientation, 0xE24);

	static uint16_t pSysGetOrientationTriggerState(void)
	{
		return sbarSysGetOrientationTriggerState();
	}
	DEF_BOOT_PATCH(pSysGetOrientationTriggerState, 0xE2C);

	static Err pSysSetOrientationTriggerState(uint16_t state)
	{
		return sbarSysSetOrientationTriggerState(state);
	}
	DEF_BOOT_PATCH(pSysSetOrientationTriggerState, 0xE2C);

	static void pFrmPrvSetActiveFormPINAttributes(uint32_t whichToAffect, bool useCustom /* use force open */)
	{
		sbarFrmPrvSetActiveFormPINAttributes(whichToAffect, useCustom);
	}
	DEF_UI_PATCH(pFrmPrvSetActiveFormPINAttributes, 0x578);
	
	static void pFrmPrvRedrawDisplay(const struct RectangleType *area)
	{
		sbarFrmPrvRedrawDisplay(area);
	}
	DEF_UI_PATCH(pFrmPrvRedrawDisplay, 0x57C);

#endif	//SUPPORT_PINS_V_1_1


#ifdef SUPPORT_PINS_V_2_0

	static bool pPINAltInputSystemEnabled(void)
	{
		return sbarPINAltInputSystemEnabled();
	}
	DEF_BOOT_PATCH(pPINAltInputSystemEnabled, 0xDD0);

	static const char* pPINGetCurrentPinletName(void)
	{
		return sbarPINGetCurrentPinletName();
	}
	DEF_BOOT_PATCH(pPINGetCurrentPinletName, 0xDD4);

	static Err pPINSwitchToPinlet(const char *pinletName, uint16_t initialInputMode)
	{
		return sbarPINSwitchToPinlet(pinletName, initialInputMode);
	}
	DEF_BOOT_PATCH(pPINSwitchToPinlet, 0xDD8);

	static uint16_t pPINCountPinlets(void)
	{
		return sbarPINCountPinlets();
	}
	DEF_BOOT_PATCH(pPINCountPinlets, 0xDDC);

	static Err pPINGetPinletInfo(uint16_t pinletIndex, uint16_t selector, uint32_t *infoP)
	{
		return sbarPINGetPinletInfo(pinletIndex, selector, infoP);
	}
	DEF_BOOT_PATCH(pPINGetPinletInfo, 0xDE0);

	static void pPINSetInputMode(uint16_t inputModeToSetForCurPinlet)
	{
		sbarPINSetInputMode(inputModeToSetForCurPinlet);
	}
	DEF_BOOT_PATCH(pPINSetInputMode, 0xDE4);

	static uint16_t pPINGetInputMode(void)
	{
		return sbarPINGetInputMode();
	}
	DEF_BOOT_PATCH(pPINGetInputMode, 0xDE8);

	static void pPINClearPinletState(void)
	{
		sbarPINClearPinletState();
	}
	DEF_BOOT_PATCH(pPINGetInputMode, 0xDEC);

	static void pPINShowReferenceDialog(void)
	{
		sbarPINShowReferenceDialog();
	}
	DEF_BOOT_PATCH(pPINShowReferenceDialog, 0xDF0);

#endif	//SUPPORT_PINS_V_2_0






















#if defined(SUPPORT_PINS_V_2_0) && !defined(SUPPORT_PINS_V_1_1)
	#error "cannot support PINS 2.0 without supporting 1.1 also"
#endif

#if defined(SUPPORT_PINS_V_1_1) && !defined(SUPPORT_PINS_V_1_0)
	#error "cannot support PINS 1.1 without supporting 1.0 also"
#endif
