#ifndef _PRIVATE_H_
#define _PRIVATE_H_

#include "rePalmSbarPublic.h"
#include "palmosInternal.h"
#include "common.h"
#include "skin.h"



struct SbarNotif;
struct Globals {						//size set to 192 bytes by amdi resource, zero inited

	//very global settings
	uint32_t fakeEnabled			: 1;		//we support all api but always return errors (needed for some apps that assume PINS support)

	//flags
	uint32_t isGarnet				: 1;
	uint32_t isOS50					: 1;
	uint32_t diaState				: 2;		//DIA_STATE_*
	uint32_t diaTriggerEn			: 1;
	uint32_t eatPenEventsTillUp		: 1;		//set to eat all events till pen up
	
	//user preferences
	uint32_t userDiaState			: 3;		//pinInputArea*
	uint32_t userRotState			: 3;		//sysOrientation*
	uint32_t userRotTriggerState	: 1;
	uint32_t userDiaTriggerState	: 1;
	
	//for alerts
	uint32_t inAlert				: 1;		//set if we're inside an alert
	uint32_t alertPrevDiaState		: 2;		//prev dia state
	
	uint16_t maxAppHeight;					//in std coord sys
	
	uint16_t num68kUsers;
	
	//skin
	struct SbarSkin skin;
	
	//drawing stuff
	uint32_t mutex;
	WinHandle sbarWin, offscreenWin, savedBits;
	
	//areas
	struct RectangleType sbarAndDia;
	struct RectangleType notifArea;		//if extent is negative, it is hidden
	
	//sbar areas
	struct SbarNotif *notifs[REPALM_BTN_GROUP_NUM];
	
	//pins up/down arror
	void *pinsCtlButton;
	
	//replaced traps
	void (*ot_pSysEventGet)(EventPtr evt, int32_t timeout);
	void (*ot_pUIReset)(void);
	void (*ot_pFrmDrawForm)(struct PalmForm *frm);
	uint16_t (*ot_pFrmCustomAlert)(uint16_t resId, const char *s1, const char *s2, const char *s3);
	uint16_t (*ot_pFrmCustomResponseAlert)(uint16_t resId, const char *s1, const char *s2, const char *s3, char *replyBuf, int16_t replyBufLen, FormCheckResponseFuncPtr cbk);
	void (*ot_pFrmSetActiveForm)(struct PalmForm *frm);
	
	//for getting native form from shadow
	bool (*ot_pFrmValidatePtr)(FormPtr frm);
	FormPtr *nativeFormP;
	
	//for getting native window shadow
	bool (*ot_pWinValidateHandle)(WinHandle wh);
	WinHandle *nativeWinP;
};








static inline struct Globals* __attribute__((pure, always_inline)) globalsGet(void)
{
	void**** ret;
	
	asm ("mov %0, r9":"=r"(ret));
	return (struct Globals*)&ret[0][MY_LIB_ID / 4][0x18/4];
}

#endif
