#ifndef _HYPERCALLS_H_
#define _HYPERCALLS_H_

#include <stdint.h>
#include <stdbool.h>

//for dal
#define HYPER_EXIT					0		// no data
#define HYPER_PUTCHAR				1		// data pointer is actually a char
#define HYPER_TASK_CREATE			2		// HyTaskCreate -> tid or 0
#define HYPER_TASK_START			3		// HyTaskStart -> error or 0
#define HYPER_TASK_GET_TID			4		// () -> tid or 0
#define HYPER_TASK_GET_INFO			5		// HyTaskInfo -> error or 0
#define HYPER_DISP_GET_SIZE			7		// () -> u64(0xFFFF is width, 0xFFFF0000 is height, 0xFF00000000 is density, others unused)
#define HYPER_DISP_UPDATE			8		// HyDispUpdt -> ()
#define HYPER_SEY_KEY_REP_RATES		9		// u32 (lo16 = delay, hi16 = interval) -> error or 0
#define HYPER_MUTEX_NEW				10		// (tag) -> mutexHandle or 0
#define HYPER_MUTEX_DEL				11		// (mutexHandle) -> error or 0
#define HYPER_MUTEX_UNLOCK			12		// (mutexHandle) -> error or 0
#define HYPER_MUTEX_LOCK			13		// (struct HyMutexLock) -> 0 for success, 1 for timeout, else for error
#define HYPER_SET_STOR_HEAP_PROT	14		// (bool allowWrites) -> error or 0
#define HYPER_GET_SECONDS_EPOCH		15		// () -> seconds (unix epoch)
#define HYPER_GET_MSEC_SINCE_BOOT	16		// () -> msec
#define HYPER_EVTGRP_NEW			17		// (initialState) -> evtGrpHandle or 0
#define HYPER_EVTGRP_DEL			18		// (evtGrpHandle) -> error or 0
#define HYPER_EVTGRP_READ			19		// (evtGrpHandle) -> (2 << 32) on error, else state
#define HYPER_EVTGRP_SET_BITS		20		// (struct hyEvtGrpSimpleOp) -> error or 0
#define HYPER_EVTGRP_CLR_BITS		21		// (struct hyEvtGrpSimpleOp) -> error or 0
#define HYPER_EVTGRP_WAIT			22		// (struct hyEvtGrpWait) -> ((1 << 32) | bits) on timeout, (2 << 32) on error, else just (bits)
#define HYPER_SEM_NEW				23		// (initialVal) -> semHandle or 0
#define HYPER_SEM_DEL				24		// (semHandle) -> error or 0
#define HYPER_SEM_POST				25		// (semHandle) -> error or 0
#define HYPER_SEM_WAIT				26		// (struct hyperSemWait) -> 0 for success, 1 for timeout, else for error
#define HYPER_TASK_WAIT				27		// (int32 timeoutMsec) -> 0 for success, 1 for timeout, else for error
#define HYPER_TASK_WAKE				28		// (tid) -> 0 for success, else for error
#define HYPER_TASK_DELAY			29		// (msec) -> ()
#define HYPER_GET_EVT_WAIT			30		// (struct HyperHwrEvt *dst) -> () //blocks until event ready
#define HYPER_TIMER_NEW				31		// (struct hyperTimerCreate) -> timerHandle or 0
#define HYPER_TIMER_DEL				32		// (timerHandle) -> error or 0
#define HYPER_TIMER_SET				33		// (struct hyperTimerSet) -> error or 0
#define HYPER_TASK_DEL				34		// (tid) -> error or 0
#define HYPER_SET_RTC_ALARM			35		// (u32 secondsSinceEpoch) -> error or 0
#define HYPER_MBX_NEW				36		// (u32 depth) -> mailboxHandle
#define HYPER_MBX_DEL				37		// (mailbox) -> error or 0
#define HYPER_MBX_SEND				38		// (struct HyMbxSend) -> error or 0
#define HYPER_MBX_RECV				39		// (struct HyMbxRecv) -> 0 for success, 1 for timeout, else for error


//for hostfs
#define HYPER_FS_FILE_OPEN			0x100	// (struct HyFsOpen) -> fd
#define HYPER_FS_FILE_CLOSE			0x101	// (fd) -> int
#define HYPER_FS_FILE_SEEK			0x102	// (struct HyFsSeek) -> int64_t
#define HYPER_FS_FILE_READ			0x103	// (struct HyFsReadWrite) -> long
#define HYPER_FS_FILE_WRITE			0x104	// (struct HyFsReadWrite) -> long
#define HYPER_FS_FILE_RESIZE		0x105	// (struct HyFsResize) -> int
#define HYPER_FS_FILE_GETINFO		0x106	// (struct HyFsGetSetInfo) -> int
#define HYPER_FS_FILE_SETINFO		0x107	// (struct HyFsGetSetInfo) -> int
#define HYPER_FS_FILE_DEL			0x108	// (const char*) -> int
#define HYPER_FS_RENAME				0x109	// (struct HyFsRename) -> int
#define HYPER_FS_DIR_READ			0x10A	// (struct HyFsReaddir) -> int (neg for err, 0 for success, 1 for no entries left)
#define HYPER_FS_DIR_CREATE			0x10B	// (const char*) -> int
#define HYPER_FS_DIR_DEL			0x10C	// (const char*) -> int


#define HYPER_FILE_MODE_READ		1		//create differes between build systems somehow. abstract it away
#define HYPER_FILE_MODE_WRITE		2
#define HYPER_FILE_MODE_RW			4
#define HYPER_FILE_MODE_CREATE		8


struct HyFsOpen {
	const char *name;
	uint8_t mode;
};

struct HyFsSeek {
	int fd;
	int32_t ofst;
	int whence;
};

struct HyFsReadWrite {
	int fd;
	void *dst;
	uint32_t bytes;
};

struct HyFsResize {
	int fd;
	uint32_t sz;
};

struct HyFsGetSetInfo {
	int fd;
	uint32_t *attribs;
	uint32_t *dateCr;
	uint32_t *dateMod;
	uint32_t *dateAcc;
};

struct HyFsRename {
	const char *from;
	const char *to;
};

struct HyFsReaddir {
	int fd;				//in: fd
	long n;				//in: we get nth file
	char *nameP;
	uint16_t nameLen;	//in bytes
	bool isDir;			//out: is this a directory
	bool theresMore;	//out: are there more entries?
};

struct HyMbxSend {
	uint32_t mailbox;
	uint32_t msg;
};

struct HyMbxRecv {
	uint32_t mailbox;
	int32_t timeout;	//negative for forever, else milliseconds
	uint32_t msg;
};

struct HyTaskCreate {
	void (*func)(void*);
	uint32_t spVal;
	uint32_t stackSz;
	uint32_t tag;
	void* exinf;
	uint32_t r9;
	uint32_t prio;
};

struct HyTaskStart {
	uint32_t tid;
	void *param;
};

struct HyTaskInfo {
	uint32_t tid;			//in
	void (*func)(void*);	//out
	void* exinf;			//out
	uint32_t tag;			//out
	uint32_t initialSp;		//out
	uint32_t stackSz;		//out
	uint32_t prio;			//out
};

struct HyDispUpdt {
	const void *data;
	const uint32_t *clut;	//RGBA8888
	uint8_t depth;
};

struct hyEvtGrpSimpleOp {
	uint32_t evtGrpHandle;
	uint32_t val;
};

struct hyEvtGrpWait {
	uint32_t evtGrpHandle;
	uint32_t desiredBits;
	int32_t timeoutMsec;	//negative for forever, else milli seconds
	bool needAllBits;		//if set all bits must be set. if clear only one
};

struct HyMutexLock {
	uint32_t mut;
	int32_t timeoutMsec;
};

struct hyperSemWait {
	uint32_t semHandle;
	int32_t timeoutMsec;		//negative for forever
};

struct hyperTimerCreate {
	void *fn;
	void *data;
};

struct hyperTimerSet {
	uint32_t timer;
	uint32_t msec;
};

#define HYPER_MEM_REGION_ROM		0
#define HYPER_MEM_REGION_DYN_RAM	1
#define HYPER_MEM_REGION_STOR_RAM	2



struct HyperHwrEvt {
	uint32_t type;
	union {
		struct {
			uint16_t x;
			uint16_t y;
		} pen;
		struct {
			void *fn;
			void *userData;
		} timer;
		struct {
			uint16_t chr;
			uint16_t mods;
		} kbd;
		struct {
			uint32_t keyBit;
			bool down;
		} hardkey;
	};
};

#define HYPER_KEY_MOD_SHIFT			1
#define HYPER_KEY_MOD_CAPSLOCK		2

//these match palm definitions so i dont have to convert them. Live with it
#define HYPER_HARD_KEY_POWER		0x00000001
#define HYPER_HARD_KEY_PG_UP		0x00000002
#define HYPER_HARD_KEY_PG_DN		0x00000004
#define HYPER_HARD_KEY_APP_1		0x00000008
#define HYPER_HARD_KEY_APP_2		0x00000010
#define HYPER_HARD_KEY_APP_3		0x00000020
#define HYPER_HARD_KEY_APP_4		0x00000040
#define HYPER_HARD_KEY_HOTSYNC		0x00000080

#define HYPER_HARD_KEY_JOG_UP		0x00001000
#define HYPER_HARD_KEY_JOG_DN		0x00002000
#define HYPER_HARD_KEY_JOG_SEL		0x00004000
#define HYPER_HARD_KEY_JOG_BACK		0x00008000

#define HYPER_HARD_KEY_ROCKER_UP	0x00010000
#define HYPER_HARD_KEY_ROCKER_DN	0x00020000
#define HYPER_HARD_KEY_ROCKER_LT	0x00040000
#define HYPER_HARD_KEY_ROCKER_RT	0x00080000
#define HYPER_HARD_KEY_ROCKER_SEL	0x00100000

#define HYPER_HWR_EVT_PEN_DOWN		0	//pen
#define HYPER_HWR_EVT_PEN_UP		1	//pen
#define HYPER_HWR_EVT_PEN_MOVE		2	//pen
#define HYPER_HWR_EVT_RTC			3	//rtc tick
#define HYPER_HWR_EVT_KBD			4	//koayboard key press
#define HYPER_HWR_EVT_HARDKEY		5	//one of the hard keys up or down
#define HYPER_VIRT_EVENT_TIMER		6	//timer

typedef uint64_t (*HyperFunc)(uint32_t call, void *data);

#endif
