#include <oscall.h>
#include <ral_export.h>


#ifdef BUILDING_FOR_BIG_ARM
	#pragma GCC target ("arm")
#endif

//ALL DEVICES
	void __attribute__((naked)) repalmDalGetClockRate() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_GET_CLOCK_RATE):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalGetTimerVal() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_GET_TIMER_VAL):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalGetAdcVal() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_GET_ADC_VALUE):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalPwrCtl() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_PWR_CTL):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}


//LEGACY-MMU devices
	void __attribute__((naked)) repalmPlatPeriphP2V() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_PLAT_PERIPH_P2V):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmPlatDmaBufAlloc() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_DMA_BUF_ALLOC):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmPlatDmaBufFree() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_DMA_BUF_FREE):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	

//VIRTUAL ONLY
	void __attribute__((naked)) repalmDalHyperCall() {
		asm volatile(CALL_OSCALL(REPALM_TABLE,  4 * REPALM_FUNC_IDX_HYPER_FORWARDER):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}



//RESPRING ONLY

	void __attribute__((naked)) repalmDalvisorCommsUpdateStart() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_UPDATE_START):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}

	void __attribute__((naked)) repalmDalvisorCommsCopyMsgToSram() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_COPY_TO_SRAM):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalvisorCommsCopyMsgFromSram() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_COPY_FROM_SRAM):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalvisorCommsSerInit() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_SER_INIT):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalvisorCommsSerOp() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_SER_OP):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalvisorCommsSerTx() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_SER_TX):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalvisorCommsSerDeinit() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_SER_DEINIT):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}
	
	void __attribute__((naked)) repalmDalvisorCommsGetBufSzs() {
		asm volatile(CALL_OSCALL(REPALM_TABLE, 4 * REPALM_FUNC_IDX_VISOR_COMMS_GET_BUF_SZS):::"r0","r1","r2","r3","r12","lr","cc","memory");
	}

