#include "paceCommon.h"

.func calcEaGeneric
calcEaGeneric:				//(ea * 2) -> val byte
	add					pc, r0
	nop
	b					calcEa_inval		//D0 (not valid in calc mode)
	b					calcEa_inval		//D1 (not valid in calc mode)
	b					calcEa_inval		//D2 (not valid in calc mode)
	b					calcEa_inval		//D3 (not valid in calc mode)
	b					calcEa_inval		//D4 (not valid in calc mode)
	b					calcEa_inval		//D5 (not valid in calc mode)
	b					calcEa_inval		//D6 (not valid in calc mode)
	b					calcEa_inval		//D7 (not valid in calc mode)
	b					calcEa_inval		//A0 (not valid in calc mode)
	b					calcEa_inval		//A1 (not valid in calc mode)
	b					calcEa_inval		//A2 (not valid in calc mode)
	b					calcEa_inval		//A3 (not valid in calc mode)
	b					calcEa_inval		//A4 (not valid in calc mode)
	b					calcEa_inval		//A5 (not valid in calc mode)
	b					calcEa_inval		//A6 (not valid in calc mode)
	b					calcEa_inval		//A7 (not valid in calc mode)
	b					calcEa_deref_A0		//(A0)
	b					calcEa_deref_A1		//(A1)
	b					calcEa_deref_A2		//(A2)
	b					calcEa_deref_A3		//(A3)
	b					calcEa_deref_A4		//(A4)
	b					calcEa_deref_A5		//(A5)
	b					calcEa_deref_A6		//(A6)
	b					calcEa_deref_A7		//(A7)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_inval		//A7 (not valid in calc-generic mode)
	b					calcEa_deref_d_A0	//d(A0)
	b					calcEa_deref_d_A1	//d(A1)
	b					calcEa_deref_d_A2	//d(A2)
	b					calcEa_deref_d_A3	//d(A3)
	b					calcEa_deref_d_A4	//d(A4)
	b					calcEa_deref_d_A5	//d(A5)
	b					calcEa_deref_d_A6	//d(A6)
	b					calcEa_deref_d_A7	//d(A7)
	b					calcEa_idx_A0		//d(A0,Xi)
	b					calcEa_idx_A1		//d(A1,Xi)
	b					calcEa_idx_A2		//d(A2,Xi)
	b					calcEa_idx_A3		//d(A3,Xi)
	b					calcEa_idx_A4		//d(A4,Xi)
	b					calcEa_idx_A5		//d(A5,Xi)
	b					calcEa_idx_A6		//d(A6,Xi)
	b					calcEa_idx_A7		//d(A7,Xi)
	b					calcEa_absW			//(0x????).W
	b					calcEa_absL			//(0x????????).L
	b					calcEa_dPC			//d(PC)
	b					calcEa_idx_PC		//d(PC,Xi)
	b					calcEa_inval		//#0x?? (not valid in calc mode)
	b					calcEa_inval
	b					calcEa_inval
	b					calcEa_inval

.endfunc


.func calcEaB
calcEaB:					//(ea * 2) -> val byte
	add					pc, r0
	nop
	b					calcEa_inval		//D0 (not valid in calc mode)
	b					calcEa_inval		//D1 (not valid in calc mode)
	b					calcEa_inval		//D2 (not valid in calc mode)
	b					calcEa_inval		//D3 (not valid in calc mode)
	b					calcEa_inval		//D4 (not valid in calc mode)
	b					calcEa_inval		//D5 (not valid in calc mode)
	b					calcEa_inval		//D6 (not valid in calc mode)
	b					calcEa_inval		//D7 (not valid in calc mode)
	b					calcEa_inval		//A0 (not valid in calc mode)
	b					calcEa_inval		//A1 (not valid in calc mode)
	b					calcEa_inval		//A2 (not valid in calc mode)
	b					calcEa_inval		//A3 (not valid in calc mode)
	b					calcEa_inval		//A4 (not valid in calc mode)
	b					calcEa_inval		//A5 (not valid in calc mode)
	b					calcEa_inval		//A6 (not valid in calc mode)
	b					calcEa_inval		//A7 (not valid in calc mode)
	b					calcEa_deref_A0		//(A0)
	b					calcEa_deref_A1		//(A1)
	b					calcEa_deref_A2		//(A2)
	b					calcEa_deref_A3		//(A3)
	b					calcEa_deref_A4		//(A4)
	b					calcEa_deref_A5		//(A5)
	b					calcEa_deref_A6		//(A6)
	b					calcEa_deref_A7		//(A7)
	b					calcEaB_deref_A0pp	//(A0)+
	b					calcEaB_deref_A1pp	//(A1)+
	b					calcEaB_deref_A2pp	//(A2)+
	b					calcEaB_deref_A3pp	//(A3)+
	b					calcEaB_deref_A4pp	//(A4)+
	b					calcEaB_deref_A5pp	//(A5)+
	b					calcEaB_deref_A6pp	//(A6)+
	b					calcEaW_deref_A7pp	//(A7)+		//yes, W
	b					calcEaB_deref_mmA0	//-(A0)
	b					calcEaB_deref_mmA1	//-(A1)
	b					calcEaB_deref_mmA2	//-(A2)
	b					calcEaB_deref_mmA3	//-(A3)
	b					calcEaB_deref_mmA4	//-(A4)
	b					calcEaB_deref_mmA5	//-(A5)
	b					calcEaB_deref_mmA6	//-(A6)
	b					calcEaW_deref_mmA7	//-(A7)		//yes, W
	b					calcEa_deref_d_A0	//d(A0)
	b					calcEa_deref_d_A1	//d(A1)
	b					calcEa_deref_d_A2	//d(A2)
	b					calcEa_deref_d_A3	//d(A3)
	b					calcEa_deref_d_A4	//d(A4)
	b					calcEa_deref_d_A5	//d(A5)
	b					calcEa_deref_d_A6	//d(A6)
	b					calcEa_deref_d_A7	//d(A7)
	b					calcEa_idx_A0		//d(A0,Xi)
	b					calcEa_idx_A1		//d(A1,Xi)
	b					calcEa_idx_A2		//d(A2,Xi)
	b					calcEa_idx_A3		//d(A3,Xi)
	b					calcEa_idx_A4		//d(A4,Xi)
	b					calcEa_idx_A5		//d(A5,Xi)
	b					calcEa_idx_A6		//d(A6,Xi)
	b					calcEa_idx_A7		//d(A7,Xi)
	b					calcEa_absW			//(0x????).W
	b					calcEa_absL			//(0x????????).L
	b					calcEa_dPC			//d(PC)
	b					calcEa_idx_PC		//d(PC,Xi)
	b					calcEa_inval		//#0x?? (not valid in calc mode)
	b					calcEa_inval
	b					calcEa_inval
	b					calcEa_inval

.macro calcEa_deref_Ax x
	calcEa_deref_A\x:
		ldr				r0, [rA, #4 * \x]
		bx				lr
.endm

	calcEa_deref_Ax		0
	calcEa_deref_Ax		1
	calcEa_deref_Ax		2
	calcEa_deref_Ax		3
	calcEa_deref_Ax		4
	calcEa_deref_Ax		5
	calcEa_deref_Ax		6
	calcEa_deref_Ax		7

.macro calcEaB_deref_Axpp x
	calcEaB_deref_A\x\()pp:
		ldr				r0, [rA, #4 * \x]
		adds			r1, r0, #1
		str				r1, [rA, #4 * \x]
		bx				lr
.endm
	
	calcEaB_deref_Axpp	0
	calcEaB_deref_Axpp	1
	calcEaB_deref_Axpp	2
	calcEaB_deref_Axpp	3
	calcEaB_deref_Axpp	4
	calcEaB_deref_Axpp	5
	calcEaB_deref_Axpp	6

.macro calcEaB_deref_mmAx x
	calcEaB_deref_mmA\x:
		ldr				r0, [rA, #4 * \x]
		subs			r0, #1
		str				r0, [rA, #4 * \x]
		bx				lr
.endm

	calcEaB_deref_mmAx	0
	calcEaB_deref_mmAx	1
	calcEaB_deref_mmAx	2
	calcEaB_deref_mmAx	3
	calcEaB_deref_mmAx	4
	calcEaB_deref_mmAx	5
	calcEaB_deref_mmAx	6

.macro calcEa_deref_d_Ax x
	calcEa_deref_d_A\x:
		getInstrWordSx	r0, r1
		ldr				r1, [rA, #4 * \x]
		adds			r0, r1
		bx				lr
.endm
	
	calcEa_deref_d_Ax	0
	calcEa_deref_d_Ax	1
	calcEa_deref_d_Ax	2
	calcEa_deref_d_Ax	3
	calcEa_deref_d_Ax	4
	calcEa_deref_d_Ax	5
	calcEa_deref_d_Ax	6
	calcEa_deref_d_Ax	7

.macro calcEa_idx_Ax x
	calcEa_idx_A\x:
		ldr				r0, [rA, #4 * \x]
		b				calcEa_idx_common
.endm

	calcEa_idx_Ax		0
	calcEa_idx_Ax		1
	calcEa_idx_Ax		2
	calcEa_idx_Ax		3
	calcEa_idx_Ax		4
	calcEa_idx_Ax		5
	calcEa_idx_Ax		6
	calcEa_idx_Ax		7

calcEa_idx_PC:
	mov					r0, rPC				//PC value we're relative to
	//fallthrough

calcEa_idx_common:							//r0 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	
	getInstrWordUx		r1, r2
	sxtb				r2, r1				//d
	adds				r0, r2				//d(An)
	lsrs				r2, r1, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	adds				r0, r2				//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	adds				r0, r2				//d(An, Xi.W)
	bx					lr

calcEa_absW:
	getInstrWordSx		r0, r1
	bx					lr

calcEa_absL:
	getInstrLong		r0, r1
	bx					lr

calcEa_dPC:
	mov					r0, rPC				//PC value we're relative to
	getInstrWordSx		r1, r2
	adds				r0, r1
	bx					lr

calcEa_inval:
	bl					instrsIllegal
.endfunc


.func calcEaW
calcEaW:					//(ea * 2) -> val byte
	add					pc, r0
	nop
	b					calcEa_inval		//D0 (not valid in calc mode)
	b					calcEa_inval		//D1 (not valid in calc mode)
	b					calcEa_inval		//D2 (not valid in calc mode)
	b					calcEa_inval		//D3 (not valid in calc mode)
	b					calcEa_inval		//D4 (not valid in calc mode)
	b					calcEa_inval		//D5 (not valid in calc mode)
	b					calcEa_inval		//D6 (not valid in calc mode)
	b					calcEa_inval		//D7 (not valid in calc mode)
	b					calcEa_inval		//A0 (not valid in calc mode)
	b					calcEa_inval		//A1 (not valid in calc mode)
	b					calcEa_inval		//A2 (not valid in calc mode)
	b					calcEa_inval		//A3 (not valid in calc mode)
	b					calcEa_inval		//A4 (not valid in calc mode)
	b					calcEa_inval		//A5 (not valid in calc mode)
	b					calcEa_inval		//A6 (not valid in calc mode)
	b					calcEa_inval		//A7 (not valid in calc mode)
	b					calcEa_deref_A0		//(A0)
	b					calcEa_deref_A1		//(A1)
	b					calcEa_deref_A2		//(A2)
	b					calcEa_deref_A3		//(A3)
	b					calcEa_deref_A4		//(A4)
	b					calcEa_deref_A5		//(A5)
	b					calcEa_deref_A6		//(A6)
	b					calcEa_deref_A7		//(A7)
	b					calcEaW_deref_A0pp	//(A0)+
	b					calcEaW_deref_A1pp	//(A1)+
	b					calcEaW_deref_A2pp	//(A2)+
	b					calcEaW_deref_A3pp	//(A3)+
	b					calcEaW_deref_A4pp	//(A4)+
	b					calcEaW_deref_A5pp	//(A5)+
	b					calcEaW_deref_A6pp	//(A6)+
	b					calcEaW_deref_A7pp	//(A7)+
	b					calcEaW_deref_mmA0	//-(A0)
	b					calcEaW_deref_mmA1	//-(A1)
	b					calcEaW_deref_mmA2	//-(A2)
	b					calcEaW_deref_mmA3	//-(A3)
	b					calcEaW_deref_mmA4	//-(A4)
	b					calcEaW_deref_mmA5	//-(A5)
	b					calcEaW_deref_mmA6	//-(A6)
	b					calcEaW_deref_mmA7	//-(A7)
	b					calcEa_deref_d_A0	//d(A0)
	b					calcEa_deref_d_A1	//d(A1)
	b					calcEa_deref_d_A2	//d(A2)
	b					calcEa_deref_d_A3	//d(A3)
	b					calcEa_deref_d_A4	//d(A4)
	b					calcEa_deref_d_A5	//d(A5)
	b					calcEa_deref_d_A6	//d(A6)
	b					calcEa_deref_d_A7	//d(A7)
	b					calcEa_idx_A0		//d(A0,Xi)
	b					calcEa_idx_A1		//d(A1,Xi)
	b					calcEa_idx_A2		//d(A2,Xi)
	b					calcEa_idx_A3		//d(A3,Xi)
	b					calcEa_idx_A4		//d(A4,Xi)
	b					calcEa_idx_A5		//d(A5,Xi)
	b					calcEa_idx_A6		//d(A6,Xi)
	b					calcEa_idx_A7		//d(A7,Xi)
	b					calcEa_absW			//(0x????).W
	b					calcEa_absL			//(0x????????).L
	b					calcEa_dPC			//d(PC)
	b					calcEa_idx_PC		//d(PC,Xi)
	b					calcEa_inval		//#0x?? (not valid in calc mode)
	b					calcEa_inval
	b					calcEa_inval
	b					calcEa_inval

.macro calcEaW_deref_Axpp x
	calcEaW_deref_A\x\()pp:
		ldr				r0, [rA, #4 * \x]
		adds			r1, r0, #2
		str				r1, [rA, #4 * \x]
		bx				lr
.endm
	
	calcEaW_deref_Axpp	0
	calcEaW_deref_Axpp	1
	calcEaW_deref_Axpp	2
	calcEaW_deref_Axpp	3
	calcEaW_deref_Axpp	4
	calcEaW_deref_Axpp	5
	calcEaW_deref_Axpp	6
	calcEaW_deref_Axpp	7

.macro calcEaW_deref_mmAx x
	calcEaW_deref_mmA\x:
		ldr				r0, [rA, #4 * \x]
		subs			r0, #2
		str				r0, [rA, #4 * \x]
		bx				lr
.endm

	calcEaW_deref_mmAx	0
	calcEaW_deref_mmAx	1
	calcEaW_deref_mmAx	2
	calcEaW_deref_mmAx	3
	calcEaW_deref_mmAx	4
	calcEaW_deref_mmAx	5
	calcEaW_deref_mmAx	6
	calcEaW_deref_mmAx	7

.endfunc


.func calcEaL
calcEaL:					//(ea * 2) -> val byte
	add					pc, r0
	nop
	b					calcEa_inval		//D0 (not valid in calc mode)
	b					calcEa_inval		//D1 (not valid in calc mode)
	b					calcEa_inval		//D2 (not valid in calc mode)
	b					calcEa_inval		//D3 (not valid in calc mode)
	b					calcEa_inval		//D4 (not valid in calc mode)
	b					calcEa_inval		//D5 (not valid in calc mode)
	b					calcEa_inval		//D6 (not valid in calc mode)
	b					calcEa_inval		//D7 (not valid in calc mode)
	b					calcEa_inval		//A0 (not valid in calc mode)
	b					calcEa_inval		//A1 (not valid in calc mode)
	b					calcEa_inval		//A2 (not valid in calc mode)
	b					calcEa_inval		//A3 (not valid in calc mode)
	b					calcEa_inval		//A4 (not valid in calc mode)
	b					calcEa_inval		//A5 (not valid in calc mode)
	b					calcEa_inval		//A6 (not valid in calc mode)
	b					calcEa_inval		//A7 (not valid in calc mode)
	b					calcEa_deref_A0		//(A0)
	b					calcEa_deref_A1		//(A1)
	b					calcEa_deref_A2		//(A2)
	b					calcEa_deref_A3		//(A3)
	b					calcEa_deref_A4		//(A4)
	b					calcEa_deref_A5		//(A5)
	b					calcEa_deref_A6		//(A6)
	b					calcEa_deref_A7		//(A7)
	b					calcEaL_deref_A0pp	//(A0)+
	b					calcEaL_deref_A1pp	//(A1)+
	b					calcEaL_deref_A2pp	//(A2)+
	b					calcEaL_deref_A3pp	//(A3)+
	b					calcEaL_deref_A4pp	//(A4)+
	b					calcEaL_deref_A5pp	//(A5)+
	b					calcEaL_deref_A6pp	//(A6)+
	b					calcEaL_deref_A7pp	//(A7)+
	b					calcEaL_deref_mmA0	//-(A0)
	b					calcEaL_deref_mmA1	//-(A1)
	b					calcEaL_deref_mmA2	//-(A2)
	b					calcEaL_deref_mmA3	//-(A3)
	b					calcEaL_deref_mmA4	//-(A4)
	b					calcEaL_deref_mmA5	//-(A5)
	b					calcEaL_deref_mmA6	//-(A6)
	b					calcEaL_deref_mmA7	//-(A7)
	b					calcEa_deref_d_A0	//d(A0)
	b					calcEa_deref_d_A1	//d(A1)
	b					calcEa_deref_d_A2	//d(A2)
	b					calcEa_deref_d_A3	//d(A3)
	b					calcEa_deref_d_A4	//d(A4)
	b					calcEa_deref_d_A5	//d(A5)
	b					calcEa_deref_d_A6	//d(A6)
	b					calcEa_deref_d_A7	//d(A7)
	b					calcEa_idx_A0		//d(A0,Xi)
	b					calcEa_idx_A1		//d(A1,Xi)
	b					calcEa_idx_A2		//d(A2,Xi)
	b					calcEa_idx_A3		//d(A3,Xi)
	b					calcEa_idx_A4		//d(A4,Xi)
	b					calcEa_idx_A5		//d(A5,Xi)
	b					calcEa_idx_A6		//d(A6,Xi)
	b					calcEa_idx_A7		//d(A7,Xi)
	b					calcEa_absW			//(0x????).W
	b					calcEa_absL			//(0x????????).L
	b					calcEa_dPC			//d(PC)
	b					calcEa_idx_PC		//d(PC,Xi)
	b					calcEa_inval		//#0x?? (not valid in calc mode)
	b					calcEa_inval
	b					calcEa_inval
	b					calcEa_inval

.macro calcEaL_deref_Axpp x
	calcEaL_deref_A\x\()pp:
		ldr				r0, [rA, #4 * \x]
		adds			r1, r0, #4
		str				r1, [rA, #4 * \x]
		bx				lr
.endm
	
	calcEaL_deref_Axpp	0
	calcEaL_deref_Axpp	1
	calcEaL_deref_Axpp	2
	calcEaL_deref_Axpp	3
	calcEaL_deref_Axpp	4
	calcEaL_deref_Axpp	5
	calcEaL_deref_Axpp	6
	calcEaL_deref_Axpp	7

.macro calcEaL_deref_mmAx x
	calcEaL_deref_mmA\x:
		ldr				r0, [rA, #4 * \x]
		subs			r0, #4
		str				r0, [rA, #4 * \x]
		bx				lr
.endm

	calcEaL_deref_mmAx	0
	calcEaL_deref_mmAx	1
	calcEaL_deref_mmAx	2
	calcEaL_deref_mmAx	3
	calcEaL_deref_mmAx	4
	calcEaL_deref_mmAx	5
	calcEaL_deref_mmAx	6
	calcEaL_deref_mmAx	7

.endfunc

.func readEaB
readEaB:					//(ea * 2) -> val byte
	add					pc, r0
	nop
	b					readEaB_d0			//D0.B
	b					readEaB_d1			//D1.B
	b					readEaB_d2			//D2.B
	b					readEaB_d3			//D3.B
	b					readEaB_d4			//D4.B
	b					readEaB_d5			//D5.B
	b					readEaB_d6			//D6.B
	b					readEaB_d7			//D7.B
	b					readEaB_inval		//A0 (not valid in B mode)
	b					readEaB_inval		//A1 (not valid in B mode)
	b					readEaB_inval		//A2 (not valid in B mode)
	b					readEaB_inval		//A3 (not valid in B mode)
	b					readEaB_inval		//A4 (not valid in B mode)
	b					readEaB_inval		//A5 (not valid in B mode)
	b					readEaB_inval		//A6 (not valid in B mode)
	b					readEaB_inval		//A7 (not valid in B mode)
	b					readEaB_deref_A0	//(A0)
	b					readEaB_deref_A1	//(A1)
	b					readEaB_deref_A2	//(A2)
	b					readEaB_deref_A3	//(A3)
	b					readEaB_deref_A4	//(A4)
	b					readEaB_deref_A5	//(A5)
	b					readEaB_deref_A6	//(A6)
	b					readEaB_deref_A7	//(A7)
	b					readEaB_deref_A0pp	//(A0)+
	b					readEaB_deref_A1pp	//(A1)+
	b					readEaB_deref_A2pp	//(A2)+
	b					readEaB_deref_A3pp	//(A3)+
	b					readEaB_deref_A4pp	//(A4)+
	b					readEaB_deref_A5pp	//(A5)+
	b					readEaB_deref_A6pp	//(A6)+
	b					readEaB_deref_A7pp	//(A7)+
	b					readEaB_deref_mmA0	//-(A0)
	b					readEaB_deref_mmA1	//-(A1)
	b					readEaB_deref_mmA2	//-(A2)
	b					readEaB_deref_mmA3	//-(A3)
	b					readEaB_deref_mmA4	//-(A4)
	b					readEaB_deref_mmA5	//-(A5)
	b					readEaB_deref_mmA6	//-(A6)
	b					readEaB_deref_mmA7	//-(A7)
	b					readEaB_deref_d_A0	//d(A0)
	b					readEaB_deref_d_A1	//d(A1)
	b					readEaB_deref_d_A2	//d(A2)
	b					readEaB_deref_d_A3	//d(A3)
	b					readEaB_deref_d_A4	//d(A4)
	b					readEaB_deref_d_A5	//d(A5)
	b					readEaB_deref_d_A6	//d(A6)
	b					readEaB_deref_d_A7	//d(A7)
	b					readEaB_idx_A0		//d(A0,Xi)
	b					readEaB_idx_A1		//d(A1,Xi)
	b					readEaB_idx_A2		//d(A2,Xi)
	b					readEaB_idx_A3		//d(A3,Xi)
	b					readEaB_idx_A4		//d(A4,Xi)
	b					readEaB_idx_A5		//d(A5,Xi)
	b					readEaB_idx_A6		//d(A6,Xi)
	b					readEaB_idx_A7		//d(A7,Xi)
	b					readEaB_absW		//(0x????).W
	b					readEaB_absL		//(0x????????).L
	b					readEaB_dPC			//d(PC)
	b					readEaB_idx_PC		//d(PC,Xi)
	b					readEaB_imm			//#0x??
	b					readEaB_inval
	b					readEaB_inval
	b					readEaB_inval

.macro readEaB_dx x
	readEaB_d\x:
		ldrb			r0, [rD, #4 * \x]
		bx				lr
.endm

	readEaB_dx			0
	readEaB_dx			1
	readEaB_dx			2
	readEaB_dx			3
	readEaB_dx			4
	readEaB_dx			5
	readEaB_dx			6
	readEaB_dx			7

.macro readEaB_deref_Ax x
	readEaB_deref_A\x:
		ldr				r1, [rA, #4 * \x]
		read8			r0, r1, r2
		bx				lr
.endm

	readEaB_deref_Ax	0
	readEaB_deref_Ax	1
	readEaB_deref_Ax	2
	readEaB_deref_Ax	3
	readEaB_deref_Ax	4
	readEaB_deref_Ax	5
	readEaB_deref_Ax	6
	readEaB_deref_Ax	7

.macro readEaB_deref_Axpp x, incrBy
	readEaB_deref_A\x\()pp:
		ldr				r1, [rA, #4 * \x]
		adds			r0, r1, #\incrBy
		str				r0, [rA, #4 * \x]
		read8			r0, r1, r2
		bx				lr
.endm
	
	readEaB_deref_Axpp	0, 1
	readEaB_deref_Axpp	1, 1
	readEaB_deref_Axpp	2, 1
	readEaB_deref_Axpp	3, 1
	readEaB_deref_Axpp	4, 1
	readEaB_deref_Axpp	5, 1
	readEaB_deref_Axpp	6, 1
	readEaB_deref_Axpp	7, 2	//A7 is special

.macro readEaB_deref_mmAx x, decrBy
	readEaB_deref_mmA\x:
		ldr				r1, [rA, #4 * \x]
		subs			r1, #\decrBy
		str				r1, [rA, #4 * \x]
		read8			r0, r1, r2
		bx				lr
.endm

	readEaB_deref_mmAx	0, 1
	readEaB_deref_mmAx	1, 1
	readEaB_deref_mmAx	2, 1
	readEaB_deref_mmAx	3, 1
	readEaB_deref_mmAx	4, 1
	readEaB_deref_mmAx	5, 1
	readEaB_deref_mmAx	6, 1
	readEaB_deref_mmAx	7, 2	//A7 is special

.macro readEaB_deref_d_Ax x
	readEaB_deref_d_A\x:
		getInstrWordSx	r0, r1
		ldr				r1, [rA, #4 * \x]
		read8sum		r0, r0, r1
		bx				lr
.endm
	
	readEaB_deref_d_Ax	0
	readEaB_deref_d_Ax	1
	readEaB_deref_d_Ax	2
	readEaB_deref_d_Ax	3
	readEaB_deref_d_Ax	4
	readEaB_deref_d_Ax	5
	readEaB_deref_d_Ax	6
	readEaB_deref_d_Ax	7

.macro readEaB_idx_Ax x
	readEaB_idx_A\x:
		ldr				r0, [rA, #4 * \x]
		b				readEaB_idx_common
.endm

	readEaB_idx_Ax		0
	readEaB_idx_Ax		1
	readEaB_idx_Ax		2
	readEaB_idx_Ax		3
	readEaB_idx_Ax		4
	readEaB_idx_Ax		5
	readEaB_idx_Ax		6
	readEaB_idx_Ax		7

readEaB_idx_PC:
	mov					r0, rPC				//PC value we're relative to
	//fallthrough

readEaB_idx_common:							//r0 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	
	getInstrWordUx		r1, r2
	sxtb				r2, r1				//d
	adds				r0, r2				//d(An)
	lsrs				r2, r1, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	read8sum			r0, r0, r2			//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	read8sum			r0, r0, r2			//d(An, Xi.W)
	bx					lr

readEaB_absW:
	getInstrWordSx		r1, r2
	read8				r0, r1, r2
	bx					lr

readEaB_absL:
	getInstrLong		r1, r2
	read8				r0, r1, r2
	bx					lr

readEaB_dPC:
	mov					r0, rPC				//PC value we're relative to
	getInstrWordSx		r1, r2
	read8sum			r0, r0, r1
	bx					lr

readEaB_imm:
	getInstrBytex		r0, r1
	bx					lr

readEaB_inval:
	bl					instrsIllegal
.endfunc

.func readEaW
readEaW:					//(ea * 2) -> val word (high bytes not always guaranteed clear)
	add					pc, r0
	nop
	b					readEaW_d0			//D0.W
	b					readEaW_d1			//D1.W
	b					readEaW_d2			//D2.W
	b					readEaW_d3			//D3.W
	b					readEaW_d4			//D4.W
	b					readEaW_d5			//D5.W
	b					readEaW_d6			//D6.W
	b					readEaW_d7			//D7.W
	b					readEa_a0			//A0
	b					readEa_a1			//A1
	b					readEa_a2			//A2
	b					readEa_a3			//A3
	b					readEa_a4			//A4
	b					readEa_a5			//A5
	b					readEa_a6			//A6
	b					readEa_a7			//A7
	b					readEaW_deref_A0	//(A0)
	b					readEaW_deref_A1	//(A1)
	b					readEaW_deref_A2	//(A2)
	b					readEaW_deref_A3	//(A3)
	b					readEaW_deref_A4	//(A4)
	b					readEaW_deref_A5	//(A5)
	b					readEaW_deref_A6	//(A6)
	b					readEaW_deref_A7	//(A7)
	b					readEaW_deref_A0pp	//(A0)+
	b					readEaW_deref_A1pp	//(A1)+
	b					readEaW_deref_A2pp	//(A2)+
	b					readEaW_deref_A3pp	//(A3)+
	b					readEaW_deref_A4pp	//(A4)+
	b					readEaW_deref_A5pp	//(A5)+
	b					readEaW_deref_A6pp	//(A6)+
	b					readEaW_deref_A7pp	//(A7)+
	b					readEaW_deref_mmA0	//-(A0)
	b					readEaW_deref_mmA1	//-(A1)
	b					readEaW_deref_mmA2	//-(A2)
	b					readEaW_deref_mmA3	//-(A3)
	b					readEaW_deref_mmA4	//-(A4)
	b					readEaW_deref_mmA5	//-(A5)
	b					readEaW_deref_mmA6	//-(A6)
	b					readEaW_deref_mmA7	//-(A7)
	b					readEaW_deref_d_A0	//d(A0)
	b					readEaW_deref_d_A1	//d(A1)
	b					readEaW_deref_d_A2	//d(A2)
	b					readEaW_deref_d_A3	//d(A3)
	b					readEaW_deref_d_A4	//d(A4)
	b					readEaW_deref_d_A5	//d(A5)
	b					readEaW_deref_d_A6	//d(A6)
	b					readEaW_deref_d_A7	//d(A7)
	b					readEaW_idx_A0		//d(A0,Xi)
	b					readEaW_idx_A1		//d(A1,Xi)
	b					readEaW_idx_A2		//d(A2,Xi)
	b					readEaW_idx_A3		//d(A3,Xi)
	b					readEaW_idx_A4		//d(A4,Xi)
	b					readEaW_idx_A5		//d(A5,Xi)
	b					readEaW_idx_A6		//d(A6,Xi)
	b					readEaW_idx_A7		//d(A7,Xi)
	b					readEaW_absW		//(0x????).W
	b					readEaW_absL		//(0x????????).L
	b					readEaW_dPC			//d(PC)
	b					readEaW_idx_PC		//d(PC,Xi)
	b					readEaW_imm			//#0x??
	b					readEaW_inval
	b					readEaW_inval
	b					readEaW_inval

.macro readEaW_dx_ax x
	readEaW_d\x:
		ldrh			r0, [rD, #4 * \x]
		bx				lr
.endm

	readEaW_dx_ax		0
	readEaW_dx_ax		1
	readEaW_dx_ax		2
	readEaW_dx_ax		3
	readEaW_dx_ax		4
	readEaW_dx_ax		5
	readEaW_dx_ax		6
	readEaW_dx_ax		7

.macro readEaW_deref_Ax x
	readEaW_deref_A\x:
		ldr				r1, [rA, #4 * \x]
		read16			r0, r1, r2
		bx				lr
.endm

	readEaW_deref_Ax	0
	readEaW_deref_Ax	1
	readEaW_deref_Ax	2
	readEaW_deref_Ax	3
	readEaW_deref_Ax	4
	readEaW_deref_Ax	5
	readEaW_deref_Ax	6
	readEaW_deref_Ax	7

.macro readEaW_deref_Axpp x
	readEaW_deref_A\x\()pp:
		ldr				r1, [rA, #4 * \x]
		adds			r0, r1, #2
		str				r0, [rA, #4 * \x]
		read16			r0, r1, r2
		bx				lr
.endm
	
	readEaW_deref_Axpp	0
	readEaW_deref_Axpp	1
	readEaW_deref_Axpp	2
	readEaW_deref_Axpp	3
	readEaW_deref_Axpp	4
	readEaW_deref_Axpp	5
	readEaW_deref_Axpp	6
	readEaW_deref_Axpp	7

.macro readEaW_deref_mmAx x
	readEaW_deref_mmA\x:
		ldr				r1, [rA, #4 * \x]
		subs			r1, #2
		str				r1, [rA, #4 * \x]
		read16			r0, r1, r2
		bx				lr
.endm

	readEaW_deref_mmAx	0
	readEaW_deref_mmAx	1
	readEaW_deref_mmAx	2
	readEaW_deref_mmAx	3
	readEaW_deref_mmAx	4
	readEaW_deref_mmAx	5
	readEaW_deref_mmAx	6
	readEaW_deref_mmAx	7

.macro readEaW_deref_d_Ax x
	readEaW_deref_d_A\x:
		getInstrWordSx	r0, r1
		ldr				r1, [rA, #4 * \x]
		read16sum		r0, r0, r1
		bx				lr
.endm
	
	readEaW_deref_d_Ax	0
	readEaW_deref_d_Ax	1
	readEaW_deref_d_Ax	2
	readEaW_deref_d_Ax	3
	readEaW_deref_d_Ax	4
	readEaW_deref_d_Ax	5
	readEaW_deref_d_Ax	6
	readEaW_deref_d_Ax	7

.macro readEaW_idx_Ax x
	readEaW_idx_A\x:
		ldr				r0, [rA, #4 * \x]
		b				readEaW_idx_common
.endm

	readEaW_idx_Ax		0
	readEaW_idx_Ax		1
	readEaW_idx_Ax		2
	readEaW_idx_Ax		3
	readEaW_idx_Ax		4
	readEaW_idx_Ax		5
	readEaW_idx_Ax		6
	readEaW_idx_Ax		7

readEaW_idx_PC:
	mov					r0, rPC				//PC value we're relative to
	//fallthrough

readEaW_idx_common:							//r0 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	
	getInstrWordUx		r1, r2
	sxtb				r2, r1				//d
	adds				r0, r2				//d(An)
	lsrs				r2, r1, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	read16sum			r0, r0, r2			//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	read16sum			r0, r0, r2			//d(An, Xi.W)
	bx					lr


readEaW_absW:
	getInstrWordSx		r1, r2
	read16				r0, r1, r2
	bx					lr

readEaW_absL:
	getInstrLong		r1, r2
	read16				r0, r1, r2
	bx					lr

readEaW_dPC:
	mov					r0, rPC				//PC value we're relative to
	getInstrWordSx		r1, r2
	read16sum			r0, r0, r1
	bx					lr

readEaW_imm:
	getInstrWordUx		r0, r1
	bx					lr

readEaW_inval:
	bl					instrsIllegal
.endfunc

.func readEaL
readEaL:					//(ea * 2) -> val word (high bytes not always guaranteed clear)
	add					pc, r0
	nop
	b					readEaL_d0			//D0.L
	b					readEaL_d1			//D1.L
	b					readEaL_d2			//D2.L
	b					readEaL_d3			//D3.L
	b					readEaL_d4			//D4.L
	b					readEaL_d5			//D5.L
	b					readEaL_d6			//D6.L
	b					readEaL_d7			//D7.L
	b					readEa_a0			//A0
	b					readEa_a1			//A1
	b					readEa_a2			//A2
	b					readEa_a3			//A3
	b					readEa_a4			//A4
	b					readEa_a5			//A5
	b					readEa_a6			//A6
	b					readEa_a7			//A7
	b					readEaL_deref_A0	//(A0)
	b					readEaL_deref_A1	//(A1)
	b					readEaL_deref_A2	//(A2)
	b					readEaL_deref_A3	//(A3)
	b					readEaL_deref_A4	//(A4)
	b					readEaL_deref_A5	//(A5)
	b					readEaL_deref_A6	//(A6)
	b					readEaL_deref_A7	//(A7)
	b					readEaL_deref_A0pp	//(A0)+
	b					readEaL_deref_A1pp	//(A1)+
	b					readEaL_deref_A2pp	//(A2)+
	b					readEaL_deref_A3pp	//(A3)+
	b					readEaL_deref_A4pp	//(A4)+
	b					readEaL_deref_A5pp	//(A5)+
	b					readEaL_deref_A6pp	//(A6)+
	b					readEaL_deref_A7pp	//(A7)+
	b					readEaL_deref_mmA0	//-(A0)
	b					readEaL_deref_mmA1	//-(A1)
	b					readEaL_deref_mmA2	//-(A2)
	b					readEaL_deref_mmA3	//-(A3)
	b					readEaL_deref_mmA4	//-(A4)
	b					readEaL_deref_mmA5	//-(A5)
	b					readEaL_deref_mmA6	//-(A6)
	b					readEaL_deref_mmA7	//-(A7)
	b					readEaL_deref_d_A0	//d(A0)
	b					readEaL_deref_d_A1	//d(A1)
	b					readEaL_deref_d_A2	//d(A2)
	b					readEaL_deref_d_A3	//d(A3)
	b					readEaL_deref_d_A4	//d(A4)
	b					readEaL_deref_d_A5	//d(A5)
	b					readEaL_deref_d_A6	//d(A6)
	b					readEaL_deref_d_A7	//d(A7)
	b					readEaL_idx_A0		//d(A0,Xi)
	b					readEaL_idx_A1		//d(A1,Xi)
	b					readEaL_idx_A2		//d(A2,Xi)
	b					readEaL_idx_A3		//d(A3,Xi)
	b					readEaL_idx_A4		//d(A4,Xi)
	b					readEaL_idx_A5		//d(A5,Xi)
	b					readEaL_idx_A6		//d(A6,Xi)
	b					readEaL_idx_A7		//d(A7,Xi)
	b					readEaL_absW		//(0x????).W
	b					readEaL_absL		//(0x????????).L
	b					readEaL_dPC			//d(PC)
	b					readEaL_idx_PC		//d(PC,Xi)
	b					readEaL_imm			//#0x??
	b					readEaL_inval
	b					readEaL_inval
	b					readEaL_inval

.macro readEaL_dx_ax x
	readEaL_d\x:
		ldr				r0, [rD, #4 * \x]
		bx				lr
	
	readEa_a\x:
		ldr				r0, [rA, #4 * \x]
		bx				lr
.endm

	readEaL_dx_ax		0
	readEaL_dx_ax		1
	readEaL_dx_ax		2
	readEaL_dx_ax		3
	readEaL_dx_ax		4
	readEaL_dx_ax		5
	readEaL_dx_ax		6
	readEaL_dx_ax		7

.macro readEaL_deref_Ax x
	readEaL_deref_A\x:
		ldr				r0, [rA, #4 * \x]
		read32			r0, r0, r1
		bx				lr
.endm

	readEaL_deref_Ax	0
	readEaL_deref_Ax	1
	readEaL_deref_Ax	2
	readEaL_deref_Ax	3
	readEaL_deref_Ax	4
	readEaL_deref_Ax	5
	readEaL_deref_Ax	6
	readEaL_deref_Ax	7

.macro readEaL_deref_Axpp x
	readEaL_deref_A\x\()pp:
		ldr				r0, [rA, #4 * \x]
		adds			r1, r0, #4
		str				r1, [rA, #4 * \x]
		read32			r0, r0, r1
		bx				lr
.endm
	
	readEaL_deref_Axpp	0
	readEaL_deref_Axpp	1
	readEaL_deref_Axpp	2
	readEaL_deref_Axpp	3
	readEaL_deref_Axpp	4
	readEaL_deref_Axpp	5
	readEaL_deref_Axpp	6
	readEaL_deref_Axpp	7

.macro readEaL_deref_mmAx x
	readEaL_deref_mmA\x:
		ldr				r0, [rA, #4 * \x]
		subs			r0, #4
		str				r0, [rA, #4 * \x]
		read32			r0, r0, r1
		bx				lr
.endm

	readEaL_deref_mmAx	0
	readEaL_deref_mmAx	1
	readEaL_deref_mmAx	2
	readEaL_deref_mmAx	3
	readEaL_deref_mmAx	4
	readEaL_deref_mmAx	5
	readEaL_deref_mmAx	6
	readEaL_deref_mmAx	7

.macro readEaL_deref_d_Ax x
	readEaL_deref_d_A\x:
		getInstrWordSx	r0, r1
		ldr				r1, [rA, #4 * \x]
		adds			r0, r1
		read32			r0, r0, r1
		bx				lr
.endm
	
	readEaL_deref_d_Ax	0
	readEaL_deref_d_Ax	1
	readEaL_deref_d_Ax	2
	readEaL_deref_d_Ax	3
	readEaL_deref_d_Ax	4
	readEaL_deref_d_Ax	5
	readEaL_deref_d_Ax	6
	readEaL_deref_d_Ax	7

.macro readEaL_idx_Ax x
	readEaL_idx_A\x:
		ldr				r0, [rA, #4 * \x]
		b				readEaL_idx_common
.endm

	readEaL_idx_Ax		0
	readEaL_idx_Ax		1
	readEaL_idx_Ax		2
	readEaL_idx_Ax		3
	readEaL_idx_Ax		4
	readEaL_idx_Ax		5
	readEaL_idx_Ax		6
	readEaL_idx_Ax		7

readEaL_idx_PC:
	mov					r0, rPC				//PC value we're relative to
	//fallthrough

readEaL_idx_common:							//r0 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	
	getInstrWordUx		r1, r2
	sxtb				r2, r1				//d
	adds				r0, r2				//d(An)
	lsrs				r2, r1, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	adds				r0, r2
	read32				r0, r0, r2			//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	adds				r0, r2
	read32				r0, r0, r2			//d(An, Xi.W)
	bx					lr


readEaL_absW:
	getInstrWordSx		r0, r1
	read32				r0, r0, r1
	bx					lr

readEaL_absL:
	getInstrLong		r0, r1
	read32				r0, r0, r1
	bx					lr

readEaL_dPC:
	mov					r0, rPC				//PC value we're relative to
	getInstrWordSx		r1, r2
	adds				r0, r1
	read32				r0, r0, r1
	bx					lr

readEaL_imm:
	getInstrLong		r0, r1
	bx					lr

readEaL_inval:
	bl					instrsIllegal
.endfunc

.func writeEaB
writeEaB:					//(val, ea * 2)
	add					pc, r1
	nop
	b					writeEaB_d0			//D0.B
	b					writeEaB_inval		//A0 (not valid in B mode)
	b					writeEaB_deref_A0	//(A0)
	b					writeEaB_deref_A0pp	//(A0)+
	b					writeEaB_deref_mmA0	//-(A0)
	b					writeEaB_deref_d_A0	//d(A0)
	b					writeEaB_idx_A0		//d(A0,Xi)
	b					writeEaB_absW		//(0x????).W
	b					writeEaB_d1			//D1.B
	b					writeEaB_inval		//A1 (not valid in B mode)
	b					writeEaB_deref_A1	//(A1)
	b					writeEaB_deref_A1pp	//(A1)+
	b					writeEaB_deref_mmA1	//-(A1)
	b					writeEaB_deref_d_A1	//d(A1)
	b					writeEaB_idx_A1		//d(A1,Xi)
	b					writeEaB_absL		//(0x????????).L
	b					writeEaB_d2			//D2.B
	b					writeEaB_inval		//A2 (not valid in B mode)
	b					writeEaB_deref_A2	//(A2)
	b					writeEaB_deref_A2pp	//(A2)+
	b					writeEaB_deref_mmA2	//-(A2)
	b					writeEaB_deref_d_A2	//d(A2)
	b					writeEaB_idx_A2		//d(A2,Xi)
	b					writeEaB_inval		//d(PC)
	b					writeEaB_d3			//D3.B
	b					writeEaB_inval		//A3 (not valid in B mode)
	b					writeEaB_deref_A3	//(A3)
	b					writeEaB_deref_A3pp	//(A3)+
	b					writeEaB_deref_mmA3	//-(A3)
	b					writeEaB_deref_d_A3	//d(A3)
	b					writeEaB_idx_A3		//d(A3,Xi)
	b					writeEaB_inval		//d(PC,Xi)
	b					writeEaB_d4			//D4.B
	b					writeEaB_inval		//A4 (not valid in B mode)
	b					writeEaB_deref_A4	//(A4)
	b					writeEaB_deref_A4pp	//(A4)+
	b					writeEaB_deref_mmA4	//-(A4)
	b					writeEaB_deref_d_A4	//d(A4)
	b					writeEaB_idx_A4		//d(A4,Xi)
	b					writeEaB_inval		//#0x??
	b					writeEaB_d5			//D5.B
	b					writeEaB_inval		//A5 (not valid in B mode)
	b					writeEaB_deref_A5	//(A5)
	b					writeEaB_deref_A5pp	//(A5)+
	b					writeEaB_deref_mmA5	//-(A5)
	b					writeEaB_deref_d_A5	//d(A5)
	b					writeEaB_idx_A5		//d(A5,Xi)
	b					writeEaB_inval
	b					writeEaB_d6			//D6.B
	b					writeEaB_inval		//A6 (not valid in B mode)
	b					writeEaB_deref_A6	//(A6)
	b					writeEaB_deref_A6pp	//(A6)+
	b					writeEaB_deref_mmA6	//-(A6)
	b					writeEaB_deref_d_A6	//d(A6)
	b					writeEaB_idx_A6		//d(A6,Xi)
	b					writeEaB_inval
	b					writeEaB_d7			//D7.B
	b					writeEaB_inval		//A7 (not valid in B mode)
	b					writeEaB_deref_A7	//(A7)
	b					writeEaB_deref_A7pp	//(A7)+
	b					writeEaB_deref_mmA7	//-(A7)
	b					writeEaB_deref_d_A7	//d(A7)
	b					writeEaB_idx_A7		//d(A7,Xi)
	b					writeEaB_inval


.macro writeEaB_dx x
	writeEaB_d\x:
		strb			r0, [rD, #4 * \x]
		bx				lr
.endm

	writeEaB_dx			0
	writeEaB_dx			1
	writeEaB_dx			2
	writeEaB_dx			3
	writeEaB_dx			4
	writeEaB_dx			5
	writeEaB_dx			6
	writeEaB_dx			7


.macro writeEaB_deref_Ax x
	writeEaB_deref_A\x:
		ldr				r1, [rA, #4 * \x]
		write8			r0, r1, r2
		bx				lr
.endm

	writeEaB_deref_Ax	0
	writeEaB_deref_Ax	1
	writeEaB_deref_Ax	2
	writeEaB_deref_Ax	3
	writeEaB_deref_Ax	4
	writeEaB_deref_Ax	5
	writeEaB_deref_Ax	6
	writeEaB_deref_Ax	7

.macro writeEaB_deref_Axpp x, incrBy
	writeEaB_deref_A\x\()pp:
		ldr				r1, [rA, #4 * \x]
		adds			r2, r1, #\incrBy
		str				r2, [rA, #4 * \x]
		write8			r0, r1, r2
		bx				lr
.endm
	
	writeEaB_deref_Axpp	0, 1
	writeEaB_deref_Axpp	1, 1
	writeEaB_deref_Axpp	2, 1
	writeEaB_deref_Axpp	3, 1
	writeEaB_deref_Axpp	4, 1
	writeEaB_deref_Axpp	5, 1
	writeEaB_deref_Axpp	6, 1
	writeEaB_deref_Axpp	7, 2	//A7 is special
	

.macro writeEaB_deref_mmA x, decrBy
	writeEaB_deref_mmA\x:
		ldr				r1, [rA, #4 * \x]
		subs			r1, #\decrBy
		str				r1, [rA, #4 * \x]
		write8			r0, r1, r2
		bx				lr
.endm

	writeEaB_deref_mmA	0, 1
	writeEaB_deref_mmA	1, 1
	writeEaB_deref_mmA	2, 1
	writeEaB_deref_mmA	3, 1
	writeEaB_deref_mmA	4, 1
	writeEaB_deref_mmA	5, 1
	writeEaB_deref_mmA	6, 1
	writeEaB_deref_mmA	7, 2	//A7 is special


.macro writeEaB_deref_d_Ax x
	writeEaB_deref_d_A\x:
		getInstrWordSx	r1, r2
		ldr				r2, [rA, #4 * \x]
		write8sum		r0, r1, r2
		bx				lr
.endm
	
	writeEaB_deref_d_Ax	0
	writeEaB_deref_d_Ax	1
	writeEaB_deref_d_Ax	2
	writeEaB_deref_d_Ax	3
	writeEaB_deref_d_Ax	4
	writeEaB_deref_d_Ax	5
	writeEaB_deref_d_Ax	6
	writeEaB_deref_d_Ax	7


.macro writeEaB_idx_Ax x
	writeEaB_idx_A\x:
		ldr				r1, [rA, #4 * \x]
		b				writeEaB_idx_common
.endm

	writeEaB_idx_Ax		0
	writeEaB_idx_Ax		1
	writeEaB_idx_Ax		2
	writeEaB_idx_Ax		3
	writeEaB_idx_Ax		4
	writeEaB_idx_Ax		5
	writeEaB_idx_Ax		6
	writeEaB_idx_Ax		7


writeEaB_idx_common:						//r0 is the byte, r1 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	
	getInstrWordUx		r2, r3
	sxtb				r3, r2				//d
	adds				r1, r3				//d(An)
	lsrs				r2, r2, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	write8sum			r0, r1, r2			//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	write8sum			r0, r1, r2			//d(An, Xi.W)
	bx					lr

writeEaB_absW:
	getInstrWordSx		r1, r2
	write8				r0, r1, r2
	bx					lr

writeEaB_absL:
	getInstrLong		r1, r2
	write8				r0, r1, r2
	bx					lr

writeEaB_inval:
	bl					instrsIllegal
.endfunc

.func writeEaW
writeEaW:					//(val, ea * 2)
	add					pc, r1
	nop
	b					writeEaW_d0			//D0.W
	b					writeEaW_a0			//A0.W
	b					writeEaW_deref_A0	//(A0)
	b					writeEaW_deref_A0pp	//(A0)+
	b					writeEaW_deref_mmA0	//-(A0)
	b					writeEaW_deref_d_A0	//d(A0)
	b					writeEaW_idx_A0		//d(A0,Xi)
	b					writeEaW_absW		//(0x????).W
	b					writeEaW_d1			//D1.W
	b					writeEaW_a1			//A1.W
	b					writeEaW_deref_A1	//(A1)
	b					writeEaW_deref_A1pp	//(A1)+
	b					writeEaW_deref_mmA1	//-(A1)
	b					writeEaW_deref_d_A1	//d(A1)
	b					writeEaW_idx_A1		//d(A1,Xi)
	b					writeEaW_absL		//(0x????????).L
	b					writeEaW_d2			//D2.W
	b					writeEaW_a2			//A2.W
	b					writeEaW_deref_A2	//(A2)
	b					writeEaW_deref_A2pp	//(A2)+
	b					writeEaW_deref_mmA2	//-(A2)
	b					writeEaW_deref_d_A2	//d(A2)
	b					writeEaW_idx_A2		//d(A2,Xi)
	b					writeEaW_inval		//d(PC)
	b					writeEaW_d3			//D3.W
	b					writeEaW_a3			//A3.W
	b					writeEaW_deref_A3	//(A3)
	b					writeEaW_deref_A3pp	//(A3)+
	b					writeEaW_deref_mmA3	//-(A3)
	b					writeEaW_deref_d_A3	//d(A3)
	b					writeEaW_idx_A3		//d(A3,Xi)
	b					writeEaW_inval		//d(PC,Xi)
	b					writeEaW_d4			//D4.W
	b					writeEaW_a4			//A4.W
	b					writeEaW_deref_A4	//(A4)
	b					writeEaW_deref_A4pp	//(A4)+
	b					writeEaW_deref_mmA4	//-(A4)
	b					writeEaW_deref_d_A4	//d(A4)
	b					writeEaW_idx_A4		//d(A4,Xi)
	b					writeEaW_inval		//#0x??
	b					writeEaW_d5			//D5.W
	b					writeEaW_a5			//A5.W
	b					writeEaW_deref_A5	//(A5)
	b					writeEaW_deref_A5pp	//(A5)+
	b					writeEaW_deref_mmA5	//-(A5)
	b					writeEaW_deref_d_A5	//d(A5)
	b					writeEaW_idx_A5		//d(A5,Xi)
	b					writeEaW_inval
	b					writeEaW_d6			//D6.W
	b					writeEaW_a6			//A6.W
	b					writeEaW_deref_A6	//(A6)
	b					writeEaW_deref_A6pp	//(A6)+
	b					writeEaW_deref_mmA6	//-(A6)
	b					writeEaW_deref_d_A6	//d(A6)
	b					writeEaW_idx_A6		//d(A6,Xi)
	b					writeEaW_inval
	b					writeEaW_d7			//D7.W
	b					writeEaW_a7			//A7.W
	b					writeEaW_deref_A7	//(A7)
	b					writeEaW_deref_A7pp	//(A7)+
	b					writeEaW_deref_mmA7	//-(A7)
	b					writeEaW_deref_d_A7	//d(A7)
	b					writeEaW_idx_A7		//d(A7,Xi)
	b					writeEaW_inval


.macro writeEaW_dx_ax x
	writeEaW_d\x:
		strh			r0, [rD, #4 * \x]
		bx				lr
	
	writeEaW_a\x:
		sxth			r0, r0
		str				r0, [rA, #4 * \x]
		nextInstr
.endm

	writeEaW_dx_ax		0
	writeEaW_dx_ax		1
	writeEaW_dx_ax		2
	writeEaW_dx_ax		3
	writeEaW_dx_ax		4
	writeEaW_dx_ax		5
	writeEaW_dx_ax		6
	writeEaW_dx_ax		7


.macro writeEaW_deref_Ax x
	writeEaW_deref_A\x:
		ldr				r1, [rA, #4 * \x]
		write16			r0, r1, r2
		bx				lr
.endm

	writeEaW_deref_Ax	0
	writeEaW_deref_Ax	1
	writeEaW_deref_Ax	2
	writeEaW_deref_Ax	3
	writeEaW_deref_Ax	4
	writeEaW_deref_Ax	5
	writeEaW_deref_Ax	6
	writeEaW_deref_Ax	7

.macro writeEaW_deref_Axpp x
	writeEaW_deref_A\x\()pp:
		ldr				r1, [rA, #4 * \x]
		adds			r2, r1, #2
		str				r2, [rA, #4 * \x]
		write16			r0, r1, r2
		bx				lr
.endm
	
	writeEaW_deref_Axpp	0
	writeEaW_deref_Axpp	1
	writeEaW_deref_Axpp	2
	writeEaW_deref_Axpp	3
	writeEaW_deref_Axpp	4
	writeEaW_deref_Axpp	5
	writeEaW_deref_Axpp	6
	writeEaW_deref_Axpp	7


.macro writeEaW_deref_mmA x, decrBy
	writeEaW_deref_mmA\x:
		ldr				r1, [rA, #4 * \x]
		subs			r1, #2
		str				r1, [rA, #4 * \x]
		write16			r0, r1, r2
		bx				lr
.endm

	writeEaW_deref_mmA	0
	writeEaW_deref_mmA	1
	writeEaW_deref_mmA	2
	writeEaW_deref_mmA	3
	writeEaW_deref_mmA	4
	writeEaW_deref_mmA	5
	writeEaW_deref_mmA	6
	writeEaW_deref_mmA	7


.macro writeEaW_deref_d_Ax x
	writeEaW_deref_d_A\x:
		getInstrWordSx	r1, r2
		ldr				r2, [rA, #4 * \x]
		write16sum		r0, r1, r2, r3
		bx				lr
.endm
	
	writeEaW_deref_d_Ax	0
	writeEaW_deref_d_Ax	1
	writeEaW_deref_d_Ax	2
	writeEaW_deref_d_Ax	3
	writeEaW_deref_d_Ax	4
	writeEaW_deref_d_Ax	5
	writeEaW_deref_d_Ax	6
	writeEaW_deref_d_Ax	7


.macro writeEaW_idx_Ax x
	writeEaW_idx_A\x:
		ldr				r1, [rA, #4 * \x]
		b				writeEaW_idx_common
.endm

	writeEaW_idx_Ax		0
	writeEaW_idx_Ax		1
	writeEaW_idx_Ax		2
	writeEaW_idx_Ax		3
	writeEaW_idx_Ax		4
	writeEaW_idx_Ax		5
	writeEaW_idx_Ax		6
	writeEaW_idx_Ax		7


writeEaW_idx_common:						//r1 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	
	getInstrWordUx		r2, r3
	sxtb				r3, r2				//d
	adds				r1, r3				//d(An)
	lsrs				r2, r2, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	write16sum			r0, r1, r2, r3		//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	write16sum			r0, r1, r2, r2		//d(An, Xi.W)
	bx					lr

writeEaW_absW:
	getInstrWordSx		r1, r2
	write16				r0, r1, r2
	bx					lr
	
writeEaW_absL:
	getInstrLong		r1, r2
	write16				r0, r1, r2
	bx					lr

writeEaW_inval:
	bl					instrsIllegal
.endfunc

.func writeEaL
writeEaL:					//(VAL, ea * 2)
	add					pc, r1
	nop
	b					writeEaL_d0			//D0.W
	b					writeEaL_a0			//A0.W
	b					writeEaL_deref_A0	//(A0)
	b					writeEaL_deref_A0pp	//(A0)+
	b					writeEaL_deref_mmA0	//-(A0)
	b					writeEaL_deref_d_A0	//d(A0)
	b					writeEaL_idx_A0		//d(A0,Xi)
	b					writeEaL_absW		//(0x????).W
	b					writeEaL_d1			//D1.W
	b					writeEaL_a1			//A1.W
	b					writeEaL_deref_A1	//(A1)
	b					writeEaL_deref_A1pp	//(A1)+
	b					writeEaL_deref_mmA1	//-(A1)
	b					writeEaL_deref_d_A1	//d(A1)
	b					writeEaL_idx_A1		//d(A1,Xi)
	b					writeEaL_absL		//(0x????????).L
	b					writeEaL_d2			//D2.W
	b					writeEaL_a2			//A2.W
	b					writeEaL_deref_A2	//(A2)
	b					writeEaL_deref_A2pp	//(A2)+
	b					writeEaL_deref_mmA2	//-(A2)
	b					writeEaL_deref_d_A2	//d(A2)
	b					writeEaL_idx_A2		//d(A2,Xi)
	b					writeEaL_inval		//d(PC)
	b					writeEaL_d3			//D3.W
	b					writeEaL_a3			//A3.W
	b					writeEaL_deref_A3	//(A3)
	b					writeEaL_deref_A3pp	//(A3)+
	b					writeEaL_deref_mmA3	//-(A3)
	b					writeEaL_deref_d_A3	//d(A3)
	b					writeEaL_idx_A3		//d(A3,Xi)
	b					writeEaL_inval		//d(PC,Xi)
	b					writeEaL_d4			//D4.W
	b					writeEaL_a4			//A4.W
	b					writeEaL_deref_A4	//(A4)
	b					writeEaL_deref_A4pp	//(A4)+
	b					writeEaL_deref_mmA4	//-(A4)
	b					writeEaL_deref_d_A4	//d(A4)
	b					writeEaL_idx_A4		//d(A4,Xi)
	b					writeEaL_inval		//#0x??
	b					writeEaL_d5			//D5.W
	b					writeEaL_a5			//A5.W
	b					writeEaL_deref_A5	//(A5)
	b					writeEaL_deref_A5pp	//(A5)+
	b					writeEaL_deref_mmA5	//-(A5)
	b					writeEaL_deref_d_A5	//d(A5)
	b					writeEaL_idx_A5		//d(A5,Xi)
	b					writeEaL_inval
	b					writeEaL_d6			//D6.W
	b					writeEaL_a6			//A6.W
	b					writeEaL_deref_A6	//(A6)
	b					writeEaL_deref_A6pp	//(A6)+
	b					writeEaL_deref_mmA6	//-(A6)
	b					writeEaL_deref_d_A6	//d(A6)
	b					writeEaL_idx_A6		//d(A6,Xi)
	b					writeEaL_inval
	b					writeEaL_d7			//D7.W
	b					writeEaL_a7			//A7.W
	b					writeEaL_deref_A7	//(A7)
	b					writeEaL_deref_A7pp	//(A7)+
	b					writeEaL_deref_mmA7	//-(A7)
	b					writeEaL_deref_d_A7	//d(A7)
	b					writeEaL_idx_A7		//d(A7,Xi)
	b					writeEaL_inval


.macro writeEaL_dx_ax x
	writeEaL_d\x:
		str					r0, [rD, #4 * \x]
		bx					lr
	
	writeEaL_a\x:
		str					r0, [rA, #4 * \x]
		nextInstr
.endm

	writeEaL_dx_ax		0
	writeEaL_dx_ax		1
	writeEaL_dx_ax		2
	writeEaL_dx_ax		3
	writeEaL_dx_ax		4
	writeEaL_dx_ax		5
	writeEaL_dx_ax		6
	writeEaL_dx_ax		7


.macro writeEaL_deref_Ax x
	writeEaL_deref_A\x:
		ldr				r1, [rA, #4 * \x]
		write32			r0, r1, r2
		bx				lr
.endm

	writeEaL_deref_Ax	0
	writeEaL_deref_Ax	1
	writeEaL_deref_Ax	2
	writeEaL_deref_Ax	3
	writeEaL_deref_Ax	4
	writeEaL_deref_Ax	5
	writeEaL_deref_Ax	6
	writeEaL_deref_Ax	7

.macro writeEaL_deref_Axpp x
	writeEaL_deref_A\x\()pp:
		ldr				r1, [rA, #4 * \x]
		adds			r2, r1, #4
		str				r2, [rA, #4 * \x]
		write32			r0, r1, r2
		bx				lr
.endm
	
	writeEaL_deref_Axpp	0
	writeEaL_deref_Axpp	1
	writeEaL_deref_Axpp	2
	writeEaL_deref_Axpp	3
	writeEaL_deref_Axpp	4
	writeEaL_deref_Axpp	5
	writeEaL_deref_Axpp	6
	writeEaL_deref_Axpp	7
	

.macro writeEaL_deref_mmA x
	writeEaL_deref_mmA\x:
		ldr				r1, [rA, #4 * \x]
		subs			r1, #4
		str				r1, [rA, #4 * \x]
		write32			r0, r1, r2
		bx				lr
.endm

	writeEaL_deref_mmA	0
	writeEaL_deref_mmA	1
	writeEaL_deref_mmA	2
	writeEaL_deref_mmA	3
	writeEaL_deref_mmA	4
	writeEaL_deref_mmA	5
	writeEaL_deref_mmA	6
	writeEaL_deref_mmA	7


.macro writeEaL_deref_d_Ax x
	writeEaL_deref_d_A\x:
		getInstrWordSx	r1, r2
		ldr				r2, [rA, #4 * \x]
		adds			r1, r2
		write32			r0, r1, r2
		bx				lr
.endm
	
	writeEaL_deref_d_Ax	0
	writeEaL_deref_d_Ax	1
	writeEaL_deref_d_Ax	2
	writeEaL_deref_d_Ax	3
	writeEaL_deref_d_Ax	4
	writeEaL_deref_d_Ax	5
	writeEaL_deref_d_Ax	6
	writeEaL_deref_d_Ax	7


.macro writeEaL_idx_Ax x
	writeEaL_idx_A\x:
		ldr				r1, [rA, #4 * \x]
		b				writeEaL_idx_common
.endm

	writeEaL_idx_Ax		0
	writeEaL_idx_Ax		1
	writeEaL_idx_Ax		2
	writeEaL_idx_Ax		3
	writeEaL_idx_Ax		4
	writeEaL_idx_Ax		5
	writeEaL_idx_Ax		6
	writeEaL_idx_Ax		7


writeEaL_idx_common:						//r0 is An's value
	//the word next has:
	//qrrrw000dddddddd, where q is 1 for Ax, 0 for Dx, r is the reg to use, w is 0 to treat reg as signed word (else u32), d is signed 8bit offset
	//"qrrr", due to how we store regs can be used to deref "rD" to get A regs too.
	getInstrWordUx		r2, r3
	sxtb				r3, r2				//d
	adds				r1, r3				//d(An)
	lsrs				r2, r2, #12			//r2 = D/A bit and then reg number. SR.C is "W"
	bcc					1f
	lsls				r2, r2, #2
	ldr					r2, [rD, r2]		//Xi.L
	adds				r1, r2
	write32				r0, r1, r2			//d(An, Xi.L)
	bx					lr
	
1:
	lsls				r2, r2, #2
	ldrsh				r2, [rD, r2]		//Xi.W
	adds				r1, r2
	write32				r0, r1, r2			//d(An, Xi.W)
	bx					lr

writeEaL_absW:
	getInstrWordSx		r1, r2
	write32				r0, r1, r2
	bx					lr
	
writeEaL_absL:
	getInstrLong		r1, r2
	write32				r0, r1, r2
	bx					lr

writeEaL_inval:
	bl					instrsIllegal
.endfunc

