#include <stdint.h>
#include <MemoryMgr.h>
#include <LibTraps.h>
#include <Extensions/ExpansionMgr/ExpansionMgr.h>
#include <Extensions/ExpansionMgr/SlotDrvrLib.h>
#include "printf.h"
#include "common.h"
#include "pace.h"
#include "slot.h"




static Err paceHandleCardMetrics(uint16_t refNum, EmulStateRef ref)
{
	uint16_t slot;
	CardMetricsType* info;
	CardMetricsType local;	//local copy
	uint32_t cardMetricsStructFormat[2];
	
	cardMetricsStructFormat[0] = 0x24414214;	//format fo struct: bytes in order: 0x14 0x42 0x44 0x24:	
	cardMetricsStructFormat[1] = 0;				/// 1 4-byte val;   4 2-byte vals; 
												/// 4 1-byte vals;  2 4-byte vals
	slot = PceReadInt16From68KStack(ref, 2);
	info = (CardMetricsType*)PceReadInt32From68KStack(ref, 4);
	PceSet68KInt16ReturnResult(ref, impl_SlotLibCardMetrics(refNum, slot, &local));
	if(info)
		PceWriteStructureTo68KMemory(ref, &local, info, (uint8_t*)&cardMetricsStructFormat);
	
	return errNone;
}

static Err paceEntry(EmulStateRef ref, void* param, uint16_t call)
{
	if(call == 0)
		((void**)param)[5] = "rePalm slot driver";
	else if (call != 1) {
		
		uint16_t libRef = PceReadInt16From68KStack(ref, 0);
		uint32_t* mediaTypeP, *numSectorsP, *portP;
		uint32_t mediaType, numSectors, port;
		ExpCardInfoPtr infoP;
		uint16_t ret_val_16;
		
		switch(call) {
			case sysLibTrapOpen:
				ret_val_16 = impl_SlotLibOpen(libRef);
				goto ret_16b;
				
			case sysLibTrapClose:
				ret_val_16 = impl_SlotLibClose(libRef);
				goto ret_16b;
			
			case sysLibTrapSleep:
				ret_val_16 = impl_SlotLibSleep(libRef);
				goto ret_16b;
			
			case sysLibTrapWake:
				ret_val_16 = impl_SlotLibWake(libRef);
				goto ret_16b;
			
			case SlotTrapLibAPIVersion:
				PceSet68KInt32ReturnResult(ref, impl_SlotLibLibAPIVersion(libRef));
				return errNone;
			
			case SlotTrapCustomControl:
				ret_val_16 = expErrUnsupportedOperation;
				goto ret_16b;
			
			case SlotTrapCardPresent:
				ret_val_16 = impl_SlotLibCardPresent(libRef, PceReadInt16From68KStack(ref, 2));
				goto ret_16b;
			
			case SlotTrapCardInfo:
				infoP = (ExpCardInfoPtr)PceReadInt32From68KStack(ref, 4);
				ret_val_16 = impl_SlotLibCardInfo(libRef, PceReadInt16From68KStack(ref, 2), infoP);
				if (infoP)
					PceWriteInt32To68KMemory(ref, &infoP->capabilityFlags, 0, infoP->capabilityFlags);
				goto ret_16b;
			
			case SlotTrapCardMediaType:
				mediaTypeP = (uint32_t*)PceReadInt32From68KStack(ref, 4);
				ret_val_16 = impl_SlotLibCardMediaType(libRef, PceReadInt16From68KStack(ref, 2), &mediaType);
				if (mediaTypeP)
					PceWriteInt32To68KMemory(ref, mediaTypeP, 0, mediaType);
				goto ret_16b;
			
			case SlotTrapCardIsFilesystemSupported:
				PceSet68KInt8ReturnResult(ref, impl_SlotLibCardIsFilesystemSupported(libRef, PceReadInt16From68KStack(ref, 2), PceReadInt32From68KStack(ref, 4)));
				return errNone;
			
			case SlotTrapCardMetrics:
				return paceHandleCardMetrics(libRef, ref);
			
			case SlotTrapCardLowLevelFormat:
				ret_val_16 = impl_SlotLibCardLowLevelFormat(libRef, PceReadInt16From68KStack(ref, 2));
				goto ret_16b;
			
			case SlotTrapCardSectorRead:
				numSectorsP = (uint32_t*)PceReadInt32From68KStack(ref, 12);
				if (numSectorsP)		//swap before...
					numSectors = PceReadInt32From68KMemory(ref, numSectorsP, 0);
				ret_val_16 = impl_SlotLibCardSectorRead(libRef, PceReadInt16From68KStack(ref, 2), PceReadInt32From68KStack(ref, 4),(uint8_t*)PceReadInt32From68KStack(ref, 8), &numSectors);
				if (numSectorsP)	//swap after...
					PceWriteInt32To68KMemory(ref, numSectorsP, 0, numSectors);
				goto ret_16b;
			
			case SlotTrapCardSectorWrite:
				numSectorsP = (uint32_t*)PceReadInt32From68KStack(ref, 12);
				if (numSectorsP)		//swap before...
					numSectors = PceReadInt32From68KMemory(ref, numSectorsP, 0);
				ret_val_16 = impl_SlotLibCardSectorWrite(libRef, PceReadInt16From68KStack(ref, 2), PceReadInt32From68KStack(ref, 4), (uint8_t*)PceReadInt32From68KStack(ref, 8), &numSectors);
				if (numSectorsP)	//swap after...
					PceWriteInt32To68KMemory(ref, numSectorsP, 0, numSectors);
				goto ret_16b;
			
			case SlotTrapPowerCheck:
				ret_val_16 = impl_SlotLibPowerCheck(libRef, PceReadInt16From68KStack(ref, 2), PceReadInt16From68KStack(ref, 4), PceReadInt16From68KStack(ref, 6), PceReadInt16From68KStack(ref, 8));
				goto ret_16b;
			
			case SlotTrapMediaType:
				mediaTypeP = (uint32_t*)PceReadInt32From68KStack(ref, 4);
				ret_val_16 = impl_SlotLibMediaType(libRef, PceReadInt16From68KStack(ref, 2), &mediaType);
				if (mediaTypeP)
					PceWriteInt32To68KMemory(ref, mediaTypeP, 0, mediaType);
				goto ret_16b;
	
			case SlotTrapCardReserve:
				ret_val_16 = impl_SlotLibCardReserve(libRef, PceReadInt16From68KStack(ref, 2));
				goto ret_16b;
			
			case SlotTrapCardRelease:
				ret_val_16 = impl_SlotLibCardRelease(libRef, PceReadInt16From68KStack(ref, 2));
				goto ret_16b;
			
			case SlotTrapCardGetSerialPort:
				portP = (uint32_t*)PceReadInt32From68KStack(ref, 4);
				ret_val_16 = impl_SlotLibCardGetSerialPort(libRef, PceReadInt16From68KStack(ref, 2), &port);
				if (portP)
					PceWriteInt32To68KMemory(ref, portP, 0, port);
				goto ret_16b;

			default:
				return sysErrNotAllowed;
		}
		
ret_16b:
		PceSet68KInt16ReturnResult(ref, ret_val_16);
	}

	return errNone;
}

uint32_t PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	if (cmd == 0x7FFD)
		*(void**)cmdPBP = &paceEntry;
	
	return errNone;
}
