#include <stdint.h>
#include <MemoryMgr.h>
#include <LibTraps.h>
#include <SerialMgr.h>
#include <string.h>
#include "common.h"
#include "printf.h"
#include "vdrvV5.h"
#include "port.h"


Err __attribute__((used)) impl_DrvEntry(uint32_t opCode, void *data)
{
	Err err = 0xFFFF;
	
	loge("ENTRY %u 0x%08x\n", opCode, data);
	
	if (data) switch (opCode) {
		case VDRV_ENTRY_NUM_GET_NUM_PORTS:
			*(uint16_t*)data = NUM_PORTS;
			err = errNone;
			break;
		
		case VDRV_ENTRY_NUM_GET_PORT_FUNCS:
			((struct VdrvPortFuncs*)data)->VdrvOpenF = portOpen;
			((struct VdrvPortFuncs*)data)->VdrvCloseF = portClose;
			((struct VdrvPortFuncs*)data)->VdrvControlF = portControl;
			((struct VdrvPortFuncs*)data)->VdrvGetStatusF = portGetStatus;
			((struct VdrvPortFuncs*)data)->VdrvWriteF = portWrite;
			((struct VdrvPortFuncs*)data)->VdrvCustomControlF = portCustomControl;
			err = errNone;
			break;
		
		case VDRV_ENTRY_NUM_GET_PORT_INFO:
			err = portGetInfo((struct VdrvPortInfo*)data);
			break;
	}
	
	return err;
}

uint32_t __attribute__((used)) PilotMain(uint16_t cmd, void* cmdPBP, uint16_t flags)
{
	
	loge("ser main 0x%04x\n", cmd);
	
	return errNone;
}

