#!/bin/bash

DIR="${BASH_SOURCE%/*}"
if [[ ! -d "$DIR" ]]; then DIR="$PWD"; fi
. "$DIR/util.sh"

if [ "$#" -ne 2 ] ; then
    echo "Illegal number of parameters" >&2
	exit 1
fi

commonentry $1 $2

function funcstart {

# funcstart(name isGlobal isWeak tabspacing)

	echo "$4.type $1, %function"
	if [ "$2" = "yes" ]
	then
		echo "$4.globl $1"
	fi
	if [ "$3" = "yes" ]
	then
		echo "$4.weak $1"
	fi
	echo "$4.section .text.$1"
	echo "$4.balign 4 //life is easier when aligned to a 4-byte-boundary :)"
	echo "$4.func"
	echo "$4$1:"
}


#header
echo ".syntax unified"
echo ".globl SysLinkerStub  //required to exist"

#emit LinkerStubCall function


if [ "$INSTRSET" = "full" ]
then
	funcstart "LinkerStubCall_v7m" yes yes ""

	echo "	//stack has [descr] [callfunc | 1]"
	echo "	push  {r0-r3, lr}"
	echo "	ldr   r0, [sp, #0x18]  //get stub func addr"
	echo "	ldrh  r1, [r0, #0x05]  //load (self_module_id * 4)"
	echo "	ldrh  r2, [r0, #0x09]  //load lib slot in globals"
	echo "	bic   r1, #0xf000      //isolate (self_module_id * 4)"
	echo "	bic   r2, #0xf000      //isolate lib slot in globals"
	echo "	ldr   r3, [r9]         //get pointer to where table shall go into r3"
	echo "	ldr   r3, [r3, r1]"
	echo "	adds  r2, r3"
	echo "	ldr   r0, [sp, #0x14]  //param #1: lib descriptor"
	echo "	lsrs  r1, #2           //param #2: module ID"
	echo "	adds  r2, #1           //param #3: table write loc (lower bit tells linker stub that we cna handle thumb addrs directly (rePalm special)"
	echo "	bl    SysLinkerStub"
	echo "	pop   {r0-r3, lr}"
	echo "	add   sp, #4"
	echo "	pop   {pc}"
	
elif [ "$INSTRSET" = "basic_plus" ]
then
	funcstart "LinkerStubCall_v8m_base" yes yes ""

	echo "	//lr = (descr + 1), stack has [proper_lr] [callfunc | 1]"
	echo "	push  {r0-r3}"
	echo "	ldr   r0, [sp, #0x14]  //get stub func addr"
	echo "	subs  r0, #1           //get it rounded down to real address"
	echo "	movs  r2, #0x06        //get imm of (self_module_id * 4)"
	echo "	bl    1f"
	echo "	mov   r1, r2"
	echo "	movs  r2, #0x0c        //get imm of lib slot in globals"
	echo "	bl    1f"
	echo "	ldrh  r1, [r0, #0x08]  //load (self_module_id * 4)"
	echo "	ldrh  r2, [r0, #0x0e]  //load lib slot in globals"
	echo "	lsrs  r3, r1, #4       //reconstitute (self_module_id * 4)"
	echo "	uxtb  r1, r1"
	echo "	adds  r1, r3"
	echo "	lsrs  r3, r2, #4       //reconstitute lib slot in globals"
	echo "	uxtb  r2, r2"
	echo "	adds  r2, r3"
	echo "	mov   r3, r9           //get pointer to where table shall go into r3"
	echo "	ldr   r3, [r3]"
	echo "	ldr   r3, [r3, r1]"
	echo "	adds  r2, r3"
	echo "	mov   r0, lr           //param #1: lib descriptor"
	echo "  subs  r0, #1"
	echo "	lsrs  r1, #2           //param #2: module ID"
	echo "	adds  r2, #1           //param #3: table write loc (lower bit tells linker stub that we cna handle thumb addrs directly (rePalm special)"
	echo "	bl    SysLinkerStub"
	echo "	ldr   r0, [sp, #0x10]  //get LR"
	echo "	mov   lr, r0"
	echo "	pop   {r0-r3}"
	echo "	add   sp, #4"
	echo "	pop   {pc}"
	echo "1: //get imm. instr is at r0 + r2, result in r2, can clobber r1, r12, lr"
	echo "	ldrh  r3, [r0, r2]"
	echo "	lsls  r3, #21"
	echo "	lsrs  r3, #31"
	echo "	lsls  r3, #15"
	echo "	add   r2, r0"
	echo "	ldrh  r2, [r2, #2]"
	echo "	add   r3, r2"
	echo "	lsrs  r3, #4"
	echo "	uxtb  r2, r2"
	echo "	adds  r2, r3"
	echo "	bx    lr"
	
elif [ "$INSTRSET" = "basic" ]
then
	funcstart "LinkerStubCall_v6m" yes yes ""

	echo "	//lr = (descr + 1), stack has [proper_lr] [@{u32 self_lib_id, lib_slot_in_globals, &stubfunc - &past_this_struct + 1} + 1 !!!]"
	echo "	push  {r0-r3}"
	echo "	ldr   r3, [sp, #0x14]  //get info struct pointer"
	echo "	ldmia r3!, {r0-r2}     //load it"
	echo "	add   r2, r3           //calc addr of the stub func + 1"
	echo "	str   r2, [sp, #0x14]  //replace it on stack with re-jump address"
	echo "	mov   r3, r9           //get pointer to where table shall go into r3"
	echo "	ldr   r3, [r3]"
	echo "	ldr   r3, [r3, r0]"
	echo "	adds  r3, r1"
	echo "	adds  r2, r3, #1        //param #3: table write loc (lower bit tells linker stub that we cna handle thumb addrs directly (rePalm special)"
	echo "	lsrs  r1, r0, #2        //param #2: module ID"
	echo "	mov   r0, lr            //param #1: lib descriptor"
	echo "  subs  r0, #1"
	echo "	bl    SysLinkerStub"
	echo "	ldr   r0, [sp, #0x10]   //get LR"
	echo "	mov   lr, r0"
	echo "	pop   {r0-r3}"
	echo "	add   sp, #4"
	echo "	pop   {pc}"
	
elif [ "$INSTRSET" = "v4" ]
then
	
	funcstart "LinkerStubCall_v4" yes yes ""
	
	echo "	STMFD           SP!, {R0-R3,LR}"
	echo "	ADR             R1, 1f"
	echo "1:"
	echo "	STMFD           SP!, {PC}"
	echo "	LDMFD           SP!, {R2}"
	echo "	SUB             R2, R2, R1"
	echo "	ADD             R2, R2, #0x14"
	echo "	LDR             R1, [SP,#0x18]"
	echo "	SUB             R1, R1, R2"
	echo "	STR             R1, [SP,#0x18]"
	echo "	LDR             R0, [R1,#8]"
	echo "	MOV             R3, #0x1000"
	echo "	SUB             R3, R3, #1"
	echo "	AND             R0, R0, R3"
	echo "	LDR             R2, [R9]"
	echo "	LDR             R2, [R2, #0 + MY_LIB_ID]"
	echo "	ADD             R2, R2, R0"
	echo "	LDR             R0, [R1,#4]"
	echo "	AND             R1, R0, R3"
	echo "	MOV             R1, R1,LSR#2"
	echo "	LDR             R0, [SP,#0x14]"
	echo "	BL              SysLinkerStub"
	echo "	LDMFD           SP!, {R0-R3,LR}"
	echo "	LDMFD           SP!, {R12}"
	echo "	LDMFD           SP!, {R12}"
	echo "	MOV             PC, R12"
	
fi

echo ".endfunc"


#emit lib_load_stub
funcstart "Llib_load_stub" no no ""

if [ "$INSTRSET" = "full" ]
then
	
	echo "	adr r12, 1f"
	echo "	push {r12}"
	echo "	b.w LinkerStubCall_v7m"

elif [ "$INSTRSET" = "v4" ]
then

	echo "	ADR    R12, 1f"
	echo "	STMFD  SP!, {R12}"
	echo "	B      LinkerStubCall_v4"

else

	echo "	//bl sets lr to point to data - cool"

	if [ "$INSTRSET" = "basic" ]
	then
		echo "	bl   LinkerStubCall_v6m //lr was pushed by stub func, so bl is safe"
	else
		echo "	bl   LinkerStubCall_v8m_base //lr was pushed by stub func, so bl is safe"
	fi
fi

echo "	.balign 4 // the data needs to be word-aligned"
echo "1:"
echo "	.word $TYPE_V // type ($TYPE)"
echo "	.word $CRID_V // creator ($CRID)"
echo "	.word $MOD_VER"
echo "	.word $NUM_ENTRIES"
echo "	.word $RES_DATA_V // res type for data ($RES_DATA)"
echo "	.word $RES_INFO_V // res type for info ($RES_INFO)"
echo "	.word $RES_CODE_V // res type for code ($RES_CODE)"
echo "	.hword $RES_IDX // res id for data"
echo "	.hword $RES_IDX // res id for info"
echo "	.hword $RES_IDX // res id for code"
echo "	.hword 0 // reserved"
echo ".endfunc"

#emit the entrypoint macro
echo ".macro libentry name idx"
funcstart "\name" yes no "	"




if [ "$INSTRSET" = "full" ]
then
	echo "	1:"
	echo "		ldr   r12, [r9]"
	echo "		ldr   r12, [r12, #0 + MY_LIB_ID]           // .W to force format T3"
	echo "		ldr   r12, [r12, #0 + LIB_SLOT_IN_GLOBALS] // .W to force format T3"
	echo "		cmp   r12, #0"
	echo "		it    ne"
	echo "		ldrne pc,  [r12, #4 * \idx]"
	echo "		adr   r12, 1b + 1"
	echo "		push  {r12}"
	echo "		b     Llib_load_stub"

elif [ "$INSTRSET" = "v4" ]
then
	echo "		ldr   r12, [r9]"
	echo "		ldr   r12, [r12, #0 + MY_LIB_ID]"
	echo "		ldr   r12, [r12, #0 + LIB_SLOT_IN_GLOBALS]"
	echo "		cmp   r12, #0"
	echo "		addne pc,  r12, #4 * \idx"
	echo "		stmfd sp!, {pc}"
	echo "		b     Llib_load_stub"

elif [ "$INSTRSET" = "basic_plus" ]
then
	echo "	1:"
	echo "		push    {r0, r1, lr}"
	echo "		mov     r1, r9"
	echo "		ldr     r1, [r1]"
	echo "		movw    r0, #0 + MY_LIB_ID           // use of r0 is deliberate and used by LinkerStubCall_v8m_base"
	echo "		ldr     r1, [r1, r0]"
	echo "		movw    r0, #0 + LIB_SLOT_IN_GLOBALS // use of r0 is deliberate and used by LinkerStubCall_v8m_base"
	echo "		ldr     r1, [r1, r0]"
	echo "		cmp     r1, #0"
	echo "		beq     2f"
	echo "		adds    r1, #4 * \idx		//biger range"
	echo "		ldr     r1, [r1]"
	echo "		str     r1, [sp, #8]"
	echo "		pop     {r0, r1, pc}"
	echo "	2:"
	echo "		mov     r1, pc	//get addr of this func plus bottom bit (careful to not mess this up)"
	echo "		subs    r1, #0x21"
	echo "		str     r1, [sp, #8]"
	echo "		pop     {r0, r1}"
	echo "		push    {lr}	//pre-push LR for lib_load_stub, so we can corrupt it now"
	echo "		bl      Llib_load_stub"
	echo "		.ltorg"

elif [ "$INSTRSET" = "basic" ]
then

	echo "	1:"
	echo "		push    {r0, r1, lr}"
	echo "		mov     r0, r9"
	echo "		ldr     r0, [r0]"
	echo "		ldr     r1, 3f //MY_LIB_ID"
	echo "		ldr     r0, [r0, r1]"
	echo "		ldr     r1, 4f //LIB_SLOT_IN_GLOBALS"
	echo "		ldr     r0, [r0, r1]"
	echo "		cmp     r0, #0"
	echo "		beq     2f"
	echo "		adds    r0, #4 * \idx		//biger range"
	echo "		ldr     r0, [r0]"
	echo "		str     r0, [sp, #8]"
	echo "		pop     {r0, r1, pc}"
	echo "	2:"
	echo "		adr     r1, 3f	//make it easy"
	echo "		str     r1, [sp, #8]"
	echo "		pop     {r0, r1}"
	echo "		push    {lr}	//pre-push LR for lib_load_stub, so we can corrupt it now"
	echo "		bl      Llib_load_stub"
	echo "		.balign 4"
	echo "	3:"
	echo "		.word	MY_LIB_ID"
	echo "	4:"
	echo "		.word	LIB_SLOT_IN_GLOBALS"
	echo "	5:"
	echo "		.word   1b - 6f + 1"
	echo "	6:"
	
fi

echo "	.endfunc"
echo ".endm"




#emit the entrypoints
IDX=0
for entrypt in "${ENTRIES[@]}"; do
    echo "libentry $entrypt $IDX"
    IDX="$(($IDX+1))"
done

exit 0



