
.globl loader2
.globl __loader_2_start
.globl __loader_2_end

.section .text.loader


.syntax unified
.globl __entry
__entry:

	cpsid	i

	movs	r6, #0x18
	lsls	r6, r6, #24				//r6 = SSI
	movs	r7, #0xf0
	adds	r7, r7, r6				//r7 = SSI + 0xf0
	
	movs	r0, #0
	str		r0, [r6, #0x08]			//SSI off
	
	movs	r0, #2
	str		r0, [r6, #0x14]
	
	movs	r0, #1
	str		r0, [r7, #0x00]

	ldr		r0, =0x001f7300
	str		r0, [r6, #0x00]
		
	movs	r0, #0x86
	lsls	r0, #2
	adds    r0, #3
	str		r0, [r7, #0x04]
	
	adr		r0, config
	ldmia	r0, {r0-r4}
	mov		sp, r0
	subs	r3, r3, r2			//r3 = num bytes to copy
	subs	r1, r2, r1			//r1 = flash offset to read at
								//r2 = ram destiation address
								//r4 = ram jump address
	lsrs	r3, r3, #2			//r3 = num words to copy
	
	movs	r0, #0x03			//command for flash to ORR into flash addr
	lsls	r0, #24
	orrs	r1, r0				//flash command for read
	
	
	subs	r0, r3, #1
	str		r0, [r6, #0x04]		//store count
	
	movs	r0, #0x01
	str		r0, [r6, #0x08]		//SSI on
	
	str		r1, [r6, #0x60]		//command
	
1:
	bl		rxwait
	rev		r0, r0
	stmia	r2!, {r0}
	subs	r3, #1
	bne		1b

	mov		pc, r4


rxwait:		//returns in r0
	ldr		r0, [r6, #0x28]
	lsrs	r0, r0, #4
	bcc		rxwait
	ldr		r0, [r6, #0x60]
	bx		lr


	
.balign 4
config:
	.word	0x20041ff8					//sp
	.word	__loader_1_start
	.word	__loader_2_start
	.word	__loader_2_end
	.word	loader2
