/*****************************************************************************/
/*         OS/2 Warp 4 and ThinkPad Drivers CID Installation                 */
/*         Install Setup sample script from IBM ThinkPad team                */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/*****************************************************************************/
         
         
/* CASSKEL 2.0               */
         
/* This is the LAN CID Utility skeleton command file.  This command file     */
/* illustrates the installation of OS/2 and an application.                  */

/* Specifically, this command file installs OS/2 2.1 and LS 4.0.             */

/*---------------------------------------------------*/
/*         DO NOT MODIFY THE NEXT EIGHT LINES        */
/*---------------------------------------------------*/

parse ARG client logfile additional

QUEUE_REBOOT = 0
CALL_AGAIN = 0

Call AddDLLFunctions

x.0.instprog = ''
x.0.rspdir   = ''
x.0.statevar = 'CAS_STATE'
x.0.default  = ''


/*---------------------------------------------------*/
/*             MODIFICATIONS START HERE              */
/*---------------------------------------------------*/


/*****************************************************/
/*                 SRVATTCH SECTION                  */
/*****************************************************/

/* 'SRVATTCH z: \\SERVER1\ALIAS' */                             /* Additional SRVATTCHs can be placed here*/

                                                                /* They can be placed before specific     */
                                                                /* RunInstall statements too if you only  */
                                                                /* want to attach to a special server     */
                                                                /* right before a specific install.       */

/*****************************************************/
/*                 VARIABLES SECTION                 */
/*****************************************************/

/*---------------------------------------------------*/
/*         DO NOT REMOVE THE NEXT FIVE LINES         */
/*              (They may be modified)               */
/*---------------------------------------------------*/

bootdrive = 'c:'                                                /* Boot Drive                             */
configsys = bootdrive || '\CONFIG.SYS'                          /* Fully qualified path to CONFIG.SYS     */
maintdir  = bootdrive || '\SERVICE'                             /* Maintenance directory, refrenced by    */
                                                                /*   SEMAINT, SEINST, and LAPS.           */
exepath   = 'X:\EXE\WARP4'                                      /* Path to executable directory on server */
exepath2  = 'X:'                                                /* Path to executable directory on server for LAPS */
dllpath   = 'X:\DLL\WARP4;X:\EXE\WARP4'                         /* Paths to the DLL directories on server */

/*---------------------------------------------------*/
/* The next four lines are included to make it       */
/* easier to change the version of OS/2 2.x that is  */
/* to be installed.                                  */
/*                                                   */
/* These variables are referenced in the product     */
/* data sections for SEINST and SEMAINT.             */
/*---------------------------------------------------*/

os2dir  = 'WARP4\OS2IMAGE'                                      /* Name of OS/2 2.1 directories         */
os2img  = 'X:\IMG\'                                             /* - product image directory            */
os2rsp  = 'X:\RSP\'                                             /* - response file directory            */
os2csd  = 'X:\FIXPAK\'                                          /* - fixpak file directory              */
os2log  = 'Y:\'
cidsrv  = '\\TPCID\CID'
logsrv  = '\\TPCID\LOG'
ciddrv  = 'X:'
logdrv  = 'Y:'


/*****************************************************/
/*               PRODUCT DATA SECTION                */
/*****************************************************/

x.seinst = 1                                                    /* structure index                      */
x.1.name='OS/2 Warp 4'                                          /* product name                         */
x.1.statevar = 'CAS_' || x.1.name                               /* state variable name                  */
x.1.instprog = exepath || '\seinst                    ',        /* fully qualified install program name */
               '/b:' || bootdrive,                              /* - bootdrive                          */
               '/s:' || os2img || os2dir,                       /* - source directory                   */
               '/t:' || maintdir,                               /* - service directory                  */
               '/l1:' || logfile,                               /* - log file                           */
               '/r:'                                            /* - response file flag (auto selection)*/
x.1.rspdir   = os2rsp || 'warp4'                                /* response file directory              */
x.1.default  = 'default.rsp'                                    /* default response file name           */

x.semaint = 2                                                   /* structure index                      */
x.2.name='OS/2 Warp Maintenance'                                /* product name                         */
x.2.statevar = 'CAS_' || x.2.name                               /* state variable name                  */
x.2.instprog = os2csd || 'xr_w026\fservice.exe        ',        /* fully qualified install program name */
               '/s:' || os2csd || 'xr_w026            ',        /* - source directory                   */
               '/l1:' || logfile,                               /* - log file                           */
               '/cid',                                          /* unattended CID mode                  */
               '/r:'                                            /* - response file flag (auto selection)*/
x.2.rspdir   = os2rsp || 'fixpak'                               /* response file directory              */
x.2.default  = 'xr_w026.rsp'                                    /* default response file name           */

x.laps_prep = 3                                                 /* structure index                      */
x.3.name='LAPS Maintnenace'                                     /* product name                         */
x.3.statevar = 'CAS_' || x.3.name                               /* state variable name                  */
x.3.instprog = os2csd || 'laps\mpts                   ',        /* fully qualified install program name */
               '/e:prep                               ',        /* - prep installation                  */
               '/s:' || os2csd || 'laps               ',        /* - source directory                   */
               '/t:' || maintdir,                               /* - target directory                   */
               'tu:' || bootdrive,                              /* - location of config.sys             */
               'l1:' || logfile,                                /* - log file                           */
               '/r:'                                            /* - response file flag (auto selection)*/
x.3.rspdir   = os2rsp || 'laps'                                 /* response file directory              */
x.3.default  = 'lapsrsp.rsp'                                    /* default response file name           */

x.laps = 4                                                      /* structure index                      */
x.4.name='LAPS'                                                 /* product name                         */
x.4.statevar = 'CAS_' || x.4.name                               /* state variable name                  */
x.4.instprog = os2img || 'warp4\mpts\mpts             ',        /* fully qualified install program name */
               '/e:maint                              ',        /* - maintenance installation           */
               '/s:' || os2img || 'warp4\mpts         ',        /* - source directory                   */
               '/t:' || bootdrive || '\               ',        /* - target directory                   */
               '/l1:' || logfile,                               /* - log file                           */
               '/r:'                                            /* - response file flag (auto selection)*/
x.4.rspdir   = os2rsp || 'laps'                                 /* response file directory              */
x.4.default  = 'lapsrsp.rsp'                                    /* default response file name           */

x.laninstr = 5                                                  /* structure index                      */
x.5.name='LAN Services 4.0'                                     /* product name                         */
x.5.statevar = 'CAS_' || x.5.name                               /* state variable name                  */
x.5.instprog = os2img || 'ibmlsa\laninstr             ',        /* fully qualified install program name */
               '/REQ                                  ',        /* - install a requester                */
               '/l1:' || logfile,                               /* - log file                           */
               '/l2:' || logdrv || '\' || client || '.l2',      /* - log file                           */
               '/r:'                                            /* - response file flag (auto selection)*/
x.5.rspdir   = os2rsp || 'ibmlsa'                               /* response file directory              */
x.5.default  = 'ibmlsa.rsp'                                     /* default response file name           */

x.thinifs = 6                                                   /* structure index                      */
x.6.name='SRVIFS Requester'                                     /* product name                         */
x.6.statevar = ''                                               /* state variable name                  */
x.6.instprog = os2img || 'warp4\srvifs\thinifs        ',        /* fully qualified install program name */
               '/s:' || os2img || 'warp4\srvifs       ',        /* - source directory                   */
               '/t:' || bootdrive || '\srvifsrq       ',        /* - target directory                   */
               '/tu:' || bootdrive || '\              ',        /* - config.sys location                */
               '/l1:' || logfile,                               /* - log file                           */
               '/req:*                                ',        /* - random requester name              */
               '/srv:' || cidsrv,                               /* - server name                        */
               '/d:' || ciddrv                                  /* - remote drive identifier            */
x.6.rspdir   = ''                                               /* no auto selection                    */
x.6.default  = ''

x.ifsdel = 7                                                    /* structure index                      */
x.7.name='SRVIFS Delete'                                        /* product name                         */
x.7.statevar = ''                                               /* state variable name                  */
x.7.instprog = os2img || 'warp4\srvifs\ifsdel         ',        /* fully qualified install program name */
               '/t:' || bootdrive || '\srvifsrq       ',        /* - target directory                   */
               '/tu:' || bootdrive                              /* - config.sys location                */
x.7.rspdir   = ''                                               /* no auto selection                    */
x.7.default  = ''

x.casinstl = 8                                                  /* structure index                               */
x.8.name='LAN CID Utility'                                      /* product name                                  */
x.8.statevar = ''                                               /* state variable name                           */
x.8.instprog = os2img || 'warp4\lcu\casinstl          ',        /* fully qualified install program name          */
               '/cmd:' || ciddrv || '\client\warp4    ',        /* - location of .cmd files (passed to casagent) */
               '/tu:' || bootdrive,                             /* - config.sys location (boot drive)            */
               '/pl:' || dllpath,                               /* - string to add to libpath                    */
               '/pa:' || os2img || 'warp4\lcu         ',        /* - workstation's path to LCU code on server    */
               '/l1:' || logfile,                               /* - log file                           */
               '/l2:' || logdrv || '\' || client || '.l2',      /* - log file                           */
               '/req:' || client                                /* - LCU client name                             */
x.8.rspdir   = ''                                               /* no auto selection                             */
x.8.default  = ''

x.casdelet = 9                                                  /* structure index                      */
x.9.name='LAN CID Utility Delete'                               /* product name                         */
x.9.statevar = ''                                               /* state variable name                  */
x.9.instprog = os2img || 'warp4\lcu\casdelet          ',        /* fully qualified install program name */
               '/pl:' || dllpath,                               /* - string to delete from libpath      */
               '/tu:' || bootdrive                              /* - config.sys location (boot drive)   */
x.9.rspdir   = ''                                               /* no auto selection                    */
x.9.default  = ''

x.thinifs2 = 10                                                 /* structure index                      */
x.10.name='SRVIFS Requester'                                    /* product name                         */
x.10.statevar = ''                                              /* state variable name                  */
x.10.instprog = os2img || 'warp4\srvifs\thinifs        ',       /* fully qualified install program name */
                '/s:' || os2img || 'srvifs             ',       /* - source directory                   */
                '/t:' || bootdrive || '\srvifsrq       ',       /* - target directory                   */
                '/tu:' || bootdrive || '\              ',       /* - config.sys location                */
                '/l1:' || logfile,                              /* - log file                           */
                '/req:*                                ',       /* - random requester name              */
                '/srv:' || logsrv,                              /* - server name                        */
               ' /d:' || logdrv                                 /* - remote drive identifier            */
x.10.rspdir   = ''                                              /* no auto selection                    */
x.10.default  = ''

x.product11 = 11                                                /* structure index                      */
x.11.name='dummy'                                               /* product name                         */
x.11.statevar = ''                                              /* state variable name                  */
x.11.instprog = ''                                              /* fully qualified install program name */
x.11.rspdir   = ''                                              /* no auto selection                    */
x.11.default  = ''

x.pcminst2 = 12                                                 /* structure index                      */
x.12.name='ThinkPad PC Card Director for OS/2'                  /* product name                         */
x.12.drv = ciddr 
x.12.path = os2img || 'tp760e\pcmcia'
x.12.statevar = ''                                              /* state variable name                  */
x.12.instprog = 'pcminst2                             ',        /* fully qualified install program name */
                '/s:'|| x.12.path,                              /* - source directory                   */
                '/t:' || bootdrive || '\thinkpad      ',        /* - target directory                   */
                '/l1:' || logfile,                              /* - log file                           */
                '/l2:' || logdrv || '\' || client || '.l2 ',    /* - log file                           */
                '/r:                                  '         /* - response file flag                 */
x.12.rspdir   = os2rsp || 'tp760e\pcmcia'                       /* - response file directory            */
x.12.default  = 'pcmcia.rsp'                                    /* - response file name                 */

x.install2 = 13                                                 /* structure index                      */
x.13.name='OS/2 ThinkPad Feature'                               /* product name                         */
x.13.drv = ciddrv
x.13.path = os2img || 'tp760e\tputil'
x.13.statevar = ''                                              /* state variable name                  */
x.13.instprog = 'install2                             ',        /* fully qualified install program name */
                '/s:'|| x.13.path,                              /* - source directory                   */
                '/t:' || bootdrive || '\thinkpad      ',        /* - target directory                   */
                '/l1:' || logfile,                              /* - log file                           */
                '/l2:' || logdrv || '\' || client || '.l2 ',    /* - log file                           */
                '/r:                                   '        /* - response file flag                 */
x.13.rspdir   = os2rsp || 'tp760e\tputil'                       /* - response file directory            */
x.13.default  = 'tputil.rsp'                                    /* - response file name                 */

x.9385inst = 14                                                 /* structure index                      */
x.14.name='OS/2 Video Feature Diskette (Trident 9385/82 PCI)'   /* product name                         */
x.14.drv = 'x:'
x.14.path = os2img || 'tp760e\video\t9385'
x.14.statevar = ''                                              /* state variable name                  */
x.14.instprog = 'install',                                      /* fully qualified install program name */
                '/s:' || x.14.path,                             /* - source directory                   */
                '/t:' || bootdrive || '\',                      /* - target directory                   */
                '/l:' || logfile,                               /* - log file                           */
                '/u'                                            /* - quiet mode                         */
x.14.rspdir   = ''                                              /* - response file directory            */
x.14.default  = ''                                              /* - response file name                 */

x.prod15 = 15                                                   /* structure index                      */
x.15.name='dummy'                                               /* product name                         */
x.15.drv = ''  
x.15.path = ''                            
x.15.statevar = ''                                              /* state variable name                  */
x.15.instprog = ''                                              /* fully qualified install program name */
x.15.rspdir   = ''                                              /* - response file directory            */
x.15.default  = ''                                              /* - response file name                 */

x.minstall = 16                                                 /* structure index                      */
x.16.name='MMPM2 Installation'                                  /* product name                         */
x.16.drv = bootdrive
x.16.path = '\mmtemp'
x.16.statevar = ''                                              /* state variable name                  */
x.16.instprog = 'minstall                             ',        /* fully qualified install program name */
                '/m                                   ',        /* - transfer files off of the MMTEMP   */
                '/r:'                                           /* - response file flag                 */
x.16.rspdir   = os2rsp || 'mmpm2'                               /* - response file directory            */
x.16.default  = 'mmpm2.rsp'                                     /* - response file name                 */

x.mwaveins = 17                                                 /* structure index                      */
x.17.name='Mwave Driver Installation'                           /* product name                         */
x.17.drv = ciddrv
x.17.path = os2img || 'tp760e\mwave\mwdd'
x.17.statevar = ''                                              /* state variable name                  */
x.17.instprog = logdrv || '\setup                     ',        /* fully qualified install program name */
                logdrv || '\  cid.lst'
x.17.rspdir   = ''                                              /* - response file directory            */
x.17.default  = ''                                              /* - response file name                 */

x.mwvsdins = 18                                                 /* structure index                      */
x.18.name='Mwave VSD Diskette Installation'                     /* product name                         */
x.18.drv = bootdrive
x.18.path = ''                          
x.18.statevar = ''                                              /* state variable name                  */
x.18.instprog = os2img || 'tp760e\mwave\mwvsd\setup.cmd',       /* fully qualified install program name */
                '/r:'                                           /* - response file flag                 */
x.18.rspdir   = os2rsp || 'tp760e\mwave'                        /* - response file directory            */
x.18.default  = 'mwvsd.rsp'                                     /* - response file name                 */

x.midiins = 19                                                  /* structure index                      */
x.19.name='Mwave MIDI Samples Installation'                     /* product name                         */
x.19.drv = ciddrv
x.19.path = os2img || 'tp760e\mwave\mwmidi'
x.19.statevar = ''                                              /* state variable name                  */
x.19.instprog = 'setup                                ',        /* fully qualified install program name */
                logdrv || '\ cid.lst                  '
x.19.rspdir   = ''                                              /* - response file directory            */
x.19.default  = ''                                              /* - response file name                 */

x.essinst = 20                                                  /* structure index                      */
x.20.name='OS/2 ESS Audio Driver Installation'                  /* product name                         */
x.20.drv = ''
x.20.path = ''                           
x.20.statevar = ''                                              /* state variable name                  */
x.20.instprog = 'minstall                              ',       /* fully qualified install program name */
                '/r:'                                           /* - response file flag                 */
x.20.rspdir   = os2rsp || 'tp760e\ess'                          /* - response file directory            */
x.20.default  = 'ess.rsp'                                       /* - response file name                 */

x.mpeginst = 21                                                 /* structure index                      */
x.21.name='OS/2 MPEG Feature Installation'                      /* product name                         */
x.21.drv = bootdrive
x.21.path = ''                           
x.21.statevar = ''                                              /* state variable name                  */
x.21.instprog = 'minstall                             ',        /* fully qualified install program name */
                '/r:'                                           /* - response file flag                 */
x.21.rspdir   = os2rsp || 'tp760e\mpeg'                         /* - response file directory            */
x.21.default  = 'mpeg.rsp'                                      /* - response file name                 */

x.vcapinst = 22                                                 /* structure index                      */
x.22.name='OS/2 Video Capture / Play Back Driver Installation'  /* product name                         */
x.22.drv = bootdrive
x.22.path = ''                             
x.22.statevar = ''                                              /* state variable name                  */
x.22.instprog = 'minstall                               ',      /* fully qualified install program name */
                '/r:'                                           /* - response file flag                 */
x.22.rspdir   = os2rsp || 'tp760e\vidcap'                       /* - response file directory            */
x.22.default  = 'vidcap.rsp'                                    /* - response file name                 */

x.irinst = 23                                                   /* structure index                      */
x.23.name='WIN-OS/2 IR Driver Installation'                     /* product name                         */
x.23.drv = 'x:'
x.23.path = '\img\tp760e\ir'
x.23.statevar = ''                                              /* state variable name                  */
x.23.instprog = 'irinst                                ',       /* fully qualified install program name */
                 x.23.drv || x.23.path                  ,       /* - source directory                   */
                'c:\os2\mdos\winos2                   ',        /* - target directory                   */
                bootdrive                                       /* - boot directory                     */
x.23.rspdir   = ''                                              /* - response file directory            */
x.23.default  = ''                                              /* - response file name                 */

x.9320inst = 24                                                 /* structure index                      */
x.24.name='OS/2 Video Feature Diskette (Trident 9320 PCI)'      /* product name                         */
x.24.drv = ciddrv
x.24.path = os2img || 'tp760e\video\t9320'
x.24.statevar = ''                                              /* state variable name                  */
x.24.instprog = 'install                               ',       /* fully qualified install program name */
                ' /s:' || x.24.path,                            /* - source directory                   */
                ' /t:' || bootdrive || '\',                     /* - target directory                   */
                ' /l:' || logfile,                              /* - log file                           */
                ' /u'                                           /* - quiet mode                         */
x.24.rspdir   = ''                                              /* - response file directory            */
x.24.default  = ''                                              /* - response file name                 */

x.repvga = 25                                                   /* structure index                      */
x.25.name='OS/2 Video Fix Diskette                     '        /* product name                         */
x.25.drv = ciddrv
x.25.path = os2img || 'tp760e\video\repvga'
x.25.statevar = 'CAS_' || x.25.name                             /* state variable name                  */
x.25.instprog = 'repvga c                              '        /* fully qualified install program name */
x.25.rspdir   = ''                                              /* - response file directory            */
x.25.default  = ''                                              /* - response file name                 */


/*---------------------------------------------------*/
/*         NUMBER OF PROGRAMS SET UP IN THE          */
/*               PRODUCT DATA SECTION                */
/*---------------------------------------------------*/

NUM_INSTALL_PROGS = 25


/*---------------------------------------------------*/
/*       DO NOT MODIFY OR REMOVE THE NEXT LINE       */
/*---------------------------------------------------*/

OVERALL_STATE = GetEnvironmentVars()


/*****************************************************/
/*                  INSTALL SECTION                  */
/*****************************************************/

Do Forever
  Select

    when OVERALL_STATE = 0 then do
      if BootDriveIsDiskette()   == YES    then iterate         /* Check if booted from diskette*/
                                                                /*  if it was, then goto state 1*/
      if RunInstall(x.semaint)   == BAD_RC then exit            /* Install maintenance system   */
      if RunInstall(x.laps_prep) == BAD_RC then exit            /* Install LAPS prep system     */
      if RunInstall(x.thinifs)   == BAD_RC then exit            /* Install SRVIFS requester     */
      if RunInstall(x.casinstl)  == BAD_RC then exit            /* Install LCU                  */
      Call CheckBoot                                            /* Reboot if it was requested   */
    end

    when OVERALL_STATE = 1 then do
      if RunInstall(x.seinst)   == BAD_RC then exit             /* Install operating system     */
      if RunInstall(x.laps)     == BAD_RC then exit             /* Install LAPS                 */
      if RunInstall(x.thinifs)  == BAD_RC then exit             /* Install SRVIFS requester     */
      if RunInstall(x.thinifs2)  == BAD_RC then exit            /* Install SRVIFS requester     */
      if RunInstall(x.casinstl) == BAD_RC then exit             /* Install LCU                  */
/*    if RunInstall(x.copypsys) == BAD_RC then exit   */        /* Copy PCMCIA.SYS to C: drive  */
/*    if RunInstall(x.copyssdd) == BAD_RC then exit   */        /* Copy IBM2SSxx.SYS to C: drive*/
      x.25.drv
      'cd' x.25.path
      if RunInstall(x.repvga)   == BAD_RC then exit             /* Install OS/2 Video Fix       */

      Call RebootAndGotoState(2)
/*    Call CheckBoot    */                                      /* Reboot if it was requested   */
    end

    when OVERALL_STATE = 2 then do
      x.16.drv
      'cd' x.16.path
      if RunInstall(x.minstall) == BAD_RC then exit             /* Install MMPM2                */
      Call RebootAndGotoState(4)
    end

    when OVERALL_STATE = 4 then do
      'cd \'
      x.13.drv
      'cd' x.13.path
      if RunInstall(x.install2) == BAD_RC then exit             /* Install ThinkPad Feature     */
      'cd' x.12.path
      if RunInstall(x.pcminst2) == BAD_RC then exit             /* Install PC Card Director     */
      select
         when wordpos(client, 'TP760E TP560 TP760ED TP760ELD') > 0 then do
            'cd' x.14.path
            if RunInstall(x.9385inst) == BAD_RC then exit       /* Install Video Driver for OS/2*/
         end /* do */
         when wordpos(client, 'TP760E2 TP365X TP760EL') > 0 then do
            'cd' x.24.path
            if RunInstall(x.9320inst) == BAD_RC then exit       /* Install Video Driver for OS/2*/
         end /* do */
      otherwise
      nop
      end  /* select */
      'cd \'
      'c:'
      Call CheckBoot                                            /* Reboot if it was requested   */
      Call RebootAndGotoState(5)
    end

    when OVERALL_STATE = 5 then do
      select
         when wordpos(client, 'TP760ELD TP760EL TP560 TP365X') > 0 then do
            if RunInstall(x.essinst) == BAD_RC then exit        /* Install ESS Audio Driver for OS/2      */
         end /* do */
         when wordpos(client, 'TP760E TP760ED TP760E2') > 0 then do
            x.17.drv
            'cd' x.17.path
            'copy *' logdrv || '\'
            if RunInstall(x.mwaveins) == BAD_RC then exit       /* Install Mwave Driver for OS/2      */

            call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
            call SysLoadFuncs
            call SysSleep 60
      
            'cd \'
            x.18.drv
            'cd' x.18.path
            if RunInstall(x.mwvsdins) == BAD_RC then exit       /* Install Mwave VSD Diskette for OS/2*/
            'cd \'
            x.19.drv
            'cd' x.19.path
            'copy cid.lst' logdrv || '\'
            if RunInstall(x.midiins ) == BAD_RC then exit       /* Install MIDI Sample for OS/2       */
            call SysSleep 180
         end /* do */
      otherwise
      nop
      end  /* select */
      'cd \'
      select
         when wordpos(client, 'TP760ED TP760ELD TP760E TP560') > 0 then do
            x.21.drv
            'cd' x.21.path
            if RunInstall(x.mpeginst) == BAD_RC then exit       /* Install MPEG Feature for OS/2      */
         end /* do */
      otherwise
      nop
      end  /* select */
      'cd \'
      select
         when wordpos(client, 'TP760ED') > 0 then do
         x.22.drv                                           
         'cd' x.22.path                                     
         if RunInstall(x.vcapinst) == BAD_RC then exit          /* Install VidCap/Playback for OS/2   */
         end /* do */
      otherwise
      nop
      end  /* select */
      'cd \'
/*    x.23.drv                                         */
/*    'cd' x.23.path                                   */
/*    if RunInstall(x.irinst  ) == BAD_RC then exit    */       /* Install IR Driver for WIN-OS/2     */
      'cd \'                                           
      Call CheckBoot                                            /* Reboot if it was requested   */
    end

    when OVERALL_STATE = 6 then do
      if RunInstall(x.ifsdel)   == BAD_RC then exit             /* Delete SRVIFS requester      */
      if RunInstall(x.casdelet) == BAD_RC then exit             /* Delete LCU                   */
      Call Reboot                                               /* Reboot                       */
    end
  end
end
exit


/*************************************************************/
/*         DO NOT MODIFY ANY CODE BELOW THIS LINE !!!        */
/*************************************************************/

RunInstall: procedure expose x. queue_reboot call_again configsys logfile client OVERALL_STATE
  parse arg index, new_state, other
  install = SetEnvironmentVar(x.index.statevar)
  if install == YES then do
    state = value('REMOTE_INSTALL_STATE',,'OS2ENVIRONMENT')     /* check   REMOTE_INSTALL_STATE */
    if state <> 0 then
      rc2 = LogMessage(75, x.index.name, state, logfile)        /* log an install starting msg  */
    else
      rc2 = LogMessage(72, x.index.name, '', logfile)           /* log an install starting msg  */

    install_prog = 'CMD /C ' || strip(x.index.instprog)         /* build the command string     */

                                                /* If automatic responst file selection was     */
                                                /* indicated, then get the response file name   */
                                                /* and append it to the command string.         */
    if x.index.default <> '' then do
      response_file = DetermineResponseFile(x.index.rspdir, client,
                                            , x.index.default, x.index.name,
                                            , logfile)
      if response_file == '' then exit
      install_prog = install_prog || response_file
    end

    install_prog                                                /* Execute the install program  */

    state = value(x.index.statevar,,'OS2ENVIRONMENT')           /* Get the current install state*/
                                                                /* for this install program from*/
                                                                /* the environment.             */

                                                /* Check the return code and set the global     */
                                                /* variables accordingly.                       */

    parse value ProcessReturnCode(rc, state, QUEUE_REBOOT, CALL_AGAIN, logfile),
           with rc ',' state ',' QUEUE_REBOOT ',' CALL_AGAIN

    rc2 = value(x.index.statevar, state, 'OS2ENVIRONMENT')      /* Set the new install state for*/
                                                                /* this install program.        */

                                                /* Put the install state into the CONFIG.SYS,   */
                                                /* if this action was unsuccessful, then exit.  */

    if PutStateVar(x.index.statevar, state, configsys, logfile) <> 0 then exit

    if rc == GOOD_RC then do
      if pos('\SEMAINT', translate(install_prog)) <> 0 then     /* If the install program was   */
        Call PreserveStartupCmd(install_prog)                   /* SEMAINT, then make sure      */
                                                                /* STARTUP.CMD won't be copied  */
                                                                /* over when SEINST runs.       */

      rc2 = LogMessage(70, x.index.name, '', logfile)           /* log an install successful msg*/
      return GOOD_RC                                            /* return a good return code    */
    end

    else do
      rc2 = LogMessage(71, x.index.name, '', logfile)           /* log an install failed msg    */
      if (new_state <> '') then                                 /* If a new state was requested,*/
                                                                /* then set OVERALL_STATE to the*/
        rc2 = SetState(new_state, 'RunInstall', 2)              /* new state.                   */

      return BAD_RC                                             /* return a bad return code     */
    end
  end
  return GOOD_RC


/*************************************************************/
PreserveStartupCmd: procedure

  parse upper arg string, other

  if pos('/T:', string) <> 0 then                               /* Determine if there is a      */
    findvalue = '/T:'                                           /* target parameter.  If there  */
  else                                                          /* is none, return.             */
    if pos('-T:',string) <> 0 then
      findvalue = '-T:'
    else
      return 0

  remain = substr(string, pos(findvalue, string) + 3)           /* Get the value of the target  */
                                                                /* parameter.                   */
  blank = pos(' ', remain)

  if (blank <> 0) then
    param = substr(remain, 1, blank-1)
  else
    param = remain
                                                /* Erase startup.lcu in the target directory,  */
                                                /* then rename startup.s13 to startup.lcu      */

  'if exist ' param || '\startup.lcu erase  ' param || '\startup.lcu'
  'if exist ' param || '\startup.s13 rename ' param || '\startup.s13 *.lcu'

  return 0

/*************************************************************/
GetEnvironmentVars: procedure expose X. NUM_INSTALL_PROGS


  OVERALL_STATE = value(x.0.statevar,,'OS2ENVIRONMENT')         /* Get the overall install state */
                                                                /* from the environment.         */

  if OVERALL_STATE == '' then do                                /* If the overall install state  */
    OVERALL_STATE = 0                                           /* has not been set yet, reset   */
    do I=0 to NUM_INSTALL_PROGS by 1                            /* all the state vars to 0.      */
      if x.I.statevar <> '' then
        rc = value(x.I.statevar,'0','OS2ENVIRONMENT')
    end
  end

  return OVERALL_STATE


/*************************************************************/
SetEnvironmentVar: procedure
  parse arg env_string, other
  if env_string == '' then do                                   /* If the install program has   */
                                                                /* no state variable, then ...  */

    rc = value('REMOTE_INSTALL_STATE','0','OS2ENVIRONMENT')     /* Set the REMOTE_INSTALL_STATE */
                                                                /* to 0 so that the program     */
                                                                /* being run can know that is   */
                                                                /* being run in an unattended   */
                                                                /* environment.                 */

    return YES                                                  /* return install=yes           */

  end

  state = value(env_string,,'OS2ENVIRONMENT')                   /* Otherwise, get the value of  */
                                                                /* the state variable from the  */
                                                                /* environment.                 */

  if state <> '' then do                                        /* If the state variable exists */

    rc = value('REMOTE_INSTALL_STATE',state,'OS2ENVIRONMENT')   /* Set the REMOTE_INSTALL_STATE */
                                                                /* environment variable to the  */
                                                                /* value of the state variable. */

    return YES                                                  /* return install=yes           */
  end
  else                                                          /* Otherwise,                   */
    return NO                                                   /* return install=no            */


/*************************************************************/
BootDriveIsDiskette:

  if IsBootDriveRemovable() == 1 then do                        /* If the drive booted from is  */
                                                                /* a diskette drive, then set   */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from the hardfile.           */
    return 'NO'

/*************************************************************/
BootDriveIsFixedDisk:

  if IsBootDriveRemovable() == 0 then do                        /* If the drive booted from is  */
                                                                /* a fixed disk, then set       */
    rc2 = SetState(OVERALL_STATE+1)                             /* the OVERALL_STATE to the     */
                                                                /* requested value.             */
    return 'YES'

  end

  else                                                          /* else the machine was booted  */
                                                                /* from a diskette.             */
    return 'NO'

/*************************************************************/
SetState:
  parse arg new_state, proc_name, param_num, other

    if datatype(new_state, number) <> 1 then do                 /* If the new state requested is*/
                                                                /* not numeric, then log an     */
      if proc_name <> '' then                                   /* error.                       */
        LogMessage(63, proc_name, param_num, logfile)
      else
        LogMessage(63, 'SetState', 1, logfile)

      exit
    end

    OVERALL_STATE = new_state                                   /* Set the OVERALL_STATE to the */
                                                                /* new state requested.         */

    rc = value(x.0.statevar, new_state, 'OS2ENVIRONMENT')       /* Save the OVERALL_STATE in the*/
                                                                /* environment.                 */
    return 'NO_ERROR'


/*************************************************************/
SaveStates:

  do I=0 to NUM_INSTALL_PROGS by 1            /* Put the install states into the CONFIG.SYS,  */
    if x.I.statevar <> '' then                /* if this action was unsuccessful, then exit.  */

      if PutStateVar(x.I.statevar, value(x.I.statevar,,'OS2ENVIRONMENT'),
                     , configsys, logfile) <> 0 then exit
  end

  return

/*************************************************************/
RebootAndGotoState:
  parse arg new_state, other

  rc2 = SetState(new_state, 'RebootAndGotoState', 1)           /* Set the state to go to in    */
                                                               /* OVERALL_STATE.               */

  Call SaveStates                                              /* Save the environment vars    */

  Call Reboot                                                  /* Reboot the machine           */

  return


/*************************************************************/
CheckBoot:
  if QUEUE_REBOOT <> 0 then do                                  /* If a reboot has been queued  */
                                                                /* by an install program ...    */

    if CALL_AGAIN == 0 then                                     /* If no install programs want  */
                                                                /* to be recalled ...           */

      rc = SetState(OVERALL_STATE+1)                            /* Increment the overall state  */
                                                                /* variable.                    */

    Call SaveStates                                             /* Save the environment vars    */

    Call Reboot                                                 /* Reboot the machine           */

  end

  else                                                          /* Otherwise, increment the     */
    rc = SetState(OVERALL_STATE+1)                              /* state variable and go on.    */

  return


/*************************************************************/
Reboot:
  bootdrive

  rc = value('OS2_SHELL', bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')
  rc = value('COMSPEC',   bootdrive || '\OS2\CMD.EXE', 'OS2ENVIRONMENT')

  'cls'
  rc = AskRemoveDiskIfFloppy()

  pathlen = length(exepath)                                     /* Get length of exepath        */
  posslash = lastpos("\",strip(exepath))                        /* Determine the last occurcnce */
                                                                /*   of '\' in exepath          */

  if posslash = pathlen then                                    /* If '\' is the last character */

    cmdline = exepath || 'SETBOOT /IBD:' || bootdrive           /* Then append 'SETBOOT'        */

  else

    cmdline = exepath || '\SETBOOT /IBD:' || bootdrive          /* Else append '\SETBOOT'       */

  LogMessage(74, '', '', logfile)                               /* Log a message indicating     */
                                                                /* reboot.                      */
  cmdline

  LogMessage(73, 'SETBOOT', '', logfile)                        /* If the code gets to here, the*/
                                                                /* reboot failed.  Log a message*/
  exit                                                          /* and exit.                    */

  return


/*************************************************************/
AddDLLFunctions:
  Call RxFuncAdd 'ProcessReturnCode',     'CASAGENT', 'PROCESSRETURNCODE'
  Call RxFuncAdd 'DetermineResponseFile', 'CASAGENT', 'DETERMINERESPONSEFILE'
  Call RxFuncAdd 'PutStateVar',           'CASAGENT', 'PUTSTATEVAR'
  Call RxFuncAdd 'LogMessage',            'CASAGENT', 'GETANDLOGMESSAGE'
  Call RxFuncAdd 'AskRemoveDiskIfFloppy', 'CASAGENT', 'ASKREMOVEDISKIFFLOPPY'
  Call RxFuncAdd 'IsBootDriveRemovable',  'CASAGENT', 'ISBOOTDRIVEREMOVABLE'
  Call RxFuncAdd 'GetOS2Version',         'CASAGENT', 'GETOS2VERSION'
  Call RxFuncAdd 'SetCIDType',            'CASAGENT', 'SETCIDTYPE'

  return
