/***********************************************************/
/* LIBRARY 2.00 source code copyright (c) 1993 by M. Kimes */
/*                          all rights reserved            */
/* code may not be used without prior written permission   */
/***********************************************************/

#include "doorskel.h"
#include "library.h"


int _fastcall common (int func) {

  char        *p;
  word        x,y;
  char        s[33];
  char        temp;
  static char keyword[81]="";
  static char tempstr[311];

  switch(func) {
    case 'F':   if (*DoorGenericInput(1,0,1,1,YESNO,
                    "\r\nDo you want complete File/Section lists? (Y/n) ",
                    NULL) != 'N')
                  full = 0;
                else
                  full = 1;
                if (*DoorGenericInput(1,0,1,1,YESNO,
                    "\r\nDo you want a short list at Read and Jump? (Y/n) ",
                    NULL) != 'N')
                  quick = 0;
                else
                  quick = 1;
                if (*DoorGenericInput(1,0,1,1,YESNO,
                    "\r\nDo you want a full menu? (Y/n) ",
                    NULL) != 'N')
                  menus = 0;
                else
                  menus = 1;
                if(menus)
                  DoorPuts("\r\n? will redisplay full menu.\r\n");
                break;
    case 'A':   DoorToggleGraphics();
                if (!DoorGetGraphics())
                  DoorPuts("\r\n\x1b[0m\b \b\b \b\b \b\b \b");
                break;
    case 'J':   DoorPrintf("\r\nThere are %u section%s.\r\n",numsecs,
                           &"s"[numsecs == 1]);
                if (!quick)
                  list_sections();
                strcpy(s,DoorGenericInput(9,0,1,0,FLEW,
                         "\r\nNew Section name or #: ",NULL));
                if((p = strchr(s,'.')) != NULL)
                  *p = 0;
                p = s;
                if(!*p) {
                  DoorPuts("\r\n");
                  break;
                }
                x = atoi(p);
                if (x < 1 || x > numsecs) {

                  word matched = 0;

                  x = 0;
                  for(y = 0;y < numsecs;y++) {
                    if(!stricmp(section[y],p)) {
                      matched++;
                      x = y + 1;
                      break;
                    }
                  }
                  if(!matched) {
                    if (!strchr(p,'*') && !strchr(p,'?')) {
                      strcat(p,"*");
                      DoorPuts("*");
                    }
                    for(y = 0;y < numsecs;y++) {

                      char temp;

                      if(name_match(p,section[y])) {
                        matched++;
                        sprintf(tempstr,"\r\nJump to section #%u (%s)? (Y/n/q) ",
                                y + 1,section[y]);
                        temp = *DoorGenericInput(1,0,1,1,YESNOQ,tempstr,NULL);
                        if(temp == 'Q') {
                          DoorPuts("\r\n");
                          return 1;
                        }
                        if(temp != 'N') {
                          x = y + 1;
                          DoorPuts("\r\n");
                          break;
                        }
                      }
                    }
                    if(!x && matched) {
                      DoorPuts("\r\nNo more matching sections.\r\n");
                      break;
                    }
                  }
                  if(!x) {
                    DoorPuts("\r\n\r\nInvalid\r\n");
                    break;
                  }
                }
                DoorPuts("\r\n");
                cursec = x - 1;
                list_zoo(cursec,0,0,NULL);
                break;
    case '<':
    case 'P':   if (cursec > 0) {
                  cursec--;
                  list_zoo(cursec,0,0,NULL);
                }
                else
                  DoorRemoteBell();
                break;
    case '>':
    case 'N':   if (cursec < (numsecs - 1)) {
                  cursec++;
                  list_zoo(cursec,0,0,NULL);
                }
                else
                  DoorRemoteBell();
                break;
    case 'L':   if (!full)
                  list_zoo(cursec,1,0,NULL);
                else
                  quick_list();
                break;
    case 'S':   if (!full)
                  full_list(NULL);
                else
                  list_sections();
                DoorPuts("\r\n");
                break;
    case 'B':   temp = (char)toupper(*DoorGenericInput(1,0,1,1,YESNOQ,
                                     "\r\nAll sections? (y-N) ",NULL));
                DoorPuts("\r\n");
                if(temp == 'Q')
                  break;
                if(temp == 'N' && !numfiles) {
                  DoorPrintf("No %sdocuments available.\r\n",(!numfiles) ?
                          " " : "more ");
                  break;
                }
                sprintf(tempstr,"\r\nEnter keyword [%s]:\r\n-> ",keyword);
                p = DoorGenericInput(76,0,1,1,ALLL,tempstr,NULL);
                DoorPuts("\r\n");
                if(!*p) {
                  if(!*keyword)
                    break;
                }
                else
                  strcpy(keyword,p);
                if(temp != 'Y')
                  list_zoo(cursec,1,0,keyword);
                else {
                  full_list(keyword);
                  DoorPuts("\r\n");
                }
                break;
    case 'R':   if (!numfiles) {
                  DoorPuts("\r\nNo documents available.\r\n");
                  break;
                }
                if (numfiles == 1) {
                  readfile(0,cursec);
                  break;
                }
                if (*section[cursec] == '_' && !DoorGetGraphics()) {
                  DoorPuts("\r\nANSI Graphics required.\r\n");
                  break;
                }
                if (!quick)
                  quick_list();
                DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
                sprintf(tempstr,"\r\nRead which document name or # (1-%u)? ",
                        numfiles);
                strcpy(s,DoorGenericInput(32,0,1,0,FLEW,tempstr,NULL));
                p = s;
                if(!*p) {
                  DoorPuts("\r\n");
                  break;
                }
                x = atoi(p);
                if (x < 1 || x > numfiles) {

                  word matched = 0;

                  x = 0;
                  for(y = 0;y < numfiles;y++) {
                    if(!stricmp(p,document[y])) {
                      x = y + 1;
                      matched++;
                      break;
                    }
                  }
                  if(!matched) {
                    if(!strchr(p,'*') && strchr(p,'?')) {
                      if(!strchr(p,'.')) {
                        strcat(p,"*.*");
                        DoorPuts("*.*");
                      }
                      else {
                        strcat(p,"*");
                        DoorPuts("*");
                      }
                    }
                    else {
                      if(!strchr(p,'.')) {
                        strcat(p,"*");
                        DoorPuts("*");
                      }
                    }
                    DoorPuts("\r\n");
                    for(y = 0;y < numfiles;y++) {

                      char temp;

                      if(name_match(p,document[y])) {
                        matched++;
                        sprintf(tempstr,"\r\nRead #%u (%s)? (Y/n/q) ",
                                y + 1,document[y]);
                        temp = *DoorGenericInput(1,0,1,1,YESNOQ,tempstr,NULL);
                        if(temp == 'Q') {
                          DoorPuts("\r\n");
                          return 1;
                        }
                        if(temp != 'N') {
                          DoorPuts("\r\n");
                          readfile(y,cursec);
                        }
                      }
                    }
                    if(matched) {
                      DoorPrintf("\r\nNo %smatching documents.\r\n",
                                 (matched) ? "more " : "");
                      break;
                    }
                  }
                  if(!x) {
                    DoorPuts("\r\n\r\nInvalid.\r\n");
                    break;
                  }
                }
                DoorPuts("\r\n");
                readfile(x-1,cursec);
                break;
    default:    return 0;
  }
  return 1;
}

char * _fastcall make_ansi (int fore, int back,char *scratch) {

    /* construct an ANSI escape sequence to yield foreground and background
       colors as passed in fore and back.  scratch array should be at least
       13 bytes long.  Valid colors:        Foreground  Background (0 = none)
                       -------------------- ----------- ----------
                             BLACK          1           1
                             DARK BLUE      2           2
                             DARK GREEN     3           3
                             DARK CYAN      4           4
                             DARK RED       5           5
                             DARK MAGENTA   6           6
                             BROWN          7           7
                             LIGHT GREY     8           8
                             DARK GREY      9
                             LIGHT BLUE     10
                             LIGHT GREEN    11
                             LIGHT CYAN     12
                             LIGHT RED      13
                             LIGHT MAGENTA  14
                             YELLOW         15
                             WHITE          16
    */

    static char ret[40];
    static char *fa[] = {"2;30","2;34","2;32","2;36","2;31","2;35","2;33",
                         "2;37","1;30","1;34","1;32","1;36","1;31","1;35",
                         "1;33","1;37"
                        };
    static char *ba[] = {"40","44","42","45","41","46","43","47"
                        };
    char        *p,*pp;


    if(!scratch)
      scratch = ret;
    if((fore < 1 || fore > 16) || (back < 0 || back > 8)) {  /* Error checking */
        fore = 15;  /* white */
        back = 0;   /* black */
    }
    else {
        fore--;
        back--;
    }

    strcpy(scratch,"\x1b[0;");  /* make foreground string */
    p = scratch + 4;
    pp = fa[fore];
    while(*pp) {
        *p = *pp;
        p++;
        pp++;
    }

    if(back != -1) {    /* add background string if back wasn't 0 */
        *p = ';';
        p++;
        pp = ba[back];
        while(*pp) {
            *p = *pp;
            p++;
            pp++;
        }
    }

    *p = 'm';
    p++;
    *p = 0;
    return scratch;
}

