;
;      Sound Numbers for F14 Fleet Defender
;

; Common sounds

N_AllOff          equ  0 ;/* All Sounds Off */
N_AllFade         equ  1 ;/* Graceful ending for All Sounds (1-6 on the Stack)*/
N_MusicOff        equ  2 ;/* Immediate ending for Background music */
N_MusicFade       equ  3 ;/* Graceful ending for Background music (1-6 on the Stack) */
N_NoiseOff        equ  4 ;/* Immediate ending for Noise */
N_NoiseFade       equ  5 ;/* Graceful ending for Noise (1-6 on the Stack)*/
N_Pause           equ  6 ;/*  */
N_UnPause         equ  7 ;/*  */
N_IsAnySoundOn    equ  8 ;/* Is Any Sound Still On?? [ Flag in AX ] */

;   Wrapper Numbers   

N_ButtonClicks    equ   9;/* Assorted Random Clicks for menu screens */
N_PosFeedBack     equ  10;/* Major Menu Feedback sound */
N_NegFeedBack     equ  11;/* Feedback sound */
N_F14TitleMusic   equ  12;/* Opening Music */
N_MenuMus         equ  13;/* Menu Background Music (repeating) */
N_MenuCoda        equ  14;/* Ends Menu Music Gracefully */
N_GoodEndMus      equ  15;/* "Did Well" Music */
N_PoorEndMus      equ  16;/* "Did Poorly" Music */
N_DeathMus        equ  17;/* Died in combat */
N_PromoMus        equ  18;/* Promoted Music */
N_MenuClick       equ  19;/* Minor Menu Feedback sound */
N_TextClick       equ  20;/* Text Menu Feedback sound */

MaxWrapSnds       equ  20;/* [Same as Last Sound]*/

;    Game Numbers 

N_ButtonClicks    equ   9;/* Assorted Random Clicks for instrument panel */
N_FarExplo        equ  10;/* Distant or small Explo */
N_LoudExplo       equ  11;/* Distant or small Explo */
N_WeGetHitExplo   equ  12;/* Different Explo for us getting hit */
N_VulcanCannon    equ  13;/* (Continuous calling = repeated sound)*/
N_IFFWarning      equ  14;/* IFF Warning Sound (If Continuous calling -> repeated sound)*/
N_AIM9Search      equ  15;/* AIM Searches Sound (Continuous, Turned Off by AIM Lock)*/
N_AIM9Lock        equ  16;/* AIM LockOn Sound */
N_RadarSearch     equ  17;/* Enemy Radar Searching your area */
N_RadarLock       equ  18;/* Enemy Radar Locked on You! */
N_SpoolUp         equ  19;/* Sound for any plane Spools Up on carrier deck */
N_SpoolDown       equ  20;/* Sound for any plane Spools Down */
N_JetPassesBy      equ  21;/* Jet passes by the canopy */
N_LoudMissile     equ  22;/* Clunk and Missile Launch */
N_StallHorn       equ  23;/* (Continuous calling = repeated sound)*/
N_DropChaff       equ  24;/* */
N_DropBomb        equ  25;/* */
N_Eject           equ  26;/* */
N_OkJet           equ  27;/* OK to have Jet Sound */
N_NoJet           equ  28;/* No Jet Sound now */
N_KnotsAre        equ  29;/* Jet Speed on Stack, 0 - 999 */
N_JetFromInside   equ  30;/* Jet Sound Heard From Inside Cockpit */
N_JetFromOutside  equ  31;/* Jet Sound Heard From Outside Cockpit */
N_AirBrakeOn      equ  32;/* AirBrake Starts to move */
N_AirBrakeOff     equ  33;/* Stop AirBrake Sound */
N_GearOpenSeq     equ  34;/* Doors Open & Gear Moves until stopped by Close */
N_GearCloseSeq    equ  35;/* Gear stops & Doors Close */
N_CatapultTakeOff equ  36;/* Sound for any plane making carrier takeoff */
N_CarrierLanding  equ  37;/* Landing crunch with tire squeal */
N_RedOut          equ  38;/* 0-15 [0=no chg,15=barely audible] vchg for G stress */
N_OutgoingJet     equ  39;/* [jet#][0=off,1=start,2=pause,3=cont] */
N_IncomingJet     equ  40;/* [jet#][0=off,1=start,2=pause,3=cont] */
N_Helicopter      equ  41;/* helicopter [0=off, 1=on] */

MaxGameSnds       equ  41;/* [Same as Last Sound]*/
