// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved) {
	static __int64 clocks;
	HANDLE hProc;
	int priority;

	switch (dwReason) {
	case DLL_PROCESS_ATTACH:
		if (Settings.logging) {
			of.open("glide.log");
			of.close();
		}

//		prof_start(clocks)
//		prof_enter(clocks)

//		prof_start(func_time);

		log("Called DllMain");
		log("  Attached to process");


		switch (Settings.priority) {
		case 1:		priority = IDLE_PRIORITY_CLASS;		break;
		case 2:		priority = NORMAL_PRIORITY_CLASS;	break;
		case 3:		priority = HIGH_PRIORITY_CLASS;		break;
		case 4:		priority = REALTIME_PRIORITY_CLASS;	break;
		default:	priority = NORMAL_PRIORITY_CLASS;
		}

		if (Settings.priority) {
			hProc = GetCurrentProcess();
			SetPriorityClass(hProc, priority);
		}

//		SetCursorPos(0, 0);

		fontInUse = CreateFont(12 ,0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, NONANTIALIASED_QUALITY, VARIABLE_PITCH, "Arial");

		_hInstance = hInstance;
		break;
	case DLL_PROCESS_DETACH:

		log("Called DllMain");
		log("  Detached from process");

//		prof_exit(clocks)

//		log((float(clocks)/400000000) << " seconds passed");
//		log((float(func_time)/400000000) << " seconds in vconv");

		break;
	}




	return TRUE;
}
