/////////////////////////////////////////////////////////////////////////////
// GliD3D.h : GliD3D - Glide to Direct3D
/////////////////////////////////////////////////////////////////////////////
#ifndef __GLID3D_H__
#define __GLID3D_H__
/////////////////////////////////////////////////////////////////////////////
extern "C" {

#include <windows.h>
#include <GL/gl.h>
#include <stdio.h>

#define FX_GLIDE_NO_FUNC_PROTO
#include "glide.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

#define NO_BGRA_REV
#define CACHETRIANGLES
//#define USEVERTEXARRAY
//#define DEBUGDLL
#define NO_FLUSH_DEPTHMASK

#ifdef DEBUGDLL
//#define WARNING(v)		MessageBox(NULL,v, NULL, MB_OK);
#define WARNING(v)
//#define ERROROUT(v)
#define ERROROUT(v) {if(!ErrorFile) InitErrorFile(); fputs(v, ErrorFile); fputc('\n', ErrorFile);}
#define TRACEFUNCTION(v)
//#define TRACEFUNCTION(v) ERROROUT(v)
#else
#define WARNING(v)
#define ERROROUT(v)
#define TRACEFUNCTION(v)
#endif	/* DEBUGDLL */

#define GREXPORT	__declspec(dllexport)

#define GLID3D_PROFILENAME						"GL2ideal.ini"
#define GLID3DPROF_VIDEO_FULLSCREEN				"FullScreen"
#define GLID3DPROF_VIDEO_PRECISIONFIX			"PrecisionFix"
#define GLID3DPROF_VIDEO_USEZINVERSE			"UseZInverse"
#define GLID3DPROF_VIDEO_USETEXENVADD			"UseTexEnvAdd"
#define GLID3DPROF_VIDEO_USETEXENVCOMBINE		"UseTexEnvCombine"
#define GLID3DPROF_VIDEO_USETEXENVCOMBINE4		"UseTexEnvCombine4"
#define GLID3DPROF_VIDEO_USETEXENVBLENDEMU		"UseTexEnvBlendEmu"
#define GLID3DPROF_VIDEO_WIN_CUSTOM				"WinCustom"
#define GLID3DPROF_VIDEO_WIN_WIDTH				"WinWidth"
#define GLID3DPROF_VIDEO_WIN_HEIGHT				"WinHeight"
#define GLID3DPROF_VIDEO_FOG_MODE				"FogMode"
#define GLID3DPROF_VIDEO_FOG_FACTOR				"FogFactor"
#define GLID3DPROF_VIDEO_GL_HINT				"GLHint"
#define GLID3DPROF_VIDEO_FIX1					"Fix1"
#define GLID3DPROF_VIDEO_DEBUG					"Debug"

#define GLID3D_TMU0						(0)
#define GLID3D_NUM_TMU					(1)
#define GLID3D_TEXCALCMEMREQUIRED		(1)
#define GLID3D_TEXTEXTUREMEMREQUIRED	(1)
#define GLID3D_TEXMINADDRESS			(0)
#define GLID3D_TEXMAXADDRESS			(8192)

struct CORD {
	GLfloat x, y, z, w;
};

struct GL2IDE_COLOR
{
	struct {
		GLfloat	r, g, b;
	} rgb;
	GLfloat	a;
};

struct GL2IDE_TEXCORD
{
	GLfloat tu, tv;
};

typedef struct t_vertex2
{
	CORD cord;
	GL2IDE_TEXCORD tcord;
	GL2IDE_COLOR color;
}
VERTEX2;


typedef struct tagGLID3D_TEXTURE
{
	float	ah, aw;
	unsigned int	texId;		//gltexturename, -1 if no texture associated with 
	unsigned short	texture_filter_mode;
	unsigned short	clampmode;
}
 *LPGLID3D_TEXTURE, GLID3D_TEXTURE;

typedef struct tagGLID3D_TMU
{
	GLID3D_TEXTURE *texture;
}
 *LPGLID3D_TMU, GLID3D_TMU;

typedef struct tagGLID3D_STATE
{
	// System
	GrColorFormat_t color_format;
	GrOriginLocation_t origin_location;
	GrBuffer_t render_buffer;
	GrCullMode_t cull_mode;
	GrDitherMode_t dither_mode;
	GrColor_t fog_color;
	GrFogMode_t fog_mode;
	DWORD fog_d3dcolor;

	// Clip window
/*  	FxU32 clip_window_minx; */
/*  	FxU32 clip_window_miny; */
/*  	FxU32 clip_window_maxx; */
/*  	FxU32 clip_window_maxy; */

	// Chromakey
/*  	GrChromakeyMode_t chromakey_mode; */
/*  	GrColor_t chromakey_value; */

	// Depth buffer
	GrDepthBufferMode_t depth_buffer_mode;
	FxBool depth_mask;
	GrCmpFnc_t depth_buffer_function;
	FxI16 depth_bias_level;

	// Color
	DWORD constant_color_value;
	DWORD constant_color_value_color;
	DWORD constant_color_value_alpha;
	GL2IDE_COLOR constant_color;
	GrCombineFunction_t color_combine_function;
	GrCombineFactor_t color_combine_factor;
	GrCombineLocal_t color_combine_local;
	GrCombineOther_t color_combine_other;
	FxBool color_combine_invert;
	FxBool color_mask_rgb;
	FxBool color_mask_a;

	// Alpha
	GrCombineFunction_t alpha_combine_function;
	GrCombineFactor_t alpha_combine_factor;
	GrCombineLocal_t alpha_combine_local;
	GrCombineOther_t alpha_combine_other;
	GrAlphaBlendFnc_t alpha_blend_function_rgb_sf;
	GrAlphaBlendFnc_t alpha_blend_function_rgb_df;
	GrAlphaBlendFnc_t alpha_blend_function_alpha_sf;
	GrAlphaBlendFnc_t alpha_blend_function_alpha_df;
	GrCmpFnc_t alpha_test_function;
	GrAlpha_t alpha_test_reference_value;
}
 *LPGLID3D_STATE, GLID3D_STATE;


/////////////////////////////////////////////////////////////////////////////
// Globals

extern HWND g_gr_hWnd;
extern HWND g_gr_hWndOld;
extern HDC g_gr_hDC;
extern HGLRC g_gr_glRC;
extern INT g_gr_nWidth;
extern INT g_gr_nHeight;
extern BOOL g_gr_bOpenedWindow;

const BOOL g_gr_bUseZInverse = TRUE;
const BOOL g_gr_bPrecisionFix = TRUE;
///extern BOOL g_gr_bUseZInverse;
///extern BOOL g_gr_bPrecisionFix;
///extern BOOL g_gr_bUseTexEnvBlendEmu;
const BOOL g_gr_bUseTexEnvBlendEmu = TRUE;
extern BOOL g_gr_bUseTexEnvAdd;
extern BOOL g_gr_bUseTexEnvCombine;
extern BOOL g_gr_bUseTexEnvCombine4;
extern BOOL g_gr_bFullScreen;
extern INT g_gr_glHint;
extern BOOL g_gr_nWinCustom;
extern INT g_gr_nWinWidth;
extern INT g_gr_nWinHeight;
extern INT g_gr_fogMode;
extern INT g_gr_fogFactor;
extern INT g_gr_fix1;
//extern INT g_gr_nDebug;

extern int			static_color_mode;
//extern GL2IDE_COLOR	static_color;
extern BOOL			noTexColor;
extern BOOL			noTexAlpha;
extern int			combine_color_mode;
extern int			flushDrawState;
extern GL2IDE_COLOR	texEnvColor;

extern BOOL		g_gr_Texture2DOn;
extern BOOL		g_gr_BlendOn;
extern BOOL		g_gr_AlphaTestOn;
extern GLint	g_gr_texenv;
extern GLint		f_texenv;
extern GrAlphaBlendFnc_t	f_alpha_blend_function_rgb_sf;
extern GrAlphaBlendFnc_t	f_alpha_blend_function_rgb_df;
extern GrCmpFnc_t	f_alpha_test_function;
extern GrAlpha_t	f_alpha_test_reference_value;
extern FxBool		f_depth_mask;
extern GrCmpFnc_t	f_depth_buffer_function;
extern GrCullMode_t	f_cull_mode;
extern float		fPrecisionFix, f256, f_255;

extern GLID3D_TEXTURE *current_texture;
extern GLID3D_TMU g_gr_tmu[GLID3D_NUM_TMU];

extern VERTEX2	ptlv[3];

extern GLID3D_STATE g_gr_state;
extern GLenum	src_blendmap[16], dst_blendmap[16];
extern GLID3D_TEXTURE texture_buf[GLID3D_TEXMAXADDRESS + 2];


#ifdef DEBUGDLL
extern FILE *ErrorFile;
void InitErrorFile(void);
void CloseErrorFile(void);
#endif

/////////////////////////////////////////////////////////////////////////////
// Prototypes

// Glide functions
GREXPORT FX_ENTRY void FX_CALL grDrawLine (const GrVertex * v1, const
	GrVertex * v2);
GREXPORT FX_ENTRY void FX_CALL grDrawPlanarPolygon (int nverts, const int
	ilist[], const
	GrVertex vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawPlanarPolygonVertexList (int
	nverts, const
	GrVertex
	vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawPoint (const GrVertex * pt);
GREXPORT FX_ENTRY void FX_CALL grDrawPolygon (int nverts, const int
	ilist[], const GrVertex
	vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawPolygonVertexList (int nverts, const
	GrVertex vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawTriangle (const GrVertex * a, const
	GrVertex * b, const
	GrVertex * c);

GREXPORT FX_ENTRY void FX_CALL grBufferClear (GrColor_t color, GrAlpha_t
	alpha, FxU16 depth);
GREXPORT FX_ENTRY int FX_CALL grBufferNumPending (void);
GREXPORT FX_ENTRY void FX_CALL grBufferSwap (int swap_interval);
GREXPORT FX_ENTRY void FX_CALL grRenderBuffer (GrBuffer_t buffer);

typedef void (*GrErrorCallbackFnc_t) (const char *string, FxBool fatal);
GREXPORT FX_ENTRY void FX_CALL grErrorSetCallback (GrErrorCallbackFnc_t fnc);

GREXPORT FX_ENTRY void FX_CALL grSstIdle (void);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstVideoLine (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstVRetraceOn (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstIsBusy (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstWinOpen (
	FxU32 hWnd,
	GrScreenResolution_t screen_resolution,
	GrScreenRefresh_t refresh_rate,
	GrColorFormat_t color_format,
	GrOriginLocation_t origin_location,
	int nColBuffers,
	int nAuxBuffers);
GREXPORT FX_ENTRY void FX_CALL grSstWinClose (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstControl (FxU32 code);
GREXPORT FX_ENTRY FxBool FX_CALL grSstQueryHardware (GrHwConfiguration * hwconfig);
GREXPORT FX_ENTRY FxBool FX_CALL grSstQueryBoards (GrHwConfiguration * hwconfig);
GREXPORT FX_ENTRY void FX_CALL grSstOrigin (GrOriginLocation_t origin);
GREXPORT FX_ENTRY void FX_CALL grSstSelect (int which_sst);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstScreenHeight (void);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstScreenWidth (void);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstStatus (void);

GREXPORT FX_ENTRY void FX_CALL grSstPerfStats (GrSstPerfStats_t * pStats);
GREXPORT FX_ENTRY void FX_CALL grSstResetPerfStats (void);
GREXPORT FX_ENTRY void FX_CALL grResetTriStats ();
GREXPORT FX_ENTRY void FX_CALL grTriStats (FxU32 * trisProcessed, FxU32
	* trisDrawn);

GREXPORT FX_ENTRY void FX_CALL grAlphaBlendFunction (GrAlphaBlendFnc_t
	rgb_sf, GrAlphaBlendFnc_t rgb_df, GrAlphaBlendFnc_t alpha_sf,
	GrAlphaBlendFnc_t alpha_df);
GREXPORT FX_ENTRY void FX_CALL grAlphaCombine (GrCombineFunction_t
	function, GrCombineFactor_t factor, GrCombineLocal_t local,
	GrCombineOther_t other, FxBool invert);
GREXPORT FX_ENTRY void FX_CALL grAlphaControlsITRGBLighting (FxBool enable);
GREXPORT FX_ENTRY void FX_CALL grAlphaTestFunction (GrCmpFnc_t function);
GREXPORT FX_ENTRY void FX_CALL grAlphaTestReferenceValue (GrAlpha_t value);
GREXPORT FX_ENTRY void FX_CALL grChromakeyMode (GrChromakeyMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grChromakeyValue (GrColor_t value);
GREXPORT FX_ENTRY void FX_CALL grClipWindow (FxU32 minx, FxU32 miny, FxU32
	maxx, FxU32 maxy);
GREXPORT FX_ENTRY void FX_CALL grColorCombine (GrCombineFunction_t
	function, GrCombineFactor_t factor, GrCombineLocal_t local,
	GrCombineOther_t other, FxBool invert);
GREXPORT FX_ENTRY void FX_CALL grColorMask (FxBool rgb, FxBool a);
GREXPORT FX_ENTRY void FX_CALL grCullMode (GrCullMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grConstantColorValue (GrColor_t value);
GREXPORT FX_ENTRY void FX_CALL grConstantColorValue4 (float a, float r, float
	g, float b);
GREXPORT FX_ENTRY void FX_CALL grDepthBiasLevel (FxI16 level);
GREXPORT FX_ENTRY void FX_CALL grDepthBufferFunction (GrCmpFnc_t function);
GREXPORT FX_ENTRY void FX_CALL grDepthBufferMode (GrDepthBufferMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grDepthMask (FxBool mask);
GREXPORT FX_ENTRY void FX_CALL grDisableAllEffects (void);
GREXPORT FX_ENTRY void FX_CALL grDitherMode (GrDitherMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grFogColorValue (GrColor_t fogcolor);
GREXPORT FX_ENTRY void FX_CALL grFogMode (GrFogMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grFogTable (const GrFog_t ft[GR_FOG_TABLE_SIZE]);
GREXPORT FX_ENTRY void FX_CALL grGammaCorrectionValue (float value);
GREXPORT FX_ENTRY void FX_CALL grSplash (float x, float y, float width, float
	height, FxU32 frame);

GREXPORT FX_ENTRY FxU32 FX_CALL
  grTexCalcMemRequired (
	GrLOD_t lodmin, GrLOD_t lodmax,
	GrAspectRatio_t aspect, GrTextureFormat_t fmt);
GREXPORT FX_ENTRY FxU32 FX_CALL
  grTexTextureMemRequired (FxU32 evenOdd,
	GrTexInfo * info);
GREXPORT FX_ENTRY FxU32 FX_CALL grTexMinAddress (GrChipID_t tmu);
GREXPORT FX_ENTRY FxU32 FX_CALL grTexMaxAddress (GrChipID_t tmu);
GREXPORT FX_ENTRY void FX_CALL grTexNCCTable (GrChipID_t tmu,
	GrNCCTable_t table);
GREXPORT FX_ENTRY void FX_CALL grTexSource (GrChipID_t tmu, FxU32 startAddress,
	FxU32 evenOdd, GrTexInfo * info);
GREXPORT FX_ENTRY void FX_CALL grTexClampMode (GrChipID_t tmu,
	GrTextureClampMode_t s_clampmode, GrTextureClampMode_t t_clampmode);
GREXPORT FX_ENTRY void FX_CALL grTexCombine (GrChipID_t tmu,
	GrCombineFunction_t rgb_function, GrCombineFactor_t rgb_factor,
	GrCombineFunction_t alpha_function, GrCombineFactor_t alpha_factor,
	FxBool rgb_invert, FxBool alpha_invert);
GREXPORT FX_ENTRY void FX_CALL grTexCombineFunction (GrChipID_t tmu,
	GrTextureCombineFnc_t fnc);
GREXPORT FX_ENTRY void FX_CALL grTexDetailControl (GrChipID_t tmu, int lod_bias,
	FxU8 detail_scale,
	float detail_max
);
GREXPORT FX_ENTRY void FX_CALL grTexFilterMode (GrChipID_t tmu,
	GrTextureFilterMode_t minfilter_mode, GrTextureFilterMode_t magfilter_mode);
GREXPORT FX_ENTRY void FX_CALL grTexLodBiasValue (GrChipID_t tmu, float bias);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadMipMap (GrChipID_t tmu,
	FxU32 startAddress, FxU32 evenOdd, GrTexInfo * info);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadMipMapLevel (GrChipID_t tmu,
	FxU32 startAddress, GrLOD_t thisLod, GrLOD_t largeLod,
	GrAspectRatio_t aspectRatio, GrTextureFormat_t format, FxU32
	evenOdd, void *data);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadMipMapLevelPartial
	(GrChipID_t tmu, FxU32 startAddress, GrLOD_t thisLod, GrLOD_t largeLod,
	GrAspectRatio_t aspectRatio, GrTextureFormat_t format, FxU32
	evenOdd, void *data,
	int start,
	int end);
GREXPORT FX_ENTRY void FX_CALL ConvertAndDownloadRle (GrChipID_t tmu,
	FxU32 startAddress, GrLOD_t thisLod, GrLOD_t largeLod,
	GrAspectRatio_t aspectRatio, GrTextureFormat_t format, FxU32 evenOdd,
	FxU8 * bm_data, long bm_h,
	FxU32 u0,
	FxU32 v0,
	FxU32 width,
	FxU32 height,
	FxU32 dest_width,
	FxU32 dest_height,
	FxU16 * tlut);
GREXPORT FX_ENTRY void FX_CALL grCheckForRoom (FxI32 n);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadTable (GrChipID_t tmu,
	GrTexTable_t type, void *data);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadTablePartial (GrChipID_t tmu,
	GrTexTable_t type, void *data,
	int start,
	int end);
GREXPORT FX_ENTRY void FX_CALL grTexMipMapMode (GrChipID_t tmu,
	GrMipMapMode_t mode, FxBool lodBlend);
GREXPORT FX_ENTRY void FX_CALL grTexMultibase (GrChipID_t tmu, FxBool enable);
GREXPORT FX_ENTRY void FX_CALL grTexMultibaseAddress (GrChipID_t tmu,
	GrTexBaseRange_t range, FxU32 startAddress, FxU32 evenOdd, GrTexInfo
	* info);

GREXPORT FX_ENTRY GrMipMapId_t FX_CALL guTexAllocateMemory (GrChipID_t tmu,
	FxU8 odd_even_mask, int width, int height,
	GrTextureFormat_t fmt,
	GrMipMapMode_t mm_mode,
	GrLOD_t smallest_lod, GrLOD_t largest_lod,
	GrAspectRatio_t aspect,
	GrTextureClampMode_t s_clamp_mode,
	GrTextureClampMode_t t_clamp_mode,
	GrTextureFilterMode_t minfilter_mode,
	GrTextureFilterMode_t magfilter_mode,
	float lod_bias,
	FxBool trilinear
);

GREXPORT FX_ENTRY FxBool FX_CALL
  guTexChangeAttributes (
	GrMipMapId_t mmid,
	int width, int height,
	GrTextureFormat_t fmt,
	GrMipMapMode_t mm_mode,
	GrLOD_t smallest_lod, GrLOD_t largest_lod,
	GrAspectRatio_t aspect,
	GrTextureClampMode_t s_clamp_mode,
	GrTextureClampMode_t t_clamp_mode,
	GrTextureFilterMode_t minFilterMode,
	GrTextureFilterMode_t magFilterMode
);

GREXPORT FX_ENTRY void FX_CALL guTexCombineFunction (GrChipID_t tmu,
	GrTextureCombineFnc_t fnc);
GREXPORT FX_ENTRY GrMipMapId_t FX_CALL guTexGetCurrentMipMap (GrChipID_t tmu);
GREXPORT FX_ENTRY GrMipMapInfo *FX_CALL guTexGetMipMapInfo (GrMipMapId_t mmid);
GREXPORT FX_ENTRY FxU32 FX_CALL guTexMemQueryAvail (GrChipID_t tmu);
GREXPORT FX_ENTRY void FX_CALL guTexMemReset (void);
GREXPORT FX_ENTRY void FX_CALL guTexDownloadMipMap (GrMipMapId_t mmid, const void *src,
	const GuNccTable * table
);
GREXPORT FX_ENTRY void FX_CALL guTexDownloadMipMapLevel (GrMipMapId_t mmid,
	GrLOD_t lod, const void **src
);
GREXPORT FX_ENTRY void FX_CALL guTexSource (GrMipMapId_t id);

GREXPORT FX_ENTRY FxBool FX_CALL grLfbLock (GrLock_t type, GrBuffer_t
	buffer, GrLfbWriteMode_t writeMode, GrOriginLocation_t origin,
	FxBool pixelPipeline, GrLfbInfo_t * info);
GREXPORT FX_ENTRY FxBool FX_CALL grLfbUnlock (GrLock_t type, GrBuffer_t buffer);
GREXPORT FX_ENTRY void FX_CALL grLfbConstantAlpha (GrAlpha_t alpha);
GREXPORT FX_ENTRY void FX_CALL grLfbConstantDepth (FxU16 depth);
GREXPORT FX_ENTRY void FX_CALL grLfbWriteColorSwizzle (FxBool swizzleBytes,
	FxBool swapWords);
GREXPORT FX_ENTRY void FX_CALL grLfbWriteColorFormat (GrColorFormat_t colorFormat);
GREXPORT FX_ENTRY FxBool FX_CALL grLfbWriteRegion (GrBuffer_t dst_buffer,
	FxU32 dst_x, FxU32 dst_y, GrLfbSrcFmt_t src_format, FxU32 src_width,
	FxU32 src_height, FxI32 src_stride, void *src_data);
GREXPORT FX_ENTRY FxBool FX_CALL
  grLfbReadRegion (GrBuffer_t src_buffer,
	FxU32 src_x, FxU32 src_y,
	FxU32 src_width, FxU32 src_height,
	FxU32 dst_stride, void *dst_data);

GREXPORT FX_ENTRY void FX_CALL grAADrawLine (const GrVertex * v1, const
	GrVertex * v2);
GREXPORT FX_ENTRY void FX_CALL grAADrawPoint (const GrVertex * pt);
GREXPORT FX_ENTRY void FX_CALL grAADrawPolygon (const int nverts, const int
	ilist[], const GrVertex
	vlist[]);
GREXPORT FX_ENTRY void FX_CALL grAADrawPolygonVertexList (const int
	nverts, const
	GrVertex vlist[]);
GREXPORT FX_ENTRY void FX_CALL grAADrawTriangle (const GrVertex * a, const
	GrVertex * b, const
	GrVertex * c,
	FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
);

GREXPORT FX_ENTRY void FX_CALL grGlideInit (void);
GREXPORT FX_ENTRY void FX_CALL grGlideShutdown (void);
GREXPORT FX_ENTRY void FX_CALL grGlideGetVersion (char version[80]);
GREXPORT FX_ENTRY void FX_CALL grGlideGetState (GrState * state);
GREXPORT FX_ENTRY void FX_CALL grGlideSetState (const GrState * state);
GREXPORT FX_ENTRY void FX_CALL grGlideShamelessPlug (const FxBool on);
GREXPORT FX_ENTRY void FX_CALL grHints (GrHint_t hintType, FxU32 hintMask);

GREXPORT FX_ENTRY void FX_CALL guAADrawTriangleWithClip (const GrVertex
	* a, const GrVertex
	* b, const GrVertex * c);
GREXPORT FX_ENTRY void FX_CALL guDrawTriangleWithClip (const GrVertex * a,
	const GrVertex * b,
	const GrVertex * c
);
GREXPORT FX_ENTRY void FX_CALL guDrawPolygonVertexListWithClip (int
	nverts, const
	GrVertex
	vlist[]);
GREXPORT FX_ENTRY void FX_CALL guAlphaSource (GrAlphaSource_t mode);
GREXPORT FX_ENTRY void FX_CALL guColorCombineFunction
	(GrColorCombineFnc_t fnc);
GREXPORT FX_ENTRY int FX_CALL guEncodeRLE16 (void *dst,
	void *src,
	FxU32 width,
	FxU32 height);
GREXPORT FX_ENTRY FxU16 *FX_CALL guTexCreateColorMipMap (void);

GREXPORT FX_ENTRY float FX_CALL guFogTableIndexToW (int i);
GREXPORT FX_ENTRY void FX_CALL guFogGenerateExp (GrFog_t
	fogtable[GR_FOG_TABLE_SIZE], float density);
GREXPORT FX_ENTRY void FX_CALL guFogGenerateExp2 (GrFog_t
	fogtable[GR_FOG_TABLE_SIZE], float density);
GREXPORT FX_ENTRY void FX_CALL guFogGenerateLinear (GrFog_t
	fogtable[GR_FOG_TABLE_SIZE], float
	nearZ, float farZ);

GREXPORT FX_ENTRY FxU32 FX_CALL guEndianSwapWords (FxU32 value);
GREXPORT FX_ENTRY FxU16 FX_CALL guEndianSwapBytes (FxU16 value);

GREXPORT FX_ENTRY FxBool FX_CALL gu3dfGetInfo (const char *filename,
	Gu3dfInfo * info);
GREXPORT FX_ENTRY FxBool FX_CALL gu3dfLoad (const char *filename,
	Gu3dfInfo * data);


///////////////////////////////////////////////////////////////////////////////
// Sub functions

inline static DWORD grsubConvColor (GrColor_t color)
{ // Convert color format to ARGB
	switch (g_gr_state.color_format)
	{
	case GR_COLORFORMAT_RGBA:
		return (DWORD) (
			((((DWORD) color) >> 8) & 0x00ffffff) |
			((((DWORD) color) << 24) & 0xff000000));
	case GR_COLORFORMAT_ARGB:
		return (DWORD) color;
	case GR_COLORFORMAT_BGRA:
		return (DWORD) (
			((((DWORD) color) << 8) & 0x00ff0000) |
			((((DWORD) color) >> 8) & 0x0000ff00) |
			((((DWORD) color) >> 24) & 0x000000ff) |
			((((DWORD) color) << 24) & 0xff000000));
	case GR_COLORFORMAT_ABGR:
		return (DWORD) (
			((((DWORD) color) << 16) & 0x00ff0000) |
			((((DWORD) color)) & 0xff00ff00) |
			((((DWORD) color) >> 16) & 0x000000ff));
	}
	return 0xffffffff;
}

inline COLORREF grsubConvColorRef (GrColor_t color)
{ // Convert color format to COLORREF (BGR)
	switch (g_gr_state.color_format)
	{
	case GR_COLORFORMAT_RGBA:
		return (COLORREF) (
			((((DWORD) color) >> 24) & 0x000000ff) |
			((((DWORD) color) >> 8) & 0x0000ff00) |
			((((DWORD) color) << 8) & 0x00ff0000));
	case GR_COLORFORMAT_ARGB:
		return (COLORREF) (
			((((DWORD) color) >> 16) & 0x000000ff) |
			((((DWORD) color) << 16) & 0x00ff0000) |
			((((DWORD) color)) & 0x0000ff00));
	case GR_COLORFORMAT_BGRA:
		return (COLORREF) ((((DWORD) color) >> 8) & 0x00ffffff);
	case GR_COLORFORMAT_ABGR:
		return (COLORREF) color & 0x00ffffff;
	}
	return 0xffffffff;
}

inline INT grsubGetTmuIndex (GrChipID_t tmu)	{ return GLID3D_TMU0; }
BOOL gusub3dfGetInfo (LPCSTR filename, Gu3dfInfo * info, LPDWORD pdwDataOffset);


inline INT grsubLodToInt (GrLOD_t lod)
{
	switch (lod)
	{
	case GR_LOD_1:
		return 1;
	case GR_LOD_2:
		return 2;
	case GR_LOD_4:
		return 4;
	case GR_LOD_8:
		return 8;
	case GR_LOD_16:
		return 16;
	case GR_LOD_32:
		return 32;
	case GR_LOD_64:
		return 64;
	case GR_LOD_128:
		return 128;
	case GR_LOD_256:
		return 256;
	}
	return 0;
}

inline GrLOD_t grsubIntToLod (INT nLod)
{
	switch (nLod)
	{
	case 1:
		return GR_LOD_1;
	case 2:
		return GR_LOD_2;
	case 4:
		return GR_LOD_4;
	case 8:
		return GR_LOD_8;
	case 16:
		return GR_LOD_16;
	case 32:
		return GR_LOD_32;
	case 64:
		return GR_LOD_64;
	case 128:
		return GR_LOD_128;
	case 256:
		return GR_LOD_256;
	}
	return 0;
}

inline VOID grsubAspectToInt (INT & pnAspectW, INT & pnAspectH,
	GrAspectRatio_t aspect_ratio)
{
	switch (aspect_ratio)
	{
	case GR_ASPECT_8x1:
		pnAspectW = 8;
		pnAspectH = 1;
		return;
	case GR_ASPECT_4x1:
		pnAspectW = 4;
		pnAspectH = 1;
		return;
	case GR_ASPECT_2x1:
		pnAspectW = 2;
		pnAspectH = 1;
		return;
	case GR_ASPECT_1x1:
		pnAspectW = 1;
		pnAspectH = 1;
		return;
	case GR_ASPECT_1x2:
		pnAspectW = 1;
		pnAspectH = 2;
		return;
	case GR_ASPECT_1x4:
		pnAspectW = 1;
		pnAspectH = 4;
		return;
	case GR_ASPECT_1x8:
		pnAspectW = 1;
		pnAspectH = 8;
		return;
	default:
		pnAspectW = 1;
		pnAspectH = 1;
		break;
	}
}

inline VOID grsubIntToAspect (GrAspectRatio_t & paspect_ratio, INT nAspectW,
	INT nAspectH)
{
	if (nAspectW == 1)
	{
		if (nAspectH == 1)
			paspect_ratio = GR_ASPECT_1x1;
		else if (nAspectH == 2)
			paspect_ratio = GR_ASPECT_1x2;
		else if (nAspectH == 4)
			paspect_ratio = GR_ASPECT_1x4;
		else if (nAspectH == 8)
			paspect_ratio = GR_ASPECT_1x8;
	}
	else
	{
		if (nAspectW == 2)
			paspect_ratio = GR_ASPECT_2x1;
		else if (nAspectW == 4)
			paspect_ratio = GR_ASPECT_4x1;
		else if (nAspectW == 8)
			paspect_ratio = GR_ASPECT_8x1;
	}
}


/////////////////////////////////////////////////////////////////////////////
// CacheTriangles


#ifdef USEVERTEXARRAY
#define MAXVERTEX (3 * 128)
extern GLsizei ArrayCount;
extern CORD CoordArray[MAXVERTEX];
extern GL2IDE_TEXCORD TexCoordArray[MAXVERTEX];
extern GL2IDE_COLOR ColorArray[MAXVERTEX];
inline static void FlushTriangleVertex(void)
{
	if (ArrayCount == 0)
		return;

	if (g_gr_Texture2DOn)
		glTexCoordPointer (2, GL_FLOAT, 0, TexCoordArray);
	glColorPointer( 4, GL_FLOAT, 0, ColorArray);
	glVertexPointer( 4, GL_FLOAT, 0, CoordArray);

	glDrawArrays( GL_TRIANGLES, 0, ArrayCount);
	ArrayCount = 0;
}
#else
#ifdef CACHETRIANGLES
extern BOOL g_gr_DrawingTriangles;
inline void FlushTriangleVertex(void)
{
	if(!g_gr_DrawingTriangles)
		return;
	glEnd();
	g_gr_DrawingTriangles = FALSE;
}
#else
#define FlushTriangleVertex()
#endif	//CACHETRIANGLES
#endif	//USEVERTEXARRAY


}	/* extern "C" */

#endif
/////////////////////////////////////////////////////////////////////////////
