/////////////////////////////////////////////////////////////////////////////
// GliD3D_GlideManagement.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"
/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements


FX_ENTRY void FX_CALL grGlideInit (void)
{
	TRACEFUNCTION ("grGlideInit");

	// Initialize system variables

	g_gr_hWndOld = NULL;
	g_gr_bOpenedWindow = FALSE;
	g_gr_nWidth = 0;
	g_gr_nHeight = 0;
	g_gr_bFullScreen = FALSE;
}

FX_ENTRY void FX_CALL grGlideShutdown (void)
{
	TRACEFUNCTION ("grGlideShutdown");

	if (g_gr_bOpenedWindow)
		grSstWinClose ();
}

FX_ENTRY void FX_CALL grGlideGetVersion (char version[80])
{
	TRACEFUNCTION ("grGlideGetVersion");

	lstrcpy (version, "2.46");
}

FX_ENTRY void FX_CALL grGlideGetState (GrState * state)
{
	TRACEFUNCTION ("grGlideGetState");

	CopyMemory (state, &g_gr_state, sizeof (GLID3D_STATE));
}

FX_ENTRY void FX_CALL grGlideSetState (const GrState * state)
{
	TRACEFUNCTION ("grGlideSetState");

	CopyMemory (&g_gr_state, state, sizeof (GLID3D_STATE));
	grColorCombine (g_gr_state.color_combine_function,
		g_gr_state.color_combine_factor,
		g_gr_state.color_combine_local,
		g_gr_state.color_combine_other,
		g_gr_state.color_combine_invert);
	grAlphaBlendFunction(g_gr_state.alpha_blend_function_rgb_sf,
		g_gr_state.alpha_blend_function_rgb_df,
		g_gr_state.alpha_blend_function_alpha_sf,
		g_gr_state.alpha_blend_function_alpha_df);
	grCullMode (g_gr_state.cull_mode);
	grDepthBufferMode (g_gr_state.depth_buffer_mode);
	grDepthMask (g_gr_state.depth_mask);
	grAlphaTestFunction (g_gr_state.alpha_test_function);
	grAlphaTestReferenceValue (g_gr_state.alpha_test_reference_value);
	grDepthBufferFunction (g_gr_state.depth_buffer_function);
	grRenderBuffer (g_gr_state.render_buffer);
	//grClipWindow (g_gr_state.clip_window_minx, g_gr_state.clip_window_miny,
	//	g_gr_state.clip_window_maxx, g_gr_state.clip_window_maxy);
	//grFogMode (g_gr_state.fog_mode);
	//grDepthBiasLevel (g_gr_state.depth_bias_level);
}

FX_ENTRY void FX_CALL grGlideShamelessPlug (const FxBool on)
{
	TRACEFUNCTION ("grGlideShamelessPlug");
}

FX_ENTRY void FX_CALL grHints (GrHint_t hintType, FxU32 hintMask)
{
	TRACEFUNCTION ("grHints");
}

/////////////////////////////////////////////////////////////////////////////
