#include "stdafx.h"

BLEND blend;

extern "C" __declspec(dllexport)
void grAlphaBlendFunction(GrAlphaBlendFnc_t rgb_sf,
                          GrAlphaBlendFnc_t rgb_df,
                          GrAlphaBlendFnc_t alpha_sf,
                          GrAlphaBlendFnc_t alpha_df)
{
   blend.rgb_sf = rgb_sf;
   blend.rgb_df = rgb_df;
   blend.alpha_sf = alpha_sf;
   blend.alpha_df = alpha_df;
   
   int sf, df;

   switch(rgb_sf)
   {
   case GR_BLEND_ZERO:
      sf = GL_ZERO;
      break;
   case GR_BLEND_ONE:
      sf = GL_ONE;
      break;
   case GR_BLEND_DST_COLOR:
      sf = GL_DST_COLOR;
      break;
   case GR_BLEND_ONE_MINUS_DST_COLOR:
      sf = GL_ONE_MINUS_DST_COLOR;
      break;
   case GR_BLEND_SRC_ALPHA:
      sf = GL_SRC_ALPHA;
      break;
   case GR_BLEND_ONE_MINUS_SRC_ALPHA:
      sf = GL_ONE_MINUS_SRC_ALPHA;
      break;
   case GR_BLEND_DST_ALPHA: 
      sf = GL_DST_ALPHA;
      break;
   case GR_BLEND_ONE_MINUS_DST_ALPHA:
      sf = GL_ONE_MINUS_DST_ALPHA;
      break;
   case GR_BLEND_ALPHA_SATURATE:
      //sf - GL_ALPHA_SATURATE;
      break;
   }

   switch(rgb_df)
   {
   case GR_BLEND_ZERO:
      df = GL_ZERO;
      break;
   case GR_BLEND_ONE:
      df = GL_ONE;
      break;
   case GR_BLEND_SRC_COLOR:
      df = GL_SRC_COLOR;
      break;
   case GR_BLEND_ONE_MINUS_SRC_COLOR:
      df = GL_ONE_MINUS_SRC_COLOR;
      break;
   case GR_BLEND_SRC_ALPHA:
      df = GL_SRC_ALPHA;
      break;
   case GR_BLEND_ONE_MINUS_SRC_ALPHA:
      df = GL_ONE_MINUS_SRC_ALPHA;
      break;
   case GR_BLEND_DST_ALPHA: 
      df = GL_DST_ALPHA;
      break;
   case GR_BLEND_ONE_MINUS_DST_ALPHA:
      df = GL_ONE_MINUS_DST_ALPHA;
      break;
   case GR_BLEND_PREFOG_COLOR:
      //df = GL_PREFOG_COLOR;
      break;
   }

   
   glEnable(GL_BLEND);
	glBlendFunc(sf, df);

   //MessageBox(NULL, string, "Blend Notice", MB_APPLMODAL);
}