#include "include.h"

ExeBuffer::ExeBuffer() {
	// Initial size
	_max = 1024;

	_num = 0;
	_buf = new D3DTLVERTEX[3*_max];

	// Invalidate initial states 
	_lastcolorop = -1;
	_lastcolorarg1 = -1;
	_lastcolorarg2 = -1;
	_lastalphaop = -1;
	_lastalphaarg1 = -1;
	_lastalphaarg2 = -1;
	_lastalphatestfunc = -1;
	_lastckmode = -1;
}

ExeBuffer::~ExeBuffer() {
	delete [] _buf;
}


// Force Direct3D to reload the texture (may be necessary if palette changes)
void ExeBuffer::ForceTex(Tex *tex) {
	Flush();

	Voodoo.curtex = tex;

	if (tex) {
		Voodoo.texture = TEXTURE;

		if (tex->paletted()) tex->setpalette();

		SetVconv();

		if (DX.D3DD->SetTexture(0, tex->tex()) != D3D_OK) log("Error setting texture");
	} else {
		Voodoo.texture = NO_TEXTURE;
		SetVconv();

		if (DX.D3DD->SetTexture(0, 0) != D3D_OK) log("Error setting texture");
	}
}

// Set the texture if it differs from the currently selected one
void ExeBuffer::SetTex(Tex *tex) {
	if (Voodoo.curtex != tex) {
		ForceTex(tex);
	}
}
