/*
 *	@(#) Space.c 9.1 95/03/15 SCOINC
 *
 *      Copyright (C) The Santa Cruz Operation, 1994-1995.
 *      This Module contains Proprietary Information of
 *      The Santa Cruz Operation and should be treated
 *      as Confidential.
 */

/*
 *      System V STREAMS TCP - Release 4.0
 *
 *      Copyright 1987, 1988 Lachman Associates, Incorporated (LAI)
 *
 *      All Rights Reserved.
 *
 *      The copyright above and this notice must be preserved in all
 *      copies of this source code.  The copyright above does not
 *      evidence any actual or intended publication of this source
 *      code.
 *
 *      This is unpublished proprietary trade secret source code of
 *      Lachman Associates.  This source code may not be copied,
 *      disclosed, distributed, demonstrated or licensed except as
 *      expressly authorized by Lachman Associates.
 *
 *      System V STREAMS TCP was jointly developed by Lachman
 *      Associates and Convergent Technologies.
 */
#include "sys/types.h"
#include "sys/stream.h"
#include "sys/mdi.h"
#include "sys/pci.h"
#include "pnt.h"

#include "config.h"
#include "space.h"

#define MAX_MINORS 16

int    pnt_MaxStrepnt = MAX_MINORS;
int    pnt_TotalDevCount = PNT_CNTLS;

struct pnt_ConfigStruct pnt_ConfigArray[PNT_CNTLS] = {
#if defined PNT_0
                {0,
                MAX_MINORS,
                PNT_0_VECT,
                PNT_0_SIOA,
                PNT_0_EIOA,
                PNT_0_DMA,
                PNT_0_TX_BUFFERS,
                PNT_0_RX_BUFFERS,
                PNT_0_LED0,
                PNT_0_LED1,
                PNT_0_LED2,
                PNT_0_LED3,
                PNT_0_DMAROTATE,
                PNT_0_TP,
                PNT_0_FDUP,
                PNT_0_PCNET2,
                PNT_0_PCI_BUS,
                PNT_0_PCI_DEV,
                PNT_0_PCI_FUNC
                }
#endif
#if defined PNT_1
                ,{1,
                MAX_MINORS,
                PNT_1_VECT,
                PNT_1_SIOA,
                PNT_1_EIOA,
                PNT_1_DMA,
                PNT_1_TX_BUFFERS,
                PNT_1_RX_BUFFERS,
                PNT_1_LED0,
                PNT_1_LED1,
                PNT_1_LED2,
                PNT_1_LED3,
                PNT_1_DMAROTATE,
                PNT_1_TP,
		PNT_1_FDUP,
		PNT_1_PCNET2,
                PNT_1_PCI_BUS,
                PNT_1_PCI_DEV,
                PNT_1_PCI_FUNC
                }
#endif
#if defined PNT_2
                ,{2,
                MAX_MINORS,
                PNT_2_VECT,
                PNT_2_SIOA,
                PNT_2_EIOA,
                PNT_2_DMA,
                PNT_2_TX_BUFFERS,
                PNT_2_RX_BUFFERS,
                PNT_2_LED0,
                PNT_2_LED1,
                PNT_2_LED2,
                PNT_2_LED3,
                PNT_2_DMAROTATE,
                PNT_2_TP,
		PNT_2_FDUP,
		PNT_2_PCNET2,
                PNT_2_PCI_BUS,
                PNT_2_PCI_DEV,
                PNT_2_PCI_FUNC
                }
#endif
#if defined PNT_3
                ,{3,
                MAX_MINORS,
                PNT_3_VECT,
                PNT_3_SIOA,
                PNT_3_EIOA,
                PNT_3_DMA,
                PNT_3_TX_BUFFERS,
                PNT_3_RX_BUFFERS,
                PNT_3_LED0,
                PNT_3_LED1,
                PNT_3_LED2,
                PNT_3_LED3,
                PNT_3_DMAROTATE,
                PNT_3_TP,
		PNT_3_FDUP,
		PNT_3_PCNET2,
                PNT_3_PCI_BUS,
                PNT_3_PCI_DEV,
                PNT_3_PCI_FUNC
                }
#endif
};

extern int pntopen(), pntclose(), pntuwput();
extern int nulldev();

struct module_info pnt_minfo = {
        0, "pnt", 14, 1514, 16*1514, 12*1514
};

struct qinit pnturinit = {
        0,  0, pntopen, pntclose, nulldev, &pnt_minfo, 0
};

struct qinit pntuwinit = {
        pntuwput, 0, pntopen, pntclose, nulldev, &pnt_minfo, 0
};

struct streamtab pntinfo = {
    &pnturinit, &pntuwinit, 0, 0
};
