///////////////////////////////////////////////////////////////////////////
//
//              LLL         UUU      UUU    IIIIIIIIIII
//             LLL         UUU      UUU        III
//             LLL         UUU      UUU        III
//            LLL         UUU      UUU        III
//            LLL         UUU      UUU        III
//           LLL         UUU      UUU        III
//           LLLLLLLLL    UUUUUUUUUU     IIIIIIIIII
//
//
//  LUI - Little User Interface
//
//  Copyright (c) 1995 ADVANCED MICRO DEVICES, INC. All Rights Reserved.
//  This software is unpblished and contains the trade secrets and
//  confidential proprietary information of AMD. Unless otherwise provided
//  in the Software Agreement associated herewith, it is licensed in confidence
//  "AS IS" and is not to be reproduced in whole or part by any means except
//  for backup. Use, duplication, or disclosure by the Government is subject
//  to the restrictions in paragraph (b) (3) (B) of the Rights in Technical
//  Data and Computer Software clause in DFAR 52.227-7013 (a) (Oct 1988).
//  Software owned by Advanced Micro Devices, Inc., 901 Thompson Place,
//  Sunnyvale, CA 94088.
//
//
//  Who's Who:
//  ~~~~~~~~~~
//  NAF - Nestor A. Fesas, Jr.
//
//  Modification History
//  ~~~~~~~~~~~~~~~~~~~~
//  11JUL95   NAF   Completed initial revision.
//

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <memory.h>
#include <string.h>
#include <graph.h>
#include <io.h>
#include <dos.h>
#include <fcntl.h>
#include <time.h>
#include <direct.h>
#include <time.h>
#include <sys/timeb.h>

extern "C" {
#include <dmiapi.h>
#include "dosins.h"
}

#include "dosinsui.hpp"


/////////////////////// Miscellaneous Helper Functions ////////////////////////

#define BIOS_VIDEO                          0x10
#define BIOS_SET_CURSOR_POSITION            0x02
#define BIOS_READ_CURSOR_POSITION           0x03
#define BIOS_READ_CHAR_AND_ATR              0x08
#define BIOS_WRITE_CHAR_AND_ATR             0x09

char* getTextImage(int r1,int c1,int r2,int c2)
{
  int x=c2-c1;
  int y=r2-r1;
  char *b0=new char[x*y*sizeof(short int)];
  char *b1=b0;
  if(b0!=NULL){
    int iActivePg=_getactivepage();
    register int i;
    for(i=0;i<y;i++){
      register int j;
      for(j=0;j<x;j++){
        union REGS regs;
        regs.h.ah=BIOS_SET_CURSOR_POSITION;
        regs.h.bh=char(iActivePg);
        regs.h.dh=i+r1;
        regs.h.dl=j+c1;
        int86(BIOS_VIDEO,&regs,&regs);
        regs.h.ah=BIOS_READ_CHAR_AND_ATR;
        regs.h.bh=char(iActivePg);
        int86(BIOS_VIDEO,&regs,&regs);
        *(short int*)b0=regs.x.ax;
        b0+=sizeof(regs.x.ax);
        }
      }
    }
  return b1;
}

void putTextImage(int r1,int c1,int r2,int c2,char* b1)
{
  int iActivePg=_getactivepage();
  int x=c2-c1;
  int y=r2-r1;
  char* b0=b1;
  register int i;
  for(i=0;i<y;i++){
    register int j;
    for(j=0;j<x;j++){
      union REGS regs;
      regs.h.ah=BIOS_SET_CURSOR_POSITION;
      regs.h.bh=char(iActivePg);
      regs.h.dh=i+r1;
      regs.h.dl=j+c1;
      int86(BIOS_VIDEO,&regs,&regs);
      regs.h.ah=BIOS_WRITE_CHAR_AND_ATR;
      regs.h.al=*b0++;
      regs.h.bh=char(iActivePg);
      regs.h.bl=*b0++;
      regs.x.cx=1;
      int86(BIOS_VIDEO,&regs,&regs);
      }
    }
}

void messageBox(char* msg,char* lbl,int r1,int c1,int r2,int c2)
{
  int iOldCurs=_settextcursor(iTextCursNone);
  struct _rccoord r=_gettextposition();
  char* b=getTextImage(r1-1,c1-1,r2-1,c2-1);
  TTextWindow*  ptErrorDialog=new TTextWindow(r1,c1,r2,c2,snglBrdr,lbl);
  if(ptErrorDialog!=NULL){
    if(strstr(lbl,"Error")||strstr(lbl,"ERROR")||strstr(lbl,"error"))
      ptErrorDialog->setFgBkColors(lBrtWhite,lRed);
    else
      ptErrorDialog->setFgBkColors(lBlue,lWhite);
    ptErrorDialog->paint();
    ptErrorDialog->putText(msg);
    while(!kbhit())
      ;
    getch();
    delete ptErrorDialog;
    }
  if(b!=NULL){
    putTextImage(r1-1,c1-1,r2-1,c2-1,b);
    delete b;
    }
  _settextcursor(iOldCurs);
  _settextposition(r.row,r.col);
}

extern "C" void _cdecl mbox(char*);
void _cdecl mbox(char* msg)
{
  messageBox(msg);
}

unsigned doSumUpper(char* p)
{
  if(p==NULL) return 0xFFFF;
  register unsigned sum=0;
  _strupr(p);
  while(*p)
    sum+=*p++;
  return sum;
}

unsigned getMonth(char* p)
{
  register unsigned sum=doSumUpper(p);

  // The 'break' statements are executed if the month name comparison
  // fails.
  switch(sum){
    case iJanSum: if(strcmp(p,JANUARY)==0)   return  0; break;
    case iFebSum: if(strcmp(p,FEBRUARY)==0)  return  1; break;
    case iMarSum: if(strcmp(p,MARCH)==0)     return  2; break;
    case iAprSum: if(strcmp(p,APRIL)==0)     return  3; break;
    case iMaySum: if(strcmp(p,MAY)==0)       return  4; break;
    case iJunSum: if(strcmp(p,JUNE)==0)      return  5; break;
    case iJulSum: if(strcmp(p,JULY)==0)      return  6; break;
    case iAugSum: if(strcmp(p,AUGUST)==0)    return  7; break;
    case iSepSum: if(strcmp(p,SEPTEMBER)==0) return  8; break;
    case iOctSum: if(strcmp(p,OCTOBER)==0)   return  9; break;
    case iNovSum: if(strcmp(p,NOVEMBER)==0)  return 10; break;
    case iDecSum: if(strcmp(p,DECEMBER)==0)  return 11; break;
    }
  return NOMONTH;
}

//////////////////////////////// TDosInstl /////////////////////////////////

TDvr TDosInstl::setSelectedDriver(long lDvrValue)
{
  return tSelectedDriver=(TDvr)lDvrValue;
}                

TDvr TDosInstl::setSelectedDriver(char* acDvrName,const char** ppcDvrNameLst)
{
  
  return tSelectedDriver;  
}

//////////////////////////////// Status Box ////////////////////////////////

class TStatusBox
{
 public:
  TStatusBox(int,int,int,int,char*lbl=NULL);
 ~TStatusBox();
  static void _cdecl _interrupt _far statusUpdate(
    unsigned _es, unsigned _ds, unsigned _di, unsigned _si,
    unsigned _bp, unsigned _sp, unsigned _bx, unsigned _dx,
    unsigned _cx, unsigned _ax, unsigned _ip, unsigned _cs,
    unsigned _flags);
 private:
  static char _far* fpcRegenBase;
  static int    iPhase;
  static int    iBaseRow;
  static int    iBaseCol;
  static int    iExtentRow;
  static int    iExtentCol;
  static int    iIndex;
  static int    iModVal;
  static void   (_cdecl _interrupt _far *pfOldVec)();
  static TTextWindow* ptWnd;
  int           iOldCurs;
  struct        _rccoord tOldCursCoords;
  char*         pcScrnSaveBfr;
  TTextWindow*  ptStatusWnd;
};

char _far* TStatusBox::fpcRegenBase;
int  TStatusBox::iPhase;
int  TStatusBox::iBaseRow;
int  TStatusBox::iBaseCol;
int  TStatusBox::iExtentRow;
int  TStatusBox::iExtentCol;
int  TStatusBox::iIndex;
int  TStatusBox::iModVal;
void (_cdecl _interrupt _far *TStatusBox::pfOldVec)();

TStatusBox::TStatusBox(int r1,int c1,int r2,int c2,char* lbl)
{
  int iEquipFlag;
  _asm{
    int   0x11
    mov   iEquipFlag,ax
    }
  if((iEquipFlag&0x30)==0x30)
    fpcRegenBase=(char _far*)0xB0000000L;
  else
    fpcRegenBase=(char _far*)0xB8000000L;
  iPhase=0;
  iBaseRow=r1;
  iBaseCol=c1;
  iExtentRow=r2;
  iExtentCol=c2;
  iIndex=0;
  iModVal=c2-c1-2;
  iOldCurs=_settextcursor(iTextCursNone);
  tOldCursCoords=_gettextposition();
  pcScrnSaveBfr=getTextImage(r1-1,c1-1,r2-1,c2-1);
  ptStatusWnd=new TTextWindow(r1,c1,r2,c2,snglBrdr);
  if(ptStatusWnd!=NULL){
    ptStatusWnd->setFgBkColors(lBlue,lWhite);
    ptStatusWnd->paint();
    ptStatusWnd->putText(lbl);
    }
  pfOldVec=_dos_getvect(0x21);
  _dos_setvect(0x21,(void 
  (_cdecl _interrupt _far *)())TStatusBox::statusUpdate);
}

TStatusBox::~TStatusBox()
{
  _dos_setvect(0x21,pfOldVec);
  delete ptStatusWnd;
  if(pcScrnSaveBfr!=NULL){
    putTextImage(iBaseRow-1,iBaseCol-1,iExtentRow-1,iExtentCol-1,pcScrnSaveBfr);
    delete pcScrnSaveBfr;
    }
  _settextcursor(iOldCurs);
  _settextposition(tOldCursCoords.row,tOldCursCoords.col);
}

void _cdecl _interrupt _far TStatusBox::statusUpdate(
  unsigned _es, unsigned _ds, unsigned _di, unsigned _si,
  unsigned _bp, unsigned _sp, unsigned _bx, unsigned _dx,
  unsigned _cx, unsigned _ax, unsigned _ip, unsigned _cs,
  unsigned _flags)
{
  int iRqst=_ax&0xFF00;
  if(/*(iRqst==0x3F00)||*/(iRqst==0x4000)){
    *(fpcRegenBase+((iExtentRow-3)*80+iBaseCol+iIndex)*2)=iPhase?' ':'\333';
    iIndex=(iIndex+1)%iModVal;
    if(iIndex==0)
      iPhase=!iPhase;
    }
  _chain_intr(pfOldVec);
}

/////////////////////////////////// Methods ///////////////////////////////////

TDisplayObj* TDisplayObj::ptInputFocus=NULL;
      
TDisplayObj::TDisplayObj(
  int iOriginR=0,
  int iOriginC=0,
  int iExtentR=0,
  int iExtentC=0,
  TDisplayObj* ptParent=(TDisplayObj*)NULL,
  const char*  pcFldName=NULL)
{
  if(pcFldName!=NULL){
    pcName=new char[strlen(pcFldName)+1];
    if(pcName!=NULL)
      strcpy(pcName,pcFldName);
    }
  else
    pcName=NULL;
  bDelayedInitCmplt=_false;
  bSelectable=_false;
  bSelected=_false;
  ptDispObjNext=NULL;
  ptDispObjFirst=NULL;
  pcData=NULL;
  iDataLen=0;
  iDataMax=0;
  this->ptParent=ptParent;
  iOrgR=iOriginR;
  iOrgC=iOriginC;
  if(iExtentC)
    iWidth=iExtentC-iOriginC;
  else
    iWidth=0;
  if(iExtentR)
    iHeight=iExtentR-iOriginR;
  else
    iHeight=0;
  if(ptParent){
    iOrgC+=ptParent->iOrgC;
    iOrgR+=ptParent->iOrgR;
    }
  lBkColor=lBlue;
  lFgColor=lBrtWhite;
}

TDisplayObj::~TDisplayObj()
{
  if(pcData) delete pcData;
}

void TDisplayObj::paint(void)
{
  register TDisplayObj* p=ptDispObjFirst;
  while(p){
    p->paint();
    p=p->ptDispObjNext;
    }
}

long TDisplayObj::message(long m1,long m2)
{
  char c;
  switch(shortFromLong(m1)){
    case cmChrExt:
      switch(shortFromLong(m2)){
        case iClose:
          return 0;
          break;
        case iHelp:
          break;
        default:
          break;
        }
      break;
    case cmChr:
      c=shortFromLong(m2);
      if(c==iTab||c==iEnter){
        ptInputFocus->message(shortToLong(cmKillFocus),NULL);
        ptInputFocus=findNextSelectable(this);
        ptInputFocus->message(shortToLong(cmSetFocus),NULL);
        return m1;
        }
      break;
    default:
      break;
    }
  if(ptParent!=NULL)
    return ptParent->message(m1,m2);
  else
    return m1;
}

TDisplayObj& TDisplayObj::operator+(
  TDisplayObj& tDisplayObj)
{
  if(ptDispObjFirst==NULL){
    ptDispObjFirst=&tDisplayObj;
    ptDispObjLast=&tDisplayObj;
    }
  else{
    ptDispObjLast->ptDispObjNext=&tDisplayObj;
    ptDispObjLast=&tDisplayObj;
    }
  tDisplayObj.iOrgC+=iOrgC;
  tDisplayObj.iOrgR+=iOrgR;
  tDisplayObj.ptParent=this;
  return *this;
}

TDisplayObj* TDisplayObj::findNextSelectable(TDisplayObj* ptObject)
{
  register TDisplayObj* ptLast=ptObject;
  register TDisplayObj* ptCurrent=ptObject;
  while(ptCurrent->ptDispObjNext || ptCurrent->ptParent){
    if(ptCurrent->ptDispObjNext==NULL){
      if(ptCurrent->ptParent->ptDispObjFirst==NULL){
        ptCurrent=ptCurrent->ptParent;
        continue;
        }
      else{
        ptCurrent=ptParent->ptDispObjFirst;
        break;
        }
      }
    ptCurrent=ptCurrent->ptDispObjNext;
    break;
    }
  do{
    if(ptCurrent->bSelectable){
      ptLast=ptCurrent;
      break;
      }
    if(ptCurrent->ptDispObjNext){
      ptCurrent=ptCurrent->ptDispObjNext;
      continue;
      }
    ptCurrent=ptCurrent->ptParent->ptDispObjFirst;
    }while(1);
  return ptLast;
}

// Possible cases:
// 1. A selectable leaf exists.
// 2. A selectable branch exists with no selectable leafs.
// 3. A selectable branch exists with selectable leafs.
// 4. No selectable branch or leaf exists.
TDisplayObj* TDisplayObj::findFirstSelectable(TDisplayObj* ptDOList)
{
  register TDisplayObj* ptCurrent=ptDOList;
  register TDisplayObj* ptLast=NULL;
  while(ptCurrent!=NULL){
    if(ptCurrent->bSelectable){
      ptLast=ptCurrent;
      ptCurrent=ptCurrent->ptDispObjFirst;
      }
    else{
      ptCurrent=ptCurrent->ptDispObjNext;
      }
    }
  return ptLast;
}

void* TDisplayObj::getObjPtrByName(const char* pcFldName)
{
  TDisplayObj* ptObj=ptDispObjFirst;
  while(ptObj!=NULL){
    if(ptObj->pcName!=NULL)
      if(strcmp(pcFldName,ptObj->pcName)==0)
        goto gopbn_exit;
    // Either the object doesn't have a name, or it isn't the one we
    // want. Determine if it owns other objects. If so, scan them.
    if(ptObj->ptDispObjFirst!=NULL){
      void* tmp=ptObj->ptDispObjFirst->getObjPtrByName(pcFldName);
      if(tmp){
        ptObj=(TDisplayObj*)tmp;
        goto gopbn_exit;
        }
      }
    ptObj=ptObj->ptDispObjNext;
    }
gopbn_exit:
  return (void*)ptObj;
}
// Depth first search of each object owned by the curret object. We are
// looking for the object with the name pointed to by pcFldName.
char* TDisplayObj::getDataByName(const char* pcFldName,char* pcBfr,int iMaximum)
{
  strnset(pcBfr,0,iMaximum);
  TDisplayObj* ptObj=(TDisplayObj*)getObjPtrByName(pcFldName);
  if(ptObj){
    // The desired object has been found, copy its data in to the
    // provided buffer.
    int iMax=iMaximum-1;          // Compensate for terminating null.
    iMax=iMax>ptObj->iDataLen?ptObj->iDataLen:iMax;
    strncpy(pcBfr,ptObj->pcData,iMax);
    pcBfr[iMax]='\0';
    }
  return pcBfr;
}

////////////////////////////// Text Label /////////////////////////////////

TTextLbl::TTextLbl(char* pcLabel,int iLblRow,int iLblCol) :
  TDisplayObj(iLblRow,iLblCol)
{
  if(pcLabel!=NULL){
    pcData=new char[iWidth=strlen(pcLabel)+1];
    if(pcData)
      strcpy(pcData,pcLabel);
    }
}

TTextLbl::~TTextLbl()
{
  if(pcData) delete pcData;
}

void TTextLbl::paint(void)
{
  if(pcData){
    if(bDelayedInitCmplt==_false&&ptParent!=NULL){
      bDelayedInitCmplt=_true;
      lBkColor=ptParent->getBkColor();
      lFgColor=ptParent->getFgColor();
      }
    _settextposition(iOrgR,iOrgC);
    _setbkcolor(lBkColor);
    _settextcolor(short(lFgColor));
    _outtext(pcData);
    }
}

/////////////////////  Text Input Field w/ Editing  ///////////////////////

TTextFld::TTextFld(
  const char* pcFldName,
  char*   pcDefText,
  int     iOrgR,
  int     iOrgC,
  int     iExtentR=0,
  int     iExtentC=0)
  : TDisplayObj(iOrgR,iOrgC,iExtentR,iExtentC,NULL,pcFldName)
{
  lFgColor=lBrtWhite;
  lBkColor=lBlack;
  bSelectable=_true;
  int iBfrSz=iExtentC-iOrgC;
  if(iBfrSz>iDefTextFldLen)
    iBfrSz=iDefTextFldLen;
  pcData=new char[iBfrSz+1];
  if(pcData){
    memset(pcData,' ',iBfrSz);
    pcData[iBfrSz]='\0';
    iDataMax=iBfrSz;
    if(pcDefText){
      iDataLen=strlen(pcDefText);
      iDataLen=iDataLen>iDataMax?iDataMax:iDataLen;
      strncpy(pcData,pcDefText,iDataLen);
      pcData[iDataLen]='\0';
      }
     else{
      iDataLen=0;
      }
    }
  iCursPos=iDataLen==iDataMax?iDataMax-1:iDataLen;
}

TTextFld::~TTextFld()
{
  if(pcData) delete pcData;
}

void TTextFld::delOneChar(void)
{
  memmove(pcData+iCursPos,pcData+iCursPos+1,iDataMax-iCursPos-1);
  pcData[iDataMax-1]=' ';
  if(iCursPos<iDataLen&&iDataLen>0)
    iDataLen-=1;
}

void TTextFld::paint(void)
{
  _setbkcolor(lBkColor);
  _settextcolor(short(lFgColor));
  if(pcData){
    _settextposition(iOrgR,iOrgC);
    _outmem(pcData,iDataMax);
    _settextposition(iOrgR,iOrgC+iCursPos);
    }
}

long TTextFld::message(long m1,long m2)
{
  char  c;
  switch(shortFromLong(m1)){
    case cmChr:{
      c=charFromLong(m2);
      if(c==iBackSpace){
        if(iCursPos>0){
          iCursPos--;
          delOneChar();
          paint();
          }
        }
      else if(c==iTab||c==iEnter){
        TDisplayObj::message(m1,m2);
        }
      else{
        pcData[iCursPos++]=c;
        if(iCursPos==iDataMax)
          iCursPos--;
        paint();
        if(iCursPos-1>=iDataLen)
          iDataLen=iCursPos;
        }
      return m1;
      break;
      }
    case cmChrExt:
      c=charFromLong(m2);
      switch(c){
        case iRight:
          if(++iCursPos==iDataMax) iCursPos--;
          else paint();
          return m1;
          break;
        case iLeft:
          if(iCursPos>0){
            iCursPos--;
            paint();
            }
          return m1;
          break;
        case iDel:
          delOneChar();
          paint();
          return m1;
          break;
        }
      break;
     case cmSetFocus:
      _settextcursor(iTextCursNormal);
      _settextposition(iOrgR,iOrgC+iCursPos);
      return m1;
      break;
    case cmKillFocus:
      _settextcursor(iTextCursNone);
      return m1;
      break;
    }
  return TDisplayObj::message(m1,m2);
}

void TTextFld::setText(char* pcText)
{
  if(iDataMax){
    int i=strlen(pcText);
    i=iDataMax<i?iDataMax:i;
    strncpy(pcData,pcText,i);
    memset(pcData+i,' ',iDataMax-i);
    iDataLen=i;
    }
}

/////////////////////////////// List Item /////////////////////////////////

TListItem::TListItem(char* pcItemLbl,int iRow,int iCol)
  : TTextLbl(pcItemLbl,iRow,iCol)
{
  bSelectable=_true;
  lBkColor=ptParent->getFgColor();
  lFgColor=ptParent->getBkColor();
}

void TListItem::paint(void)
{
  if(pcData){
    char* p=new char[ptParent->getWidth()];
    if(p!=NULL){
      memset(p,' ',ptParent->getWidth());
      long lBackground=bSelected?lBkColor:ptParent->getBkColor();
      long lForeground=bSelected?lFgColor:ptParent->getFgColor();
      _setbkcolor(lBackground);
      _settextcolor(short(lForeground));
      _settextposition(iOrgR,iOrgC);
      _outtext(p);
      delete p;
      _settextposition(iOrgR,iOrgC);
      _outtext(pcData);
      }
    }
}

////////////////////////////// Combo Box //////////////////////////////////

TComboBox::TComboBox(
  const char* pcFldName,
  int         iRow,
  int         iCol,
  int         iExtentR,
  int         iExtentC,
  TLBEnt*     ptList)
  : TTextFld(pcFldName,NULL,iRow,iCol,iRow+1,iExtentC)
{
  if(ptList!=NULL)
    setText(ptList[0].pcItemName);
  ptListBox=new TListBox(iRow+1,iCol,iExtentR,iExtentC,ptList);
  ptListBox->setParent(this);
}

TComboBox::~TComboBox()
{
  delete ptListBox;
}

void TComboBox::paint(void)
{
  TTextFld::paint();
  _setbkcolor(lFgColor);
  _settextcolor(short(lBkColor));
  _settextposition(iOrgR,iOrgC+iWidth);
  _outtext("\037");
} 

long TComboBox::message(long m1,long m2)
{
  long lTmp;
  switch(shortFromLong(m1)){
    case cmChrExt:
      if(shortFromLong(m2)==iAltDown){
        ptInputFocus=ptListBox;
        ptListBox->paint();
        return m1;
        }
      break;
    case cmKillFocus:
    case cmSetFocus:
      lTmp=lFgColor;
      lFgColor=lBkColor;
      lBkColor=lTmp;
      paint();
      break;
    default:
      break;
    }
  return TDisplayObj::message(m1,m2);
}

///////////////////////////// Text Window /////////////////////////////////

TTextWindow::TTextWindow(
  int   iUR,
  int   iUC,
  int   iLR,
  int   iLC,
  TBrdr tBrdr,
  char* pcTitle) :
    TDisplayObj(iUR,iUC,iLR,iLC)
{
  bSelectable=_true;
  lBkColor=lBlue;
  lFgColor=lBrtWhite;
  iCurrRow=0;
  iCurrCol=0;
  if(tBrdr!=noBrdr){
    this->tBrdr=tBrdr;
    iWidth-=iWndBrdrComp;
    iHeight-=iWndBrdrComp;
    iOrgR+=1;
    iOrgC+=1;
    }
  if(pcTitle){
    this->pcTitle=new char[strlen(pcTitle)+1];
    if(this->pcTitle) strcpy(this->pcTitle,pcTitle);
    }
  else
    this->pcTitle=NULL;
  switch(tBrdr){
    case snglBrdr:
      cULC='\332';
      cURC='\277';
      cLLC='\300';
      cLRC='\331';
      cLeft='\263';
      cRight='\263';
      cTop='\304';
      cBottom='\304';
      break;
    case dblBrdr:              
      cULC='\311';
      cURC='\273';
      cLLC='\310';
      cLRC='\274';
      cLeft='\272';
      cRight='\272';
      cTop='\315';
      cBottom='\315';
      break;
    case thickBrdr:
      cULC='\333';
      cURC='\333';
      cLLC='\337';
      cLRC='\337';
      cLeft='\335';
      cRight='\336';
      cTop='\333';
      cBottom='\337';
      break;
    case noBrdr:
    default:
      break;
    }
}

void TTextWindow::paint(void)
{
  char* cBfr=new char[iWidth+iWndBrdrComp+1];
  register int i;
  register int l;
  _setbkcolor(lBkColor);
  _settextcolor(short(lFgColor));
  if(cBfr){
    if(tBrdr){
      int iOrgR=this->iOrgR-1;
      int iOrgC=this->iOrgC-1;
      strnset(cBfr,0,iWidth+iWndBrdrComp+1);
      cBfr[0]=cULC;
      cBfr[iWidth+iWndBrdrComp-1]=cURC;
      for(i=1,l=iWidth;l;i++,l--) cBfr[i]=cTop;
      char* p=pcTitle;
      if(p) for(i=(iWidth-(l=strlen(pcTitle)))/2+1;l;i++,l--) cBfr[i]=*p++;
      struct _rccoord coords=_settextposition(iOrgR,iOrgC);
      cBfr[iWidth+iWndBrdrComp]='\0';
      _outtext(cBfr);
      cBfr[0]=cLLC;
      cBfr[iWidth+iWndBrdrComp-1]=cLRC;
      for(i=1,l=iWidth;l;i++,l--) cBfr[i]=cBottom;
      _settextposition(iOrgR+iHeight+1,iOrgC);
      _outtext(cBfr);
      cBfr[0]=cLeft;
      cBfr[iWidth+iWndBrdrComp-1]=cRight;
      for(i=1,l=iWidth;l;i++,l--) cBfr[i]=' ';
      for(i=1,l=iHeight;l;i++,l--){
        _settextposition(iOrgR+i,iOrgC);
        _outtext(cBfr);
        }
      _settextposition(coords.row,coords.col);
      }
    else{
      cBfr[iWidth]='\0';
      for(i=0,l=iWidth;l;i++,l--) cBfr[i]=' ';
      for(i=0,l=iHeight;l;i++,l--){
        _settextposition(iOrgR+i,iOrgC);
        _outtext(cBfr);
        }
      }
    delete cBfr;
    TDisplayObj::paint();
    }
}

long TTextWindow::message(long m1,long m2)
{
  switch(shortFromLong(m1)){
    case cmSetFocus:
      break;
    case cmKillFocus:
      break;
    }
  return TDisplayObj::message(m1,m2);
}

void TTextWindow::putText(char* s)
{
  _setbkcolor(lBkColor);
  _settextcolor(short(lFgColor));
  char* p0=s;
  do{
    char* p1;
    int   i,j;
    // Possible Cases:
    //  1.  strlen(s) < iWidth, no '\n' chars.
    //  2.  strlen(s) < iWidth, one or more '\n' chars.
    //  3.  strlen(s) >=iWidth, no '\n' chars.
    //  4.  strlen(s) >=iWidth, one or more '\n' chars.
    _settextposition(iCurrRow+iOrgR,iCurrCol+iOrgC);
    p1=strchr(p0,'\n');
    i=p1==NULL?strlen(p0):p1-p0;
    j=i+iCurrCol>iWidth?p1=NULL,iWidth-iCurrCol:i;
    i-=j;
    _outmem(p0,j);
    if(p1!=NULL||i!=0){
      iCurrRow+=1;
      iCurrCol=0;
      }
    else
      iCurrCol+=j;
    p0+=(j+(p1==NULL?0:1));
    }while(*p0);
}

///////////////////////////////// List Box ////////////////////////////////

TListBox::TListBox(
  int       iRow,
  int       iCol,
  int       iExtentR,
  int       iExtentC,
  TLBEnt*   ptItems)
  : TTextWindow(iRow,iCol,iExtentR,iExtentC,snglBrdr)
{
  iSelected=0;
  register int j;
  for(j=0;ptItems[j].pcItemName!=NULL;j++)
    ;
  TLBEnt* p=new TLBEnt[j];
  if(p!=NULL){
    memset(p,0,j*sizeof(TLBEnt));
    // update the object member.
    ptItemList=p;
    int i;
    for(i=0;i<j;i++){
      p[i].pcItemName=new char[strlen(ptItems[i].pcItemName)+1];
      if(p[i].pcItemName){
        strcpy(p[i].pcItemName,ptItems[i].pcItemName);
        p[i].lItemData=ptItems[i].lItemData;
        continue;
        }
      break;
      }
    iItemListLen=i;
    }  
}

TListBox::~TListBox()
{
  register int    i;
  register TLBEnt* p=ptItemList;
  if(p!=NULL){
    for(i=0;p[i].pcItemName!=NULL;i++)
      delete p[i].pcItemName;
    delete p;
    }
}

long TListBox::message(long m1,long m2)
{
  int i=0;                              // This initialization is important.
  switch(shortFromLong(m1)){
    case cmChrExt:
      switch(shortFromLong(m2)){
        case iUp:
          i=-2;                         // Fall through.
        case iDown:
          i++;                          // 1 if down, -1 if up.
          select(iSelected,_false);
          iSelected=(iSelected+i+iItemListLen)%iItemListLen;
          select(iSelected,_true);
          return m1;
          break;
        default:
          break;
        }
      break;
    case cmChr:
      switch(shortFromLong(m2)){
        case iEnter:
          ((TComboBox*)ptParent)->setText(ptItemList[iSelected].pcItemName);
          // Fall through.
        case iTab:
        case iEsc:
          ptInputFocus=ptParent;
          TDisplayObj* ptCurr;
          TDisplayObj* ptLast;
          ptCurr=ptParent;
          while(ptCurr!=NULL){
            ptLast=ptCurr;
            ptCurr=ptCurr->getPtParent();
            }
          ptLast->paint();               // Paint starting at the root.
          if(shortFromLong(m2)==iTab)
            break;
          return m1;
          break;
        default:
          break;
        }
    }
  return TTextWindow::message(m1,m2);
}

void TListBox::select(int iItem,int iHighlight)
{
  _setbkcolor(iHighlight?ptParent->getBkColor():lBkColor);
  _settextcolor(short(iHighlight?ptParent->getFgColor():lFgColor));
  char* p=new char[iWidth];
  if(p!=NULL){
    _settextposition(iItem+iOrgR,iOrgC);
    memset(p,' ',iWidth);
    _outmem(p,iWidth);
    delete p;
    }
  _settextposition(iItem+iOrgR,iOrgC);
  _outtext(ptItemList[iItem].pcItemName);
}

void TListBox::paint(void)
{
  register int i;
  if(bDelayedInitCmplt==_false&&ptParent->getPtParent()!=NULL){
    bDelayedInitCmplt=_true;
    iOrgR+=ptParent->getPtParent()->getOrgR();
    iOrgC+=ptParent->getPtParent()->getOrgC();
    }
  TTextWindow::paint();
  for(i=0;i<iItemListLen;i++)
    select(i,i==iSelected);
}

////////////////////// Display Subsystem Manager //////////////////////////

TApplication::TApplication() :
  TDisplayObj(0,0,80,25)
{
  bSelectable=_true;
  lBkColor=lCyan;
  lFgColor=lBlack;
  _setvideomode(_TEXTC80);
  _setvieworg(0,0);
  iOldCurs=_settextcursor(iTextCursNone);
  paint();
}

TApplication::~TApplication()
{
  _setbkcolor(lBlack);
  _settextcolor(short(lWhite));
  _clearscreen(_GCLEARSCREEN);
  _settextcursor(iOldCurs);
}

void TApplication::messageLoop(void)
{
  paint();
  ptInputFocus=findFirstSelectable(ptDispObjFirst);
  ptInputFocus->message(cmSetFocus,0);
  if(ptInputFocus==NULL)
    ptInputFocus=this;
  long m1;
  long m2;
  while(1){
    if(kbhit()){
      m2=_getch();
      if(!m2){
        m1=cmChrExt;
        m2=_getch();
        }
      else
        m1=cmChr;
      if(!ptInputFocus->message(m1,m2))
        break;
      }
    }
}

void TApplication::paint(void)
{
  _setbkcolor(lBkColor);
  _settextcolor(short(lFgColor));
  _clearscreen(_GCLEARSCREEN);
  TDisplayObj::paint();
}

///////////////////// Application Specific Code ////////////////////////////

#define TIMEBFRLEN 25

char* getTime(void)
{
  time_t t=time(NULL);
  char* p=ctime(&t);
  p[strlen(p)-1]='\0';
  memcpy(p,p+4,TIMEBFRLEN);
  return p;
}

TErrCode fileCopy(char* pcDstPath,char* pcSrcPath)
{
    char*       pcInputBfr=NULL;
    FILE*       tFHIn=NULL;
    FILE*       tFHOut=NULL;
    TErrCode    tRetCode=errOk;
    unsigned    usWritten;
    unsigned    usRead;
    unsigned    i;
    char        tmpBfr[DOSPATHBFRLEN];

    // Open the source file.
    tFHIn=fopen(pcSrcPath,"rb");
    if(tFHIn==NULL)
        return errSrcOpenFail;
    // Verify the existence of the target directory.
    strncpy(tmpBfr,pcDstPath,i=my_strrchr(pcDstPath,'\\')-pcDstPath);
    tmpBfr[i]='\0';
    // If the target directory is the root, tmpBfr will be empty -- skip the
    // existence test. If the target does not exist, then return an error.
    if((strlen(tmpBfr)!=0)&&!file_exists(tmpBfr)){
        tRetCode=errNoDir;
        goto fc_ErrExit;
        }
    // Create the output file.
    tFHOut=fopen(pcDstPath,"w+b");
    if(tFHOut==NULL){
        tRetCode=errDstOpenFail;
        goto fc_ErrExit;
        }
    else{
        fseek(tFHIn,0L,SEEK_SET);
        // Allocate a buffer into which the MIF file can be read.
        if((pcInputBfr=new char[SCANBFRLEN])==NULL){
            tRetCode=errNoBfr;
            goto fc_ErrExit;
            }
        else{
            while(!feof(tFHIn)){
                // Read a portion of the file into memory.
                usRead=fread(pcInputBfr,1,SCANBFRLEN-1,tFHIn);
                if(usRead==0&&ferror(tFHIn)){
                    tRetCode=errFRead;
                    goto fc_ErrExit;
                    }
                if(usRead!=0){
                    // Write it to the destination.
                    usWritten=fwrite(pcInputBfr,1,usRead,tFHOut);
                    if(usWritten!=usRead){
                        tRetCode=errFWrite;
                        goto fc_ErrExit;
                        }
                    } 
                }
            }
        }
fc_ErrExit:
    if(pcInputBfr!=NULL)
        delete pcInputBfr;
    if(tFHOut!=NULL)
        fclose(tFHOut);
    if(tFHIn!=NULL)
        fclose(tFHIn);
    unsigned usDate;
    unsigned usTime;
    int      iFHIn;
    int      iFHOut;
    _dos_open(pcSrcPath,_O_RDONLY,&iFHIn);
    _dos_open(pcDstPath,_O_RDONLY,&iFHOut);
    _dos_getftime(iFHIn,&usDate,&usTime);
    _dos_setftime(iFHOut,usDate,usTime);
    _dos_close(iFHIn);
    _dos_close(iFHOut);
    return tRetCode;
}

extern "C" TErrCode _cdecl doFileCopy(char* pcDstPath,char* pcSrcPath)
{
  char      acMsgBfr[CHRBFRLEN];
  TErrCode  tErrCode;
  strupr(pcDstPath);
  strupr(pcSrcPath);
  do{
    switch(tErrCode=fileCopy(pcDstPath,pcSrcPath)){
      case errOk:
        break;
      case errDstOpenFail:
        sprintf(acMsgBfr,"Unable to create file %s.",pcDstPath);
        messageBox(acMsgBfr,ERR_PRESS_KEY);
        break;
      case errNoDir:
        if(makePath(pcDstPath)==errAccess){
          sprintf(acMsgBfr,
            "\nA file already exists with the same "
            "name"
            "\nas one of the components in:"
            "\n%s.",
            pcDstPath);
          messageBox(acMsgBfr,ERR_PRESS_KEY);
          break;
          }
        continue;
      case errSrcOpenFail:
        sprintf(acMsgBfr,"\nUnable to open the source file:\n\n%s.",
          pcSrcPath);
        messageBox(acMsgBfr,ERR_PRESS_KEY);
        break;
      case errNoBfr:
        messageBox("\nUnable to allocate memory for file copy.",ERR_PRESS_KEY);
        break;
      case errFRead:
        sprintf(acMsgBfr,"\nUnable to read the source file:\n\n%s.",
          pcSrcPath);
        messageBox(acMsgBfr,ERR_PRESS_KEY);
        break;
      case errFWrite:
        sprintf(acMsgBfr,"\nUnable to write the destination file:\n\n%s.",
          pcDstPath);
        messageBox(acMsgBfr,ERR_PRESS_KEY);
        break;
      default:
        messageBox("\nUnexpected error while copying files.",ERR_PRESS_KEY);
        break;
      }
    break;
    }while(1);
  return tErrCode;
}

const char* pcFldNameSerial="SERIAL";
const char* pcFldNameInstDate="INSTDATE";
const char* pcFldNameConnType="CONNTYPE";
const char* pcFldNameTargetDvr="TARGETDVR";

class TTextWndApp : public TTextWindow
{
 public:
  TTextWndApp(int,int,int,int,TBrdr,char*);
  long message(long,long);
 protected:
  TDosInstl*  ptDosInstl;
};

TTextWndApp::TTextWndApp(
  int   iRow,
  int   iCol,
  int   iExtentR,
  int   iExtentC,
  TBrdr tBrdr,
  char* pcLbl)
  : TTextWindow(iRow,iCol,iExtentR,iExtentC,tBrdr,pcLbl)
{
}

long TTextWndApp::message(long m1,long m2)
{
  int       iLevelCompleted=-1;
  char      acSrcPath[DOSPATHBFRLEN];
  char      acBfr[iDefTextFldLen];
  char*     pcDstPath;
  char*     pcTmp;
  if(shortFromLong(m1)==cmChrExt&&shortFromLong(m2)==iF10){
    ptDosInstl=new TDosInstl;
    if(ptDosInstl!=NULL){
      struct tm tTime;
      getDataByName(pcFldNameInstDate,acBfr,iDefTextFldLen);
      tTime.tm_mon=getMonth(strtok(acBfr," "));
      if(tTime.tm_mon==NOMONTH){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      pcTmp=strtok(NULL," ");
      if(pcTmp==NULL){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      tTime.tm_mday=atoi(pcTmp);
      if(tTime.tm_mday>31||tTime.tm_mday<1){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      pcTmp=strtok(NULL,":");
      if(pcTmp==NULL){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      tTime.tm_hour=atoi(pcTmp);
      if(tTime.tm_hour<0||tTime.tm_hour>23){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      pcTmp=strtok(NULL,":");
      if(pcTmp==NULL){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      tTime.tm_min=atoi(pcTmp);
      if(tTime.tm_min<0||tTime.tm_min>59){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      pcTmp=strtok(NULL," ");
      if(pcTmp==NULL){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      tTime.tm_sec=atoi(pcTmp);
      if(tTime.tm_sec<0||tTime.tm_sec>59){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      pcTmp=strtok(NULL," ");
      if(pcTmp==NULL){
        messageBox(ERR_DATE_MSG,ERR_PRESS_KEY);
        return m1;
        }
      tTime.tm_year=atoi(pcTmp);
      struct _timeb tb;
      _ftime(&tb);
      sprintf(acBfr,"%04d%02d%02d%02d%02d%02d.%06d%+03d",
        tTime.tm_year,tTime.tm_mon+1,tTime.tm_mday,tTime.tm_hour,
        tTime.tm_min,tTime.tm_sec,0,tb.timezone,0
        );
      ptDosInstl->setNextAtrVal(INSTDATE,acBfr,t_str);
      TStatusBox* tSB=new TStatusBox(15,20,19,60,
        "  Installing -- one moment please...");
      ptDosInstl->setNextAtrVal(SERIALNO,getDataByName(pcFldNameSerial,acBfr,iDefTextFldLen),t_str);
      getDataByName(pcFldNameConnType,acBfr,iDefTextFldLen);
      if(strcmp(acBfr,CT_AUI)==0)
        ptDosInstl->setNextAtrVal(CONNTYPE,"0x02",t_hexint);
      else if(strcmp(acBfr,CT_RJ45)==0)
        ptDosInstl->setNextAtrVal(CONNTYPE,"0x03",t_hexint);
      else
        ptDosInstl->setNextAtrVal(CONNTYPE,"0x06",t_hexint);
      TComboBox* tmp=(TComboBox*)getObjPtrByName(pcFldNameTargetDvr);
      ptDosInstl->setSelectedDriver(
        tmp->getSelectedItem()->lItemData
        );
      pcDstPath=DMI_DOS_ROOT BIN_DIR DOS_INSTR;
      _getcwd(acSrcPath,DOSPATHBFRLEN);
      int iTmp;
      if(acSrcPath[iTmp=(strlen(acSrcPath)-1)]!='\\')
        strcat(acSrcPath,"\\");
      strcat(acSrcPath,DOS_INSTR);
      if(doFileCopy(pcDstPath,acSrcPath)==errOk){
        pcDstPath=DMI_WIN_ROOT BIN_DIR WIN_INSTR;
        _getcwd(acSrcPath,DOSPATHBFRLEN);
        if(acSrcPath[iTmp=(strlen(acSrcPath)-1)]!='\\')
          strcat(acSrcPath,"\\");
        strcat(acSrcPath,WIN_INSTR);
        if(doFileCopy(pcDstPath,acSrcPath)==errOk){
          pcDstPath=DMI_OS2_ROOT BIN_DIR OS2_INSTR;
          _getcwd(acSrcPath,DOSPATHBFRLEN);
          if(acSrcPath[iTmp=(strlen(acSrcPath)-1)]!='\\')
            strcat(acSrcPath,"\\");
          strcat(acSrcPath,OS2_INSTR);
          if(doFileCopy(pcDstPath,acSrcPath)==errOk){
            ptDosInstl->DoInstall();
            m1=0;
            }
          }
        }
      delete tSB;
      return m1;
      }
    else
      messageBox(
        "\nUnable to allocate memory for DMI"
        "\ninstallation object."
        );
    }
  return TTextWindow::message(m1,m2);
}

int main(void)
{
  TApplication  a;
  TLBEnt* ptConnectorList=new TLBEnt[4];
  if(ptConnectorList!=NULL){
    ptConnectorList[0].pcItemName=CT_AUI;
    ptConnectorList[0].lItemData=0;
    ptConnectorList[1].pcItemName=CT_BNC;
    ptConnectorList[1].lItemData=0;
    ptConnectorList[2].pcItemName=CT_RJ45;
    ptConnectorList[2].lItemData=0;
    ptConnectorList[3].pcItemName=NULL;
    ptConnectorList[3].lItemData=0;
    }
  TLBEnt* ptTargetDvrList=new TLBEnt[4];
  if(ptTargetDvrList!=NULL){
    ptTargetDvrList[0].pcItemName=WIN_ND3;
    ptTargetDvrList[0].lItemData=wfwDvr;
    ptTargetDvrList[1].pcItemName=DOS_OTHER;
    ptTargetDvrList[1].lItemData=dosDvr;
    ptTargetDvrList[2].pcItemName=OS2_OTHER;
    ptTargetDvrList[2].lItemData=os2Dvr;
    ptTargetDvrList[3].pcItemName=NULL;
    ptTargetDvrList[3].lItemData=0;
    }
  ((((
    a
    +*(new TTextWndApp(3,15,19,65,dblBrdr,"DMI Installation Utility " MAJVER MINVER)))
    +*(new TTextLbl("<F10> to proceed with installation, <Enter> to accept field,",22,10)))
    +*(new TTextLbl("<Alt-F4> to Cancel, <Tab> to move between fields,",23,16)))
    +*(new TTextLbl("<Alt-\031> to pull down list, <Esc> to hide list.",24,18)));
  ((((((((((
    *a.getDispObjFirst()
    +*(new TTextLbl("Serial Number:",1,5)))
    +*(new TTextFld(pcFldNameSerial,NULL,1,19,2,47)))
    +*(new TTextLbl("Installation Date:",3,1)))
    +*(new TTextFld(pcFldNameInstDate,getTime(),3,19,4,47)))
    +*(new TTextLbl("Connector Type:",5,4)))
    +*(new TComboBox(pcFldNameConnType,5,19,11,46,ptConnectorList)))
    +*(new TTextLbl("Target Driver:",7,5)))
    +*(new TComboBox(pcFldNameTargetDvr,7,19,13,46,ptTargetDvrList)))
    +*(new TTextLbl("Copyright(c) 1996 by Advanced Micro Devices",10,3)))
    +*(new TTextLbl("All rights reserved",11,15)));
  delete ptConnectorList;
  delete ptTargetDvrList;
  a.messageLoop();
  return 0;
}
