/* 2004.03.05, 2004.8.18, 2005.12.29
****************************************
**  Copyright  (C)  W.ch  1999-2005   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB 1.1 Host Examples for CH375   **
**  KC7.0@MCS-51                      **
****************************************
*/
/* ƬͨCH375USBӡ */
/* ʾ,C,CH375жΪѯʽ,ֻݴ,漰ӡʽӡ */
/* ṩ̨һ̨USBӡķ */

/* ¶MCS-51Ƭ,Ƭ޸,ΪṩCԵٶҪԱŻ */
#include <reg51.h>
unsigned char volatile xdata	CH375_CMD_PORT _at_ 0xBDF1;	/* CH375˿ڵI/Oַ */
unsigned char volatile xdata	CH375_DAT_PORT _at_ 0xBCF0;	/* CH375ݶ˿ڵI/Oַ */
sbit	CH375_INT_WIRE	=		0xB0^2;	/* P3.2, INT0, CH375INT#,ڲѯж״̬ */
typedef	unsigned char BOOL1;  /* typedef	bit	BOOL1; */

/* ΪͨõĵƬC */
#include <string.h>
#include <stdio.h>

/* CH375뼰״̬ */
#include "CH375INC.H"

typedef unsigned char	UCHAR;
typedef unsigned short	USHORT;

typedef struct _USB_DEVICE_DESCRIPTOR {
    UCHAR bLength;
    UCHAR bDescriptorType;
    USHORT bcdUSB;
    UCHAR bDeviceClass;
    UCHAR bDeviceSubClass;
    UCHAR bDeviceProtocol;
    UCHAR bMaxPacketSize0;
    USHORT idVendor;
    USHORT idProduct;
    USHORT bcdDevice;
    UCHAR iManufacturer;
    UCHAR iProduct;
    UCHAR iSerialNumber;
    UCHAR bNumConfigurations;
} USB_DEV_DESCR, *PUSB_DEV_DESCR;

typedef struct _USB_CONFIG_DESCRIPTOR {
    UCHAR bLength;
    UCHAR bDescriptorType;
    USHORT wTotalLength;
    UCHAR bNumInterfaces;
    UCHAR bConfigurationValue;
    UCHAR iConfiguration;
    UCHAR bmAttributes;
    UCHAR MaxPower;
} USB_CFG_DESCR, *PUSB_CFG_DESCR;

typedef struct _USB_INTERF_DESCRIPTOR {
    UCHAR bLength;
    UCHAR bDescriptorType;
    UCHAR bInterfaceNumber;
    UCHAR bAlternateSetting;
    UCHAR bNumEndpoints;
    UCHAR bInterfaceClass;
    UCHAR bInterfaceSubClass;
    UCHAR bInterfaceProtocol;
    UCHAR iInterface;
} USB_ITF_DESCR, *PUSB_ITF_DESCR;

typedef struct _USB_ENDPOINT_DESCRIPTOR {
    UCHAR bLength;
    UCHAR bDescriptorType;
    UCHAR bEndpointAddress;
    UCHAR bmAttributes;
    UCHAR wMaxPacketSize;
    UCHAR wMaxPacketSize1;
    UCHAR bInterval;
} USB_ENDP_DESCR, *PUSB_ENDP_DESCR;

typedef struct _USB_CONFIG_DESCRIPTOR_LONG {
	USB_CFG_DESCR	cfg_descr;
	USB_ITF_DESCR	itf_descr;
	USB_ENDP_DESCR	endp_descr[4];
} USB_CFG_DESCR_LONG, *PUSB_CFG_DESCR_LONG;

unsigned char buffer[64];		/* û */

/* ʱ2΢,ȷ */
void	delay2us( )
{
	unsigned char i;
	for ( i = 2; i != 0; i -- );
}

/* ʱ1΢,ȷ */
void	delay1us( )
{
	unsigned char i;
	for ( i = 1; i != 0; i -- );
}

/* ԺΪλʱ,ȷ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/*  */

void CH375_WR_CMD_PORT( unsigned char cmd ) {  /* CH375˿д,ڲС4uS,ƬϿʱ */
	delay2us();
	CH375_CMD_PORT=cmd;
	delay2us();
}

void CH375_WR_DAT_PORT( unsigned char dat ) {  /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	delay1us();  /* ΪMCS51Ƭʵʱ */
}

unsigned char CH375_RD_DAT_PORT() {  /* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	delay1us();  /* ΪMCS51Ƭʵʱ */
	return( CH375_DAT_PORT );
}

unsigned char wait_interrupt() {  /* ˵ȴ, ز״̬ */
	unsigned short i;
//	while( CH375_INT_WIRE );  /* ѯȴCH375ж(INT#͵ƽ) */
	for ( i = 0; CH375_INT_WIRE != 0; i ++ ) {  /* CH375жߵƽȴ,ֹͨʱ */
		delay1us();
		if ( i == 0xF000 ) CH375_WR_CMD_PORT( CMD_ABORT_NAK );  /* ʱ61mSǿֹNAK,жϷUSB_INT_RET_NAK */
	}

	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ж, ȡж״̬ */
	return( CH375_RD_DAT_PORT() );
}

#define	TRUE	1
#define	FALSE	0
unsigned char set_usb_mode( unsigned char mode ) {  /* CH375Ĺģʽ */
	unsigned char i;
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );
	CH375_WR_DAT_PORT( mode );
	for( i=0; i!=100; i++ ) {  /* ȴģʽ,30uS */
		if ( CH375_RD_DAT_PORT()==CMD_RET_SUCCESS ) return( TRUE );  /* ɹ */
	}
	return( FALSE );  /* CH375,оƬͺŴߴڴڷʽ߲֧ */
}

/* ͬ */
/* USBͬͨлDATA0DATA1ʵ: 豸, USBӡԶл;
   , SET_ENDP6SET_ENDP7CH375лDATA0DATA1.
   ˵ĳΪ豸˵ĸ˵ֱṩһȫֱ,
   ʼֵΪDATA0, ÿִһγɹȡ, ÿִһʧ临λΪDATA1 */

void toggle_recv( BOOL1 tog ) {  /* ͬ:0=DATA0,1=DATA1 */
	CH375_WR_CMD_PORT( CMD_SET_ENDP6 );
	CH375_WR_DAT_PORT( tog ? 0xC0 : 0x80 );
	delay2us();
}

void toggle_send( BOOL1 tog ) {  /* ͬ:0=DATA0,1=DATA1 */
	CH375_WR_CMD_PORT( CMD_SET_ENDP7 );
	CH375_WR_DAT_PORT( tog ? 0xC0 : 0x80 );
	delay2us();
}

unsigned char clr_stall( unsigned char endp_addr ) {  /* USBͨѶʧܺ,λ豸˵ָ˵㵽DATA0 */
	CH375_WR_CMD_PORT( CMD_CLR_STALL );
	CH375_WR_DAT_PORT( endp_addr );
	return( wait_interrupt() );
}

/* ݶд, ƬдCH375оƬеݻ */

unsigned char rd_usb_data( unsigned char *buf ) {  /* CH37Xݿ */
	unsigned char i, len;
	CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* CH375Ķ˵㻺ȡյ */
	len=CH375_RD_DAT_PORT();  /* ݳ */
	for ( i=0; i!=len; i++ ) *buf++=CH375_RD_DAT_PORT();
	return( len );
}

void wr_usb_data( unsigned char len, unsigned char *buf ) {  /* CH37Xдݿ */
	CH375_WR_CMD_PORT( CMD_WR_USB_DATA7 );  /* CH375Ķ˵㻺д׼͵ */
	CH375_WR_DAT_PORT( len );  /* ݳ, lenܴ64 */
	while( len-- ) CH375_WR_DAT_PORT( *buf++ );
}

/*  */
unsigned char endp_out_addr;	/* ӡݽն˵Ķ˵ַ */
unsigned char endp_out_size;	/* ӡݽն˵Ķ˵ߴ */
BOOL1	tog_send;				/* ӡݽն˵ͬ־ */
unsigned char endp_in_addr;		/* ˫ӡͶ˵Ķ˵ַ,һ㲻 */
BOOL1	tog_recv;				/* ˫ӡͶ˵ͬ־,һ㲻 */

unsigned char issue_token( unsigned char endp_and_pid ) {  /* ִUSB */
/* ִɺ, ж֪ͨƬ, USB_INT_SUCCESS˵ɹ */
	CH375_WR_CMD_PORT( CMD_ISSUE_TOKEN );
	CH375_WR_DAT_PORT( endp_and_pid );  /* 4λĿĶ˵, 4λPID */
	return( wait_interrupt() );  /* ȴCH375 */
}

unsigned char issue_token_X( unsigned char endp_and_pid, unsigned char tog ) {  /* ִUSB,CH375A */
/* ִɺ, ж֪ͨƬ, USB_INT_SUCCESS˵ɹ */
	CH375_WR_CMD_PORT( CMD_ISSUE_TKN_X );
	CH375_WR_DAT_PORT( tog );  /* ͬ־λ7Ϊ˵INͬλ, λ6Ϊ˵OUTͬλ, λ5~λ0Ϊ0 */
	CH375_WR_DAT_PORT( endp_and_pid );  /* 4λĿĶ˵, 4λPID */
	return( wait_interrupt() );  /* ȴCH375 */
}

void soft_reset_print( ) {  /* ƴ:λӡ */
	tog_send=tog_recv=0;  /* λUSBͬ־ */
	toggle_send( 0 );  /* SETUP׶ΪDATA0 */
	buffer[0]=0x21; buffer[1]=2; buffer[2]=buffer[3]=buffer[4]=buffer[5]=buffer[6]=buffer[7]=0;  /* SETUP,SOFT_RESET */
	wr_usb_data( 8, buffer );  /* SETUP8ֽ */
	if ( issue_token( ( 0 << 4 ) | DEF_USB_PID_SETUP )==USB_INT_SUCCESS ) {  /* SETUP׶βɹ */
		toggle_recv( 1 );  /* STATUS׶,׼DATA1 */
		if ( issue_token( ( 0 << 4 ) | DEF_USB_PID_IN )==USB_INT_SUCCESS ) return;  /* STATUS׶βɹ,ɹ */
	}
}

#define	USB_INT_RET_NAK		0x2A		/* 00101010B,NAK */
void send_data( unsigned short len, unsigned char *buf ) {  /* ݿ,һ64KB */
	unsigned char l, s;
	while( len ) {  /* ݿUSBӡ */
		toggle_send( tog_send );  /* ͬ */
		l = len>endp_out_size?endp_out_size:len;  /* ηͲܳ˵ߴ */
		wr_usb_data( l, buf );  /* ȸƵCH375оƬ */
		s = issue_token( ( endp_out_addr << 4 ) | DEF_USB_PID_OUT );  /* CH375 */
		if ( s==USB_INT_SUCCESS ) {  /* CH375ɹ */
			tog_send = ~ tog_send;  /* лDATA0DATA1ͬ */
			len-=l;  /*  */
			buf+=l;  /* ɹ */
		}
		else if ( s==USB_INT_RET_NAK ) {  /* USBӡæ,δִSET_RETRYCH375Զ,Բ᷵USB_INT_RET_NAK״̬ */
			/* USBӡæ,ӦԺ */
			/* s=get_port_status( );  бҪ,Լʲôԭ´ӡæ */
		}
		else {  /* ʧ,²ʧ */
			clr_stall( endp_out_addr );  /* ӡݽն˵, soft_reset_print() */
/*			soft_reset_print();  ӡ,λ */
			tog_send = 0;  /* ʧ */
		}
/* ϴ,Զڵget_port_status()ӡ״̬ */
	}
}

unsigned char get_port_status( ) {  /* ѯӡ˿״̬,״̬,Ϊ0FFH˵ʧ */
/* ״̬: λ5(Paper Empty)Ϊ1˵ֽ, λ4(Select)Ϊ1˵ӡ, λ3(Not Error)Ϊ0˵ӡ */
	toggle_send( 0 );  /* ͨƴȡӡ״̬, SETUP׶ΪDATA0 */
	buffer[0]=0xA1; buffer[1]=1; buffer[2]=buffer[3]=buffer[4]=buffer[5]=0; buffer[6]=1; buffer[7]=0;  /* SETUP,GET_PORT_STATUS */
	wr_usb_data( 8, buffer );  /* SETUP8ֽ */
	if ( issue_token( ( 0 << 4 ) | DEF_USB_PID_SETUP )==USB_INT_SUCCESS ) {  /* SETUP׶βɹ */
		toggle_recv( 1 );  /* DATA׶,׼DATA1 */
		if ( issue_token( ( 0 << 4 ) | DEF_USB_PID_IN )==USB_INT_SUCCESS ) {  /* DATA׶βɹ */
			rd_usb_data( buffer );  /* յ,ֻͨ1ֽ */
			toggle_send( 1 );  /* STATUS׶ΪDATA1 */
			wr_usb_data( 0, buffer );  /* 0ȵ˵ƴɹ */
			if ( issue_token( ( 0 << 4 ) | DEF_USB_PID_OUT )==USB_INT_SUCCESS ) return( buffer[0] );  /* ״̬ */
		}
	}
	return( 0xFF );  /* زʧ */
}

unsigned char get_port_status_X( ) {  /* ѯӡ˿״̬,״̬,Ϊ0FFH˵ʧ,CH375A */
/* ״̬: λ5(Paper Empty)Ϊ1˵ֽ, λ4(Select)Ϊ1˵ӡ, λ3(Not Error)Ϊ0˵ӡ */
	buffer[0]=0xA1; buffer[1]=1; buffer[2]=buffer[3]=buffer[4]=buffer[5]=0; buffer[6]=1; buffer[7]=0;  /* ƴȡӡ״̬,SETUP */
	wr_usb_data( 8, buffer );  /* SETUP8ֽ */
	if ( issue_token_X( ( 0 << 4 ) | DEF_USB_PID_SETUP, 0x00 )==USB_INT_SUCCESS ) {  /* SETUP׶DATA0ɹ */
		if ( issue_token_X( ( 0 << 4 ) | DEF_USB_PID_IN, 0x80 )==USB_INT_SUCCESS ) {  /* DATA׶DATA1ղɹ */
			rd_usb_data( buffer );  /* յ,ֻͨ1ֽ */
			wr_usb_data( 0, buffer );  /* 0ȵDATA1˵ƴɹ */
			if ( issue_token_X( ( 0 << 4 ) | DEF_USB_PID_OUT, 0x40 )==USB_INT_SUCCESS ) return( buffer[0] );  /* STATUS׶βɹ,״̬ */
		}
	}
	return( 0xFF );  /* زʧ */
}

unsigned char get_descr( unsigned char type ) {  /* 豸˻ȡ */
	CH375_WR_CMD_PORT( CMD_GET_DESCR );
	CH375_WR_DAT_PORT( type );  /* , ֻ֧1(豸)2() */
	return( wait_interrupt() );  /* ȴCH375 */
}

unsigned char set_addr( unsigned char addr ) {  /* 豸˵USBַ */
	unsigned char status;
	CH375_WR_CMD_PORT( CMD_SET_ADDRESS );  /* USB豸˵USBַ */
	CH375_WR_DAT_PORT( addr );  /* ַ, 1127ֵ֮, 220 */
	status=wait_interrupt();  /* ȴCH375 */
	if ( status==USB_INT_SUCCESS ) {  /* ɹ */
		CH375_WR_CMD_PORT( CMD_SET_USB_ADDR );  /* USB˵USBַ */
		CH375_WR_DAT_PORT( addr );  /* ĿUSB豸ĵַɹ޸ĺ,Ӧͬ޸˵USBַ */
	}
	mDelaymS( 5 );
	return( status );
}

unsigned char set_config( unsigned char cfg ) {  /* 豸˵USB */
	tog_send=tog_recv=0;  /* λUSBͬ־ */
	CH375_WR_CMD_PORT( CMD_SET_CONFIG );  /* USB豸˵ֵ */
	CH375_WR_DAT_PORT( cfg );  /* ֵȡUSB豸 */
	return( wait_interrupt() );  /* ȴCH375 */
}

#define	UNKNOWN_USB_DEVICE	0xF1
#define	UNKNOWN_USB_PRINT	0xF2

unsigned char init_print() {  /* ʼUSBӡ,ɴӡö */
#define	p_dev_descr		((PUSB_DEV_DESCR)buffer)
#define	p_cfg_descr		((PUSB_CFG_DESCR_LONG)buffer)
	unsigned char status, len, c;
	status=get_descr(1);  /* ȡ豸 */
	if ( status==USB_INT_SUCCESS ) {
		len=rd_usb_data( buffer );  /* ȡݴCH375жƬRAM, */
		if ( len<18 || p_dev_descr->bDescriptorType!=1 ) return( UNKNOWN_USB_DEVICE );  /* :ȴʹ */
		if ( p_dev_descr->bDeviceClass!=0 ) return( UNKNOWN_USB_DEVICE );  /* ӵUSB豸USBӡ,߲USB淶 */
		status=set_addr(3);  /* ôӡUSBַ */
		if ( status==USB_INT_SUCCESS ) {
			status=get_descr(2);  /* ȡ */
			if ( status==USB_INT_SUCCESS ) {  /* ɹ */
				len=rd_usb_data( buffer );  /* ȡݴCH375жƬRAM, */
				if ( p_cfg_descr->itf_descr.bInterfaceClass!=7 || p_cfg_descr->itf_descr.bInterfaceSubClass!=1 ) return( UNKNOWN_USB_PRINT );  /* USBӡ߲USB淶 */
				endp_out_addr=endp_in_addr=0;
				c=p_cfg_descr->endp_descr[0].bEndpointAddress;  /* һ˵ĵַ */
				if ( c&0x80 ) endp_in_addr=c&0x0f;  /* IN˵ĵַ */
				else {  /* OUT˵ */
					endp_out_addr=c&0x0f;
					endp_out_size=p_cfg_descr->endp_descr[0].wMaxPacketSize;  /* ݽն˵ */
				}
				if ( p_cfg_descr->itf_descr.bNumEndpoints>=2 ) {  /* ӿϵĶ˵ */
					if ( p_cfg_descr->endp_descr[1].bDescriptorType==5 ) {  /* ˵ */
						c=p_cfg_descr->endp_descr[1].bEndpointAddress;  /* ڶ˵ĵַ */
						if ( c&0x80 ) endp_in_addr=c&0x0f;  /* IN˵ */
						else {  /* OUT˵ */
							endp_out_addr=c&0x0f;
							endp_out_size=p_cfg_descr->endp_descr[1].wMaxPacketSize;
						}
					}
				}
				if ( p_cfg_descr->itf_descr.bInterfaceProtocol<=1 ) endp_in_addr=0;  /* ӿڲҪIN˵ */
				if ( endp_out_addr==0 ) return( UNKNOWN_USB_PRINT );  /* USBӡ߲USB淶 */
				status=set_config( p_cfg_descr->cfg_descr.bConfigurationValue );  /* USBֵ */
				if ( status==USB_INT_SUCCESS ) {
					CH375_WR_CMD_PORT( CMD_SET_RETRY );  /* USBԴ */
					CH375_WR_DAT_PORT( 0x25 );
					CH375_WR_DAT_PORT( 0x89 );  /* λ7Ϊ1յNAKʱ, λ3~λ0ΪʱԴ */
/* Ƭڴӡæʱ¿,λ7Ϊ1,ʹCH375յNAKʱԶֱɹʧ */
/* ϣƬڴӡæʱܹ,ôӦλ7Ϊ0,ʹCH375յNAKʱ,
   USBͨѶ,USBӡæ,issue_tokenӳ򽫵õ״̬USB_INT_RET_NAK */
				}
			}
		}
	}
	return(status);
}

/* ˵ʾ */
main() {
	unsigned char xdata data_to_send[200];  /*  */
	unsigned char str_to_print[]="OK, support text print\n";
	unsigned char s;
	mDelaymS( 200 );
	set_usb_mode( 6 );  /* USBģʽ */
	while ( wait_interrupt()!=USB_INT_CONNECT );  /* ȴUSBӡ */

/* 豸CH341תӡڻCH37X,ô²ǿѡ,USBоƬ,ôҪִ² */
#define USB_RESET_FIRST	1  /* USB淶δҪUSB豸븴λ豸,ǼWINDOWS,ЩUSB豸ҲҪڲȸλܹ */
#ifdef USB_RESET_FIRST
	set_usb_mode( 7 );  /* λUSB豸,CH375USBźߵD+D-͵ƽ */
/* ƬCH375INT#ŲжϷʽǲѯʽ,ôӦڸUSB豸ڼֹCH375ж,USB豸λɺCH375жϱ־ж */
	mDelaymS( 10 );  /* λʱ䲻1mS,Ϊ10mS */
	set_usb_mode( 6 );  /* λ */
	mDelaymS( 100 );
	while ( wait_interrupt()!=USB_INT_CONNECT );  /* ȴλ֮豸ٴ */
#endif

	mDelaymS( 200 );  /* ЩUSB豸Ҫȴٺ */
	if ( init_print()!=USB_INT_SUCCESS ) while(1);  /*  */
	while ( 1 ) {
		s = get_port_status( );
		if ( s!=0xFF ) {
/*			if ( s&0x20 ) printf("No paper!\n");
			if ( (s&0x08) == 0 ) printf("Print ERROR!\n");*/
		}
		send_data( strlen(str_to_print), str_to_print );  /* ݸӡ,ͨڷʽһ */
		send_data( sizeof(data_to_send), data_to_send );  /* ݱ밴մӡĸʽҪѭӡ */
		/* ٴμݻ߽ */
	}
}
