/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH375 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH375 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32 */

/* MCS-51ƬCԵUļдʾ, 89C52߸ռĵƬ */
/* ʾUǷд,ʾģ˵İȫƳ,ҲԲοд */
/* CH375INT#Ųòѯʽ, MCS51Ƭ, V2.4ϰ汾CH375ӳ, CH375AоƬ */


/* C51   CH375HFT.C */
/* LX51  CH375HFT.OBJ , CH375HF4.LIB    CH375HF4CH375HF6Ϳ֧FAT32 */
/* OHX51 CH375HFT */

#include <reg52.h>
#include <stdio.h>
#include <string.h>
#include <intrins.h>

/* ¶ϸ˵뿴CH375HF6.Hļ */
#define	MAX_BYTE_IO				48		/* ֽΪλζдļʱ󳤶,Ĭֵ29,ֵռڴ,ֵС򳬹óȱֶζд */

#define LIB_CFG_DISK_IO			1		/* ̶дݵĸƷʽ,1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_FILE_IO			1		/* ļдݵĸƷʽ,0Ϊ"ⲿӳ",1Ϊ"DPTR",2Ϊ"˫DPTR",3Ϊ"DPTRP2+R0" */
#define LIB_CFG_INT_EN			0		/* CH375INT#ӷʽ,0Ϊ"ѯʽ",1Ϊ"жϷʽ" */
/*#define LIB_CFG_FILE_IO_DEFAULT	1*/		/* ʹCH375HF6.HṩĬ"ⲿӳ" */
/*#define LIB_CFG_UPD_SIZE		1*/		/* ݺǷԶļ: 0Ϊ"",1Ϊ"Զ" */
/* Ĭ,/ֽΪ0ôCH375FileWrite/CH375ByteWriteֻдݶ޸ļ,
   ҪÿдݺԶ޸/ļ,ôʹȫֱCH375LibConfigλ4Ϊ1,
   ʱ䲻дӦøļ,ֹͻȻϵǰдļȲ,
   ȷͻȻϵߺܿݲд򲻱ظļ,ٶȲU(Uڲڴ,Ƶд) */

#define CH375_CMD_PORT_ADDR		0xBDF1	/* CH375˿ڵI/Oַ */
#define CH375_DAT_PORT_ADDR		0xBCF0	/* CH375ݶ˿ڵI/Oַ */
/* 62256ṩ32KBRAMΪ: 0000H-01FFHΪ̶д, 0200H-7FFFHΪļݻ */
#define	DISK_BASE_BUF_ADDR		0x0000	/* ⲿRAMĴݻʼַ,ӸõԪʼĻΪSECTOR_SIZE */
#define DISK_BASE_BUF_LEN		4096	/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */

#define CH375_INT_WIRE			INT0	/* P3.2, INT0, CH375жINT#,CH375INT#,ڲѯж״̬ */

#define NO_DEFAULT_CH375_F_ENUM		1		/* δCH375FileEnumerʽֹԽԼ */
#define NO_DEFAULT_CH375_F_QUERY	1		/* δCH375FileQueryʽֹԽԼ */

#include "..\CH375HF6.H"				/* Ҫ֧FAT32,ôѡCH375HF4.H */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_INIT( )		{ P1_4 = 1; }	/* P1.4 ߵƽ */
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */
sbit P1_5  = P1^5;
/* P1.5һLEDڼʾĽ,͵ƽLED,U̲ʱ */
#define LED_RUN_ACT( )		{ P1_5 = 0; }	/* P1.5 ͵ƽLEDʾ */
#define LED_RUN_INACT( )	{ P1_5 = 1; }	/* P1.5 ͵ƽLEDʾ */
sbit P1_6  = P1^6;
/* P1.6һLEDڼʾĽ,͵ƽLED,Uдʱ */
#define LED_WR_ACT( )		{ P1_6 = 0; }	/* P1.6 ͵ƽLEDʾ */
#define LED_WR_INACT( )		{ P1_6 = 1; }	/* P1.6 ͵ƽLEDʾ */

/* ԺΪλʱ,ȷ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* ռַƵڲRAM,ַ */
UINT8	mCopyCodeStringToIRAM( UINT8 idata *iDestination, UINT8 code *iSource )
{
	UINT8	i = 0;
	while ( *iDestination = *iSource ) {
		iDestination ++;
		iSource ++;
		i ++;
	}
	return( i );
}

/* ״̬,ʾ벢ͣ,Ӧ滻ΪʵʵĴʩ */
void	mStopIfError( UINT8 iError )
{
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
	printf( "Error: %02X\n", (UINT16)iError );  /* ʾ */
	while ( 1 ) {
		LED_OUT_ACT( );  /* LED˸ */
		mDelaymS( 200 );
		LED_OUT_INACT( );
		mDelaymS( 200 );
	}
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x21;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

/* ΪCH375Ӳӿӳ */
#ifdef __C51__  // MCS51

#define xWriteCH375Cmd( c )		{ CH375_CMD_PORT = ( c ); _nop_( ); _nop_( ); _nop_( ); _nop_( ); }	/* дʱ2uS */
#define xWriteCH375Data( c )	{ CH375_DAT_PORT = ( c ); _nop_( ); }	/* дݲʱ1uS */
#define xReadCH375Data( )		( CH375_DAT_PORT )	/* ,СΪ1uS,ʱ */

#else  // MCS51ƬģⲢ

void xWriteCH375Cmd( UINT8 mCmd )		/* ⲿıCH375õӳ,CH375д */
{
	mDelay1uS( ); mDelay1uS( );  /* ʱ1uS */
	P0 = mCmd;  /* CH375Ĳ */
	CH375_A0 = 1;
	CH375_CS = 0;
	CH375_WR = 0;  /* Чдź, дCH375оƬ˿ */
	CH375_CS = 0;  /* ò,ʱ,CH375Ҫдȴ50nS */
	CH375_WR = 1;  /* ЧĿź, ɲCH375оƬ */
	CH375_CS = 1;
	CH375_A0 = 0;
	P0 = 0xFF;  /* ֹ */
	mDelay1uS( ); mDelay1uS( );  /* ʱ2uS */
}

void xWriteCH375Data( UINT8 mData )		/* ⲿıCH375õӳ,CH375д */
{
	P0 = mData;  /* CH375Ĳ */
	CH375_A0 = 0;
	CH375_CS = 0;
	CH375_WR = 0;  /* Чдź, дCH375оƬݶ˿ */
	CH375_CS = 0;  /* ò,ʱ,CH375Ҫдȴ50nS */
	CH375_WR = 1;  /* ЧĿź, ɲCH375оƬ */
	CH375_CS = 1;
	P0 = 0xFF;  /* ֹ */
	mDelay1uS( );  /* ʱ1uS */
}

UINT8 xReadCH375Data( void )			/* ⲿıCH375õӳ,CH375 */
{
	UINT8	mData;
	mDelay1uS( );  /* ʱ1uS */
	P0 = 0xFF;  /*  */
	CH375_A0 = 0;
	CH375_CS = 0;
	CH375_RD = 0;  /* Чдź, CH375оƬݶ˿ */
	CH375_CS = 0;  /* ò,ʱ,CH375Ҫдȴ50nS */
	mData = P0;  /* CH375Ĳ */
	CH375_RD = 1;  /* ЧĿź, ɲCH375оƬ */
	CH375_CS = 1;
	return( mData );
}

#endif

/* CH375˵Ľջȡݿ,ضȡܳ */
UINT8	ReadUsbData( UINT8 *iBuffer )
{
	UINT8	mCount, mLength;
	xWriteCH375Cmd( CMD_RD_USB_DATA0 );  /* ӵǰUSBжϵĶ˵㻺ȡݿ */
	mLength = xReadCH375Data( );  /* ݵĳ */
	for ( mCount = mLength; mCount != 0; mCount -- ) {  /* ݳȶȡ */
		*iBuffer = xReadCH375Data( );  /* ݲ */
		iBuffer ++;
	}
	return( mLength );
}

/* CH375˵ķͻдݿ */
void	WriteUsbData( UINT8 *iBuffer, UINT8 iCount )
{
	xWriteCH375Cmd( CMD_WR_USB_DATA7 );  /* USB˵ķͻдݿ */
	xWriteCH375Data( iCount );  /* ݵĳ */
	for ( ; iCount != 0; iCount -- ) {  /* ݳд */
		xWriteCH375Data( *iBuffer );  /* д */
		iBuffer ++;
	}
}

/* UǷд, USB_INT_SUCCESS˵д,0xFF˵ֻ/д,ֵ˵Ǵ */
/* BulkOnlyЭԲοӴ,޸ǰ˽USB MassStorageSCSI淶 */
UINT8	IsDiskWriteProtect( void )
{
	UINT8	mIfSubClass, mLength, mDevSpecParam;
	if ( CH375Version2 == 0 ) return( ERR_USB_DISK_ERR );  /* CH375S֧ */
	CH375IntStatus = 0;  /* жϱ־ */
	xWriteCH375Cmd( CMD_GET_DESCR );  /* ȡ */
	xWriteCH375Data( 2 );  /*  */
	xQueryInterrupt( );  /* ѯCH375жϲж״̬ */
	if ( CH375IntStatus == USB_INT_SUCCESS ) {  /* ɹ */
		ReadUsbData( (UINT8 *)&mCmdParam );  /* ȡ,ȷmCmdParamMAX_BYTE_IO32ֽ,ѡ */
		mIfSubClass = mCmdParam.Other.mBuffer[9+6];  /*  USB_CFG_DESCR_LONG.itf_descr.bInterfaceSubClass */
		mCmdParam.BOC.mCBW.mCBW_DataLen = 0x10;  /* ݴ䳤 */
		mCmdParam.BOC.mCBW.mCBW_Flag = 0x80;  /* ䷽Ϊ */
		if ( mIfSubClass == 6 ) {  /* ѡ */
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[0] = 0x1A;  /* ֽ, MODE SENSE(6) */
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[1] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[2] = 0x3F;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[3] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[4] = 0x10;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[5] = 0x00;
		}
		else {
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[0] = 0x5A;  /* ֽ, MODE SENSE(10) */
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[1] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[2] = 0x3F;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[3] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[4] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[5] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[6] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[7] = 0x00;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[8] = 0x10;
			mCmdParam.BOC.mCBW.mCBW_CB_Buf[9] = 0x00;
		}
		WriteUsbData( (UINT8 *)&mCmdParam, 31 );  /* CH375˵ķͻдCBWݿ,ʣಿCH375Զ */
		CH375IntStatus = 0;
		xWriteCH375Cmd( CMD_DISK_BOC_CMD );  /* USB洢ִBulkOnlyЭ */
		xQueryInterrupt( );  /* ѯCH375жϲж״̬ */
		if ( CH375IntStatus == USB_INT_SUCCESS ) {  /* ɹ */
			mLength = ReadUsbData( (UINT8 *)&mCmdParam );  /* CH375˵Ľջȡݿ */
			if ( mLength > 3 ) {  /* MODE SENSEݵĳЧ */
				if ( mIfSubClass == 6 ) mDevSpecParam = mCmdParam.Other.mBuffer[2];  /* MODE SENSE(6), device specific parameter */
				else mDevSpecParam = mCmdParam.Other.mBuffer[3];  /* MODE SENSE(10), device specific parameter */
				if ( mDevSpecParam & 0x80 ) return( 0xFF );  /* Uд */
				else return( USB_INT_SUCCESS );  /* Uûд */
			}
			return( ERR_USB_DISK_ERR );
		}
		mIfSubClass = CH375IntStatus;  /* ݴ */
		xWriteCH375Cmd( CMD_DISK_R_SENSE );  /* USB洢 */
		xQueryInterrupt( );  /* ѯCH375жϲж״̬ */
		return( mIfSubClass );
	}
	return( CH375IntStatus );
}

/* ȫƳU, USB_INT_SUCCESS˵԰ȫƳ,˵ܰȫƳ,ֻǿƳ */
/* ڲU׼ûγUǰ, ֹûγU̶ʧ */
UINT8	SafeRemoveDisk( void )
{
	UINT8	i;
	for ( i = 0; i < 10; i ++ ) {  /* еUǷδ׼,Ա */
		mDelaymS( 100 );
		if ( CH375DiskReady( ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
	}
	mDelaymS( 10 );
	xWriteCH375Cmd( CMD_SET_CONFIG );  /* USB */
	xWriteCH375Data( 0 );  /* ȡ,ᵼºܶU̵LED */
	xQueryInterrupt( );  /* ѯCH375жϲж״̬ */
	mDelaymS( 10 );
	if ( i < 5 && CH375IntStatus == USB_INT_SUCCESS ) return( USB_INT_SUCCESS );  /* ɹ */
	else return( 0xFF );
/* ȡSOFᵼ¾U̵LED */
/* ˴ȡSOF, ô˶Ӧ, ڼ⵽U̲ӦٻָΪģʽ6ָSOF */
//	xWriteCH375Cmd( CMD_SET_USB_MODE );  /* USBģʽ */
//	xWriteCH375Data( 5 );  /* ֹͣSOF,⵽U̲ģʽ6ָSOF */
//	mDelaymS( 1 );
}

main( ) {
	UINT8	i;
	LED_OUT_INIT( );
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start\n" );

#if DISK_BASE_BUF_LEN == 0
	pDISK_BASE_BUF = &my_buffer[0];  /* .HļжCH375רû,ûָָӦóĻںԽԼRAM */
#endif

	i = CH375LibInit( );  /* ʼCH375CH375оƬ,ɹ0 */
	mStopIfError( i );
/* ·ʼ */

	while ( 1 ) {
		printf( "Wait Udisk\n" );
		while ( CH375DiskStatus < DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴU̲ */
			CH375DiskConnect( );
			mDelaymS( 100 );
		}
		LED_OUT_ACT( );  /* LED */
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */

/* UǷ׼,ЩU̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 3; i ++ ) {  /* еUǷδ׼,Ա */
			mDelaymS( 100 );
			printf( "Ready ?\n" );
			if ( CH375DiskReady( ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
#if DISK_BASE_BUF_LEN
		if ( DISK_BASE_BUF_LEN < CH375vSectorSize ) {  /* ݻǷ㹻,CH375vSectorSizeU̵ʵС */
			printf( "Too large sector size\n" );
			while ( CH375DiskConnect( ) == ERR_SUCCESS ) mDelaymS( 100 );
			continue;
		}
#endif
/* ѯ */
/*		printf( "DiskSize\n" );
		i = CH375DiskSize( );  
		mStopIfError( i );
		printf( "TotalSize = %u MB \n", (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * (CH375vSectorSize/512) / 2048 ) );  // ʾΪMBΪλ
		// ԭ㷽 (unsigned int)( mCmdParam.DiskSize.mDiskSizeSec * CH375vSectorSize / 1000000 ) пǰ˺, ޸ĳʽ
*/
		LED_RUN_ACT( );  /* ʼU */

		printf( "Check Disk Write Protect ? ...\n" );
		i = IsDiskWriteProtect( );  /* UǷд, USB_INT_SUCCESS˵д,0xFF˵ֻ/д,ֵ˵Ǵ */
		if ( i != USB_INT_SUCCESS && i != 0xFF ) {  /* ʧ */
			printf( "Again ...\n" );
			mDelaymS( 100 );
			i = IsDiskWriteProtect( );  /* һ */
		}
		if ( i == USB_INT_SUCCESS ) {  /* д */
			printf( "... No !\n" );
			LED_WR_ACT( );  /* д */
			printf( "Create a File\n" );
			mCopyCodeStringToIRAM( mCmdParam.Create.mPathName, "\\NEWFILE.TXT" );  /* ļ,ڸĿ¼ */
			i = CH375FileCreate( );  /* ½ļ,ļѾɾ½ */
			mStopIfError( i );
			mCmdParam.ByteWrite.mByteBuffer[0] = 'O';
			mCmdParam.ByteWrite.mByteBuffer[1] = 'K';
			mCmdParam.ByteWrite.mByteCount = 2;  /* дݵַ,ζдĳȲܳMAX_BYTE_IO,ڶεʱŸղŵд */
			i = CH375ByteWrite( );  /* ļд */
			mStopIfError( i );
			printf( "Close\n" );
			mCmdParam.Close.mUpdateLen = 0;  /* ҪԶļ */
			i = CH375FileClose( );
			mStopIfError( i );
			LED_WR_INACT( );
			if ( SafeRemoveDisk( ) == USB_INT_SUCCESS ) {  /* ȫƳU */
				printf( "Safe Remove !\n" );
			}
			else {
				printf( "Unsafe Remove !\n" );
			}
		}
		else if ( i == 0xFF ) {  /* д */
			printf( "... Yes !\n" );
		}
		else {
			mStopIfError( i );  /* ʾ */
		}
		LED_RUN_INACT( );
		printf( "Take out\n" );
		while ( CH375DiskStatus >= DISK_CONNECT ) {  /* ѯCH375жϲж״̬,ȴṴγ */
			CH375DiskConnect( );
			mDelaymS( 100 );
		}
		LED_OUT_INACT( );  /* LED */
		mDelaymS( 200 );
	}
}
