/* 2004.03.05
  ޸ļ¼
    2007.08ִ֧, CH375BоƬ, ޸: mInitDisk, mReadSector, mWriteSector, ˽: mClearError
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB 1.1 Host Examples for CH375   **
**  KC7.0@MCS-51                      **
****************************************
*/
/* CH375ΪUSBӿڵĳʾ */

/* MCS-51ƬCԵʾ, Uݶд */

#include <reg51.h>
#include <string.h>
#include <stdio.h>

#define		MAX_SECTOR_SIZE		4096	/* 512ֽÿΪ,2Kֽÿ,Ϊ4Kֽ */

/* CH375뼰״̬ */
#include "CH375INC.H"
/* CH375 */
#define CH375_BLOCK_SIZE		64		/* CH375 maximum data block size */

/* ¶MCS-51Ƭ,Ƭ޸,ΪṩCԵٶҪԱŻ */
#include <reg51.h>
unsigned char volatile xdata	CH375_CMD_PORT _at_ 0xBDF1;	/* CH375˿ڵI/Oַ */
unsigned char volatile xdata	CH375_DAT_PORT _at_ 0xBCF0;	/* CH375ݶ˿ڵI/Oַ */
unsigned char xdata				DATA_BUFFER[ MAX_SECTOR_SIZE ]    _at_ 0x0000;	/* ⲿRAMݻʼַ,Ȳһζдݳ */
sbit	CH375_INT_WIRE	=		0xB0^2;	/* P3.2, INT0, CH375INT#,ڲѯж״̬ */

unsigned short  BytePerSector;		/* ÿֽС */
unsigned char   BlockPerSector;		/* ÿָCH375дʱĿ BlockPerSector=BytePerSector/CH375_BLOCK_SIZE */

/* P1.4һLEDڼʾĽ,͵ƽLED,U̲ */
sbit P1_4  = P1^4;
#define LED_OUT_ACT( )		{ P1_4 = 0; }	/* P1.4 ͵ƽLEDʾ */
#define LED_OUT_INACT( )	{ P1_4 = 1; }	/* P1.4 ͵ƽLEDʾ */


/* ʱ2΢,ȷ */
void	delay2us( )
{
	unsigned char i;
	for ( i = 2; i != 0; i -- );
}

/* ʱ1΢,ȷ */
void	delay1us( )
{
	unsigned char i;
	for ( i = 1; i != 0; i -- );
}

/* ʱ,ȷ */
void	mDelaymS( unsigned char cnt )
{
	unsigned char	i, c;
	while ( cnt -- ) {
		for ( i = 250; i != 0; i -- ) c+=3;
	}
}

/*  */

void CH375_WR_CMD_PORT( unsigned char cmd ) {  /* CH375˿д,ڲС4uS,ƬϿʱ */
	delay2us();
	CH375_CMD_PORT=cmd;
	delay2us();
}

void CH375_WR_DAT_PORT( unsigned char dat ) {  /* CH375ݶ˿д,ڲС1.5uS,ƬϿʱ */
	CH375_DAT_PORT=dat;
	delay1us();  /* ΪMCS51Ƭʵʱ */
}

unsigned char CH375_RD_DAT_PORT() {  /* CH375ݶ˿ڶ,ڲС1.5uS,ƬϿʱ */
	delay1us();  /* ΪMCS51Ƭʵʱ */
	return( CH375_DAT_PORT );
}

/* ȴCH375жϲȡ״̬ */
unsigned char mWaitInterrupt() {  /* ˵ȴ, ز״̬ */
	while( CH375_INT_WIRE );  /* ѯȴCH375ж(INT#͵ƽ) */
	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ж, ȡж״̬ */
	return( CH375_RD_DAT_PORT( ) );
/*	c = CH375_RD_DAT_PORT( );   ж״̬ */
/*	if ( c == USB_INT_DISCONNECT ) ?;   ⵽USB豸Ͽ¼ */
/*	else if ( c == USB_INT_CONNECT ) ?;   ⵽USB豸¼ */
}

/* CH375ΪUSBʽ */
unsigned char	mCH375Init( )
{
	unsigned char	i;
#ifdef	TEST_CH375_PORT
	unsigned char	c;
	CH375_WR_CMD_PORT( CMD_CHECK_EXIST );  /* Թ״̬ */
	CH375_WR_DAT_PORT( 0x55 );  /*  */
	c = CH375_RD_DAT_PORT( );  /* Ӧǲȡ */
	if ( c != 0xaa ) {  /* CH375 */
		for ( i = 100; i != 0; i -- ) {  /* ǿͬ */
			CH375_WR_CMD_PORT( CMD_RESET_ALL );  /* CH375ִӲλ */
			c = CH375_RD_DAT_PORT( );  /* ʱ */
		}
		mDelaymS( 50 );  /* ʱ30mS */
	}
#endif
	CH375_WR_CMD_PORT( CMD_SET_USB_MODE );  /* USBģʽ */
	CH375_WR_DAT_PORT( 6 );  /* ģʽ,ԶUSB豸 */
	for ( i = 0xff; i != 0; i -- )  /* ȴɹ,ͨҪȴ10uS-20uS */
		if ( CH375_RD_DAT_PORT( ) == CMD_RET_SUCCESS ) break;  /* ɹ */
	if ( i != 0 ) return( 0 );  /* ɹ */
	else return( 0xff );  /* CH375,оƬͺŴߴڴڷʽ߲֧ */
}

/* ʼ */
unsigned char	mInitDisk( )
{
	unsigned char mIntStatus, i;
	CH375_WR_CMD_PORT( CMD_GET_STATUS );  /* ж, ȡж״̬ */
	mIntStatus = CH375_RD_DAT_PORT( );
	if ( mIntStatus == USB_INT_DISCONNECT ) return( mIntStatus );  /* USB豸Ͽ */
	CH375_WR_CMD_PORT( CMD_DISK_INIT );  /* ʼUSB洢 */
	mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
	if ( mIntStatus != USB_INT_SUCCESS ) return( mIntStatus );  /* ִ */
	CH375_WR_CMD_PORT( CMD_DISK_SIZE );  /* ȡUSB洢 */
	mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
	if ( mIntStatus != USB_INT_SUCCESS ) {  /*  */
		mDelaymS( 200 );
		CH375_WR_CMD_PORT( CMD_DISK_SIZE );  /* ȡUSB洢 */
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
	}
	if ( mIntStatus != USB_INT_SUCCESS ) return( mIntStatus );  /* ִ */

/* CMD_RD_USB_DATAݶ,ÿֽ */
	CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* CH375ȡݿ */
	i = CH375_RD_DAT_PORT( );  /* ݵĳ */
	if ( i != 8 ) return( USB_INT_DISK_ERR );  /* 쳣 */
	for ( i = 0; i != 8; i ++ ) {  /* ݳȶȡ */
		DATA_BUFFER[ i ] = CH375_RD_DAT_PORT( );  /* ݲ */
	}
	i = DATA_BUFFER[ 6 ];  /* Uеÿֽ,˸ʽ */
	if ( i == 0x04 ) BlockPerSector = 1024/CH375_BLOCK_SIZE;  /* ̵1Kֽ */
	else if ( i == 0x08 ) BlockPerSector = 2048/CH375_BLOCK_SIZE;  /* ̵2Kֽ */
	else if ( i == 0x10 ) BlockPerSector = 4096/CH375_BLOCK_SIZE;  /* ̵4Kֽ */
	else BlockPerSector = 512/CH375_BLOCK_SIZE;  /* ĬϵĴ̵512ֽ */
	BytePerSector = BlockPerSector*CH375_BLOCK_SIZE;  /* ̵С */
	CH375_WR_CMD_PORT( CMD_SET_PKT_P_SEC );  /* USB洢ÿݰ */
	CH375_WR_DAT_PORT( 0x39 );
	CH375_WR_DAT_PORT( BlockPerSector );  /* ÿݰ */
	return( 0 );  /* UѾɹʼ */
}

/* U̴Ա */
void	mClearError( void )
{
	mDelaymS( 10 );  /* ʱ10mS */
	CH375_WR_CMD_PORT( CMD_DISK_R_SENSE );  /* USB洢 */
	mDelaymS( 10 );  /* ʱ10mS */
	mWaitInterrupt( );  /* ȴжϲȡ״̬ */
}

/* U̶ȡݿ鵽 */
unsigned char	mReadSector( unsigned long iLbaStart, unsigned char iSectorCount )
/* iLbaStart ׼ȡʼ, iSectorCount ׼ȡ */
{
	unsigned char mIntStatus;
	unsigned char *mBufferPoint;
	unsigned int  mBlockCount;
	unsigned char mLength;
	CH375_WR_CMD_PORT( CMD_DISK_READ );  /* USB洢ݿ */
	CH375_WR_DAT_PORT( (unsigned char)iLbaStart );  /* LBA8λ */
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 8 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 16 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 24 ) );  /* LBA8λ */
	CH375_WR_DAT_PORT( iSectorCount );  /*  */
	mBufferPoint = DATA_BUFFER;  /* ָ򻺳ʼַ */
	for ( mBlockCount = iSectorCount * BlockPerSector; mBlockCount != 0; mBlockCount -- ) {  /* ݿ */
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
		if ( mIntStatus == USB_INT_DISK_READ ) {  /* USB洢ݿ,ݶ */
			CH375_WR_CMD_PORT( CMD_RD_USB_DATA );  /* CH375ȡݿ */
			mLength = CH375_RD_DAT_PORT( );  /* ݵĳ */
			while ( mLength ) {  /* ݳȶȡ */
				*mBufferPoint = CH375_RD_DAT_PORT( );  /* ݲ */
				mBufferPoint ++;
				mLength --;
			}
			CH375_WR_CMD_PORT( CMD_DISK_RD_GO );  /* ִUSB洢Ķ */
		}
		else break;  /* ش״̬ */
	}
	if ( mBlockCount == 0 ) {
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
		if ( mIntStatus == USB_INT_SUCCESS ) return( 0 );  /* ɹ */
	}
//	if ( mIntStatus == USB_INT_DISCONNECT ) return( mIntStatus );  /* U̶Ͽ */
	mClearError( );  /* U̴Ա */
	return( mIntStatus );  /* ʧ */
}

/* еĶݿдU */
unsigned char	mWriteSector( unsigned long iLbaStart, unsigned char iSectorCount )
/* iLbaStart дʼ, iSectorCount д */
{
	unsigned char mIntStatus;
	unsigned char *mBufferPoint;
	unsigned int  mBlockCount;
	unsigned char mLength;
	CH375_WR_CMD_PORT( CMD_DISK_WRITE );  /* USB洢дݿ */
	CH375_WR_DAT_PORT( (unsigned char)iLbaStart );  /* LBA8λ */
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 8 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 16 ) );
	CH375_WR_DAT_PORT( (unsigned char)( iLbaStart >> 24 ) );  /* LBA8λ */
	CH375_WR_DAT_PORT( iSectorCount );  /*  */
	mBufferPoint = DATA_BUFFER;  /* ָ򻺳ʼַ */
	for ( mBlockCount = iSectorCount * BlockPerSector; mBlockCount != 0; mBlockCount -- ) {  /* ݿ */
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
		if ( mIntStatus == USB_INT_DISK_WRITE ) {  /* USB洢дݿ,д */
			CH375_WR_CMD_PORT( CMD_WR_USB_DATA7 );  /* CH375дݿ */
			mLength = CH375_BLOCK_SIZE;
			CH375_WR_DAT_PORT( mLength );  /* ݵĳ */
			while ( mLength ) {  /* ݳд */
				CH375_WR_DAT_PORT( *mBufferPoint );  /* д */
				mBufferPoint ++;
				mLength --;
			}
/*			do { C51,DO+WHILEṹWHILEЧʸ,ٶȿ
				CH375_WR_DAT_PORT( *mBufferPoint );
				mBufferPoint ++;
			} while ( -- mLength );*/
			CH375_WR_CMD_PORT( CMD_DISK_WR_GO );  /* ִUSB洢д */
		}
		else break;  /* ش״̬ */
	}
	if ( mBlockCount == 0 ) {
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
		if ( mIntStatus == USB_INT_SUCCESS ) return( 0 );  /* ɹ */
	}
//	if ( mIntStatus == USB_INT_DISCONNECT ) return( mIntStatus );  /* U̶Ͽ */
	mClearError( );  /* U̴Ա */
	return( mIntStatus );  /* ʧ */
}

struct _HD_MBR_DPT {
	unsigned char	PartState;
	unsigned char	StartHead;
	unsigned int	StartSec;
	unsigned char	PartType;
	unsigned char	EndHead;
	unsigned int	EndSec;
	unsigned long	StartSector;
	unsigned long	TotalSector;
};

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xf3;  /* 24MHz, 9600bps */
	TR1 = 1;
	TI = 1;
}

main( ) {
	unsigned char	c, mIntStatus;
	LED_OUT_ACT( );  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100 */
	LED_OUT_INACT( );
	mInitSTDIO( );
	printf( "Start\n" );
	c = mCH375Init( );  /* ʼCH375 */
	if ( c ) printf( "Error @CH375Init\n" );
	printf( "Insert USB disk\n" );
	do {  /* ȴU */
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
	} while ( mIntStatus != USB_INT_CONNECT );  /* UûӻѾγ */
	mDelaymS( 200 );  /* ʱȴU̽״̬ */
	printf( "InitDisk\n" );
	c = mInitDisk( );  /* ʼU,ʵʶU̵,ӰUе,жд֮ǰд˲ */
	if ( c ) printf( "Error @InitDisk, %02X\n", c );
	LED_OUT_ACT( );

/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
//	do {
//		mDelaymS( 100 );
//		printf( "Disk Ready ?\n" );
//		i = CH375DiskReady( );  /* ѯǷ׼,ʡӳԽԼ1KBĳ */
//	} while ( i != ERR_SUCCESS );
/* CH375DiskReady CH375Uļӳ,Ϊ϶,Դ˴ʡȥ */

	printf( "ReadSector 0# to buffer\n" );
	c = mReadSector( 0, 1 );
	if ( c ) printf( "Error @ReadSector, %02X\n", c );
	if ( DATA_BUFFER[0x01FF] == 0xAA ) {  /* ̷Ч */
		printf( "WriteSector 1# from buffer\n" );
		c = mWriteSector( 1, 1 );
		if ( c ) printf( "Error @WriteSector, %02X\n", c );
		memset( DATA_BUFFER, 0, sizeof(DATA_BUFFER) );  /* ݻ,ԭķϢ */
		printf( "WriteSector 0# for clear\n" );
		c = mWriteSector( 0, 1 );
		if ( c ) printf( "Error @WriteSector, %02X\n", c );
	}
	else {
		printf( "ReadSector 1# to buffer\n" );
		c = mReadSector( 1, 1 );
		if ( c ) printf( "Error @ReadSector, %02X\n", c );
		printf( "WriteSector 0# from buffer\n" );
		c = mWriteSector( 0, 1 );
		if ( c ) printf( "Error @WriteSector, %02X\n", c );
	}
	printf( "Stop\n" );
	while ( 1 ) {
		mIntStatus = mWaitInterrupt( );  /* ȴжϲȡ״̬ */
		if ( mIntStatus == USB_INT_DISCONNECT ) {  /* UûӻѾγ */
			printf( "Out\n" );
			LED_OUT_INACT( );
		}
		else if ( mIntStatus == USB_INT_CONNECT ) {  /* UѾ */
			printf( "In\n" );
			LED_OUT_ACT( );
		}
	}
}
