/*
; CH375/CH372 Bulk Data Test
; U2(AT89C51) Program
; ݴȷ, ͨշݿԴٶ,
; ʱƵʲ24MHzı׼MCS-51Ƭ, 24MHzӦʵʱ, 24MHzʵʱ
; ֻҪƬ, ʹýϸߵʱ, 罫ԭ12MHzΪ24MHz,
; ΪMCS51ƬٶȽ,дⲿRAMҪ2Լӵѭָ,ʹ24MHzʱҲ޷500KB/S
; Ϊ˼ٵƬٶȲԵӰ,ٶȲԲڵƬжϷ
;
; Website:  http://winchiphead.com
; Email:    tech@winchiphead.com
; Author:   W.ch 2003.09
*/

/* MCS-51ƬCԵʾ */

#include <reg52.h>
#include <string.h>
#include "..\..\MCU_IF1\MCS51C\CH375INC.H"

/* #define USE_MY_USB_ID	YES */
#define MY_USB_VENDOR_ID	0x1234		/* ID */
#define MY_USB_DEVICE_ID	0x5678		/* 豸ID */

unsigned char volatile xdata CH375_CMD_PORT _at_ 0xBDF1;		/* CH375˿ڵI/Oַ */
unsigned char volatile xdata CH375_DAT_PORT _at_ 0xBCF0;		/* CH375ݶ˿ڵI/Oַ */

unsigned char THIS_CMD_CODE;  /* 浱ǰ */
unsigned char RECV_LEN;       /* սյݵĳ */
unsigned char RECV_BUFFER[ CH375_MAX_DATA_LEN ];  /* ݻ,ڱյ´,Ϊ064ֽ */
/* MCS-51ƬȡⲿRAMĶдٶȵڲRAM, ҪõDPTR, ԶдٶȽ, Բο޸ */

/* λ־ */
bit bdata FLAG_RECV_OK;       /* ճɹ־,1ָʾɹյݿ */
bit bdata FLAG_SEND_WAIT;     /* ͵ȴ־,1ָʾݿCH375еȴ */

/* Ӧò㶨 */
/* TEST_OTHER		EQU    00H				;Զ */
#define TEST_START		0x20  /* Թ̿ʼ */
#define TEST_DATA		0x21  /* ȷ */
#define TEST_UPLOAD		0x22  /* ϴݿ */
#define TEST_DOWNLOAD	0x23  /* ´ݿ */

/* йCH451Ķ,ʾӷʽ,óûõ */
sbit   CH451_dclk=P1^7;      /* ʱӼ */
sbit   CH451_din=P1^6;	     /* ,CH451 */
sbit   CH451_load=P1^5;      /* ,Ӽ */

/* ʱ2΢,ȷ */
void	Delay2us( )
{
	unsigned char i;
#define DELAY_START_VALUE	1  /* ݵƬʱѡֵ,20MHzΪ0,30MHzΪ2 */
	for ( i=DELAY_START_VALUE; i!=0; i-- );
}

/* ʱ50,ȷ */
void	Delay50ms( )
{
	unsigned char i, j;
	for ( i=200; i!=0; i-- ) for ( j=250; j!=0; j-- );
}

/* CH451ʼӳ */
void	CH451_Init( )
{
  CH451_din=0;         /* ȵͺ,ѡ4 */
  CH451_din=1;
}

/* CH451ӳ */
/* һ޷ͱ洢12ֽڵ */
void	CH451_Write( unsigned int command )
{
  unsigned char i;
  CH451_load=0;  /* ʼ */
  for( i=0; i<12; i++ ) {  /* 12λ,λǰ */
    CH451_din = command & 1;
    CH451_dclk = 0;
    command >>= 1;
    CH451_dclk = 1;  /* Ч */
  }
  CH451_load = 1;  /*  */
}

/* CH375ʼӳ */
void	CH375_Init( )
{
	unsigned char i;
	FLAG_RECV_OK=0;  /* ճɹ־,1ָʾɹյݿ */
	FLAG_SEND_WAIT=0;  /* 巢͵ȴ־,1ָʾݿCH375еȴ */
/* CH375Ƿ,ѡ,ͨҪ */
#ifdef TEST_CH375_FIRST
	CH375_CMD_PORT = CMD_CHECK_EXIST;  /* CH375Ƿ */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = 0x55;  /* д */
	Delay2us( );
	i = ~ 0x55;  /* Ӧǲȡ */
	if ( CH375_DAT_PORT != i ) {  /* CH375 */
		for ( i=80; i!=0; i-- ) {
			CH375_CMD_PORT = CMD_RESET_ALL;  /* ظ,ִӲλ */
			Delay2us( );
		}
		CH375_CMD_PORT = 0;
		Delay50ms( );  /* ʱ50ms */
	}
#endif
#ifdef USE_MY_USB_ID
/* ⲿԶUSB豸VIDPID,ѡ,ִиʹĬϵVIDPID */
	CH375_CMD_PORT = CMD_SET_USB_ID;  /* ⲿԶUSB豸VIDPID,ѡ */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = (unsigned char)MY_USB_VENDOR_ID;  /* д볧IDĵֽ */
	CH375_DAT_PORT = (unsigned char)(MY_USB_VENDOR_ID>>8);  /* д볧IDĸֽ */
	CH375_DAT_PORT = (unsigned char)MY_USB_DEVICE_ID;  /* д豸IDĵֽ */
	CH375_DAT_PORT = (unsigned char)(MY_USB_DEVICE_ID>>8);  /* д豸IDĸֽ */
	Delay2us( );
#endif
/* USBģʽ, Ҫ */
	CH375_CMD_PORT = CMD_SET_USB_MODE;
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	CH375_DAT_PORT = 2;  /* Ϊʹù̼USB豸ʽ */
	for ( i=100; i!=0; i-- ) {  /* ȴɹ,ͨҪȴ10uS-20uS */
		if ( CH375_DAT_PORT==CMD_RET_SUCCESS ) break;
	}
/*	if ( i==0 ) { CH372/CH375Ӳ }; */
/* ж,ٶCH375INT0 */
	IT0 = 0;  /* ⲿźΪ͵ƽ */
	IE0 = 0;  /* жϱ־ */
	EX0 = 1;  /* CH375ж */
}

/* CH375жϷ,ʹüĴ1 */
void	mCh375Interrupt( ) interrupt 0 using 1
{
	unsigned char InterruptStatus;
	unsigned char length, c1;
	unsigned char data *cmd_buf;
	unsigned char data *ret_buf;
	CH375_CMD_PORT = CMD_GET_STATUS;  /* ȡж״̬ȡж */
	Delay2us( );  /* ʱƵʵ16MHzָʱ */
	InterruptStatus = CH375_DAT_PORT;  /* ȡж״̬ */
	IE0 = 0;  /* жϱ־,ӦINT0ж */
	if ( InterruptStatus == USB_INT_EP2_OUT ) {  /* ˵´ɹ */
		CH375_CMD_PORT = CMD_RD_USB_DATA;  /* ӵǰUSBжϵĶ˵㻺ȡݿ,ͷŻ */
		Delay2us( );  /* ʱƵʵ16MHzָʱ */
		length = CH375_DAT_PORT;  /* ȶȡݳ */
		if ( length != 0 ) {  /* Ϊ0򲻴 */
			THIS_CMD_CODE = CH375_DAT_PORT;  /* 浱ǰ,ΪǲԳPCӦóԼֽΪ */
			if ( THIS_CMD_CODE == TEST_DOWNLOAD ) {  /* ´ٶ */
				while ( --length != 0 )  /* ȼ1ȥֽں */
					c1 = CH375_DAT_PORT;  /* ,Ϊ˲ٶ,,24MHzMCS51ÿȡһֽҪ2uS */
			}
			else {  /* ǲ´ٶȵ,Ƚٷ */
				RECV_LEN = length;  /* ݳ */
				cmd_buf = RECV_BUFFER;  /* ջ */
				*cmd_buf = THIS_CMD_CODE;
				while ( --length != 0 ) {  /* ȼ1ȥֽں */
					cmd_buf++;
					*cmd_buf = CH375_DAT_PORT;
				}
/* ϳCҪÿһֽڿҪʮ,ûֻҪ4
					mov  a,length
					jz   skip_get
					mov  r7,a
					mov  dptr,#CH375_DAT_PORT
get_next_byte:		movx a,@dptr    ֱӷ
					djnz r7,get_next_byte
skip_get:			nop
*/
				if ( THIS_CMD_CODE == TEST_UPLOAD ) {  /* ϴٶ */
					CH375_CMD_PORT = CMD_WR_USB_DATA7;  /* USB˵2ķͻдݿ */
					Delay2us( );  /* ʱƵʵ16MHzָʱ */
					length = CH375_MAX_DATA_LEN;
					CH375_DAT_PORT = length;  /* дݳ */
					do {
						CH375_DAT_PORT = TL0;  /* α,Ϊ˲ٶ,Ч,24MHzMCS51ÿдһֽҪ2uS */
					} while ( --length != 0 );
				}
				else if ( THIS_CMD_CODE == TEST_START ) {  /* Թ̿ʼ */
/* һβϴٶʱϴ, ڵڶβǰҪϴ */
					CH375_CMD_PORT = CMD_SET_ENDP7;  /* USB˵2IN */
					Delay2us( );  /* ʱƵʵ16MHzָʱ */
					CH375_DAT_PORT = 0x0e;  /* ͬλ,USB˵2INæ,NAK */
					FLAG_SEND_WAIT = 0;  /* ͵ȴ־,֪ͨӦóԼ */
				}
				else if ( THIS_CMD_CODE == TEST_DATA ) {  /* ȷ,յȡ󷵻ظPC */
					CH375_CMD_PORT = CMD_WR_USB_DATA7;  /* USB˵2ķͻдݿ */
					Delay2us( );  /* ʱƵʵ16MHzָʱ */
					ret_buf = RECV_BUFFER;  /* ջ */
					length = RECV_LEN;  /* սյݳ */
					CH375_DAT_PORT = length;  /* дݳ */
					if ( length ) {
						do {
							CH375_DAT_PORT = ~ *ret_buf;  /* ȡ󷵻,ɼӦóǷȷ */
							ret_buf++;
						} while ( --length != 0 );
					}
				}
				else {  /* ,δ */
					FLAG_RECV_OK = 1;  /* ,ýճɹ־,֪ͨӦóȡٷ */
				}
			}
		}
	}
	else if ( InterruptStatus == USB_INT_EP2_IN ) {  /* ݷͳɹ */
		if ( THIS_CMD_CODE == TEST_UPLOAD ) {  /* ϴٶ,׼ϴ */
			CH375_CMD_PORT = CMD_WR_USB_DATA7;  /* USB˵2ķͻдݿ */
			Delay2us( );  /* ʱƵʵ16MHzָʱ */
			length = CH375_MAX_DATA_LEN;
			CH375_DAT_PORT = length;  /* дݳ */
			do {
				CH375_DAT_PORT = TL0;  /* α,Ϊ˲ٶ,Ч,24MHzMCS51ÿдһֽҪ2uS */
			} while ( --length != 0 );
		}
		CH375_CMD_PORT = CMD_UNLOCK_USB;  /* ͷŵǰUSB */
		FLAG_SEND_WAIT = 1;  /* ͵ȴ־,֪ͨӦóԼ */
	}
	else if ( InterruptStatus == USB_INT_EP1_IN ) {  /* жݷͳɹ */
		CH375_CMD_PORT = CMD_UNLOCK_USB;  /* ͷŵǰUSB */
	}
	else {  /* ù̼USBʽ²Ӧóж״̬ */
	}
}

main( ) {
	unsigned char i;
	Delay50ms( );	/* ʱȴCH375ʼ,ƬCH375ṩλź򲻱ʱ */
	CH375_Init( );  /* ʼCH375 */
	CH451_Init( );  /* ʼCH451 */
/* CH451ʾ */
	CH451_Write( 0x0401 );  /* ϵͳ,ʹʾ */
	CH451_Write( 0x0588 );  /* ʾ,BCD뷽ʽ,8 */
	for ( i=0; i<8; ++i ) CH451_Write( (unsigned int)i << 8 | 0x0800 | i );  /* ʾ12345678 */
	EA = 1;  /* ж */
	TR0 = 1;  /* ɶʱ0ɼֵα */
	while ( 1 ) {  /* ָʼѭ,ȴPCв */
		if ( FLAG_RECV_OK ) {  /* յδ */
			CH451_Write( 0x0300 );  /* ʹCH451ʾһλ,ʾյδ */
		}
	}
}
