/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: 3ƴ+¼ж֪ͨ */
/* MCS-51ƬCʾ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */
/* ģ鹤USB豸ģʽ,λPC,ƬRAMֻҪʮֽ,ҪⲿRAM */
/* ʾUSB豸ģʽPCģʽл */

#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			65		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧65,Сֵ13 */
/* ģܻṤUSB豸ģʽ,ôMAX_PATH_LEN64,ΪλPCģ´ݰܴﵽ64ֽ */
#include "..\CH375HM.H"

/* ·ӷʽ,ֻҪ3,ʹôͬ
   Ƭ    ģ
    TXD   =  SIN
    RXD   =  SOUT
             STA# ջӸߵƽ
             INT# ӵػӵ͵ƽ
    GND   =  GND
*/

CMD_PARAM	idata	mCmdParam;			/* Ĭ¸ýṹռ60ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ԺΪλʱ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* һֽݸCH375ģ */
void	mSendByte( unsigned char c )
{
	TI = 0;
	SBUF = c;
	while ( TI == 0 );
}

/* CH375ģһֽ */
unsigned char	mRecvByte( )
{
	unsigned char	c;
	while ( RI == 0 );
	c = SBUF;
	RI = 0;
	return( c );
}

unsigned char	EventStatus = 0;	/* ִڼյ¼Զ֪ͨ¼״̬ */

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	unsigned char		i, j, status;
	mSendByte( SER_SYNC_CODE1 );  /* ʹ֪ͬͨģ,˵뿪ʼ,ʼִ */
	mSendByte( SER_SYNC_CODE2 );  /* ͬSTA#½ */
/* ͬӦ,,ôʱ䲻ܳ20mS,Ч */
	if ( RI ) EventStatus = SBUF;  /* յ¼Զ֪ͨ¼״̬,汸 */
	RI = 0;
	mSendByte( cmd );  /* д */
	mSendByte( len );  /* дĳ */
	if ( len ) {  /* в */
		for ( i = 0; i != len; i ++ ) mSendByte( mCmdParam.Other.mBuffer[ i ] );  /* д */
	}
	while ( 1 ) {  /* ݴ,ֱɲ˳ */
		status = mRecvByte( );  /* ȴģɲز״̬ */
		if ( status == ERR_SUCCESS ) {  /* ɹ */
			i = mRecvByte( );  /* ؽݵĳ */
			if ( i ) {  /* н */
				j = 0;
				do {  /* ʹdo+whileṹΪЧʸfor */
					mCmdParam.Other.mBuffer[ j ] = mRecvByte( );  /* սݲ浽ṹ */
					j ++;
				} while ( -- i );
			}
			break;  /* ɹ */
		}
		else if ( status == USB_INT_DISK_READ || status == USB_INT_DISK_WRITE || status == USB_INT_DISK_RETRY ) {  /* ڴU̶ݿ,ݶ,Uдݿ,д,дݿʧ */
			break;  /* ֻʹֽΪλļдӳ,²յ״̬,ʧܷ */
		}
		else {  /* ʧ */
			if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) mDelaymS( 100 );  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
			break;  /* ʧܷ */
		}
	}
	return( status );
}

/* ״̬,ʾ벢ͣ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
/*	printf( "Error: %02X\n", (unsigned short)iError );*/  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelaymS( 100 );
		led^=1;
	}
}

main( ) {
	unsigned char	es, i;
	unsigned short	len;
	unsigned char	*name;
	LED_OUT = 0;  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100,CH375ģϵҪ100ҵĸλʱ */
	mDelaymS( 100 );
	LED_OUT = 1;
/* CH375ģͨѶĴ */
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xE6;  /* 24MHz, 4800bps */
	TR1 = 1;
/* 4800bps,޸Ϊ9600bps */
	mCmdParam.BaudRate.mDivisor = 18432000/32/9600;  /* : ͨѶʳ,ٶģľX2ƵΪ18.432MHz */
	i = ExecCommand( CMD_BaudRate, 1 );  /* ôͨѶ */
	mStopIfError( i );
	TH1 = 0xF3;  /* 24MHz, ڵͨѶʵ9600bps */
	mDelaymS( 5 );  /* ʱ5,ȷCH375ģл趨ͨѶ */
/* CMD_BaudRate޸ģͨѶ,CMD_SetupModuleģ,¼Զ֪ͨ */
/* ڹʱӲʽֱָ,Ӷÿοִ */
	mCmdParam.Setup.mSetup = 0x01;  /* : ģֵ,λ0Ϊ1¼Զ֪ͨ,USBģʽ¿ʱѯU״̬Զ֪ͨ,USB豸ģʽ´ϴɹԶ֪ͨ */
	i = ExecCommand( CMD_SetupModule, 1 );  /* ģ */
	mStopIfError( i );

	mCmdParam.SetUsbMode.mUsbMode = 2;  /* USB豸ģʽ */
	i = ExecCommand( CMD_SetUsbMode, 1 );  /* ģĹģʽ */
	mStopIfError( i );

/*	printf( "Start USB Device\n" );*/
	while ( 1 ) {  /* USB豸ģʽѭ */
/*		printf( "Wait download & upload\n" );*/

		while ( 1 ) {  /* ȴģ¼֪ͨ */
			if ( RI == 1 ) {  /* ѯǷյģ¼֪ͨ,Ҳôڽжϴ */
				es = mRecvByte( );  /* ⵽PC´ϴɹ,Զ״̬֪ͨƬ */
				break;  /* ʼ */
			}
			else if ( EventStatus != 0 ) {  /* ϴִйյ¼״̬ */
				es = EventStatus; 
				EventStatus = 0;  /* 屣¼״̬ */
				break;  /* ʼ */
			}
			mDelaymS( 10 );  /* Ƭ */
		}
		if ( es == ERR_USB_DAT_DOWN ) {  /* ¼֪ͨ´ɹ,λ´Ѿģ */
/*			printf( "download ok\n" );*/
			i = ExecCommand( CMD_ReadUsbData, 0 );  /* ģ´˵ȡݿ */
			mStopIfError( i );
			if ( EventStatus != 0 ) continue;  /* ϴִйյ¼״̬,ȷ */
			for ( i = 0; i < mCmdParam.ReadUsbData.mByteCount; ++ i ) {
				mCmdParam.WriteUsbData.mByteBuffer[ i ] = ~ mCmdParam.WriteUsbData.mByteBuffer[ i ];  /* ʾ´ȡΪϴݷ */
			}
			mCmdParam.WriteUsbData.mByteCount = mCmdParam.ReadUsbData.mByteCount;
			i = ExecCommand( CMD_WriteUsbData, mCmdParam.WriteUsbData.mByteCount + 1 );  /* ģϴ˵дݿ */
			mStopIfError( i );
			if ( mCmdParam.ReadUsbData.mByteCount == 0 ) break;  /* ٶյ0ȵ´ʱ˳USB豸ģʽ,صUSBģʽ,ʵӦò˲ô˷ */
		}
		else if ( es == ERR_USB_DAT_UP ) {  /* ¼֪ͨϴɹ,ģеϴѾλȡ */
/*			printf( "upload ok\n" );*/
/*			Լϴ */
		}
	}

	mCmdParam.SetUsbMode.mUsbMode = 6;  /* USBģʽ */
	i = ExecCommand( CMD_SetUsbMode, 1 );  /* ģĹģʽ */
	mStopIfError( i );

/*	printf( "Start USB Host\n" );*/
	while ( 1 ) {  /* USBģʽѭ */
/*		printf( "Wait download & upload\n" );*/

		while ( 1 ) {  /* ȴģ¼֪ͨ */
			if ( RI == 1 ) {  /* ѯǷյģ¼֪ͨ,Ҳôڽжϴ */
				i = mRecvByte( );  /* ⵽Uӻ߶Ͽ,Զ״̬֪ͨƬ */
				if ( i == ERR_USB_CONNECT ) {  /* ¼֪ͨUѾ */
/*					printf( "Disk Connected\n" );*/
					break;
				}
				else if ( i == ERR_DISK_DISCON ) {  /* ¼֪ͨUѾϿ */
/*					printf( "Disk Disconnected\n" );*/
				}
			}
			mDelaymS( 100 );  /* ڴдUʱٲѯ,ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}

		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( es = 0; es < 5; es ++ ) {
			mDelaymS( 100 );
//			printf( "Ready ?\n" );
			i = ExecCommand( CMD_DiskReady, 0 );  /* ѯǷ׼ */
			if ( i == ERR_SUCCESS ) break;
		}
/* ȴļ,ļ,½һ */
		name = "/MY_ADC.TXT";  /* ļ,б˵ǴӸĿ¼ʼ */
/*		printf( "Open\n" );*/
		strcpy( mCmdParam.Open.mPathName, name );  /* ԭļ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		if ( i == ERR_MISS_FILE ) {  /* ERR_MISS_FILE˵ûҵļ,½һ */
/*			printf( "Create\n" );*/
			strcpy( mCmdParam.Create.mPathName, name );  /* ļ,ڸĿ¼ */
			i = ExecCommand( CMD_FileCreate, MAX_PATH_LEN );  /* ½ļ,ļѾɾ½ */
			mStopIfError( i );
		}
		else {  /* ҵļ,˵ļѴ,Ϊ㸲ԭ,ƶļָ뵽ĩβ,Ա׷ */
			mStopIfError( i );
			mCmdParam.ByteLocate.mByteOffset = 0xFFFFFFFF;  /* ƶļβ,CMD_FileOpenļ,׷ݵѴļĩβ */
			i = ExecCommand( CMD_ByteLocate, 4 );  /* ֽΪλƶļָ */
			mStopIfError( i );
		}
/*		printf( "Write or append data\n" );*/
		strcpy( mCmdParam.ByteWrite.mByteBuffer, "ֻʾһUSBUSB豸ģʽлĹ\xd\xa" );
		len = strlen( mCmdParam.ByteWrite.mByteBuffer );  /* ַ */
		mCmdParam.ByteWrite.mByteCount = len;  /* ԭļе20ֽڵӵļĩβ */
		i = ExecCommand( CMD_ByteWrite, len+1 );  /* ֽΪλļд */
		mStopIfError( i );
/*		printf( "Close\n" );*/
		mCmdParam.Close.mUpdateLen = 1;  /* Զļ,ֽΪλļдݺ,û0ȵCMD_ByteWriteļ,ôڹرļʱģԶļ */
		i = ExecCommand( CMD_FileClose, 1 );  /* رļ,ֽΪλļд(׷)ݺ,ļرļ */
		mStopIfError( i );

/* ȴU̶Ͽ */
		LED_OUT = 1;  /* LED */
		while ( 1 );
	}
}
