/* 2004.06.05
****************************************
**  Copyright  (C)  W.ch  1999-2004   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Module      @CH375  **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* Uļдģ, ӷʽ: 3ƴ+ѯ */
/* MCS-51ƬCʾ */
/* ΪʹUļдģʹUļӳ,ռýٵĵƬԴ,ʹ89C51Ƭ */
/* ֽΪλUļд,ƬRAMֻҪʮֽ,ҪⲿRAM */

#include <reg51.h>
#include <absacc.h>
#include <string.h>
#include <stdio.h>

#define MAX_PATH_LEN			32		/* ·,бָܷСԼ·00H,CH375ģֵֵ֧62,Сֵ13 */
#include "..\CH375HM.H"

/* ·ӷʽ,ֻҪ3,ʹôͬ
   Ƭ    ģ
    TXD   =  SIN
    RXD   =  SOUT
             STA# ջӸߵƽ
             INT# ӵػӵ͵ƽ
    GND   =  GND
*/
sbit	P15					=	P1^5;

CMD_PARAM	idata	mCmdParam;			/* Ĭ¸ýṹռ60ֽڵRAM,޸MAX_PATH_LEN,޸Ϊ32ʱ,ֻռ32ֽڵRAM */
unsigned char		TempLength;			/* ʱеݳ,ԭļеڶζֽ */
unsigned char idata	TempBuffer[20];		/* ʱ,Ŵԭļж */

sbit	LED_OUT		=	P1^4;			/* P1.4 ͵ƽLEDʾ,ڼʾĽ */

/* ԺΪλʱ,24MHzʱ */
void	mDelaymS( unsigned char delay )
{
	unsigned char	i, j, c;
	for ( i = delay; i != 0; i -- ) {
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
		for ( j = 200; j != 0; j -- ) c += 3;  /* 24MHzʱʱ500uS */
	}
}

/* һֽݸCH375ģ */
void	mSendByte( unsigned char c )
{
	TI = 0;
	SBUF = c;
	while ( TI == 0 );
}

/* CH375ģһֽ */
unsigned char	mRecvByte( )
{
	unsigned char	c;
	while ( RI == 0 );
	c = SBUF;
	RI = 0;
	return( c );
}

/* ִ */
unsigned char	ExecCommand( unsigned char cmd, unsigned char len )
/* ,ز״̬,ͷزCMD_PARAMṹ */
{
	unsigned char		i, j, status;
	mSendByte( SER_SYNC_CODE1 );  /* ʹ֪ͬͨģ,˵뿪ʼ,ʼִ */
	mSendByte( SER_SYNC_CODE2 );  /* ͬSTA#½ */
/* ͬӦ,,ôʱ䲻ܳ20mS,Ч */
	RI = 0;
	mSendByte( cmd );  /* д */
	mSendByte( len );  /* дĳ */
	if ( len ) {  /* в */
		for ( i = 0; i != len; i ++ ) mSendByte( mCmdParam.Other.mBuffer[ i ] );  /* д */
	}
	while ( 1 ) {  /* ݴ,ֱɲ˳ */
		status = mRecvByte( );  /* ȴģɲز״̬ */
		if ( status == ERR_SUCCESS ) {  /* ɹ */
			i = mRecvByte( );  /* ؽݵĳ */
			if ( i ) {  /* н */
				j = 0;
				do {  /* ʹdo+whileṹΪЧʸfor */
					mCmdParam.Other.mBuffer[ j ] = mRecvByte( );  /* սݲ浽ṹ */
					j ++;
				} while ( -- i );
			}
			break;  /* ɹ */
		}
		else if ( status == USB_INT_DISK_READ || status == USB_INT_DISK_WRITE || status == USB_INT_DISK_RETRY ) {  /* ڴU̶ݿ,ݶ,Uдݿ,д,дݿʧ */
			break;  /* ֻʹֽΪλļдӳ,²յ״̬,ʧܷ */
		}
		else {  /* ʧ */
			if ( status == ERR_DISK_DISCON || status == ERR_USB_CONNECT ) mDelaymS( 100 );  /* U̸ոӻ߶Ͽ,Ӧʱʮٲ */
			break;  /* ʧܷ */
		}
	}
	return( status );
}

/* ״̬,ʾ벢ͣ */
void	mStopIfError( unsigned char iError )
{
	unsigned char	led;
	if ( iError == ERR_SUCCESS ) return;  /* ɹ */
/*	printf( "Error: %02X\n", (unsigned short)iError );*/  /* ʾ */
	led=0;
	while ( 1 ) {
		LED_OUT = led&1;  /* LED˸ */
		mDelaymS( 100 );
		led^=1;
	}
}

main( ) {
	unsigned char	i;
	unsigned short	count;
	unsigned char	*pStr;
	LED_OUT = 0;  /* LEDһʾ */
	mDelaymS( 100 );  /* ʱ100,CH375ģϵҪ100ҵĸλʱ */
	mDelaymS( 100 );
	LED_OUT = 1;
/* CH375ģͨѶĴ */
	SCON = 0x50;
	PCON = 0x80;
	TMOD = 0x20;
	TH1 = 0xE6;  /* 24MHz, 4800bps */
	TR1 = 1;
/* 4800bps,޸Ϊ9600bps */
	mCmdParam.BaudRate.mDivisor = 18432000/32/9600;  /* : ͨѶʳ,ٶģľX2ƵΪ18.432MHz */
	i = ExecCommand( CMD_BaudRate, 1 );  /* ôͨѶ */
	mStopIfError( i );
	TH1 = 0xF3;  /* 24MHz, ڵͨѶʵ9600bps */
	mDelaymS( 5 );  /* ʱ5,ȷCH375ģл趨ͨѶ */
/*	printf( "Start\n" );*/
	while ( 1 ) {  /* ѭ */
/*		printf( "Wait\n" );*/
		while ( 1 ) {  /* ʹòѯʽUǷ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus >= DISK_CONNECT ) break;  /* UѾ */
			mDelaymS( 100 );  /* ڴдUʱٲѯ,ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		mDelaymS( 200 );  /* ʱ,ѡ,еUSB洢Ҫʮʱ */
		LED_OUT = 0;  /* LED */
/* UǷ׼,U̲Ҫһ,ĳЩU̱Ҫִһܹ */
		for ( i = 0; i < 5; i ++ ) {
			mDelaymS( 100 );
//			printf( "Ready ?\n" );
			if ( ExecCommand( CMD_DiskReady, 0 ) == ERR_SUCCESS ) break;  /* ѯǷ׼ */
		}
/* ȡԭļ */
/*		printf( "Open\n" );*/
		strcpy( mCmdParam.Open.mPathName, "\\C51\\CH375HFT.C" );  /* ļ,ļC51Ŀ¼ */
		i = ExecCommand( CMD_FileOpen, MAX_PATH_LEN );  /* ļ,Ϊֵ,ʡټ */
		TempLength = 0;
		if ( i == ERR_MISS_DIR || i == ERR_MISS_FILE ) {  /* ERR_MISS_DIR˵ûҵC51Ŀ¼,ERR_MISS_FILE˵ûҵļ */
//			printf( "Ҳԭļ/C51/CH375HFT.C\n" );
		}
		else {  /* ҵļ\C51\CH375HFT.C߳ */
			mStopIfError( i );
			mCmdParam.ByteRead.mByteCount = 6;  /* 6ֽ, ζдĳȲܳ sizeof( mCmdParam.ByteWrite.mByteBuffer ) */
			i = ExecCommand( CMD_ByteRead, 1 );  /* ֽΪλȡ */
			mStopIfError( i );
//			printf( "ļжǰ6ַ[" );
//			for ( i=0; i!=mCmdParam.ByteRead.mByteCount; i++ ) printf( "%C", mCmdParam.ByteRead.mByteBuffer[i] );
//			printf( "]\n" );
//			if ( mCmdParam.ByteRead.mByteCount<6 ) printf( "Ѿļĩβ\n" );
			if ( mCmdParam.ByteRead.mByteCount==6 ) {  /* δļĩβ */
				mCmdParam.ByteRead.mByteCount = 20;  /* ٶ20ֽ, ζдĳȲܳ sizeof( mCmdParam.ByteWrite.mByteBuffer ) */
				i = ExecCommand( CMD_ByteRead, 1 );  /* ֽΪλȡ,Ÿղŵ */
				mStopIfError( i );
				TempLength = mCmdParam.ByteRead.mByteCount;  /* ڶζֽ */
				memcpy( TempBuffer, mCmdParam.ByteRead.mByteBuffer, TempLength );  /* ݴڶζԱдļ */
//				printf( "ļжĵ6ַʼ[" );
//				for ( i=0; i!=mCmdParam.ByteRead.mByteCount; i++ ) printf( "%C", mCmdParam.ByteRead.mByteBuffer[i] );
//				printf( "]\n" );
//				if ( mCmdParam.ByteRead.mByteCount<20 ) printf( "Ѿļĩβ\n" );
			}
/*			printf( "Close\n" );*/
			mCmdParam.Close.mUpdateLen = 0;
			i = ExecCommand( CMD_FileClose, 1 );  /* رļ */
			mStopIfError( i );
		}
/* ļ */
/*		printf( "Create\n" );*/
/*		strcpy( mCmdParam.Create.mPathName, "\\NEWFILE.TXT" );*/
		strcpy( mCmdParam.Create.mPathName, "\\˫Ұ.TXT" );  /* ļ,ڸĿ¼ */
		i = ExecCommand( CMD_FileCreate, MAX_PATH_LEN );  /* ½ļ,ļѾɾ½ */
		mStopIfError( i );
/*		printf( "ByteLocate\n" );*/
//		mCmdParam.ByteLocate.mByteOffset = 0;  /* ƶļͷ,»صļͷ,Աдݸԭ */
//		ExecCommand( CMD_ByteLocate, 4 );  /* ֽΪλƶļָ */
//		mCmdParam.ByteLocate.mByteOffset = 0xFFFFFFFF;  /* ƶļβ,CMD_FileOpenļ,׷ݵѴļĩβ */
//		ExecCommand( CMD_ByteLocate, 4 );  /* ֽΪλƶļָ */
/*		printf( "Write\n" );*/
		pStr = "Note: \xd\xaֽΪλUļд,ƬֻҪмʮֽڵRAM,ҪⲿRAM,\xd\xaȴ/C51/CH375HFT.Cļжǰ20ַ,Ȼд˵һ\xd\xa";
		count = strlen( pStr );  /* ׼дݵܳ */
		while ( count ) {  /* ϴ,ֶд */
			if ( count < sizeof( mCmdParam.ByteWrite.mByteBuffer ) ) i = count;  /* ֻʣһЩҪд */
			else i = sizeof( mCmdParam.ByteWrite.mByteBuffer );  /* ݽ϶,ֶд */
			count -= i;  /*  */
			memcpy( mCmdParam.ByteWrite.mByteBuffer, pStr, i );  /* ׼дݵṹ,ԴݿADC,Գռ˵Ϣ */
			pStr += i;
			mCmdParam.ByteWrite.mByteCount = i;  /* ָдֽ */
			i = ExecCommand( CMD_ByteWrite, 1+i );  /* ֽΪλļд */
			mStopIfError( i );
		}
//		mCmdParam.ByteWrite.mByteCount = 0;  /* ָд0ֽ,ˢļĳ,עֽΪ0ôCMD_ByteWriteֻдݶ޸ļ */
//		ExecCommand( CMD_ByteWrite, 1 );  /* ֽΪλļд,Ϊ0ֽд,ֻڸļĳ,׶дݺ,ְ취ļ */
		memcpy( mCmdParam.ByteWrite.mByteBuffer, TempBuffer, TempLength );
		mCmdParam.ByteWrite.mByteCount = TempLength;  /* ԭļе20ֽڵӵļĩβ */
		i = ExecCommand( CMD_ByteWrite, 1+TempLength );  /* ֽΪλļд */
		mStopIfError( i );
/*		printf( "Close\n" );*/
		mCmdParam.Close.mUpdateLen = 1;  /* Զļ,ֽΪλļдݺ,û0ȵCMD_ByteWriteļ,ôڹرļʱģԶļ */
		i = ExecCommand( CMD_FileClose, 1 );  /* رļ,ֽΪλļд(׷)ݺ,ļرļ */
		mStopIfError( i );

/* ȴU̶Ͽ */
/*		printf( "Take_out\n" );*/
		while ( 1 ) {  /* ʹòѯʽUǷϿ */
			i = ExecCommand( CMD_QueryStatus, 0 );  /* ѯǰģ״̬ */
			mStopIfError( i );
			if ( mCmdParam.Status.mDiskStatus <= DISK_DISCONNECT ) break;  /* UѾϿ */
			mDelaymS( 100 );  /* ûбҪһֱͣزѯ,õƬ,û¿ʱȴһٲѯ */
		}
		LED_OUT = 1;  /* LED */
	}
}
