/* CH374оƬ Ӧò V1.0 */
/* USB,йRoot-HUBӦ,ʼöٵǰӵUSB豸,ͬʱ֧3USB豸,֧һⲿHUB */

#include	<stdio.h>
#include	<string.h>
#include	"..\HAL.H"			// MCS51ΪƬ޸HAL*Ӳļļ
#include	"..\HAL_BASE.C"	// ӳжϲѯӳ

/* Ӳӿڲ,ӷʽѡһ */
//#include "..\PARA_HW.C"	/* Ӳ׼8λ */
//#include "..\PARA_SW.C"	/* I/Oģ8λ */
//#include "..\SPI_HW.C"	/* Ӳ׼4SPI */
#include "..\SPI_SW.C"	/* I/Oģ4SPI */
//#include "..\SPI3_SW.C"	/* I/Oģ3SPI,SDOSDIһ */

#include "EX_HUB.H"		// йⲿHUBĶ

// ȡ豸
const	UINT8C	SetupGetDevDescr[] = { 0x80, 0x06, 0x00, 0x01, 0x00, 0x00, 0x12, 0x00 };
// ȡ
const	UINT8C	SetupGetCfgDescr[] = { 0x80, 0x06, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00 };
// USBַ
const	UINT8C	SetupSetUsbAddr[] = { 0x00, 0x05, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00 };
// USB
const	UINT8C	SetupSetUsbConfig[] = { 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

UINT8	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;	/* USB豸Ķ˵0ߴ */

//USB豸ϢCH374U֧3豸
#define		ROOT_DEV_DISCONNECT		0
#define		ROOT_DEV_CONNECTED		1
#define		ROOT_DEV_FAILED			2
#define		ROOT_DEV_SUCCESS		3
struct _RootHubDev{
	UINT8	DeviceStatus;			// 豸״̬,0-豸,1-豸δʼ,2-豸ʼöʧ,3-豸ҳʼöٳɹ
	UINT8	DeviceAddress;			// 豸USBַ
	UINT8	DeviceSpeed;			// 0Ϊ,0Ϊȫ
	UINT8	DeviceType;				// 豸
//	union {
//		struct MOUSE {
//			UINT8	MouseInterruptEndp;		// ж϶˵
//			UINT8	MouseIntEndpTog;		// ж϶˵ͬ־
//			UINT8	MouseIntEndpSize;		// ж϶˵ĳ
//		}
//		struct PRINT {
//		}
//	}
//.....    struct  _Endp_Attr   Endp_Attr[4];	//˵,֧4˵
	UINT8	GpVar;					// ͨñ
} idata RootHubDev[3];

struct _DevOnHubPort{
	UINT8	DeviceStatus;			// 豸״̬,0-豸,1-豸δʼ,2-豸ʼöʧ,3-豸ҳʼöٳɹ
	UINT8	DeviceAddress;			// 豸USBַ
	UINT8	DeviceSpeed;			// 0Ϊ,0Ϊȫ
	UINT8	DeviceType;				// 豸
//.....    struct  _Endp_Attr   Endp_Attr[4];	//˵,֧4˵
	UINT8	GpVar;					// ͨñ
} idata DevOnHubPort[3][4];  // ٶ:ⲿHUB,ÿⲿHUB4˿(˲)

UINT8	NewDevCount;
UINT8	xdata	CtrlBuf[8];
UINT8	xdata	TempBuf[64];

// CH374ĿĶ˵ַ/PID/ͬ־ͬCH375NAKԣʱ/
UINT8	HostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog );

// CH374ĿĶ˵ַ/PID/ͬ־/mSΪλNAKʱ(0xFFFF)ͬCH375NAKԣʱ
UINT8	WaitHostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog, UINT16 timeout );

UINT8	HostCtrlTransfer374( PUINT8 ReqBuf, PUINT8 DatBuf, PUINT8 RetLen );  // ִпƴ,ReqBufָ8ֽ,DatBufΪշ
// ҪպͷݣôDatBufָЧڴźݣʵʳɹշܳȱReqLenָֽڱ

void	HostDetectInterrupt( void );  // USB豸¼ж

void	SetHostUsbAddr( UINT8 addr );  // USBǰUSB豸ַ

void	HostEnableRootHub( void );  // õRoot-HUB

void	Init374Host( void );  // ʼUSB

UINT8	GetDeviceDescr( PUINT8 buf );  // ȡ豸

UINT8	GetConfigDescr( PUINT8 buf );  // ȡ

UINT8	SetUsbAddress( UINT8 addr );  // USB豸ַ

UINT8	SetUsbConfig( UINT8 cfg );  // USB豸

UINT8	GetHubDescriptor( void );  // ȡHUB

UINT8	GetPortStatus( UINT8 port );  // ѯHUB˿״̬

UINT8	SetPortFeature( UINT8 port, UINT8 select );

UINT8	ClearPortFeature( UINT8 port, UINT8 select );

void	DisableRootHubPort( UINT8 index );  // رָROOT-HUB˿,ʵӲѾԶر,˴ֻһЩṹ״̬

void	ResetRootHubPort( UINT8 index );  // ⵽豸,λӦ˿ڵ,Ϊö豸׼,ΪĬΪȫ

BOOL	EnableRootHubPort( UINT8 index );  // ʹROOT-HUB˿,ӦBIT_HUB?_EN1˿,FALSEʧ(豸Ͽ)

void	SetUsbSpeed( BOOL FullSpeed );  // õǰUSBٶ

void	SelectHubPort( UINT8 HubIndex, UINT8 PortIndex );  // PortIndex=0ѡָROOT-HUB˿,ѡָROOT-HUB˿ڵⲿHUBָ˿

void	AnalyzeRootHub( void );   // ROOT-HUB״̬,ROOT-HUB˿ڵ豸¼
//HUB˿ڵĲ¼豸γеDisableHubPort()˿ڹرգ¼Ӧ˿ڵ״̬λ

UINT8	AnalyzeHidIntEndp( void );  // зHIDж϶˵ĵַ

UINT8	InitDevice( UINT8 index );  // ʼ/öָROOT-HUB˿ڵUSB豸

UINT8	HubPortEnum( UINT8 index );  // öָROOT-HUB˿ϵⲿHUBĸ˿,˿ӻƳ¼

UINT8	Level2DevEnum( UINT8 HubIndex, UINT8 PortIndex );  // ʼöⲿHUBĶUSB豸

UINT8	SearchRootHubPort( UINT8 type );  // ָ͵豸ڵĶ˿ں,˿ںΪ0xFFδ

UINT16	SearchAllHubPort( UINT8 type );  // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں,˿ںΪ0xFFFFδ
// 8λΪROOT-HUB˿ں,8λΪⲿHUBĶ˿ں,8λΪ0豸ֱROOT-HUB˿


// CH374ĿĶ˵ַ/PID/ͬ־ͬCH375NAKԣʱ/
UINT8	HostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog )
{  // ӳ,ʵӦ,Ϊṩٶ,ӦöԱӳŻ
	UINT8	retry;
	UINT8	s, r;
	for ( retry = 0; retry < 3; retry ++ ) {
		Write374Byte( REG_USB_H_PID, M_MK_HOST_PID_ENDP( pid, endp_addr ) );  // ָPIDĿĶ˵
//		Write374Byte( REG_USB_H_CTRL, BIT_HOST_START | ( tog ? ( BIT_HOST_TRAN_TOG | BIT_HOST_RECV_TOG ) : 0x00 ) );  // ͬ־
		Write374Byte( REG_USB_H_CTRL, ( tog ? ( BIT_HOST_START | BIT_HOST_TRAN_TOG | BIT_HOST_RECV_TOG ) : BIT_HOST_START ) );  // ͬ־
//		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE );  // ȡͣ
		s = Wait374Interrupt( );
		if ( s == ERR_USB_UNKNOWN ) return( s );  // жϳʱ,Ӳ쳣
		s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
		if ( s & BIT_IF_DEV_DETECT ) {  // USB豸¼
//			mDelayuS( 200 );  // ȴ
			AnalyzeRootHub( );   // ROOT-HUB״̬
			Write374Byte( REG_INTER_FLAG, BIT_IF_DEV_DETECT );  // жϱ־
			s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
			if ( ( s & BIT_IF_DEV_ATTACH ) == 0x00 ) return( USB_INT_DISCONNECT );  // USB豸Ͽ¼
		}
		if ( s & BIT_IF_TRANSFER ) {  // 
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_TRANSFER );  // жϱ־
			s = Read374Byte( REG_USB_STATUS );  // USB״̬
			r = s & BIT_STAT_DEV_RESP;  // USB豸Ӧ״̬
			switch ( pid ) {
				case DEF_USB_PID_SETUP:
				case DEF_USB_PID_OUT:
					if ( r == DEF_USB_PID_ACK ) return( USB_INT_SUCCESS );
					else if ( r == DEF_USB_PID_STALL || r == DEF_USB_PID_NAK ) return( r | 0x20 );
					else if ( ! M_IS_HOST_TIMEOUT( s ) ) return( r | 0x20 );  // ǳʱ/Ӧ
					break;
				case DEF_USB_PID_IN:
					if ( M_IS_HOST_IN_DATA( s ) ) {  // DEF_USB_PID_DATA0 or DEF_USB_PID_DATA1
						if ( s & BIT_STAT_TOG_MATCH ) return( USB_INT_SUCCESS );  // ͬ趪
					}
					else if ( r == DEF_USB_PID_STALL || r == DEF_USB_PID_NAK ) return( r | 0x20 );
					else if ( ! M_IS_HOST_TIMEOUT( s ) ) return( r | 0x20 );  // ǳʱ/Ӧ
					break;
				default:
					return( ERR_USB_UNKNOWN );  // ܵ
					break;
			}
		}
		else {  // ж,Ӧ÷
			mDelayuS( 200 );  // ȴ
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  /* жϱ־ */
			if ( retry ) return( ERR_USB_UNKNOWN );  /* ǵһμ⵽򷵻ش */
		}
	}
	return( 0x20 );  // Ӧʱ
}

// CH374ĿĶ˵ַ/PID/ͬ־/mSΪλNAKʱ(0xFFFF)ͬCH375NAKԣʱ
UINT8	WaitHostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog, UINT16 timeout )
{
	UINT8	i, s;
	while ( 1 ) {
		for ( i = 0; i < 40; i ++ ) {
			s = HostTransact374( endp_addr, pid, tog );
			if ( s != ( DEF_USB_PID_NAK | 0x20 ) || timeout == 0 ) return( s );
			mDelayuS( 20 );
		}
		if ( timeout < 0xFFFF ) timeout --;
	}
}

UINT8	HostCtrlTransfer374( PUINT8 ReqBuf, PUINT8 DatBuf, PUINT8 RetLen )  // ִпƴ,ReqBufָ8ֽ,DatBufΪշ
// ҪպͷݣôDatBufָЧڴźݣʵʳɹշܳȱReqLenָֽڱ
{
	UINT8	s, len, count, total;
	BOOL	tog;
	Write374Block( RAM_HOST_TRAN, 8, ReqBuf );
	Write374Byte( REG_USB_LENGTH, 8 );
	mDelayuS( 200 );
	s = WaitHostTransact374( 0, DEF_USB_PID_SETUP, FALSE, 200 );  // SETUP׶Σ200mSʱ
	if ( s == USB_INT_SUCCESS ) {  // SETUPɹ
		tog = TRUE;  // ĬDATA1,Ĭݹ״̬׶ΪIN
		total = *( ReqBuf + 6 );
		if ( total && DatBuf ) {  // Ҫշ
			len = total;
			if ( *ReqBuf & 0x80 ) {  // 
				while ( len ) {
					mDelayuS( 200 );
					s = WaitHostTransact374( 0, DEF_USB_PID_IN, tog, 200 );  // IN
					if ( s != USB_INT_SUCCESS ) break;
					count = Read374Byte( REG_USB_LENGTH );
					Read374Block( RAM_HOST_RECV, count, DatBuf );
					DatBuf += count;
					if ( count <= len ) len -= count;
					else len = 0;
					if ( count == 0 || ( count & ( UsbDevEndpSize - 1 ) ) ) break;  // ̰
					tog = tog ? FALSE : TRUE;
				}
				tog = FALSE;  // ״̬׶ΪOUT
			}
			else {  // 
				while ( len ) {
					mDelayuS( 200 );
					count = len >= UsbDevEndpSize ? UsbDevEndpSize : len;
					Write374Block( RAM_HOST_TRAN, count, DatBuf );
					Write374Byte( REG_USB_LENGTH, count );
					s = WaitHostTransact374( 0, DEF_USB_PID_OUT, tog, 200 );  // OUT
					if ( s != USB_INT_SUCCESS ) break;
					DatBuf += count;
					len -= count;
					tog = tog ? FALSE : TRUE;
				}
				tog = TRUE;  // ״̬׶ΪIN
			}
			total -= len;  // ȥʣ೤ȵʵʴ䳤
		}
		if ( s == USB_INT_SUCCESS ) {  // ݽ׶γɹ
			Write374Byte( REG_USB_LENGTH, 0 );
			mDelayuS( 200 );
			s = WaitHostTransact374( 0, ( tog ? DEF_USB_PID_IN : DEF_USB_PID_OUT ), TRUE, 200 );  // STATUS׶
			if ( tog && s == USB_INT_SUCCESS ) {  // IN״̬ݳ
				if ( Read374Byte( REG_USB_LENGTH ) ) s = USB_INT_BUF_OVER;  // ״̬׶δ
			}
		}
	}
	if ( RetLen ) *RetLen = total;  // ʵʳɹշܳ
	return( s );
}

void	HostDetectInterrupt( void )  // USB豸¼ж
{
	UINT8	s;
	s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
	if ( s & BIT_IF_DEV_DETECT ) {  // USB豸¼
		AnalyzeRootHub( );   // ROOT-HUB״̬
		Write374Byte( REG_INTER_FLAG, BIT_IF_DEV_DETECT );  // жϱ־
	}
	else {  // ж
		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_TRANSFER | BIT_IF_USB_SUSPEND | BIT_IF_WAKE_UP );  // жϱ־
	}
}

void	SetHostUsbAddr( UINT8 addr )  // USBǰUSB豸ַ
{
	Write374Byte( REG_USB_ADDR, addr );
}

void	HostEnableRootHub( void )  // õRoot-HUB
{
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_FREE( Read374Byte( REG_USB_SETUP ) ) );  // USB߿
	Write374Byte( REG_USB_SETUP, BIT_SETP_HOST_MODE | BIT_SETP_AUTO_SOF );  // USBʽ,SOF
	Write374Byte( REG_HUB_SETUP, 0x00 );  // BIT_HUB_DISABLE,õROOT-HUB
	Write374Byte( REG_HUB_CTRL, 0x00 );  // ROOT-HUBϢ
}

void	Init374Host( void )  // ʼUSB
{
	Write374Byte( REG_USB_SETUP, 0x00 );
	SetHostUsbAddr( 0x00 );
	Write374Byte( REG_USB_H_CTRL, 0x00 );
	Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  // жϱ־
//	Write374Byte( REG_INTER_EN, BIT_IE_TRANSFER );  // ж,ΪʹòѯʽUSB豸,USB豸ж
	Write374Byte( REG_INTER_EN, BIT_IE_TRANSFER | BIT_IE_DEV_DETECT );  // жϺUSB豸ж
	Write374Byte( REG_SYS_CTRL, BIT_CTRL_OE_POLAR );  // CH374TUENյCH374SBIT_CTRL_OE_POLARΪ1
	Write374Byte( REG_USB_SETUP, BIT_SETP_HOST_MODE );  // USBʽ
	HostEnableRootHub( );  // õRoot-HUB
}

UINT8	GetDeviceDescr( PUINT8 buf )  // ȡ豸
{
	UINT8	s, len;
	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;
	s = HostCtrlTransfer374( SetupGetDevDescr, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		UsbDevEndpSize = ( (PUSB_DEV_DESCR)buf ) -> bMaxPacketSize0;  // ˵0,Ǽ򻯴,ӦȻȡǰ8ֽںUsbDevEndpSizeټ
		if ( len < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL ) s = USB_INT_BUF_OVER;  // ȴ
	}
	return( s );
}

UINT8	GetConfigDescr( PUINT8 buf )  // ȡ
{
	UINT8	s, len;
	s = HostCtrlTransfer374( SetupGetCfgDescr, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		if ( len < ( (PUSB_SETUP_REQ)SetupGetCfgDescr ) -> wLengthL ) s = USB_INT_BUF_OVER;  // سȴ
		else {
			len = ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL;
			memcpy ( CtrlBuf, SetupGetCfgDescr, sizeof( SetupGetCfgDescr ) );
			( (PUSB_SETUP_REQ)CtrlBuf ) -> wLengthL = len;  // ܳ
			s = HostCtrlTransfer374( CtrlBuf, buf, &len );  // ִпƴ
			if ( s == USB_INT_SUCCESS ) {
				if ( len < ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL ) s = USB_INT_BUF_OVER;  // ȴ
			}
		}
	}
	return( s );
}

UINT8	SetUsbAddress( UINT8 addr )  // USB豸ַ
{
	UINT8	s;
	memcpy ( CtrlBuf, SetupSetUsbAddr, sizeof( SetupSetUsbAddr ) );
	( (PUSB_SETUP_REQ)CtrlBuf ) -> wValueL = addr;  // USB豸ַ
	s = HostCtrlTransfer374( CtrlBuf, NULL, NULL );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		SetHostUsbAddr( addr );  // USBǰUSB豸ַ
	}
	mDelaymS( 10 );  // ȴUSB豸ɲ
	return( s );
}

UINT8	SetUsbConfig( UINT8 cfg )  // USB豸
{
	memcpy ( CtrlBuf, SetupSetUsbConfig, sizeof( SetupSetUsbConfig ) );
	( (PUSB_SETUP_REQ)CtrlBuf ) -> wValueL = cfg;  // USB豸
	return( HostCtrlTransfer374( CtrlBuf, NULL, NULL ) );  // ִпƴ
}

UINT8	GetHubDescriptor( void )  // ȡHUB
{
	UINT8 s,len;
	CtrlBuf[0] = GET_HUB_DESCRIPTOR;
	CtrlBuf[1] = GET_DESCRIPTOR;
	CtrlBuf[2] = 0x00;
	CtrlBuf[3] = 0x29;
	CtrlBuf[4] = 0x00;
	CtrlBuf[5] = 0x00;
	CtrlBuf[6] = 0x01;
	CtrlBuf[7] = 0x00;
	s = HostCtrlTransfer374( CtrlBuf, TempBuf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS )
	{
		CtrlBuf[6] = TempBuf[0];
		CtrlBuf[0] = GET_HUB_DESCRIPTOR;
		CtrlBuf[1] = GET_DESCRIPTOR;
		CtrlBuf[2] = 0x00;
		CtrlBuf[3] = 0x29;
		CtrlBuf[4] = 0x00;
		CtrlBuf[5] = 0x00;
		CtrlBuf[7] = 0x00;
		s = HostCtrlTransfer374( CtrlBuf, TempBuf, &len );  // ִпƴ
	}
	return s;
}

UINT8	GetPortStatus( UINT8 port )  // ѯHUB˿״̬
{
	UINT8 s,len;
	CtrlBuf[0] = GET_PORT_STATUS;
	CtrlBuf[1] = GET_STATUS;
	CtrlBuf[2] = 0x00;
	CtrlBuf[3] = 0x00;
	CtrlBuf[4] = port;
	CtrlBuf[5] = 0x00;
	CtrlBuf[6] = 4;
	CtrlBuf[7] = 0x00;
	s = HostCtrlTransfer374( CtrlBuf, TempBuf, &len );  // ִпƴ
	return s;
}

UINT8	SetPortFeature( UINT8 port, UINT8 select )
{
	UINT8 s,len;
	CtrlBuf[0] = SET_PORT_FEATURE;
	CtrlBuf[1] = SET_FEATURE;
	CtrlBuf[2] = select;
	CtrlBuf[3] = 0x00;
	CtrlBuf[4] = port;
	CtrlBuf[5] = 0x00;
	CtrlBuf[6] = 0x00;
	CtrlBuf[7] = 0x00;
	s = HostCtrlTransfer374( CtrlBuf, TempBuf, &len );  // ִпƴ
	return s;
}

UINT8	ClearPortFeature( UINT8 port, UINT8 select )
{
	UINT8 s,len;
	CtrlBuf[0] = CLEAR_PORT_FEATURE;
	CtrlBuf[1] = CLEAR_FEATURE;
	CtrlBuf[2] = select;
	CtrlBuf[3] = 0x00;
	CtrlBuf[4] = port;
	CtrlBuf[5] = 0x00;
	CtrlBuf[6] = 0x00;
	CtrlBuf[7] = 0x00;
	s = HostCtrlTransfer374( CtrlBuf, TempBuf, &len );  // ִпƴ
	return s;

}

void	DisableRootHubPort( UINT8 index )  // رָROOT-HUB˿,ʵӲѾԶر,˴ֻһЩṹ״̬
{
	RootHubDev[ index ].DeviceStatus = ROOT_DEV_DISCONNECT;
	RootHubDev[ index ].DeviceAddress = 0x00;
	if ( index == 1 ) Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL)&0xF0 );  // йHUB1Ŀ,ʵϲҪ
	else if ( index == 2 ) Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL)&0x0F );  // йHUB2Ŀ,ʵϲҪ
	else Write374Byte( REG_HUB_SETUP, Read374Byte(REG_HUB_SETUP)&0xF0 );  // йHUB0Ŀ,ʵϲҪ
//	printf( "HUB %01x close\n",(UINT16)index );
}

void	ResetRootHubPort( UINT8 index )  // ⵽豸,λӦ˿ڵ,Ϊö豸׼,ΪĬΪȫ
{
	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;  /* USB豸Ķ˵0ߴ */
	SetHostUsbAddr( 0x00 );
	Write374Byte( REG_USB_H_CTRL, 0x00 );
	if ( index == 1 ) {
		Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL) & ~ BIT_HUB1_POLAR | BIT_HUB1_RESET );  // ĬΪȫ,ʼλ
		mDelaymS( 15 );																 // λʱ10mS20mS
		Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL) & ~ BIT_HUB1_RESET );  // λ
	}
	else if ( index == 2 ) {
		Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL) & ~ BIT_HUB2_POLAR | BIT_HUB2_RESET );  // ĬΪȫ,ʼλ
		mDelaymS( 15 );																 // λʱ10mS20mS
		Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL) & ~ BIT_HUB2_RESET );  // λ
	}
	else {
		Write374Byte( REG_HUB_SETUP, Read374Byte(REG_HUB_SETUP) & ~ BIT_HUB0_POLAR | BIT_HUB0_RESET );  // ĬΪȫ,ʼλ
		mDelaymS( 15 );																 // λʱ10mS20mS
		Write374Byte( REG_HUB_SETUP, Read374Byte(REG_HUB_SETUP) & ~ BIT_HUB0_RESET );  // λ
	}
	mDelayuS( 250 );
	Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT | BIT_IF_USB_SUSPEND );  // жϱ־
}

BOOL	EnableRootHubPort( UINT8 index )  // ʹROOT-HUB˿,ӦBIT_HUB?_EN1˿,FALSEʧ(豸Ͽ)
{
	if ( RootHubDev[ index ].DeviceStatus < ROOT_DEV_CONNECTED ) RootHubDev[ index ].DeviceStatus = ROOT_DEV_CONNECTED;
	if ( index == 1 ) {
		if ( Read374Byte(REG_HUB_CTRL)&BIT_HUB1_ATTACH ) {  // 豸
			if ( !(Read374Byte(REG_HUB_CTRL)&BIT_HUB1_EN) ) {  // δʹ
				if ( !(Read374Byte(REG_HUB_SETUP) & BIT_HUB1_DX_IN) ) Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL) ^ BIT_HUB1_POLAR );  // ٶȲƥü
				RootHubDev[1].DeviceSpeed= !( Read374Byte(REG_HUB_CTRL) & BIT_HUB1_POLAR );
			}
			Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL)|BIT_HUB1_EN );	//ʹHUB˿
			return( TRUE );
		}
	}
	else if ( index == 2 ) {
		if ( Read374Byte(REG_HUB_CTRL)&BIT_HUB2_ATTACH ) {  // 豸
			if ( !(Read374Byte(REG_HUB_CTRL)&BIT_HUB2_EN) ) {  // δʹ
				if ( !(Read374Byte(REG_HUB_SETUP) & BIT_HUB2_DX_IN) ) Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL) ^ BIT_HUB2_POLAR );  // ٶȲƥü
				RootHubDev[2].DeviceSpeed= !( Read374Byte(REG_HUB_CTRL) & BIT_HUB2_POLAR );
			}
			Write374Byte( REG_HUB_CTRL, Read374Byte(REG_HUB_CTRL)|BIT_HUB2_EN );	//ʹHUB˿
			return( TRUE );
		}
	}
	else {
		if ( Read374Byte(REG_HUB_SETUP)&BIT_HUB0_ATTACH ) {  // 豸
			if ( !(Read374Byte(REG_HUB_SETUP)&BIT_HUB0_EN) ) {  // δʹ
				if ( !(Read374Byte(REG_INTER_FLAG) & BIT_HUB0_DX_IN) ) Write374Byte( REG_HUB_SETUP, Read374Byte(REG_HUB_SETUP) ^ BIT_HUB0_POLAR );  // ٶȲƥü
				RootHubDev[0].DeviceSpeed= !( Read374Byte(REG_HUB_SETUP) & BIT_HUB0_POLAR );
			}
			Write374Byte( REG_HUB_SETUP, Read374Byte(REG_HUB_SETUP)|BIT_HUB0_EN );  //ʹHUB˿
			return( TRUE );
		}
	}
	return( FALSE );
}

void	SetUsbSpeed( BOOL FullSpeed )  // õǰUSBٶ
{
	if ( FullSpeed ) {  // ȫ
		Write374Byte( REG_USB_SETUP, Read374Byte( REG_USB_SETUP ) & BIT_SETP_RAM_MODE | BIT_SETP_HOST_MODE | BIT_SETP_AUTO_SOF );  // ȫ
		Write374Byte( REG_HUB_SETUP, Read374Byte( REG_HUB_SETUP ) & ~ BIT_HUB_PRE_PID );  // ֹPRE PID
	}
	else Write374Byte( REG_USB_SETUP, Read374Byte( REG_USB_SETUP ) & BIT_SETP_RAM_MODE | BIT_SETP_HOST_MODE | BIT_SETP_AUTO_SOF | BIT_SETP_LOW_SPEED );  // 
}

void	SelectHubPort( UINT8 HubIndex, UINT8 PortIndex )  // PortIndex=0ѡָROOT-HUB˿,ѡָROOT-HUB˿ڵⲿHUBָ˿
{
	if ( PortIndex ) {  // ѡָROOT-HUB˿ڵⲿHUBָ˿
		SetHostUsbAddr( DevOnHubPort[HubIndex][PortIndex-1].DeviceAddress );  // USBǰUSB豸ַ
		if ( DevOnHubPort[HubIndex][PortIndex-1].DeviceSpeed == 0 )  // ͨⲿHUBUSB豸ͨѶҪǰID
			Write374Byte( REG_HUB_SETUP, Read374Byte( REG_HUB_SETUP ) | BIT_HUB_PRE_PID );  // PRE PID
		SetUsbSpeed( DevOnHubPort[HubIndex][PortIndex-1].DeviceSpeed );  // õǰUSBٶ
	}
	else {  // ѡָROOT-HUB˿
		SetHostUsbAddr( RootHubDev[HubIndex].DeviceAddress );  // USBǰUSB豸ַ
		SetUsbSpeed( RootHubDev[HubIndex].DeviceSpeed );  // õǰUSBٶ
	}
}

void	AnalyzeRootHub( void )   // ROOT-HUB״̬,ROOT-HUB˿ڵ豸¼
{ //HUB˿ڵĲ¼豸γеDisableHubPort()˿ڹرգ¼Ӧ˿ڵ״̬λ
	if ( ( Read374Byte( REG_HUB_SETUP ) & BIT_HUB0_ATTACH ) && RootHubDev[0].DeviceStatus == ROOT_DEV_DISCONNECT  //⵽豸
		|| ( Read374Byte( REG_HUB_SETUP ) & (BIT_HUB0_ATTACH|BIT_HUB0_EN) ) == BIT_HUB0_ATTACH ) {  //⵽豸,δ,˵Ǹղ
		DisableRootHubPort( 0 );  // رն˿
//		RootHubDev[0].DeviceSpeed=( Read374Byte(REG_INTER_FLAG) ^ ( Read374Byte( REG_HUB_SETUP ) & BIT_HUB0_POLAR ? 0xFF : 0x00 ) ) & BIT_HUB0_DX_IN;
		RootHubDev[0].DeviceStatus=ROOT_DEV_CONNECTED;  //ӱ־
		printf( "HUB 0 device in\n" );
		NewDevCount++;
	}
	if( ! ( Read374Byte(REG_HUB_SETUP) & BIT_HUB0_ATTACH ) && RootHubDev[0].DeviceStatus >= ROOT_DEV_CONNECTED ) {  //⵽豸γ
		DisableRootHubPort( 0 );  // رն˿
		printf( "HUB 0 device out\n" );
	}
	if ( ( Read374Byte( REG_HUB_CTRL ) & BIT_HUB1_ATTACH ) && RootHubDev[1].DeviceStatus == ROOT_DEV_DISCONNECT  //⵽豸
		|| ( Read374Byte( REG_HUB_CTRL ) & (BIT_HUB1_ATTACH|BIT_HUB1_EN) ) == BIT_HUB1_ATTACH ) {  //⵽豸,δ,˵Ǹղ
		DisableRootHubPort( 1 );  // رն˿
		RootHubDev[1].DeviceStatus=ROOT_DEV_CONNECTED;  //ӱ־
		printf( "HUB 1 device in\n" );
		NewDevCount++;
	}
	if( ! ( Read374Byte(REG_HUB_CTRL) & BIT_HUB1_ATTACH ) && RootHubDev[1].DeviceStatus >= ROOT_DEV_CONNECTED ) {  //⵽豸γ
		DisableRootHubPort( 1 );  // رն˿
		printf( "HUB 1 device out\n" );
	}
	if ( ( Read374Byte( REG_HUB_CTRL ) & BIT_HUB2_ATTACH ) && RootHubDev[2].DeviceStatus == ROOT_DEV_DISCONNECT  //⵽豸
		|| ( Read374Byte( REG_HUB_CTRL ) & (BIT_HUB2_ATTACH|BIT_HUB2_EN) ) == BIT_HUB2_ATTACH ) {  //⵽豸,δ,˵Ǹղ
		DisableRootHubPort( 2 );  // رն˿
		RootHubDev[2].DeviceStatus=ROOT_DEV_CONNECTED;  //ӱ־
		printf( "HUB 2 device in\n" );
		NewDevCount++;
	}
	if( ! ( Read374Byte(REG_HUB_CTRL) & BIT_HUB2_ATTACH ) && RootHubDev[2].DeviceStatus >= ROOT_DEV_CONNECTED ) {  //⵽豸γ
		DisableRootHubPort( 2 );  // رն˿
		printf( "HUB 2 device out\n" );
	}
//	Write374Byte( REG_INTER_FLAG, BIT_IF_DEV_DETECT );  // жϱ־
}

UINT8	AnalyzeHidIntEndp( void )  // зHIDж϶˵ĵַ
{
	UINT8	i, s, l;
	s = 0;
	for ( i = 0; i < ( (PUSB_CFG_DESCR)TempBuf ) -> wTotalLengthL; i += l ) {  // ж϶˵,ͽӿ
		if ( ( (PUSB_ENDP_DESCR)(TempBuf+i) ) -> bDescriptorType == USB_ENDP_DESCR_TYPE  // Ƕ˵
			&& ( (PUSB_ENDP_DESCR)(TempBuf+i) ) -> bmAttributes == USB_ENDP_TYPE_INTER  // ж϶˵
			&& ( ( (PUSB_ENDP_DESCR)(TempBuf+i) ) -> bEndpointAddress & 0x80 ) ) {  // IN˵
				s = ( (PUSB_ENDP_DESCR)(TempBuf+i) ) -> bEndpointAddress & 0x7F;  // ж϶˵ĵַ
				break;  // ԸҪwMaxPacketSizebInterval
		}
		l = ( (PUSB_ENDP_DESCR)(TempBuf+i) ) -> bLength;  // ǰ,
		if ( l > 16 ) break;
	}
	return( s );
}

UINT8	InitDevice( UINT8 index )  // ʼ/öָROOT-HUB˿ڵUSB豸
// : HUB˿ں0/1/2
// : 0-ʧ, 0x31-ɹöٵUSB, 0x32-ɹöٵ, 0x70-ɹöٵӡ, 0x80-ɹöٵU, 0xFF-ɹöδ֪豸, ֵδ
#define	DEV_ERROR		0x00
#define	DEV_KEYBOARD	0x31
#define	DEV_MOUSE		0x32
#define	DEV_PRINT		0x70
#define	DEV_DISK		0x80
#define	DEV_HUB			0x90
#define	DEV_UNKNOWN		0xFF
{
	UINT8	i, s, cfg, dv_cls, if_cls;
	printf( "Start reset HUB%01d port\n", (UINT16)index );
	ResetRootHubPort( index );  // ⵽豸,λӦ˿ڵUSB
	for ( i = 0, s = 0; i < 100; i ++ ) {  // ȴUSB豸λ
		if ( EnableRootHubPort( index ) ) {  // ʹROOT-HUB˿
			i = 0;
			s ++;  // ʱȴUSB豸Ӻȶ
			if ( s > 100 ) break;  // Ѿȶ
		}
		mDelaymS( 1 );
	}
	if ( i ) {  // λ豸û
		DisableRootHubPort( index );
		printf( "Disable HUB%01d port because of disconnect\n", (UINT16)index );
		return( DEV_ERROR );
	}
	SetUsbSpeed( RootHubDev[index].DeviceSpeed );  // õǰUSBٶ
	printf( "GetDeviceDescr @HUB%1d: ", (UINT16)index );
	s = GetDeviceDescr( TempBuf );  // ȡ豸
	if ( s == USB_INT_SUCCESS ) {
		for ( i = 0; i < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; i ++ ) printf( "0x%02X ", (UINT16)( TempBuf[i] ) );
		printf( "\n" ); // ʾ
		dv_cls = ( (PUSB_DEV_DESCR)TempBuf ) -> bDeviceClass;  // 豸
		s = SetUsbAddress( index + ( (PUSB_SETUP_REQ)SetupSetUsbAddr ) -> wValueL );  // USB豸ַ,indexԱ֤HUB˿ڷ䲻ͬĵַ
		if ( s == USB_INT_SUCCESS ) {
			RootHubDev[index].DeviceAddress = index + ( (PUSB_SETUP_REQ)SetupSetUsbAddr ) -> wValueL;  // USBַ
			printf("GetConfigDescr: " );
			s = GetConfigDescr( TempBuf );  // ȡ
			if ( s == USB_INT_SUCCESS ) {
				cfg = ((PUSB_CFG_DESCR)TempBuf ) -> bConfigurationValue;
				for ( i = 0; i < ( (PUSB_CFG_DESCR)TempBuf ) -> wTotalLengthL; i ++ ) printf( "0x%02X ", (UINT16)( TempBuf[i] ) );
				printf("\n");
/* ȡ˵/˵ַ/˵Сȣ±endp_addrendp_size */
				if_cls = ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceClass;  // ӿ
				if ( dv_cls == 0x00 && if_cls == 0x08 ) {  // USB洢豸,ȷU
					s = SetUsbConfig( cfg );  // USB豸
					if ( s == USB_INT_SUCCESS ) {
						RootHubDev[index].DeviceStatus =ROOT_DEV_SUCCESS;
//						SetUsbSpeed( TRUE );  // ĬΪȫ
						printf( "USB-Disk Ready\n" );
						return( DEV_DISK );  /* U̳ʼɹ */
					}
				}
				else if ( dv_cls == 0x00 && if_cls == 0x07 && ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceSubClass == 0x01 ) {  // Ǵӡ豸
					s = SetUsbConfig( cfg );  // USB豸
					if ( s == USB_INT_SUCCESS ) {
//						豣˵ϢԱUSB
						RootHubDev[index].DeviceStatus =ROOT_DEV_SUCCESS;
						SetUsbSpeed( TRUE );  // ĬΪȫ
						printf( "USB-Print Ready\n" );
						return( DEV_PRINT );  /* ӡʼɹ */
					}
				}
				else if ( dv_cls == 0x00 && if_cls == 0x03 && ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceSubClass <= 0x01 ) {  // HID豸,/
					s = SetUsbConfig( cfg );  // USB豸
					if ( s == USB_INT_SUCCESS ) {
//						Set_Idle( );
//						豣˵ϢԱUSB
						s = AnalyzeHidIntEndp( );  // зHIDж϶˵ĵַ
						RootHubDev[index].GpVar = s;  // ж϶˵ĵַ,λ7ͬ־λ,0
						RootHubDev[index].DeviceStatus =ROOT_DEV_SUCCESS;
						SetUsbSpeed( TRUE );  // ĬΪȫ
						s = ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceProtocol;
						if ( s == 1 ) {
//							һʼ,豸ָʾLED
							printf( "USB-Keyboard Ready\n" );
							return( DEV_KEYBOARD );  /* ̳ʼɹ */
						}
						else if ( s == 2 ) {
//							ΪԺѯ״̬,Ӧ÷,ȡж϶˿ڵĵַ,ȵϢ
							printf( "USB-Mouse Ready\n" );
							return( DEV_MOUSE );  /* ʼɹ */
						}
					}
				}
				else if ( dv_cls == 0x09 ) {  // HUB豸,
					printf( "GetHubDescriptor: ");
					s = GetHubDescriptor(  );
					if ( s == USB_INT_SUCCESS ) {
						for( i = 0; i< TempBuf[0]; i++ ) printf( "0x%02X ",(UINT16)(TempBuf[i]) );
						printf("\n");
						RootHubDev[index].GpVar = ((PHUBDescr)TempBuf) -> bNbrPorts;  // HUBĶ˿
						if ( RootHubDev[index].GpVar > 4 ) RootHubDev[index].GpVar = 4;  // ΪṹDevOnHubPortʱΪٶÿHUB4˿
//						if ( ((PHUBDescr)TempBuf) -> wHubCharacteristics[0] & 0x04 ) printf("мĸ豸\n");
//						else printf("һļƷ\n");
						s = SetUsbConfig( cfg );  // USB豸
						if ( s == USB_INT_SUCCESS ) {
//							豣˵ϢԱUSB,ж϶˵HUB¼֪ͨ,ʹòѯ״̬ƴ
//							HUB˿ϵ,ѯ˿״̬,ʼ豸ӵHUB˿,ʼ豸
							for ( i = 1; i <= RootHubDev[index].GpVar; i ++ ) {  // HUB˿ڶϵ
								DevOnHubPort[index][i-1].DeviceStatus = ROOT_DEV_DISCONNECT;  // ⲿHUB˿豸״̬
								s = SetPortFeature( i, PORT_POWER );
								if ( s != USB_INT_SUCCESS ) printf("Ext-HUB Port%01d# power on error\n",(UINT16)i );  // ˿ϵʧ
							}
							RootHubDev[index].DeviceStatus =ROOT_DEV_SUCCESS;
							SetUsbSpeed( TRUE );  // ĬΪȫ
							return( DEV_HUB );  /* HUBʼɹ */
						}
					}
				}
				else {   // Խһ
					s = SetUsbConfig( cfg );  // USB豸
					if ( s == USB_INT_SUCCESS ) {
//						豣˵ϢԱUSB
						RootHubDev[index].DeviceStatus =ROOT_DEV_SUCCESS;
						SetUsbSpeed( TRUE );  // ĬΪȫ
						return( DEV_UNKNOWN );  /* δ֪豸ʼɹ */
					}
				}
			}
		}
	}
	printf( "InitDevice Error = %02X\n", (UINT16)s );
	RootHubDev[index].DeviceStatus =ROOT_DEV_FAILED;
	SetUsbSpeed( TRUE );  // ĬΪȫ
	return( DEV_ERROR );
}

UINT8	HubPortEnum( UINT8 index )  // öָROOT-HUB˿ϵⲿHUBĸ˿,˿ӻƳ¼
{
	UINT8	i, s;
//	printf( "Enum external HUB port\n" );
	for ( i = 1; i <= RootHubDev[index].GpVar; i ++ ) {  // ѯĶ˿Ƿб仯
		SelectHubPort( index, 0 );  // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
		s = GetPortStatus( i );  // ȡ˿״̬
		if ( s != USB_INT_SUCCESS ) return( s );  // ǸHUBϿ
		if ( (TempBuf[0]&0x01) && (TempBuf[2]&0x01) ) {  // 豸
			DevOnHubPort[index][i-1].DeviceStatus = ROOT_DEV_CONNECTED;  // 豸
			DevOnHubPort[index][i-1].DeviceAddress = 0;
			s = GetPortStatus( i );  // ȡ˿״̬
			if ( s != USB_INT_SUCCESS ) return( s );  // ǸHUBϿ
			DevOnHubPort[index][i-1].DeviceSpeed = TempBuf[1] & 0x02 ? 0 : 1;  // ٻȫ
			if ( DevOnHubPort[index][i-1].DeviceSpeed ) printf( "Found full speed device on port %01d\n", (UINT16)i );
			else printf( "Found low speed device on port %01d\n", (UINT16)i );
			mDelaymS( 200 );  // ȴ豸ϵȶ	
			s = SetPortFeature( i, PORT_RESET );  // 豸ӵĶ˿ڸλ
			if ( s != USB_INT_SUCCESS ) return( s );  // ǸHUBϿ
			printf( "Reset port and then wait in\n" );
			do {  // ѯλ˿,ֱλ,ɺ״̬ʾ
				mDelaymS( 1 );
				s = GetPortStatus( i );
				if ( s != USB_INT_SUCCESS ) return( s );  // ǸHUBϿ
			} while ( TempBuf[0] & 0x10 );  // ˿ڸλȴ
			mDelaymS( 100 );
//			s = ClearPortFeature( i, C_PORT_RESET ); // λɱ־
//			s = SetPortFeature( i, PORT_ENABLE );  // HUB˿
			s = ClearPortFeature( i, C_PORT_CONNECTION ); // ӻƳ仯־
			if ( s != USB_INT_SUCCESS ) return( s );
			s = GetPortStatus( i );  // ٶȡ״̬,豸Ƿ
			if ( s != USB_INT_SUCCESS ) return( s );
			if ( (TempBuf[0]&0x01) == 0 ) DevOnHubPort[index][i-1].DeviceStatus = ROOT_DEV_DISCONNECT;  // 豸
			s = Level2DevEnum( index, i );
			DevOnHubPort[index][i-1].DeviceType = s;  // 豸
//			if ( s == DEV_ERROR ) {  // ʧܵĶ˿Ӧýֹ
//				SelectHubPort( index, 0 );  // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
//				s = ClearPortFeature( i, PORT_ENABLE );  // ֹHUB˿
//			}
			SetUsbSpeed( TRUE );  // ĬΪȫ
		}
		else if ( (TempBuf[0]&0x01) == 0 ) {  // 豸ѾϿ
			DevOnHubPort[index][i-1].DeviceStatus = ROOT_DEV_DISCONNECT;  // 豸
			if ( TempBuf[2]&0x01 ) ClearPortFeature( i, C_PORT_CONNECTION ); // Ƴ仯־
		}
	}
	return( USB_INT_SUCCESS );  // زɹ
}

UINT8	Level2DevEnum( UINT8 HubIndex, UINT8 PortIndex )  // ʼöⲿHUBĶUSB豸
{
	UINT8	i, s, cfg, dv_cls, if_cls;
	printf( "Enum dev @ExtHub-port%01d ", (UINT16)PortIndex );
	printf( "@RootHub%01d\n", (UINT16)HubIndex );
	if ( PortIndex == 0 ) return( DEV_ERROR );
	SelectHubPort( HubIndex, PortIndex );  // ѡָROOT-HUB˿ڵⲿHUBָ˿,ѡٶ
	printf( "GetDeviceDescr: " );
	s = GetDeviceDescr( TempBuf );  // ȡ豸
	if ( s != USB_INT_SUCCESS ) return( DEV_ERROR );
	dv_cls = ( (PUSB_DEV_DESCR)TempBuf ) -> bDeviceClass;  // 豸
	cfg = ( (HubIndex+1)<<4 ) + PortIndex;  // һUSBַ,ַص
	s = SetUsbAddress( cfg );  // USB豸ַ
	if ( s != USB_INT_SUCCESS ) return( DEV_ERROR );
	DevOnHubPort[HubIndex][PortIndex-1].DeviceAddress = cfg;  // USBַ
	printf("GetConfigDescr: " );
	s = GetConfigDescr( TempBuf );  // ȡ
	if ( s != USB_INT_SUCCESS ) return( DEV_ERROR );
	cfg = ((PUSB_CFG_DESCR)TempBuf ) -> bConfigurationValue;
	for ( i = 0; i < ( (PUSB_CFG_DESCR)TempBuf ) -> wTotalLengthL; i ++ ) printf( "0x%02X ", (UINT16)( TempBuf[i] ) );
	printf("\n");
	/* ȡ˵/˵ַ/˵Сȣ±endp_addrendp_size */
	if_cls = ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceClass;  // ӿ
	if ( dv_cls == 0x00 && if_cls == 0x08 ) {  // USB洢豸,ȷU
		s = SetUsbConfig( cfg );  // USB豸
		if ( s == USB_INT_SUCCESS ) {
			DevOnHubPort[HubIndex][PortIndex-1].DeviceStatus =ROOT_DEV_SUCCESS;
//			SetUsbSpeed( TRUE );  // ĬΪȫ
			printf( "USB-Disk Ready\n" );
			return( DEV_DISK );  /* U̳ʼɹ */
		}
	}
	else if ( dv_cls == 0x00 && if_cls == 0x03 && ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceSubClass <= 0x01 ) {  // HID豸,/
		s = SetUsbConfig( cfg );  // USB豸
		if ( s == USB_INT_SUCCESS ) {
//			豣˵ϢԱUSB
			s = AnalyzeHidIntEndp( );  // зHIDж϶˵ĵַ
			DevOnHubPort[HubIndex][PortIndex-1].GpVar = s;  // ж϶˵ĵַ,λ7ͬ־λ,0
			DevOnHubPort[HubIndex][PortIndex-1].DeviceStatus =ROOT_DEV_SUCCESS;
			SetUsbSpeed( TRUE );  // ĬΪȫ
			s = ( (PUSB_CFG_DESCR_LONG)TempBuf ) -> itf_descr.bInterfaceProtocol;
			if ( s == 1 ) {
//				һʼ,豸ָʾLED
				printf( "USB-Keyboard Ready\n" );
				return( DEV_KEYBOARD );  /* ̳ʼɹ */
			}
			else if ( s == 2 ) {
//				ΪԺѯ״̬,Ӧ÷,ȡж϶˿ڵĵַ,ȵϢ
				printf( "USB-Mouse Ready\n" );
				return( DEV_MOUSE );  /* ʼɹ */
			}
		}
	}
	else if ( dv_cls == 0x09 ) {  // HUB豸,
		printf( "This program don't support Level 2 HUB\n");  // Ҫֶ֧༶HUBοչ
	}
	else {   // Խһ
		s = SetUsbConfig( cfg );  // USB豸
		if ( s == USB_INT_SUCCESS ) {
//			豣˵ϢԱUSB
			DevOnHubPort[HubIndex][PortIndex-1].DeviceStatus =ROOT_DEV_SUCCESS;
			SetUsbSpeed( TRUE );  // ĬΪȫ
			return( DEV_UNKNOWN );  /* δ֪豸ʼɹ */
		}
	}
	printf( "InitDevice Error = %02X\n", (UINT16)s );
	DevOnHubPort[HubIndex][PortIndex-1].DeviceStatus =ROOT_DEV_FAILED;
	SetUsbSpeed( TRUE );  // ĬΪȫ
	return( DEV_ERROR );
}

UINT8	SearchRootHubPort( UINT8 type )  // ָ͵豸ڵĶ˿ں,˿ںΪ0xFFδ
{ // ȻҲԸUSBĳVIDƷPID(Ҫ¼豸VIDPID),Լָ
	UINT8	i;
	for ( i = 0; i < 3; i ++ ) {  // ʱԱ豸;γĳЩϢδʱµ
		if ( RootHubDev[i].DeviceType == type && RootHubDev[i].DeviceStatus >= ROOT_DEV_SUCCESS ) return( i );  // ƥöٳɹ
	}
	return( 0xFF );
}

UINT16	SearchAllHubPort( UINT8 type )  // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں,˿ںΪ0xFFFFδ
{// 8λΪROOT-HUB˿ں,8λΪⲿHUBĶ˿ں,8λΪ0豸ֱROOT-HUB˿
// ȻҲԸUSBĳVIDƷPID(Ҫ¼豸VIDPID),Լָ
	UINT8	i, port;
	i = SearchRootHubPort( type );  // ָ͵豸ڵĶ˿ں
	if ( i != 0xFF ) return( (UINT16)i << 8 );  // ROOT-HUB˿
	for ( i = 0; i < 3; i ++ ) {  // ʱԱ豸;γĳЩϢδʱµ
		if ( RootHubDev[i].DeviceType == DEV_HUB && RootHubDev[i].DeviceStatus >= ROOT_DEV_SUCCESS ) {  // ⲿHUBöٳɹ
			for ( port = 1; port <= RootHubDev[i].GpVar; port ++ ) {  // ⲿHUBĸ˿
				if ( DevOnHubPort[i][port-1].DeviceType == type && DevOnHubPort[i][port-1].DeviceStatus >= ROOT_DEV_SUCCESS )
					return( ( (UINT16)i << 8 ) | port );  // ƥöٳɹ
			}
		}
	}
	return( 0xFFFF );
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
//	TL2 = RCAP2L = 0 - 10; /* 18.432MHz, 57600bps */
	TL2 = RCAP2L = 0 - 13; /* 24MHz, 57600bps */
	TH2 = RCAP2H = 0xFF;
	T2CON = 0x34;  /* ʱ2ڴڵĲʷ */
	TI = 1;
}

int	main( void )  // USB host
{
	UINT8	i, s, n;
	UINT8	count;
	UINT16	loc;
	
//	P1&=0xF8; // Uļдģñϱ
	mDelaymS( 50 );  // ȴCH374λ
	CH374_PORT_INIT( );  /* CH374ӿڳʼ */

	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start CH374U Host\n" );
	NewDevCount = 0;
	for ( n = 0; n < 3; n ++ ) RootHubDev[n].DeviceStatus = ROOT_DEV_DISCONNECT;  // 
	count = 0;

	Init374Host( );  // ʼUSB
	HostEnableRootHub( );  // õRoot-HUB
	printf( "Wait Device In\n" );
	while ( 1 ) {
		if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
		if ( NewDevCount ) {  // µUSB豸
			mDelaymS( 200 );  // USB豸ղδȶʵȴUSB豸ٺ룬ζ
//			if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
			NewDevCount=0;
			for ( n = 0; n < 3; n ++ ) {
				if ( RootHubDev[n].DeviceStatus == ROOT_DEV_CONNECTED ) {   // ղ豸δʼ
					s = InitDevice( n );  // ʼ/öָHUB˿ڵUSB豸
					RootHubDev[n].DeviceType = s;  // 豸
					if ( s == DEV_HUB ) {  // HUBöٳɹ
						SelectHubPort( n, 0 );  // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
//						ʲô?  HUB˿ϵ,ѯ˿״̬,ʼ豸ӵHUB˿,ʼ豸
						s = HubPortEnum( n );  // öָROOT-HUB˿ϵⲿHUBĸ˿,˿ӻƳ¼
						if ( s != USB_INT_SUCCESS ) {  // HUBϿ
							printf( "HubPortEnum error = %02X\n", (UINT16)s );
						}
						SetUsbSpeed( TRUE );  // ĬΪȫ
					}
				}
			}
		}
//		other work for each device
		mDelaymS( 100 );  // ģⵥƬ
		if ( count & 0x02 ) {  // ÿһʱⲿHUBĶ˿ڽһö,Ƭпʱ
			for ( n = 0; n < 3; n ++ ) {  // ⲿHUB豸
				if ( RootHubDev[n].DeviceType == DEV_HUB && RootHubDev[n].DeviceStatus >= ROOT_DEV_SUCCESS ) {  // ЧⲿHUB
					SelectHubPort( n, 0 );  // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
					s = HubPortEnum( n );  // öָROOT-HUB˿ϵⲿHUBĸ˿,˿ӻƳ¼
					if ( s != USB_INT_SUCCESS ) {  // HUBϿ
						printf( "HubPortEnum error = %02X\n", (UINT16)s );
					}
					SetUsbSpeed( TRUE );  // ĬΪȫ
				}
			}
		}
		count++;
		if ( count > 50 ) count = 0;
		switch( count ) {  // ģ,ĳUSB豸в
			case 13:  // öʱģ,ҪU,οCH374LIB\EXAM14\CH374HFT.C
				loc = SearchAllHubPort( DEV_DISK );  // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں
				if ( loc != 0xFFFF ) {  // ҵ
					n = loc >> 8;
					loc &= 0xFF;
					printf( "Access USB-disk\n" );
					SelectHubPort( n, loc );  // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
//					U̽в,CH374LIBHostCtrlTransfer374,HostTransact374
					SetUsbSpeed( TRUE );  // ĬΪȫ
				}
				break;
			case 17:  // öʱģ,Ҫ
				loc = SearchAllHubPort( DEV_MOUSE );  // ROOT-HUBԼⲿHUB˿ָ͵豸ڵĶ˿ں
				if ( loc != 0xFFFF ) {  // ҵ,MOUSEδ?
					n = loc >> 8;
					loc &= 0xFF;
					printf( "Query Mouse\n" );
					SelectHubPort( n, loc );  // ѡָROOT-HUB˿,õǰUSBٶԼ豸USBַ
//					в
//					s = GetDeviceDescr( TempBuf );  // ȡ豸
//					if ( s == USB_INT_SUCCESS ) {
//						for ( s = 0; s < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; s ++ ) printf( "0x%02X ", (UINT16)( TempBuf[s] ) );
//						printf( "\n" ); // ʾ
//					}
					i = loc ? DevOnHubPort[n][loc-1].GpVar : RootHubDev[n].GpVar;  // ж϶˵ĵַ,λ7ͬ־λ
					if ( i & 0x7F ) {  // ˵Ч
						s = HostTransact374( i & 0x7F, DEF_USB_PID_IN, i & 0x80 );  // CH374,ȡ
						if ( s == USB_INT_SUCCESS ) {
							i ^= 0x80;  // ͬ־ת
							if ( loc ) DevOnHubPort[n][loc-1].GpVar = i;  // ͬ־λ
							else RootHubDev[n].GpVar = i;
							i = Read374Byte( REG_USB_LENGTH );  // յݳ
							if ( i ) {
								Read374Block( RAM_HOST_RECV, i, TempBuf );  // ȡݲӡ
								printf("Mouse data: ");
								for ( s = 0; s < i; s ++ ) printf("0x%02X ",(UINT16)(TempBuf+s) );
								printf("\n");
							}
						}
						else if ( s != ( 0x20 | USB_INT_RET_NAK ) ) printf("Mouse error %02x\n",(UINT16)s);  // ǶϿ
					}
					else printf("Mouse no interrupt endpoint\n");
					SetUsbSpeed( TRUE );  // ĬΪȫ
				}
				break;
		}
	}
}
