/* CH374оƬ Ӧò V1.0 */
/* USB,ʼöٵǰӵUSB豸,ֶ֧USB-HUB */

#include	<stdio.h>
#include	<string.h>
#include	"..\HAL.H"			// MCS51ΪƬ޸HAL*Ӳļļ
#include	"..\HAL_BASE.C"	// ӳжϲѯӳ

/* Ӳӿڲ,ӷʽѡһ */
#include "..\PARA_HW.C"	/* Ӳ׼8λ */
//#include "..\PARA_SW.C"	/* I/Oģ8λ */
//#include "..\SPI_HW.C"	/* Ӳ׼4SPI */
//#include "..\SPI_SW.C"	/* I/Oģ4SPI */
//#include "..\SPI3_SW.C"	/* I/Oģ3SPI,SDOSDIһ */


#include "HUB.H"

// ȡ豸
const	UINT8C	SetupGetDevDescr[] = { 0x80, 0x06, 0x00, 0x01, 0x00, 0x00, 0x12, 0x00 };
// ȡ
const	UINT8C	SetupGetCfgDescr[] = { 0x80, 0x06, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00 };
// USBַ
const	UINT8C	SetupSetUsbAddr[] = { 0x00, 0x05, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00 };
// USB
const	UINT8C	SetupSetUsbConfig[] = { 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

UINT8	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;	/* USB豸Ķ˵0ߴ */

UINT8	FlagDeviceStatus;						/* ǰUSB豸״̬ͨжϷʽȫֱδʹ */



UINT8 idata bHUBendp ; // ж϶˵
UINT8 idata bNumPort ; // ϵĶ˿
UINT8 idata	buf[64]; // ڲ
UINT8 idata	bPORTchange , bInterval, bConfig,  bMine;

UINT8 idata bChange;
UINT8 idata bAddr;

UINT16 idata mm,kk;
UINT8 idata bHubNum, bDevNum;
//UINT8 xdata xbuf[1778]={ 0 }; // ⲿ
UINT8 xdata xbuf[700]={ 0 }; // ⲿ
#define p_HUB_Descr ((PHUBDescr)buf) // ָHUBָ
#define p_Dev_Addr  ((PNUM)xbuf)     // ָ豸Եָ

// CH374ĿĶ˵ַ/PID/ͬ־ͬCH375NAKԣʱ/
UINT8	HostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog );

// CH374ĿĶ˵ַ/PID/ͬ־/mSΪλNAKʱ(0xFFFF)ͬCH375NAKԣʱ
UINT8	WaitHostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog, UINT16 timeout );

UINT8	HostCtrlTransfer374( PUINT8 ReqBuf, PUINT8 DatBuf, PUINT8 RetLen );  // ִпƴ,ReqBufָ8ֽ,DatBufΪշ
// ҪպͷݣôDatBufָЧڴźݣʵʳɹշܳȱReqLenָֽڱ

// ѯǰǷUSB豸
//BOOL	Query374DeviceIn( void );
#define	Query374DeviceIn( )	( ( Read374Byte( REG_INTER_FLAG ) & BIT_IF_DEV_ATTACH ) ? TRUE : FALSE )

// ѯǰUSB豸ȫٻǵ, TRUEΪȫ
//BOOL	Query374DevFullSpeed( void );
#define	Query374DevFullSpeed( )	( ( Read374Byte( REG_SYS_INFO ) & BIT_INFO_USB_DP ) ? TRUE : FALSE )

void	HostDetectInterrupt( void );  // USB豸¼ж

void	SetHostUsbAddr( UINT8 addr );  // USBǰUSB豸ַ

void	HostSetBusFree( void );  // USB߿

void	HostSetBusReset( void );  // USB߸λ

void	HostSetFullSpeed( void );  // 趨ȫUSB豸л

void	HostSetLowSpeed( void );  // 趨USB豸л,οEMB_HUBеĵӴ

void	Init374Host( void );  // ʼUSB

UINT8	GetDeviceDescr( PUINT8 buf );  // ȡ豸

UINT8	GetConfigDescr( PUINT8 buf );  // ȡ

UINT8	SetUsbAddress( UINT8 addr );  // USB豸ַ

UINT8	SetUsbConfig( UINT8 cfg );  // USB豸


// CH374ĿĶ˵ַ/PID/ͬ־ͬCH375NAKԣʱ/
UINT8	HostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog )
{  // ӳ,ʵӦ,Ϊṩٶ,ӦöԱӳŻ
	UINT8	retry;
	UINT8	s, r, u;
	for ( retry = 0; retry < 3; retry ++ ) {
		Write374Byte( REG_USB_H_PID, M_MK_HOST_PID_ENDP( pid, endp_addr ) );  // ָPIDĿĶ˵
//		Write374Byte( REG_USB_H_CTRL, BIT_HOST_START | ( tog ? ( BIT_HOST_TRAN_TOG | BIT_HOST_RECV_TOG ) : 0x00 ) );  // ͬ־
		Write374Byte( REG_USB_H_CTRL, ( tog ? ( BIT_HOST_START | BIT_HOST_TRAN_TOG | BIT_HOST_RECV_TOG ) : BIT_HOST_START ) );  // ͬ־
//		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE );  // ȡͣ
		s = Wait374Interrupt( );
		if ( s == ERR_USB_UNKNOWN ) return( s );  // жϳʱ,Ӳ쳣
		s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
		if ( s & BIT_IF_DEV_DETECT ) {  // USB豸¼
			mDelayuS( 200 );  // ȴ
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT | BIT_IF_TRANSFER );  // жϱ־
			if ( s & BIT_IF_DEV_ATTACH ) {  // USB豸¼
				u = Read374Byte( REG_USB_SETUP );
				if ( s & BIT_IF_USB_DX_IN ) {  // ٶƥ䣬Ҫлٶ
					if ( u & BIT_SETP_USB_SPEED ) return( USB_INT_CONNECT_LS );  // USB豸
					return( USB_INT_CONNECT );  // ȫUSB豸
				}
				else {  // ٶʧ䣬Ҫлٶ
					if ( u & BIT_SETP_USB_SPEED ) return( USB_INT_CONNECT );  // ȫUSB豸
					return( USB_INT_CONNECT_LS );  // USB豸
				}
			}
			else return( USB_INT_DISCONNECT );  // USB豸Ͽ¼
		}
		else if ( s & BIT_IF_TRANSFER ) {  // 
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_TRANSFER );  // жϱ־
			s = Read374Byte( REG_USB_STATUS );  // USB״̬
			r = s & BIT_STAT_DEV_RESP;  // USB豸Ӧ״̬
			switch ( pid ) {
				case DEF_USB_PID_SETUP:
				case DEF_USB_PID_OUT:
					if ( r == DEF_USB_PID_ACK ) return( USB_INT_SUCCESS );
					else if ( r == DEF_USB_PID_STALL || r == DEF_USB_PID_NAK ) return( r | 0x20 );
					else if ( ! M_IS_HOST_TIMEOUT( s ) ) return( r | 0x20 );  // ǳʱ/Ӧ
					break;
				case DEF_USB_PID_IN:
					if ( M_IS_HOST_IN_DATA( s ) ) {  // DEF_USB_PID_DATA0 or DEF_USB_PID_DATA1
						if ( s & BIT_STAT_TOG_MATCH ) return( USB_INT_SUCCESS );  // ͬ趪
					}
					else if ( r == DEF_USB_PID_STALL || r == DEF_USB_PID_NAK ) return( r | 0x20 );
					else if ( ! M_IS_HOST_TIMEOUT( s ) ) return( r | 0x20 );  // ǳʱ/Ӧ
					break;
				default:
					return( ERR_USB_UNKNOWN );  // ܵ
					break;
			}
		}
		else {  // ж,Ӧ÷
			mDelayuS( 200 );  // ȴ
			Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  /* жϱ־ */
			if ( retry ) return( ERR_USB_UNKNOWN );  /* ǵһμ⵽򷵻ش */
		}
	}
	return( 0x20 );  // Ӧʱ
}

// CH374ĿĶ˵ַ/PID/ͬ־/mSΪλNAKʱ(0xFFFF)ͬCH375NAKԣʱ
UINT8	WaitHostTransact374( UINT8 endp_addr, UINT8 pid, BOOL tog, UINT16 timeout )
{
	UINT8	i, s;
	while ( 1 ) {
		for ( i = 0; i < 40; i ++ ) {
			s = HostTransact374( endp_addr, pid, tog );
			if ( s != ( DEF_USB_PID_NAK | 0x20 ) || timeout == 0 ) return( s );
			mDelayuS( 20 );
		}
		if ( timeout < 0xFFFF ) timeout --;
	}
}

UINT8	HostCtrlTransfer374( PUINT8 ReqBuf, PUINT8 DatBuf, PUINT8 RetLen )  // ִпƴ,ReqBufָ8ֽ,DatBufΪշ
// ҪպͷݣôDatBufָЧڴźݣʵʳɹշܳȱReqLenָֽڱ
{
	UINT8	s, len, count, total;
	BOOL	tog;
	Write374Block( RAM_HOST_TRAN, 8, ReqBuf );
	Write374Byte( REG_USB_LENGTH, 8 );
	mDelayuS( 200 );
	s = WaitHostTransact374( 0, DEF_USB_PID_SETUP, FALSE, 200 );  // SETUP׶Σ200mSʱ
	if ( s == USB_INT_SUCCESS ) {  // SETUPɹ
		tog = TRUE;  // ĬDATA1,Ĭݹ״̬׶ΪIN
		total = *( ReqBuf + 6 );
		if ( total && DatBuf ) {  // Ҫշ
			len = total;
			if ( *ReqBuf & 0x80 ) {  // 
				while ( len ) {
					mDelayuS( 200 );
					s = WaitHostTransact374( 0, DEF_USB_PID_IN, tog, 200 );  // IN
					if ( s != USB_INT_SUCCESS ) break;
					count = Read374Byte( REG_USB_LENGTH );
					Read374Block( RAM_HOST_RECV, count, DatBuf );
					DatBuf += count;
					if ( count <= len ) len -= count;
					else len = 0;
					if ( count == 0 || ( count & ( UsbDevEndpSize - 1 ) ) ) break;  // ̰
					tog = tog ? FALSE : TRUE;
				}
				tog = FALSE;  // ״̬׶ΪOUT
			}
			else {  // 
				while ( len ) {
					mDelayuS( 200 );
					count = len >= UsbDevEndpSize ? UsbDevEndpSize : len;
					Write374Block( RAM_HOST_TRAN, count, DatBuf );
					Write374Byte( REG_USB_LENGTH, count );
					s = WaitHostTransact374( 0, DEF_USB_PID_OUT, tog, 200 );  // OUT
					if ( s != USB_INT_SUCCESS ) break;
					DatBuf += count;
					len -= count;
					tog = tog ? FALSE : TRUE;
				}
				tog = TRUE;  // ״̬׶ΪIN
			}
			total -= len;  // ȥʣ೤ȵʵʴ䳤
		}
		if ( s == USB_INT_SUCCESS ) {  // ݽ׶γɹ
			Write374Byte( REG_USB_LENGTH, 0 );
			mDelayuS( 200 );
			s = WaitHostTransact374( 0, ( tog ? DEF_USB_PID_IN : DEF_USB_PID_OUT ), TRUE, 200 );  // STATUS׶
			if ( tog && s == USB_INT_SUCCESS ) {  // IN״̬ݳ
				if ( Read374Byte( REG_USB_LENGTH ) ) s = USB_INT_BUF_OVER;  // ״̬׶δ
			}
		}
	}
	if ( RetLen ) *RetLen = total;  // ʵʳɹշܳ
	return( s );
}

// ѯǰǷUSB豸
//BOOL	Query374DeviceIn( void )
//#define	Query374DeviceIn( )	( ( Read374Byte( REG_INTER_FLAG ) & BIT_IF_DEV_ATTACH ) ? TRUE : FALSE )

// ѯǰUSB豸ȫٻǵ, TRUEΪȫ
//BOOL	Query374DevFullSpeed( void )
//#define	Query374DevFullSpeed( )	( ( Read374Byte( REG_SYS_INFO ) & BIT_INFO_USB_DP ) ? TRUE : FALSE )

void	HostDetectInterrupt( void )  // USB豸¼ж
{
	UINT8	s, u;
	s = Read374Byte( REG_INTER_FLAG );  // ȡж״̬
	if ( s & BIT_IF_DEV_DETECT ) {  // USB豸¼
		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT );  // жϱ־
		if ( s & BIT_IF_DEV_ATTACH ) {  // USB豸¼
			u = Read374Byte( REG_USB_SETUP );
			if ( s & BIT_IF_USB_DX_IN ) {  // ٶƥ䣬Ҫлٶ
				if ( u & BIT_SETP_USB_SPEED ) FlagDeviceStatus = USB_INT_CONNECT_LS;  // USB豸
				else FlagDeviceStatus = USB_INT_CONNECT;  // ȫUSB豸
			}
			else {  // ٶʧ䣬Ҫлٶ
				if ( u & BIT_SETP_USB_SPEED ) FlagDeviceStatus = USB_INT_CONNECT;  // ȫUSB豸
				else FlagDeviceStatus = USB_INT_CONNECT_LS;  // USB豸
			}
		}
		else FlagDeviceStatus = USB_INT_DISCONNECT;  // USB豸Ͽ¼
	}
	else {  // ж
		Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_TRANSFER | BIT_IF_USB_SUSPEND | BIT_IF_WAKE_UP );  // жϱ־
	}
}

void	SetHostUsbAddr( UINT8 addr )  // USBǰUSB豸ַ
{
	Write374Byte( REG_USB_ADDR, addr );
}

void	HostSetBusFree( void )  // USB߿
{
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_FREE( Read374Byte( REG_USB_SETUP ) ) );  // USB߿
	Write374Byte( REG_USB_SETUP, BIT_SETP_HOST_MODE );  // USB߸λ
	Write374Byte( REG_USB_SETUP, BIT_SETP_HOST_MODE | BIT_SETP_AUTO_SOF );  // USB߸λ,SOF
}

void	HostSetBusReset( void )  // USB߸λ
{
	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;  /* USB豸Ķ˵0ߴ */
	SetHostUsbAddr( 0x00 );
	Write374Byte( REG_USB_H_CTRL, 0x00 );
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_RESET( Read374Byte( REG_USB_SETUP ) & ~ BIT_SETP_AUTO_SOF ) );  // USB߸λ
	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_RESET( BIT_SETP_HOST_MODE ) );  // USB߸λ
	mDelaymS( 20 );  // USB߸λڼ
//	Write374Byte( REG_USB_SETUP, M_SET_USB_BUS_FREE( Read374Byte( REG_USB_SETUP ) ) );  // USB߿
	HostSetBusFree( );  // USB߿
	mDelaymS( 1 );
	Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_DEV_DETECT | BIT_IF_USB_SUSPEND );  // жϱ־
}

void	HostSetFullSpeed( void )  // 趨ȫUSB豸л
{
	Write374Byte( REG_USB_SETUP, Read374Byte( REG_USB_SETUP ) & ~ BIT_SETP_USB_SPEED | BIT_SETP_AUTO_SOF );  // ȫҷSOF
//	mDelaymS( 1 );
}

void	HostSetLowSpeed( void )  // 趨USB豸л,οEMB_HUBеĵӴ
{
	Write374Byte( REG_USB_SETUP, Read374Byte( REG_USB_SETUP ) | BIT_SETP_USB_SPEED | BIT_SETP_AUTO_SOF );  // ҷSOF
//	mDelaymS( 1 );
}

void	Init374Host( void )  // ʼUSB
{
	Write374Byte( REG_USB_SETUP, 0x00 );
	SetHostUsbAddr( 0x00 );
	Write374Byte( REG_USB_H_CTRL, 0x00 );
	Write374Byte( REG_INTER_FLAG, BIT_IF_USB_PAUSE | BIT_IF_INTER_FLAG );  // жϱ־
//	Write374Byte( REG_INTER_EN, BIT_IE_TRANSFER );  // ж,ΪʹòѯʽUSB豸,USB豸ж
	Write374Byte( REG_INTER_EN, BIT_IE_TRANSFER | BIT_IE_DEV_DETECT );  // жϺUSB豸ж
	Write374Byte( REG_SYS_CTRL, BIT_CTRL_OE_POLAR );  // CH374TUENյCH374SBIT_CTRL_OE_POLARΪ1
	HostSetBusFree( );  // USB߿
}

UINT8	GetDeviceDescr( PUINT8 buf )  // ȡ豸
{
	UINT8	s, len;
	UsbDevEndpSize = DEFAULT_ENDP0_SIZE;
	s = HostCtrlTransfer374( SetupGetDevDescr, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		UsbDevEndpSize = ( (PUSB_DEV_DESCR)buf ) -> bMaxPacketSize0;  // ˵0,Ǽ򻯴,ӦȻȡǰ8ֽںUsbDevEndpSizeټ
		if ( len < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL ) s = USB_INT_BUF_OVER;  // ȴ
	}
	return( s );
}

UINT8	GetConfigDescr( PUINT8 buf )  // ȡ
{
	UINT8	s, len;
	UINT8	BufLogDescr[ sizeof( SetupGetCfgDescr ) ] ;
	s = HostCtrlTransfer374( SetupGetCfgDescr, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		if ( len < ( (PUSB_SETUP_REQ)SetupGetCfgDescr ) -> wLengthL ) s = USB_INT_BUF_OVER;  // سȴ
		else {
			memcpy ( BufLogDescr, SetupGetCfgDescr, sizeof( SetupGetCfgDescr ) );
			( (PUSB_SETUP_REQ)BufLogDescr ) -> wLengthL = ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL;  // ܳ
			s = HostCtrlTransfer374( BufLogDescr, buf, &len );  // ִпƴ
			if ( s == USB_INT_SUCCESS ) {
				if ( len < ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL ) s = USB_INT_BUF_OVER;  // ȴ
			}
		}
	}
	return( s );
}

UINT8	SetUsbAddress( UINT8 addr )  // USB豸ַ
{
	UINT8	s;
	UINT8	BufSetAddr[ sizeof( SetupSetUsbAddr ) ] ;
	memcpy ( BufSetAddr, SetupSetUsbAddr, sizeof( SetupSetUsbAddr ) );
	( (PUSB_SETUP_REQ)BufSetAddr ) -> wValueL = addr;  // USB豸ַ
	s = HostCtrlTransfer374( BufSetAddr, NULL, NULL );  // ִпƴ
	if ( s == USB_INT_SUCCESS ) {
		SetHostUsbAddr( addr );  // USBǰUSB豸ַ
	}
	mDelaymS( 3 );  // ȴUSB豸ɲ
	return( s );
}

UINT8	SetUsbConfig( UINT8 cfg )  // USB豸
{
	UINT8	BufSetCfg[ sizeof( SetupSetUsbConfig ) ] ;
	memcpy ( BufSetCfg, SetupSetUsbConfig, sizeof( SetupSetUsbConfig ) );
	( (PUSB_SETUP_REQ)BufSetCfg ) -> wValueL = cfg;  // USB豸
	return( HostCtrlTransfer374( BufSetCfg, NULL, NULL ) );  // ִпƴ
}

UINT8	GetHubDescriptor(  )
{
	UINT8 s,len;
	buf[0] = GET_HUB_DESCRIPTOR;
	buf[1] = GET_DESCRIPTOR;
	buf[2] = 0x00;
	buf[3] = 0x29;
	buf[4] = 0x00;
	buf[5] = 0x00;
	buf[6] = 0x01;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	if ( s == USB_INT_SUCCESS )
	{
		buf[6] = buf[0];
		buf[0] = GET_HUB_DESCRIPTOR;
		buf[1] = GET_DESCRIPTOR;
		buf[2] = 0x00;
		buf[3] = 0x29;
		buf[4] = 0x00;
		buf[5] = 0x00;
		buf[7] = 0x00;
		s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	}
	return s;
}

/*
UINT8	GetHubStatus( )
{
	UINT8 s,len;
	buf[0] = GET_HUB_STATUS;
	buf[1] = GET_STATUS;
	buf[2] = 0x00;
	buf[3] = 0x00;
	buf[4] = 0x00;
	buf[5] = 0x00;
	buf[6] = 4;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;
}
*/

UINT8	GetPortStatus( UINT8 port )
{
	UINT8 s,len;
	buf[0] = GET_PORT_STATUS;
	buf[1] = GET_STATUS;
	buf[2] = 0x00;
	buf[3] = 0x00;
	buf[4] = port;
	buf[5] = 0x00;
	buf[6] = 4;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;
}

UINT8	SetPortFeature( UINT8 port, UINT8 select )
{
	UINT8 s,len;
	buf[0] = SET_PORT_FEATURE;
	buf[1] = SET_FEATURE;
	buf[2] = select;
	buf[3] = 0x00;
	buf[4] = port;
	buf[5] = 0x00;
	buf[6] = 0x00;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;
}

UINT8	ClearPortFeature( UINT8 port, UINT8 select )
{
	UINT8 s,len;
	buf[0] = CLEAR_PORT_FEATURE;
	buf[1] = CLEAR_FEATURE;
	buf[2] = select;
	buf[3] = 0x00;
	buf[4] = port;
	buf[5] = 0x00;
	buf[6] = 0x00;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;

}

/*
UINT8 ClearHubFeature( UINT8 select )
{
	UINT8 s,len;
	buf[0] = CLEAR_HUB_FEATURE;
	buf[1] = CLEAR_FEATURE;
	buf[2] = select;
	buf[3] = 0x00;
	buf[4] = 0x00;
	buf[5] = 0x00;
	buf[6] = 0x00;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;
}
*/

/*
UINT8 SetHubFeature( UINT8 select )
{
	UINT8 s,len;
	buf[0] = SET_HUB_FEATURE;
	buf[1] = SET_FEATURE;
	buf[2] = select;
	buf[3] = 0x00;
	buf[4] = 0x00;
	buf[5] = 0x00;
	buf[6] = 0x00;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;

}
*/

/*
UINT8	GetBusState( UINT8 port)
{
	UINT8 s,len;
	buf[0] = GET_BUS_STATE;
	buf[1] = GET_STATE;
	buf[2] = 0x00;
	buf[3] = 0x00;
	buf[4] = port;
	buf[5] = 0x00;
	buf[6] = 0x01;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;
}
*/

/*
UINT8	GetStatus( )
{
	UINT8 s,len;
	buf[0] = 0x80;
	buf[1] = 0x00;
	buf[2] = 0x00;
	buf[3] = 0x00;
	buf[4] = 0x00;
	buf[5] = 0x00;
	buf[6] = 0x02;
	buf[7] = 0x00;
	s = HostCtrlTransfer374( buf, buf, &len );  // ִпƴ
	return s;
}
*/

UINT8	DeviceEnum( UINT8 addr )
{
	UINT8 s , i ;
	//printf( "SetUsbAddress:\n" );
	s = SetUsbAddress( addr );  // USB豸ַ
	if ( s != USB_INT_SUCCESS ) return s;
	printf("GetConfigDescr:\n" );
	s = GetConfigDescr( buf );  // ȡ
	if ( s != USB_INT_SUCCESS ) return s;
	bConfig = ((PUSB_CFG_DESCR)buf ) -> bConfigurationValue;
	for ( i = 0; i < ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL; i ++ ) printf( "0x%02X ", (UINT16)( buf[i] ) );
	printf("\n");
	/* ȡ˵/˵ַ/˵Сȣ±endp_addrendp_size */
	//printf( "\nSetUsbConfig:\n " );
	s = SetUsbConfig( bConfig );  // USB豸
	if ( s != USB_INT_SUCCESS ) return s;
	return s;	
}

UINT8	HubEnum( UINT8 addr )
{
	UINT8 s , i ;
	//printf( "SetAddress:\n" );
	s = SetUsbAddress( addr );  // HUBַ
	if ( s != USB_INT_SUCCESS ) return s;
	printf("GetConfigDescr:\n" );
	s = GetConfigDescr( buf );  // ȡ
	if ( s != USB_INT_SUCCESS ) return s;
	bHUBendp = ((PUSB_CFG_DESCR_LONG)buf)->endp_descr[0].bEndpointAddress;
	bInterval = ((PUSB_CFG_DESCR_LONG)buf)->endp_descr[0].bInterval;
	bConfig = ((PUSB_CFG_DESCR)buf ) -> bConfigurationValue;	 
	bHUBendp = bHUBendp & 0x7f;// ֻ˵ĵַ
	for ( i = 0; i < ( (PUSB_CFG_DESCR)buf ) -> wTotalLengthL; i ++ ) printf( "0x%02X ", (UINT16)( buf[i] ) );
	printf( "\n" );
	/* ȡ˵/˵ַ/˵Сȣ±endp_addrendp_size */
	printf( "GetHubDescriptor:\n");
	s = GetHubDescriptor(  );
	if ( s != USB_INT_SUCCESS ) return s;
	for( i= 0; i< buf[0]; i++ ) printf( "0x%02x ",(UINT16)buf[i]);
	printf("\n");
	bNumPort = p_HUB_Descr->bNbrPorts; // hubϵĶ˿
	//printf("HUB at %02x have %02x ports.\n",(UINT16)addr,(UINT16)bNumPort);
	//if( p_HUB_Descr->wHubCharacteristics[0] & 0x04 ) printf("мĸ豸\n");
	//else printf("һļƷ\n");
/*
	printf("Get Status: ");
	s = GetStatus( );
	if ( s != USB_INT_SUCCESS ) {
	printf( "ERROR = %02X\n", (UINT16)s );
	goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
	}
	printf(" %02x %02x\n",(UINT16)buf[0],(UINT16)buf[1]);
*/			
	//printf( "SetUsbConfig:\n" );
	s = SetUsbConfig( bConfig );  // USB豸
	if ( s != USB_INT_SUCCESS ) return s;
	for( i= 1; i<= bNumPort; i++ ) // ˿ڶϵ
	{
		s = SetPortFeature( i, PORT_POWER );
		if ( s != USB_INT_SUCCESS ) return s; 
	}
	return s;
}

UINT8	PortEnum( ) // ؼĶ˿ڽвѯֻѯһΣûӻƳ¼
{
	UINT8 s , i ;
	//printf("p\n");
	Write374Byte( REG_USB_ADDR, bAddr ); // Ϊѡļַ
	for( i= 1; i<= bNumPort; i++ ) // ѯĶ˿Ƿб仯
	{
		s = GetPortStatus( i ); // ȡ˿״̬
		if ( s != USB_INT_SUCCESS ) return s;	
		//printf("HUB  Port%02x's current status: %02x %02x %02x %02x\n",(UINT16)i,(UINT16)buf[0],(UINT16)buf[1],(UINT16)buf[2],(UINT16)buf[3]);
		if( (buf[0] & 0x01) && (buf[2] & 0x01) ) // 豸
		{
			bPORTchange = i; // ˿豸
			i = FIND_ATTACH; // ʾ豸
			//printf("HUB at %02x Port%02x's current status:",(UINT16)bAddr,(UINT16)bPORTchange);
			s = GetPortStatus( bPORTchange ); // Ѷ˿״̬ʾ
			if ( s != USB_INT_SUCCESS ) return s; 
			//printf(" %02x %02x %02x %02x\n",(UINT16)buf[0],(UINT16)buf[1],(UINT16)buf[2],(UINT16)buf[3]);
			//if( buf[0] & 0x01 ) printf("豸\n");

			if( buf[1] & 0x02 ) // жǵٻȫ豸
			{
				printf("Low speed device\n");
				bMine = LOW_SPEED; // ʾ豸
			}
			else 
			{
				printf("Full speed device\n");
				bMine = FULL_SPEED;
			}

			mDelaymS(200);
			//printf("Reset HUB at %02x port%02x\n",(UINT16)bAddr,(UINT16)bPORTchange);
			s = SetPortFeature( bPORTchange, PORT_RESET ); // 豸ӵĶ˿ڸλ
			if ( s != USB_INT_SUCCESS ) return s;
			do // ѯλ˿ڣֱλ,ɺ״̬ʾ
			{
				s = GetPortStatus( bPORTchange );
				if ( s != USB_INT_SUCCESS ) return s;	
			}
			while( ( buf[2] & 0x10 ) != 0x10 ); // ˿ڸλɱ־Ϊ1
			//printf("HUB at %02x port%02x's current status:",(UINT16)bAddr,(UINT16)bPORTchange );
			//printf(" %02x %02x %02x %02x\n",(UINT16)buf[0],(UINT16)buf[1],(UINT16)buf[2],(UINT16)buf[3]);		
			mDelaymS(20);
		}
		else if( ( ( buf[0] & 0x01 ) == 0 ) && ( buf[2] & 0x01 ) ) // ˿ڷ豸Ƴ¼
		{
			bPORTchange = i; // 豸ƳĶ˿
			
			i = FIND_REMOVE; // 豸Ƴ
			//printf("HUB at %02x Port%02x's current status:",(UINT16)bAddr,(UINT16)bPORTchange);
			s = GetPortStatus( bPORTchange );
			if ( s != USB_INT_SUCCESS ) return s; 
			//printf(" %02x %02x %02x %02x\n",(UINT16)buf[0],(UINT16)buf[1],(UINT16)buf[2],(UINT16)buf[3]);
			
		}
		
		//printf("Port%02x's current status: %02x %02x %02x %02x\n",(UINT16)i,(UINT16)buf[0],(UINT16)buf[1],(UINT16)buf[2],(UINT16)buf[3]);
		// ӻƳֱ־
		if( buf[2] & 0x11 ) // λɣ״̬ӻƳ־
		{
			s = ClearPortFeature( bPORTchange, C_PORT_RESET ); // λɱ־
			if ( s != USB_INT_SUCCESS ) return s;
			s = ClearPortFeature( bPORTchange, C_PORT_CONNECTION ); // ӻƳ仯־
			if ( s != USB_INT_SUCCESS ) return s;
			s = GetPortStatus( bPORTchange ); // ڶȡ״̬ȷ
			if ( s != USB_INT_SUCCESS ) return s; 
			//printf("HUB at %02x Port%02x's current status: %02x %02x %02x %02x\n",(UINT16)bAddr,(UINT16)bPORTchange,(UINT16)buf[0],(UINT16)buf[1],(UINT16)buf[2],(UINT16)buf[3]);
		}			
		
		if( i == FIND_ATTACH || i == FIND_REMOVE ) break; // һ˿豸ӻƳ¼ͽѯ
	}
	bChange = i;
	mDelaymS( 200 ); 
	return s; // زɹ
}

/* Ϊprintfgetkeyʼ */
void	mInitSTDIO( )
{
	SCON = 0x50;
	PCON = 0x80;
//	TL2 = RCAP2L = 0 - 10; /* 18.432MHz, 57600bps */
	TL2 = RCAP2L = 0 - 13; /* 24MHz, 57600bps */
	TH2 = RCAP2H = 0xFF;
	T2CON = 0x34;  /* ʱ2ڴڵĲʷ */
	TI = 1;
}

int	main( void )  // USB host
{
	UINT8	i, s , n  , count ;
	UINT8	m, m1, m2, m3;
	UINT8	k, k1, k2;
	
//	P1&=0xF8; // Uļдģñϱ
	mDelaymS( 50 );  // ȴCH374λ
	CH374_PORT_INIT( );  /* CH374ӿڳʼ */

	mInitSTDIO( );  /* Ϊüͨڼʾ */
	printf( "Start CH374 Host\n" );

	Init374Host( );  // ʼUSB
	while ( 1 ) {
		HostSetBusFree( );  // 趨USB
		printf( "Wait Device In\n" );
		while ( 1 ) {
			if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
			if ( Query374DeviceIn( ) ) break;  // USB豸
		}
		mDelaymS( 250 );  // USB豸ղδȶʵȴUSB豸ٺ룬ζ
		if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж

		printf( "Reset Device\n" );
		HostSetBusReset( );  // USB߸λ
		for ( i = 0; i < 100; i ++ ) {  // ȴUSB豸λ
			if ( Query374DeviceIn( ) ) break;  // USB豸
			mDelaymS( 1 );
		}
		if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
		if ( Query374DeviceIn( ) ) {  // USB豸
			if ( Query374DevFullSpeed( ) ) {
				HostSetFullSpeed( );  // ⵽ȫUSB豸
				printf( "Start Full-Speed Device\n" );
			}
			else {  // οEMB_HUBеĵӴ
				HostSetLowSpeed( );  // ⵽USB豸,οEMB_HUBеĵӴ
				printf( "Start Low-Speed Device\n" );
			}
		}
		else {
			printf( "Device gone !\n" );
			continue;  // 豸ѾϿ,ȴ
		}
		mDelaymS( 200 );
		if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж

		bHubNum = 0; // 
		bDevNum = 0; // 豸
		printf( "GetDeviceDescr: " );
		s = GetDeviceDescr( buf );  // ȡ豸
		if ( s != USB_INT_SUCCESS ) 
		{
			//printf( "ERROR = %02X\n", (UINT16)s );
			goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
		}
		for ( i = 0; i < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; i ++ ) printf( "0x%02X ", (UINT16)( buf[i] ) );
		printf( "\n" ); // ʾ

		if( ((PUSB_DEV_DESCR)buf ) -> bDeviceClass == 0x09 ) // һ豸Ǽ
		{
			bHubNum++; // һ

			count = 0;
			while(1)
			{
				if( p_Dev_Addr->Num[count].bAddr == 0 ) break;// п
				count++;
				//if( count > 127 ) break; // 
			}
			//if( count > 127 )
			//{
			//	printf("You have used all usb addresses.\n");
			//	goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
			//}
			//else
			//{
			bAddr = count + 1; // ҵûùĵַ
			//}

			printf( "******** Appoint address %d to attached Root Hub  ********\n",(UINT16)bAddr );
			kk = 1;
			s = HubEnum( bAddr ); // ö
			if ( s != USB_INT_SUCCESS ) 
			{
				//printf( "ERROR = %02X\n", (UINT16)s );
				goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
			}
			printf("OK\n");

			p_Dev_Addr->Num[count].bAddr = bAddr;
			p_Dev_Addr->Num[count].bDevType = HUB_TYPE;
			p_Dev_Addr->Num[count].bUpPort = 0xff; // 
			p_Dev_Addr->Num[count].bEndpSize = UsbDevEndpSize;
			p_Dev_Addr->Num[count].KUNO.HUB.bNumPort = bNumPort;
			p_Dev_Addr->Num[count].KUNO.HUB.bHUBendp = bHUBendp;
			p_Dev_Addr->Num[count].KUNO.HUB.bInterval = bInterval;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[0] = 0;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[1] = 0;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[2] = 0;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[3] = 0;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[4] = 0;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[5] = 0;
			p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[6] = 0;

			/////Ϣ¼
			while(1)
			{
				bPORTchange = 0;
				bChange = 0;
				bMine = 0;
				count = 0;
				n = 0;
				while( n < bHubNum ) // м
				{
					bPORTchange = 0;
					bMine = 0;	
					bChange = 0;
					
					while( 1 )
					{
						if( p_Dev_Addr->Num[count].bDevType == HUB_TYPE && p_Dev_Addr->Num[count].bAddr != 0 ) break;// ַͣ0,
						count++;
						if( count > 50 )
						{
							count = 0;
							n = 0;
						}
					}
					
					////// üϢ
					bAddr = p_Dev_Addr->Num[count].bAddr;
					UsbDevEndpSize = p_Dev_Addr->Num[count].bEndpSize;
					bNumPort = p_Dev_Addr->Num[count].KUNO.HUB.bNumPort;
					bHUBendp = p_Dev_Addr->Num[count].KUNO.HUB.bHUBendp;
					bInterval = p_Dev_Addr->Num[count].KUNO.HUB.bInterval;
					
					s = PortEnum( );
					
					if ( s == 0x20 ) // Ӧ,Ѿγ
					{
						//printf("Find removed.\n");
						if( bAddr == 1 )
						{
							goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
							//printf("Root hub removed.\n");
						}
						printf("######## The removed hub's address is %d ########\n",(UINT16)bAddr);
						p_Dev_Addr->Num[(bAddr-1)].bAddr = 0; // ȡƳϲ㼯ı
						bHubNum--; // һ

						for( k = 0; k< 7; k++ ) // жϸƳϲ㼯Ķ˿û豸
						{
							if( p_Dev_Addr->Num[(bAddr-1)].KUNO.HUB.bSlavePort[k] != 0 ) // Ƴϲ㼯Ķ˿ҵӵĴμ豸
							{
								m1 = p_Dev_Addr->Num[(bAddr-1)].KUNO.HUB.bSlavePort[k]; // ȡһַ
								if( p_Dev_Addr->Num[(m1-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m1-1)].bAddr != 0 ) // Ƴ豸
								{
									printf("######## The removed device's address is %d ########\n",(UINT16)m1);
									p_Dev_Addr->Num[(m1-1)].bAddr = 0; // ȡƳĴϲ㹦豸ı
									bDevNum--; // 豸1
								}
								else if(  p_Dev_Addr->Num[(m1-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m1-1)].bAddr != 0 ) // ƳǼ
								{
									printf("######## The removed hub's address is %d ########\n",(UINT16)m1);
									p_Dev_Addr->Num[(m1-1)].bAddr = 0; // ȡƳĴϲ㼯ı
									bHubNum--; // һ

									for( k1 = 0; k1 < 7; k1 ++ )
									{
										if( p_Dev_Addr->Num[(m1-1)].KUNO.HUB.bSlavePort[k1] != 0 ) // μ˿ҵδμ豸
										{
											m2 = p_Dev_Addr->Num[(m1-1)].KUNO.HUB.bSlavePort[k1]; // δμ豸ַ
											if( p_Dev_Addr->Num[(m2-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m2-1)].bAddr != 0 ) // Ƴ豸
											{
												printf("######## The removed device's address is %d ########\n",(UINT16)m2);
												p_Dev_Addr->Num[(m2-1)].bAddr = 0; // ȡƳĴδϲ㹦豸ı
												bDevNum--; // 豸1
											}
											else if( p_Dev_Addr->Num[(m2-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m2-1)].bAddr != 0 ) // ƳǼ
											{
												printf("######## The remove hub's address is %d  ########\n",(UINT16)m2);
												p_Dev_Addr->Num[(m2-1)].bAddr = 0; // ȡƳĴδϲ㼯ı
												bHubNum--; // һ

												for( k2 = 0; k2 < 7; k2++ )
												{
													if( p_Dev_Addr->Num[(m2-1)].KUNO.HUB.bSlavePort[k2] != 0 ) // δμ˿ҵδδμ豸
													{
														m3 = p_Dev_Addr->Num[(m2-1)].KUNO.HUB.bSlavePort[k2]; //// δδμ豸ַ
														if( p_Dev_Addr->Num[(m3-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m3-1)].bAddr != 0 ) // Ƴ豸
														{
															printf("######## The removed device's address is %d ########\n",(UINT16)m3);
															p_Dev_Addr->Num[(m3-1)].bAddr = 0; // ȡƳĴδδϲ㹦豸ı
															bDevNum--; // 豸1
														}
														else if( p_Dev_Addr->Num[(m3-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m3-1)].bAddr!= 0 ) // ƳǼ
														{
															printf("######## The removed hub's address is %d ########\n",(UINT16)m3);
															p_Dev_Addr->Num[(m3-1)].bAddr = 0; // ȡƳĴδδϲ㼯ı
															bHubNum--; // һ

																/////ˣֻ֧5
														}
													}

												} // Ҳδδμ豸˳
											}
										}
									} // Ҳδμ豸˳
								}
							}
						} // Ҳμ豸˳



						count = 0;
						n = 0;
						bPORTchange = 0;
						bMine = 0;
						bChange = 0;
					} 
					else if ( s != USB_INT_SUCCESS ) // 
					{
						if( bAddr != 1 )
						{
							//printf( "ERROR = %02X\n", (UINT16)s );
							;
						}
						else
						{
							//printf("Root hub removed.\n");
							;
						}
						goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
					}
					else // Ӧ
					{
						if( bPORTchange != 0 ) // ѡеļж˿ڷ仯
						{
							if( bChange == FIND_ATTACH ) // 豸¼
							{
							
								//printf("Hub at address %02x Port %02x find attaching.\n",(UINT16)bAddr,(UINT16)bPORTchange);
								Write374Byte( REG_USB_ADDR, 0x00 ); // 豸ַ0
								if( bMine == LOW_SPEED )
								{
									s = SetPortFeature( bChange, PORT_LOW_SPEED );
									k = 0;
									while(1) // ûùĵַռ
									{
										if( p_Dev_Addr->Num[k].bAddr == 0 ) break; // п
										k++;
									}
									p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[(bPORTchange-1)] = k + 1; // ¼Ķ˵ָ豸ĵַ
									p_Dev_Addr->Num[k].bUpPort = bAddr; // ָһĵַ
									bAddr = k + 1; // Լҵδõַ
									bDevNum++; // 豸1
									printf( "******** Appoint address %d to attached device  ********\n",(UINT16)bAddr );
									HostSetLowSpeed( ); //Ϊģʽ
									Write374Byte( REG_HUB_SETUP, BIT_HUB_DISABLE | BIT_HUB_PRE_PID );
										s = DeviceEnum( bAddr );
									Write374Byte( REG_HUB_SETUP, BIT_HUB_DISABLE );
									HostSetFullSpeed( ); //Ϊȫģʽ
										if ( s != USB_INT_SUCCESS ) 
										{
											//printf( "ERROR = %02X\n", (UINT16)s );
											goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
										}
									printf("OK\n");

									////// ¼빦豸Ϣ
									p_Dev_Addr->Num[k].bAddr = bAddr;
									p_Dev_Addr->Num[k].bDevType = FUNCTION_DEV;
								
									p_Dev_Addr->Num[k].KUNO.DEV.bSpeed = bMine;
								}
								else if( bMine == FULL_SPEED )  
								{
									HostSetFullSpeed( ); // Ϊȫģʽ
									printf( "GetDeviceDescr: " );
									s = GetDeviceDescr( buf );  // ȡ豸
									if ( s != USB_INT_SUCCESS ) 
									{
										//printf( "ERROR = %02X\n", (UINT16)s );
										goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
									}
									for ( i = 0; i < ( (PUSB_SETUP_REQ)SetupGetDevDescr ) -> wLengthL; i ++ ) printf( "0x%02X ", (UINT16)( buf[i] ) );
									printf( "\n" );

									k = 0;
									while(1) // ûùĵַռ
									{
										if( p_Dev_Addr->Num[k].bAddr == 0 ) break; // п
										k++;
									}
									p_Dev_Addr->Num[count].KUNO.HUB.bSlavePort[(bPORTchange-1)] = k + 1; // ¼Ķ˵ָ豸ĵַ
									p_Dev_Addr->Num[k].bUpPort = bAddr; // ָһĵַ
									bAddr = k + 1; // Լҵδõַ

									if( ((PUSB_DEV_DESCR)buf ) -> bDeviceClass == 0x09 ) // HUB
									{
										bHubNum++; // һ
								
								
										printf( "******** Appoint address %d to attached hub  ********\n",(UINT16)bAddr );
										s = HubEnum( bAddr ); // ö
										if ( s != USB_INT_SUCCESS ) 
										{
											//printf( "ERROR = %02X\n", (UINT16)s );
											goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
										}
										printf("OK\n");

										//// ¼뼯Ϣ
										p_Dev_Addr->Num[k].bAddr = bAddr;	
										p_Dev_Addr->Num[k].bDevType = HUB_TYPE;
										p_Dev_Addr->Num[k].bEndpSize = UsbDevEndpSize;
										p_Dev_Addr->Num[k].KUNO.HUB.bNumPort = bNumPort;
										p_Dev_Addr->Num[k].KUNO.HUB.bHUBendp = bHUBendp;
										p_Dev_Addr->Num[k].KUNO.HUB.bInterval = bInterval;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[0] = 0;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[1] = 0;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[2] = 0;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[3] = 0;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[4] = 0;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[5] = 0;
										p_Dev_Addr->Num[k].KUNO.HUB.bSlavePort[6] = 0;

									}
									else // 豸
									{
										bDevNum++; // 豸1
										printf( "******** Appoint address %d to attached device ********\n",(UINT16)bAddr );
										s = DeviceEnum( bAddr );
										if ( s != USB_INT_SUCCESS ) 
										{
											//printf( "ERROR = %02X\n", (UINT16)s );
											goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
										}
										printf("OK\n");

										////// ¼빦豸Ϣ
										p_Dev_Addr->Num[k].bAddr = bAddr;
										p_Dev_Addr->Num[k].bDevType = FUNCTION_DEV;
										p_Dev_Addr->Num[k].bEndpSize = UsbDevEndpSize;
										p_Dev_Addr->Num[k].KUNO.DEV.bSpeed = bMine;
									}
								}
								count++; // ѯһ
								n++;

							}
						
							else if( bChange == FIND_REMOVE ) // 豸Ƴ¼
							{
								count = 0; // ѯ
								n = 0;
								//printf("Hub at address %02x Port %02x find removed.\n",(UINT16)bAddr,(UINT16)bPORTchange);
								m = p_Dev_Addr->Num[(bAddr-1)].KUNO.HUB.bSlavePort[(bPORTchange-1)]; // ȡƳ豸ĵַ
								//printf("m %02x\n",(UINT16)m);
								if( m != 0 ) // Ƴϲ豸ĵַ豸¿ܻб豸
								{
									if( p_Dev_Addr->Num[(m-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m-1)].bAddr != 0 ) // Ƴ豸
									{
										printf("######## The removed device's address is %d ########\n",(UINT16)m);
										p_Dev_Addr->Num[(m-1)].bAddr = 0; // ȡƳϲ㹦豸ı
										bDevNum--; // 豸1

									}
									else if(  p_Dev_Addr->Num[(m-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m-1)].bAddr != 0 ) // ƳǼ
									{
								
										printf("######## The removed hub's address is %d ########\n",(UINT16)m);
										p_Dev_Addr->Num[(m-1)].bAddr = 0; // ȡƳϲ㼯ı
										bHubNum--; // һ

										for( k = 0; k< 7; k++ ) // жϸƳϲ㼯Ķ˿û豸
										{
											if( p_Dev_Addr->Num[(m-1)].KUNO.HUB.bSlavePort[k] != 0 ) // Ƴϲ㼯Ķ˿ҵӵĴμ豸
											{
												m1 = p_Dev_Addr->Num[(m-1)].KUNO.HUB.bSlavePort[k]; // ȡһַ
												if( p_Dev_Addr->Num[(m1-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m1-1)].bAddr != 0 ) // Ƴ豸
												{
													printf("########  The removed device's address is %d ########\n",(UINT16)m1);
													p_Dev_Addr->Num[(m1-1)].bAddr = 0; // ȡƳĴϲ㹦豸ı
													bDevNum--; // 豸1
												}
												else if(  p_Dev_Addr->Num[(m1-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m-1)].bAddr != 0 ) // ƳǼ
												{
													printf("########  The removed hub's address is %d  ########\n",(UINT16)m1);
													p_Dev_Addr->Num[(m1-1)].bAddr = 0; // ȡƳĴϲ㼯ı
													bHubNum--; // һ

													for( k1 = 0; k1 < 7; k1 ++ )
													{
														if( p_Dev_Addr->Num[(m1-1)].KUNO.HUB.bSlavePort[k1] != 0 ) // μ˿ҵδμ豸
														{
															m2 = p_Dev_Addr->Num[(m1-1)].KUNO.HUB.bSlavePort[k1]; // δμ豸ַ
															if( p_Dev_Addr->Num[(m2-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m2-1)].bAddr != 0 ) // Ƴ豸
															{
																printf("######## The removed device's address is %d ########\n",(UINT16)m2);
																p_Dev_Addr->Num[(m2-1)].bAddr = 0; // ȡƳĴδϲ㹦豸ı
																bDevNum--; // 豸1
															}
															else if( p_Dev_Addr->Num[(m2-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m2-1)].bAddr != 0 ) // ƳǼ
															{
																printf("######## The removed hub's address is %d ########\n",(UINT16)m2);
																p_Dev_Addr->Num[(m2-1)].bAddr = 0; // ȡƳĴδϲ㼯ı
																bHubNum--; // һ

																for( k2 = 0; k2 < 7; k2++ )
																{
																	if( p_Dev_Addr->Num[(m2-1)].KUNO.HUB.bSlavePort[k2] != 0 ) // δμ˿ҵδδμ豸
																	{
																		m3 = p_Dev_Addr->Num[(m2-1)].KUNO.HUB.bSlavePort[k2]; //// δδμ豸ַ
																		if( p_Dev_Addr->Num[(m3-1)].bDevType == FUNCTION_DEV && p_Dev_Addr->Num[(m3-1)].bAddr != 0 ) // Ƴ豸
																		{
																			printf("######## The removed device's address is %d ########\n",(UINT16)m3);
																			p_Dev_Addr->Num[(m3-1)].bAddr = 0; // ȡƳĴδδϲ㹦豸ı
																			bDevNum--; // 豸1
																		}
																		else if( p_Dev_Addr->Num[(m3-1)].bDevType == HUB_TYPE && p_Dev_Addr->Num[(m3-1)].bAddr != 0 ) // ƳǼ
																		{
																			printf("######## The removed hub's address is %d ########\n",(UINT16)m3);
																			p_Dev_Addr->Num[(m3-1)].bAddr = 0; // ȡƳĴδδϲ㼯ı
																			bHubNum--; // һ

																			/////ˣֻ֧5

																		}
																	}

																} // Ҳδδμ豸˳
															}
														}
													} // Ҳδμ豸˳
												}
											}
										} // Ҳμ豸˳

									}
								
								}
							}
						}
						else // ѡеļûзֱ仯鿴һ״̬
						{
							count++;
							n++;
						}
					}
				}
			}
		}
		else // һǹ豸,˿Ѿ
		{
			printf( "Function device at address 1, no hub.\n"); 
			kk = 0;
			s = DeviceEnum( 0x01 );
			if ( s != USB_INT_SUCCESS ) {
				//printf( "ERROR = %02X\n", (UINT16)s );
				goto WaitDeviceOut;  // ֹ,ȴUSB豸γ
			}
		}
		
		printf( "USB device ready now\n" );
/* do something, read/write ...
		len = out_endp_size;
		Write374Block( RAM_HOST_TRAN, len, buf );
		Write374Byte( REG_USB_LENGTH, len );
		s = WaitHostTransact374( out_endp_addr, DEF_USB_PID_OUT, FALSE, 1000 );
		s = WaitHostTransact374( in_endp_addr, DEF_USB_PID_IN, FALSE, 1000 );
		len = Read374Byte( REG_USB_LENGTH );
		Read374Block( RAM_HOST_RECV, len, buf );
		len = out_endp_size;
		Write374Block( RAM_HOST_TRAN, len, buf );
		Write374Byte( REG_USB_LENGTH, len );
		s = WaitHostTransact374( out_endp_addr, DEF_USB_PID_OUT, TRUE, 1000 );
		s = WaitHostTransact374( in_endp_addr, DEF_USB_PID_IN, TRUE, 1000 );
		len = Read374Byte( REG_USB_LENGTH );
		Read374Block( RAM_HOST_RECV, len, buf );
*/
		printf( "do something, read / write ......\n" );

WaitDeviceOut:  // ȴUSB豸γ
		for( mm = 0; mm < sizeof(xbuf); mm++ ) xbuf[mm] = 0;
		if( kk ) printf("Root hub removed\n");
		else printf( "Wait Device Out\n" );
		kk = 0;
		
		while ( 1 ) {
			if ( Query374Interrupt( ) ) HostDetectInterrupt( );  // USBж
			if ( Query374DeviceIn( ) == FALSE ) break;  // ûUSB豸
		}
		mDelaymS( 100 );  // ȴ豸ȫϿζ
		if ( Query374DeviceIn( ) ) goto WaitDeviceOut;  // ûȫϿ
//		HostSetBusFree( );  // 趨USBУҪĿǹرSOF
		for( mm = 0; mm < sizeof(xbuf); mm++ ) xbuf[mm] = 0;
		
	}
}
