/* CH374оƬ Ӳ׼SPIӵӲ V1.0 */
/* ṩI/Oӿӳ,ṩĴдӳ */

#include	"HAL.H"

/* еӲӷʽ(ʵӦõ·Բ޸弰ӳ) */
/* Ƭ    CH374оƬ
      P1.4                 SCS#
      P1.5                 SDI
      P1.6                 SDO
      P1.7                 SCK      */
sbit	P14					=	P1^4;
#define	CH374_SPI_SCS			P14		/* ٶCH374SCS */

sfr		SPDR = 0x86;	/* SPIݼĴ */
sfr		SPSR = 0xAA;	/* SPI״̬Ĵ */
sfr		SPCR = 0xD5;    /* SPIƼĴ */
#define	SPI_IF_TRANS	0x80	/* SPIֽڴɱ־,SPSRλ7 */

void CH374_PORT_INIT( )  /* ʹͨI/OģⲢڶдʱ,Խгʼ */
{
/* ӲSPIӿ,ôʹmode3(CPOL=1&CPHA=1)mode0(CPOL=0&CPHA=0),CH374ʱز,½,λǸλǰ */
	CH374_SPI_SCS = 1;  /* ֹSPIƬѡ */
/* ˫I/OģSPIӿ,ôڴSPI_SCS,SPI_SCK,SPI_SDIΪ,SPI_SDOΪ뷽 */
	SPCR = 0x5C;  /* SPIģʽ3, DORD=0(MSB first), CPOL=1, CPHA=1, CH374Ҳ֧SPIģʽ0 */
}

UINT8	Spi374Exchange( UINT8 d )  /* ӲSPI8λ */
{  /* Ϊٶ,ԽӳɺԼӳò */
	SPDR = d;  /* ȽдSPIݼĴ,ȻѯSPI״̬ĴԵȴSPIֽڴ */
	while ( ( SPSR & SPI_IF_TRANS ) == 0 );  /* ѯSPI״̬ĴԵȴSPIֽڴ */
	SPSR &= ~ SPI_IF_TRANS;  /* SPIֽڴɱ־,еĵƬԶ */
	return( SPDR );  /* ȲѯSPI״̬ĴԵȴSPIֽڴ,ȻSPIݼĴ */
}

#define	Spi374OutByte( d )		Spi374Exchange( d )		/* SPI8λ */
#define	Spi374InByte( )			Spi374Exchange( 0xFF )	/* SPI8λ */

void	Spi374Start( UINT8 addr, UINT8 cmd )  /* SPIʼ */
{
//	CH374_SPI_SCS = 1;
/* ˫I/OģSPIӿ,ôȷѾSPI_SCS,SPI_SCK,SPI_SDIΪ,SPI_SDOΪ뷽 */
	CH374_SPI_SCS = 0;  /* SPIƬѡЧ */
	Spi374OutByte( addr );
	Spi374OutByte( cmd );
}

#define	Spi374Stop( )	{ CH374_SPI_SCS = 1; }  /* SPI */
//void	Spi374Stop( void )  /* SPI */
//{
//	CH374_SPI_SCS = 1;	/* SPIƬѡЧ */
//}

UINT8	Read374Byte( UINT8 mAddr )  /* ָĴȡ */
{
	UINT8	d;
	Spi374Start( mAddr, CMD_SPI_374READ );
	d = Spi374InByte( );
	Spi374Stop( );
	return( d );
}

void	Write374Byte( UINT8 mAddr, UINT8 mData )  /* ָĴд */
{
	Spi374Start( mAddr, CMD_SPI_374WRITE );
	Spi374OutByte( mData );
	Spi374Stop( );
}

void	Read374Block( UINT8 mAddr, UINT8 mLen, PUINT8 mBuf )  /* ָʼַݿ */
{
	Spi374Start( mAddr, CMD_SPI_374READ );
	while ( mLen -- ) *mBuf++ = Spi374InByte( );
	Spi374Stop( );
}

void	Write374Block( UINT8 mAddr, UINT8 mLen, PUINT8 mBuf )  /* ָʼַдݿ */
{
	Spi374Start( mAddr, CMD_SPI_374WRITE );
	while ( mLen -- ) Spi374OutByte( *mBuf++ );
	Spi374Stop( );
}
