/* Define for CH373 & CH374          */
/* Website:  http://winchiphead.com  */
/* Email:    tech@winchiphead.com    */
/* Author:   W.ch 2005.10            */
/* V1.3 for CH373/CH374              */

#ifndef __CH374INC_H__
#define __CH374INC_H__

#ifdef __cplusplus
extern "C" {
#endif

/* ********************************************************************************************************************* */
/* ͺͳ */

#ifndef		BOOL
typedef		unsigned char	BOOL;
#endif
#ifndef		TRUE
#define		TRUE	1
#define		FALSE	0
#endif
#ifndef		NULL
#define		NULL	0
#endif

#ifndef UINT8
typedef unsigned char                UINT8;
#endif
#ifndef UINT16
typedef unsigned short               UINT16;
#endif
#ifndef UINT32
typedef unsigned long                UINT32;
#endif
#ifndef PUINT8
typedef unsigned char               *PUINT8;
#endif
#ifndef PUINT16
typedef unsigned short              *PUINT16;
#endif
#ifndef PUINT32
typedef unsigned long               *PUINT32;
#endif
#ifndef UINT8V
typedef unsigned char volatile       UINT8V;
#endif

/* ********************************************************************************************************************* */
/* USBЭ㶨 */

/* USBİʶPID, ʽõ */
#ifndef	DEF_USB_PID_SETUP
#define	DEF_USB_PID_NULL	0x00			/* PID, δ */
#define	DEF_USB_PID_SOF		0x05
#define	DEF_USB_PID_SETUP	0x0D
#define	DEF_USB_PID_IN		0x09
#define	DEF_USB_PID_OUT		0x01
#define	DEF_USB_PID_ACK		0x02
#define	DEF_USB_PID_NAK		0x0A
#define	DEF_USB_PID_STALL	0x0E
#define	DEF_USB_PID_DATA0	0x03
#define	DEF_USB_PID_DATA1	0x0B
#define	DEF_USB_PID_PRE		0x0C
#endif

/* ********************************************************************************************************************* */
/* оƬ */

/* Ĵ */

#define	RAM_ENDP0_SIZE		0x08		/* ˵0Ļ */
#define	RAM_ENDP0_TRAN		0x20		/* ˵0ͻʼַ */
#define	RAM_ENDP0_RECV		0x28		/* ˵0ջʼַ */
#define	RAM_ENDP1_SIZE		0x08		/* ˵1Ļ */
#define	RAM_ENDP1_TRAN		0x30		/* ˵1ͻʼַ */
#define	RAM_ENDP1_RECV		0x38		/* ˵1ջʼַ */
#define	RAM_ENDP2_SIZE		0x40		/* ˵2Ļ */
#define	RAM_ENDP2_TRAN		0x40		/* ˵2ͻʼַ */
#define	RAM_ENDP2_RECV		0xC0		/* ˵2ջʼַ */
#define	RAM_ENDP2_EXCH		0x80		/* ˵2ûʼַ */
#define	RAM_HOST_TRAN		0x40		/* ͻʼַ */
#define	RAM_HOST_RECV		0xC0		/* ջʼַ */
#define	RAM_HOST_EXCH		0x80		/* ûʼַ */

#define	REG_HUB_SETUP		0x02		/* USBʽ: ROOT-HUB */
#define	REG_HUB_CTRL		0x03		/* USBʽ: ROOT-HUB */
#define	REG_SYS_INFO		0x04		/* ϵͳϢ, ֻ */
#define	REG_SYS_CTRL		0x05		/* ϵͳ, λӰ */
#define	REG_USB_SETUP		0x06		/* USB */
#define	REG_INTER_EN		0x07		/* жʹ */
#define	REG_USB_ADDR		0x08		/* USB豸ַ */
#define	REG_INTER_FLAG		0x09		/* жϱ־, ֻ, λд10 */
#define	REG_USB_STATUS		0x0A		/* USB״̬, ֻ */
#define	REG_USB_LENGTH		0x0B		/* USB, ΪǰUSBճ, 豸ʽдΪUSB˵2, ʽдΪUSBͳ */
#define	REG_USB_ENDP0		0x0C		/* USB豸ʽ: USB˵0 */
#define	REG_USB_ENDP1		0x0D		/* USB豸ʽ: USB˵1 */
#define	REG_USB_H_PID		0x0D		/* USBʽ: USB */
#define	REG_USB_ENDP2		0x0E		/* USB豸ʽ: USB˵2 */
#define	REG_USB_H_CTRL		0x0E		/* USBʽ: USB */

/* Ĵλú궨 */

#define	BIT_HUB0_EN			0x01		/* HUB0˿ڵUSBʹ: 0-ֹ, 1- */
#define	BIT_HUB0_RESET		0x02		/* HUB0˿ڵUSB߸λ: 0-λ, 1-λ */
#define	BIT_HUB0_POLAR		0x04		/* HUB0˿ڵźżԿ: 0-/ȫ, 1-/ */
#define	BIT_HUB0_ATTACH		0x08		/* HUB0˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */
#define	BIT_HUB1_DX_IN		0x10		/* HUB1ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
#define	BIT_HUB2_DX_IN		0x20		/* HUB2ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
#define	BIT_HUB_PRE_PID		0x40		/* ǰðPRE PID: 0-ֹ, 1-(ⲿ豸USB-HUB) */
#define	BIT_HUB_DISABLE		0x80		/* ֹROOT-HUB: 0-(USBʽ), 1-ֹ(Ĭ) */

#define	BIT_HUB1_EN			0x01		/* HUB1˿ڵUSBʹ: 0-ֹ, 1- */
#define	BIT_HUB1_RESET		0x02		/* HUB1˿ڵUSB߸λ: 0-λ, 1-λ */
#define	BIT_HUB1_POLAR		0x04		/* HUB1˿ڵźżԿ: 0-/ȫ, 1-/ */
#define	BIT_HUB1_ATTACH		0x08		/* HUB1˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */
#define	BIT_HUB2_EN			0x10		/* HUB2˿ڵUSBʹ: 0-ֹ, 1- */
#define	BIT_HUB2_RESET		0x20		/* HUB2˿ڵUSB߸λ: 0-λ, 1-λ */
#define	BIT_HUB2_POLAR		0x40		/* HUB2˿ڵźżԿ: 0-/ȫ, 1-/ */
#define	BIT_HUB2_ATTACH		0x80		/* HUB2˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */

#define	BIT_INFO_HW_ID		0x03		/* Ӳʶλ: ǳ01, ˵Ӳ */
#define	BIT_INFO_USB_DM		0x04		/* USBHUB0UD-ŵ߼ƽ״̬: 0-͵ƽ, 1-ߵƽ */
#define	BIT_INFO_USB_DP		0x08		/* USBHUB0UD+ŵ߼ƽ״̬: 0-͵ƽ, 1-ߵƽ */
#define	BIT_INFO_CLK_8KHZ	0x10		/* Ӳ8KHzʱλ */
#define	BIT_INFO_SOF_PRES	0x20		/* Ӳ1mSʱ״̬,USB, 1˵ҪSOF */
#define	BIT_INFO_WAKE_UP	0x40		/* оƬ״̬: 0-˯߻ѹ, 1-ѻ */
#define	BIT_INFO_POWER_RST	0x80		/* Ӳϵ縴λ״̬: 0-ڸλ, 1-λ */

#define	BIT_CTRL_OSCIL_OFF	0x01		/* ʱ: 0-, 1-ֹͣ */
#define	BIT_CTRL_CLK_12MHZ	0x02		/* ʱƵѡ: 0-24MHz, 1-12MHz */
#define	BIT_CTRL_USB_POWER	0x04		/* V3ŵUSBԴ: 0-, 1- */
#define	BIT_CTRL_RESET_NOW	0x08		/* оƬλ: 0-λ, 1-λ */
#define	BIT_CTRL_WATCH_DOG	0x10		/* RSTźRST#ŵĿŹλʹ: 0-, 1- */
#define	BIT_CTRL_INT_PULSE	0x20		/* INT#ŵжʽ: 0-͵ƽж, 1-͵ƽж */
#define	BIT_CTRL_OE_POLAR	0x40		/* UENŵUSBʹܼ: 0-ߵƽʹ, 1-͵ƽʹ */

#define	BIT_SETP_TRANS_EN	0x01		/* USB豸ʽ: USB豸ʹ: 0-ֹ, 1- */
#define	BIT_SETP_PULLUP_EN	0x02		/* USB豸ʽ: USB: 0-, 1- */
#define	BIT_SETP_BUS_CTRL	0x03		/* USBʽ: USB״̬: 00-/, 01-D+D-(߸λ), 10-, 11-D+D-(߻ָ) */
#define	M_SET_USB_BUS_FREE( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x00 )		/* USBʽ: USB߿ */
#define	M_SET_USB_BUS_RESET( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x01 )		/* USBʽ: USB״̬/D+D-(߸λ) */
#define	M_SET_USB_BUS_RESUME( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x03 )		/* USBʽ: USB״̬/D+D-(߻ָ) */
#define	BIT_SETP_RAM_MODE	0x0C		/* ûӦ÷ʽ: 00-ñû, 01-ӽջ128ֽ, 10-ڷ͵ڶ, 11-ڽյڶ */
#define	M_SET_RAM_MODE_OFF( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x00 )		/* ûʽ/ñû */
#define	M_SET_RAM_MODE_128( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x04 )		/* ûʽ/ӽջ128ֽ */
#define	M_SET_RAM_MODE_2TX( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x08 )		/* ûʽ/ڷ͵ĵڶ,֧ */
#define	M_SET_RAM_MODE_2RX( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x0C )		/* ûʽ/ڽյĵڶ,֧ */
#define	BIT_SETP_LOW_SPEED	0x20		/* USBߴٶ: 0-12Mbps, 1-1.5Mbps */
#define	BIT_SETP_USB_SPEED	0x30		/* USB: 00-ȫģʽ/12Mbps, 11-ģʽ/1.5Mbps */
#define	BIT_SETP_LED_ACT	0x40		/* USB豸ʽ: ACT#ŵ͵ƽļ¼: 0-շ, 1-USB */
#define	BIT_SETP_AUTO_SOF	0x40		/* USBʽ: ԶSOFʹ: 0-ֹ, 1- */
#define	BIT_SETP_HOST_MODE	0x80		/* USBӷʽѡ: 0-豸ʽ, 1-ʽ */

#define	BIT_IE_TRANSFER		0x01		/* USBжʹ, 1Ч */
#define	BIT_IE_BUS_RESET	0x02		/* USB豸ʽ: USB߸λжʹ, 1Ч */
#define	BIT_IE_DEV_DETECT	0x02		/* USBʽ: USB豸жʹ, 1Ч */
#define	BIT_IE_USB_SUSPEND	0x04		/* USB߹жʹ, 1Ч */
#define	BIT_IE_USB_RESUME	0x08		/* USB߻ָ/жʹ, 1Ч, 0-ʹоƬж, 1-ʹUSB߻ָж */
#define	BIT_IE_CLK_OUT_DIV	0xF0		/* ɱʱӵķƵ: ƵΪ48MHz/(ֵ+1), : 0000-48MHz, 0001-24MHz, 0010-16MHz, 1111-3MHz */
#define	M_SET_CLK_DIV( old, div )		( (old) & ~ BIT_IE_CLK_OUT_DIV | (div) << 4 )	/* ʱƵ */

#define	BIT_ADDR_USB_DEV	0x7F		/* 豸ʽΪΪUSB豸ĵַ, ʽΪǰUSB豸ַ */

#define	BIT_IF_INTER_FLAG	0x0F		/* еUSBжϱ־ */
#define	BIT_IF_TRANSFER		0x01		/* USBжϱ־, 1Ч, λд1־, λÿUSBɺԶ1 */
#define	BIT_IF_BUS_RESET	0x02		/* USB豸ʽ: USB߸λжϱ־, 1Ч, λд1־, λڼ⵽USB߸λʱԶ1 */
#define	BIT_IF_DEV_DETECT	0x02		/* USBʽ: USB豸μжϱ־, 1Ч, λд1־, λڼ⵽USB豸κԶ1 */
#define	BIT_IF_USB_SUSPEND	0x04		/* USB߹жϱ־, 1Ч, λд1־, λڼ⵽USB߹ʱԶ1 */
#define	BIT_IF_WAKE_UP		0x08		/* оƬжϱ־, 1Ч, λд1־, λоƬɺԶ1 */
#define	BIT_IF_USB_RESUME	0x08		/* USB߻ָ/жϱ־, 1Ч, λд1־, λڼ⵽USB߻ָʱԶ1 */
#define	BIT_IF_USB_PAUSE	0x10		/* USBͣ־, 1Ч, λд1־, λÿUSBɺԶ1 */
#define	BIT_IF_DEV_ATTACH	0x20		/* USB豸״̬: 0-δ/Ͽ/γ, 1-һUSB豸Ѿ/ */
#define	BIT_IF_USB_OE		0x40		/* UENŵUSBʹ״̬: 0-UENΪ͵ƽ, 1-UENΪߵƽ */
#define	BIT_IF_USB_DX_IN	0x80		/* HUB0ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
#define	BIT_HUB0_DX_IN		0x80		/* HUB0ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */

#define	BIT_STAT_THIS_ENDP	0x03		/* USB豸ʽ: USBĿĶ˵: 00-˵0, 01-˵1, 10-˵2, 11- */
#define	BIT_STAT_THIS_PID	0x0C		/* USB豸ʽ: USB/PID: 00-OUT, 01-, 10-IN, 11-SETUP */
#define	BIT_STAT_PID_ENDP	0x0F		/* USB豸ʽ: USBͶ˵,οUSB_INT_EP* */
#define	BIT_STAT_DEV_RESP	0x0F		/* USBʽ: USB豸ӦPID: XX00=ʱ,ֵ-ͬPID,οUSB_INT_RET_* */
#define	M_IS_HOST_TIMEOUT( status )		( ( (status) & 0x03 ) == 0 )		/* USB״̬ǷΪӦʱ/ */
#define	M_IS_HOST_IN_DATA( status )		( ( (status) & BIT_STAT_DEV_RESP & ~ ( DEF_USB_PID_DATA0 ^ DEF_USB_PID_DATA1 ) ) == ( DEF_USB_PID_DATA0 & DEF_USB_PID_DATA1 ) )	/* Ƿ񷵻DATA0DATA1 */
#define	BIT_STAT_TOG_MATCH	0x10		/* ָʾǰĴǷɹ/ǰյݰǷͬ: 0-ͬ, 1-ͬ */
#define	BIT_STAT_BUS_RESET	0x20		/* ǰUSB߸λ״̬: 0-ûиλ, 1-ڸλ */
#define	BIT_STAT_SUSPEND	0x40		/* ǰUSB߹״̬: 0-л, 1-߹ */
#define	BIT_STAT_SIE_FREE	0x80		/* ǰUSBӿSIE״̬: 0=æ/ڴ, 1=/ȴ */

#define	BIT_EP0_TRAN_RESP	0x0F		/* USB豸ʽ: ˵0Ӧ: 0000~1000-Ӧݳ0~8, 1110-ӦNAK, 1111-ӦSTALL,ֵ- */
#define	M_SET_EP0_TRAN_ACK( old, len )	( (old) & ~ BIT_EP0_TRAN_RESP | (len) & 0x0F )	/* USB豸ʽ: ˵0Ӧ/ӦACK */
#define	M_SET_EP0_TRAN_NAK( old )		( (old) & ~ BIT_EP0_TRAN_RESP | 0x0E )		/* USB豸ʽ: ˵0Ӧ/ӦNAK */
#define	M_SET_EP0_TRAN_STA( old )		( (old) & ~ BIT_EP0_TRAN_RESP | 0x0F )		/* USB豸ʽ: ˵0Ӧ/ӦSTALL */
#define	BIT_EP0_RECV_RESP	0x30		/* USB豸ʽ: ˵0Ӧ: 00-ӦACK, 01-, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP0_RECV_ACK( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x00 )		/* USB豸ʽ: ˵0Ӧ/ӦACK */
#define	M_SET_EP0_RECV_NAK( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x20 )		/* USB豸ʽ: ˵0Ӧ/ӦNAK */
#define	M_SET_EP0_RECV_STA( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x30 )		/* USB豸ʽ: ˵0Ӧ/ӦSTALL */
#define	BIT_EP0_TRAN_TOG	0x40		/* USB豸ʽ: ˵0ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_EP0_RECV_TOG	0x80		/* USB豸ʽ: ˵0ͬ־: 0-DATA0, 1-DATA1 */

#define	BIT_EP1_TRAN_RESP	0x0F		/* USB豸ʽ: ˵1Ӧ: 0000~1000-Ӧݳ0~8, 1110-ӦNAK, 1111-ӦSTALL,ֵ- */
#define	M_SET_EP1_TRAN_ACK( old, len )	( (old) & ~ BIT_EP1_TRAN_RESP | (len) & 0x0F )	/* USB豸ʽ: ˵1Ӧ/ӦACK */
#define	M_SET_EP1_TRAN_NAK( old )		( (old) & ~ BIT_EP1_TRAN_RESP | 0x0E )		/* USB豸ʽ: ˵1Ӧ/ӦNAK */
#define	M_SET_EP1_TRAN_STA( old )		( (old) & ~ BIT_EP1_TRAN_RESP | 0x0F )		/* USB豸ʽ: ˵1Ӧ/ӦSTALL */
#define	BIT_EP1_RECV_RESP	0x30		/* USB豸ʽ: ˵1Ӧ: 00-ӦACK, 01-, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP1_RECV_ACK( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x00 )		/* USB豸ʽ: ˵1Ӧ/ӦACK */
#define	M_SET_EP1_RECV_NAK( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x20 )		/* USB豸ʽ: ˵1Ӧ/ӦNAK */
#define	M_SET_EP1_RECV_STA( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x30 )		/* USB豸ʽ: ˵1Ӧ/ӦSTALL */
#define	BIT_EP1_TRAN_TOG	0x40		/* USB豸ʽ: ˵1ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_EP1_RECV_TOG	0x80		/* USB豸ʽ: ˵1ͬ־: 0-DATA0, 1-DATA1 */

#define	BIT_HOST_PID_ENDP	0x0F		/* USBʽ: ĿĶ˵: 0000~1111-˵0~15 */
#define	BIT_HOST_PID_TOKEN	0xF0		/* USBʽ: ָ/PID: 1101-SETUP, 0001-OUT, 1001-IN, 0101-SOF,ֵ- */
#define	M_MK_HOST_PID_ENDP( pid, endp )	( (pid) << 4 | (endp) & BIT_HOST_PID_ENDP )		/* /PIDĿĶ˵USB */

#define	BIT_EP2_TRAN_RESP	0x03		/* USB豸ʽ: ˵2Ӧ: 00-Ӧ, 01-ͬ/ʱ, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP2_TRAN_ACK( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x00 )		/* USB豸ʽ: ˵2Ӧ/ӦACK */
#define	M_SET_EP2_TRAN_ISO( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x01 )		/* USB豸ʽ: ˵2Ӧ/ͬ/ʱ/Ӧ */
#define	M_SET_EP2_TRAN_NAK( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x02 )		/* USB豸ʽ: ˵2Ӧ/ӦNAK */
#define	M_SET_EP2_TRAN_STA( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x03 )		/* USB豸ʽ: ˵2Ӧ/ӦSTALL */
#define	BIT_EP2_RECV_RESP	0x30		/* USB豸ʽ: ˵2Ӧ: 00-ӦACK, 01-ͬ/ʱ, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP2_RECV_ACK( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x00 )		/* USB豸ʽ: ˵2Ӧ/ӦACK */
#define	M_SET_EP2_RECV_ISO( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x10 )		/* USB豸ʽ: ˵2Ӧ/ͬ/ʱ/Ӧ */
#define	M_SET_EP2_RECV_NAK( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x20 )		/* USB豸ʽ: ˵2Ӧ/ӦNAK */
#define	M_SET_EP2_RECV_STA( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x30 )		/* USB豸ʽ: ˵2Ӧ/ӦSTALL */
#define	BIT_EP2_TRAN_TOG	0x40		/* USB豸ʽ: ˵2ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_EP2_RECV_TOG	0x80		/* USB豸ʽ: ˵2ͬ־: 0-DATA0, 1-DATA1 */

#define	BIT_HOST_TRAN_ISO	0x01		/* USBʽ: ͵Ĵ: 0-//жϴ, 1-ͬ/ʱ */
#define	BIT_HOST_START		0x08		/* USBʽ: : 0-ͣ, 1-,ɺԶ0 */
#define	BIT_HOST_RECV_ISO	0x10		/* USBʽ: յĴ: 0-//жϴ, 1-ͬ/ʱ */
#define	BIT_HOST_TRAN_TOG	0x40		/* USBʽ: ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_HOST_RECV_TOG	0x80		/* USBʽ: ͬ־: 0-DATA0, 1-DATA1 */

/* ״̬ȳ */

#define	CMD_SPI_374READ		0xC0		/* SPI */
#define	CMD_SPI_374WRITE	0x80		/* SPIд */

/* ********************************************************************************************************************* */
/* USB״̬ */

/* ״̬USB豸ʽ */
/*   λ4ָʾǰյݰǷͬ, 0=ͬ, 1-ͬ */
/*   λ3-λ2ָʾǰ, 00=OUT, 10=IN, 11=SETUP */
/*   λ1-λ0ָʾǰ˵, 00=˵0, 01=˵1, 10=˵2 */
#ifndef	USB_INT_EP0_SETUP
#define	USB_INT_EP0_SETUP	0x0C			/* USB˵0SETUP */
#define	USB_INT_EP0_OUT		0x00			/* USB˵0OUT */
#define	USB_INT_EP0_IN		0x08			/* USB˵0IN */
#define	USB_INT_EP1_OUT		0x01			/* USB˵1OUT */
#define	USB_INT_EP1_IN		0x09			/* USB˵1IN */
#define	USB_INT_EP2_OUT		0x02			/* USB˵2OUT */
#define	USB_INT_EP2_IN		0x0A			/* USB˵2IN */
#endif

/* ״̬USBʽ */
/*   λ4ָʾǰյݰǷͬ, 0=ͬ, 1-ͬ */
/*   λ3-λ0ָʾUSB豸Ӧ: 0010=ACK, 1010=NAK, 1110=STALL, 0011=DATA0, 1011=DATA1, XX00=Ӧ߳ʱӦ */
#ifndef	USB_INT_RET_ACK
#define	USB_INT_RET_ACK		DEF_USB_PID_ACK		/* :OUT/SETUP񷵻ACK */
#define	USB_INT_RET_NAK		DEF_USB_PID_NAK		/* :NAK */
#define	USB_INT_RET_STALL	DEF_USB_PID_STALL	/* :STALL */
#define	USB_INT_RET_DATA0	DEF_USB_PID_DATA0	/* :IN񷵻DATA0 */
#define	USB_INT_RET_DATA1	DEF_USB_PID_DATA1	/* :IN񷵻DATA1 */
#define	USB_INT_RET_TOUT	0x00			/* :Ӧ߳ʱӦ */
#define	USB_INT_RET_TOUT1	0x04			/* :Ӧ߳ʱӦ */
#define	USB_INT_RET_TOUT2	0x08			/* :Ӧ߳ʱӦ */
#define	USB_INT_RET_TOUT3	0x0C			/* :Ӧ߳ʱӦ */
#endif

/* ״̬1XHUSBʽĲ״̬, жֵ, ĶΪ˼CH375 */
#ifndef	USB_INT_SUCCESS
#define	USB_INT_SUCCESS		0x14			/* USBߴɹ */
#define	USB_INT_CONNECT		0x15			/* ⵽USB豸¼ */
#define	USB_INT_DISCONNECT	0x16			/* ⵽USB豸Ͽ¼ */
#define	USB_INT_BUF_OVER	0x17			/* USBƴ̫,  */
#define	USB_INT_DISK_ERR	0x1F			/* USB洢ʧ */
#endif
#ifndef	USB_INT_CONNECT_LS
#define	USB_INT_CONNECT_LS	0x13			/* ⵽USB豸¼ */
#endif

/* ********************************************************************************************************************* */
/* USBṹس */

typedef struct _USB_SETUP_REQ {
	UINT8	bType;
	UINT8	bReq;
	UINT8	wValueL;
	UINT8	wValueH;
	UINT8	wIndexL;
	UINT8	wIndexH;
	UINT8	wLengthL;
	UINT8	wLengthH;
} USB_SETUP_REQ, *PUSB_SETUP_REQ;

typedef struct _USB_DEVICE_DESCRIPTOR {
    UINT8 bLength;
    UINT8 bDescriptorType;
    UINT8 bcdUSBL;
    UINT8 bcdUSBH;
    UINT8 bDeviceClass;
    UINT8 bDeviceSubClass;
    UINT8 bDeviceProtocol;
    UINT8 bMaxPacketSize0;
    UINT8 idVendorL;
    UINT8 idVendorH;
    UINT8 idProductL;
    UINT8 idProductH;
    UINT8 bcdDeviceL;
    UINT8 bcdDeviceH;
    UINT8 iManufacturer;
    UINT8 iProduct;
    UINT8 iSerialNumber;
    UINT8 bNumConfigurations;
} USB_DEV_DESCR, *PUSB_DEV_DESCR;

typedef struct _USB_CONFIG_DESCRIPTOR {
    UINT8 bLength;
    UINT8 bDescriptorType;
    UINT8 wTotalLengthL;
    UINT8 wTotalLengthH;
    UINT8 bNumInterfaces;
    UINT8 bConfigurationValue;
    UINT8 iConfiguration;
    UINT8 bmAttributes;
    UINT8 MaxPower;
} USB_CFG_DESCR, *PUSB_CFG_DESCR;

typedef struct _USB_INTERF_DESCRIPTOR {
    UINT8 bLength;
    UINT8 bDescriptorType;
    UINT8 bInterfaceNumber;
    UINT8 bAlternateSetting;
    UINT8 bNumEndpoints;
    UINT8 bInterfaceClass;
    UINT8 bInterfaceSubClass;
    UINT8 bInterfaceProtocol;
    UINT8 iInterface;
} USB_ITF_DESCR, *PUSB_ITF_DESCR;

typedef struct _USB_ENDPOINT_DESCRIPTOR {
    UINT8 bLength;
    UINT8 bDescriptorType;
    UINT8 bEndpointAddress;
    UINT8 bmAttributes;
    UINT8 wMaxPacketSize;
    UINT8 wMaxPacketSize1;
    UINT8 bInterval;
} USB_ENDP_DESCR, *PUSB_ENDP_DESCR;

typedef struct _USB_CONFIG_DESCRIPTOR_LONG {
	USB_CFG_DESCR	cfg_descr;
	USB_ITF_DESCR	itf_descr;
	USB_ENDP_DESCR	endp_descr[4];
} USB_CFG_DESCR_LONG, *PUSB_CFG_DESCR_LONG;

/* USB */
#ifndef	DEF_USB_REQ_TYPE
#define	DEF_USB_REQ_READ		0x80			/* ƶ */
#define	DEF_USB_REQ_WRITE		0x00			/* д */
#define	DEF_USB_REQ_TYPE		0x60			/*  */
#define	DEF_USB_REQ_STAND		0x00			/* ׼ */
#define	DEF_USB_REQ_CLASS		0x20			/* 豸 */
#define	DEF_USB_REQ_VENDOR		0x40			/*  */
#define	DEF_USB_REQ_RESERVE		0x60			/*  */
#endif

/* USB׼豸, RequestTypeλ6λ5=00(Standard) */
#ifndef	DEF_USB_GET_DESCR
#define	DEF_USB_CLR_FEATURE		0x01
#define	DEF_USB_SET_FEATURE		0x03
#define	DEF_USB_GET_STATUS		0x00
#define	DEF_USB_SET_ADDRESS		0x05
#define	DEF_USB_GET_DESCR		0x06
#define	DEF_USB_SET_DESCR		0x07
#define	DEF_USB_GET_CONFIG		0x08
#define	DEF_USB_SET_CONFIG		0x09
#define	DEF_USB_GET_INTERF		0x0A
#define	DEF_USB_SET_INTERF		0x0B
#define	DEF_USB_SYNC_FRAME		0x0C
#endif

/*  */
#ifndef	USB_DEVICE_DESCR_TYPE
#define	USB_DEVICE_DESCR_TYPE		0x01
#define	USB_CONFIG_DESCR_TYPE		0x02
#define	USB_STRING_DESCR_TYPE		0x03
#define	USB_INTERF_DESCR_TYPE		0x04
#define	USB_ENDP_DESCR_TYPE			0x05
#define	USB_POWER_DESCR_TYPE		0x06
#define	USB_HID_DESCR_TYPE			0x21
#define	USB_REPORT_DESCR_TYPE		0x22
#define	USB_PHYSIC_DESCR_TYPE		0x23
#endif

/* ˵ͺ */
#ifndef	USB_ENDP_TYPE_MASK
#define	USB_ENDP_DIR_MASK			0x80
#define	USB_ENDP_TYPE_MASK			0x03
#define	USB_ENDP_TYPE_CTRL			0x00
#define	USB_ENDP_TYPE_ISOCH			0x01
#define	USB_ENDP_TYPE_BULK			0x02
#define	USB_ENDP_TYPE_INTER			0x03
#endif

/* 豸 */
#ifndef	USB_DEV_CLASS_HUB
#define	USB_DEV_CLASS_RESERVED		0x00
#define	USB_DEV_CLASS_AUDIO			0x01
#define	USB_DEV_CLASS_COMMUNIC		0x02
#define	USB_DEV_CLASS_HUMAN_IF		0x03
#define	USB_DEV_CLASS_MONITOR		0x04
#define	USB_DEV_CLASS_PHYSIC_IF		0x05
#define	USB_DEV_CLASS_POWER			0x06
#define	USB_DEV_CLASS_PRINTER		0x07
#define	USB_DEV_CLASS_STORAGE		0x08
#define	USB_DEV_CLASS_HUB			0x09
#define	USB_DEV_CLASS_VEN_SPEC		0xFF
#endif

#define	DEFAULT_ENDP0_SIZE	8				/* ĬϵĶ˵0 */

#ifdef __cplusplus
}
#endif

#endif
