/* 06.07.20 V1.0 for CH374, 06.08.15 V1.1, 06.09.21 V1.2, 07.05.25 V1.3, 07.09.20 V1.4, 08.01.14 V1.5, 08.08.26 V1.6, 10.06.06 V1.7, 11.08.01 V1.8
****************************************
**  Copyright  (C)  W.ch  1999-2006   **
**  Web:  http://www.winchiphead.com  **
****************************************
**  USB Host File Interface for CH374 **
**  TC2.0@PC, KC7.0@MCS51             **
****************************************
*/
/* CH374 ļϵͳӿ */
/* ֧: FAT12/FAT16/FAT32 */
/* MCS51Ƭ, ѯʽжϷʽ, ֧С//ģʽ */
/* ֧3ݴȡʽ: ͨĵDPTRлʽ, ATMEL/PHILIPS/SSTȵƬ˫DPTRлʽ, P2+R0ָ˿ڶDPTRָⲿRAMķʽ */
/* MCS51ƬⲿRAMеʱȽ,CH374ĳṩŻٶȵķʽ,ʱѡӦI/Oӿڿ:
   C51DPTR1.LIB: "DPTR", ݸƷʽ, ʹһDPTRл, ÿһֽҪ11.25, ٶ, MCS51Ƭ,
   C51DPTR2.LIB: "˫DPTR", ضӲݸƷʽ, ʹDPTR, ÿһֽҪ8.25, ٶȽϿ, ATMEL/PHILIPS/SSTȾ˫DPTRĵƬ,
   C51P2R0.LIB: "DPTRP2+R0", P2+R0ָCH374I/O˿ڲDPTRָⲿRAMݸ, ÿһֽҪ6.25, ٶ,
                       б׼MCS51Ƭ, ĳЩƬõⲿRAMʱرP2+R0Ĺ, Կܲ */

#ifndef __CH374HF_H__
#define __CH374HF_H__

#define CH374_LIB_VER		0x19

#ifdef __cplusplus
extern "C" {
#endif

/* FILE: CH374INC.H */

/* ********************************************************************************************************************* */
/* USBЭ㶨 */

/* USBİʶPID, ʽõ */
#ifndef	DEF_USB_PID_SETUP
#define	DEF_USB_PID_NULL	0x00			/* PID, δ */
#define	DEF_USB_PID_SOF		0x05
#define	DEF_USB_PID_SETUP	0x0D
#define	DEF_USB_PID_IN		0x09
#define	DEF_USB_PID_OUT		0x01
#define	DEF_USB_PID_ACK		0x02
#define	DEF_USB_PID_NAK		0x0A
#define	DEF_USB_PID_STALL	0x0E
#define	DEF_USB_PID_DATA0	0x03
#define	DEF_USB_PID_DATA1	0x0B
#define	DEF_USB_PID_PRE		0x0C
#endif

/* ********************************************************************************************************************* */
/* оƬ */

/* Ĵ */

#define	RAM_ENDP0_SIZE		0x08		/* ˵0Ļ */
#define	RAM_ENDP0_TRAN		0x20		/* ˵0ͻʼַ */
#define	RAM_ENDP0_RECV		0x28		/* ˵0ջʼַ */
#define	RAM_ENDP1_SIZE		0x08		/* ˵1Ļ */
#define	RAM_ENDP1_TRAN		0x30		/* ˵1ͻʼַ */
#define	RAM_ENDP1_RECV		0x38		/* ˵1ջʼַ */
#define	RAM_ENDP2_SIZE		0x40		/* ˵2Ļ */
#define	RAM_ENDP2_TRAN		0x40		/* ˵2ͻʼַ */
#define	RAM_ENDP2_RECV		0xC0		/* ˵2ջʼַ */
#define	RAM_ENDP2_EXCH		0x80		/* ˵2ûʼַ */
#define	RAM_HOST_TRAN		0x40		/* ͻʼַ */
#define	RAM_HOST_RECV		0xC0		/* ջʼַ */
#define	RAM_HOST_EXCH		0x80		/* ûʼַ */

#define	REG_HUB_SETUP		0x02		/* USBʽ: ROOT-HUB */
#define	REG_HUB_CTRL		0x03		/* USBʽ: ROOT-HUB */
#define	REG_SYS_INFO		0x04		/* ϵͳϢ, ֻ */
#define	REG_SYS_CTRL		0x05		/* ϵͳ, λӰ */
#define	REG_USB_SETUP		0x06		/* USB */
#define	REG_INTER_EN		0x07		/* жʹ */
#define	REG_USB_ADDR		0x08		/* USB豸ַ */
#define	REG_INTER_FLAG		0x09		/* жϱ־, ֻ, λд10 */
#define	REG_USB_STATUS		0x0A		/* USB״̬, ֻ */
#define	REG_USB_LENGTH		0x0B		/* USB, ΪǰUSBճ, 豸ʽдΪUSB˵2, ʽдΪUSBͳ */
#define	REG_USB_ENDP0		0x0C		/* USB豸ʽ: USB˵0 */
#define	REG_USB_ENDP1		0x0D		/* USB豸ʽ: USB˵1 */
#define	REG_USB_H_PID		0x0D		/* USBʽ: USB */
#define	REG_USB_ENDP2		0x0E		/* USB豸ʽ: USB˵2 */
#define	REG_USB_H_CTRL		0x0E		/* USBʽ: USB */

/* Ĵλú궨 */

#define	BIT_HUB0_EN			0x01		/* HUB0˿ڵUSBʹ: 0-ֹ, 1- */
#define	BIT_HUB0_RESET		0x02		/* HUB0˿ڵUSB߸λ: 0-λ, 1-λ */
#define	BIT_HUB0_POLAR		0x04		/* HUB0˿ڵźżԿ: 0-/ȫ, 1-/ */
#define	BIT_HUB0_ATTACH		0x08		/* HUB0˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */
#define	BIT_HUB1_DX_IN		0x10		/* HUB1ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
#define	BIT_HUB2_DX_IN		0x20		/* HUB2ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
#define	BIT_HUB_PRE_PID		0x40		/* ǰðPRE PID: 0-ֹ, 1-(ⲿ豸USB-HUB) */
#define	BIT_HUB_DISABLE		0x80		/* ֹROOT-HUB: 0-(USBʽ), 1-ֹ(Ĭ) */

#define	BIT_HUB1_EN			0x01		/* HUB1˿ڵUSBʹ: 0-ֹ, 1- */
#define	BIT_HUB1_RESET		0x02		/* HUB1˿ڵUSB߸λ: 0-λ, 1-λ */
#define	BIT_HUB1_POLAR		0x04		/* HUB1˿ڵźżԿ: 0-/ȫ, 1-/ */
#define	BIT_HUB1_ATTACH		0x08		/* HUB1˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */
#define	BIT_HUB2_EN			0x10		/* HUB2˿ڵUSBʹ: 0-ֹ, 1- */
#define	BIT_HUB2_RESET		0x20		/* HUB2˿ڵUSB߸λ: 0-λ, 1-λ */
#define	BIT_HUB2_POLAR		0x40		/* HUB2˿ڵźżԿ: 0-/ȫ, 1-/ */
#define	BIT_HUB2_ATTACH		0x80		/* HUB2˿ڵUSB豸״̬(ֻ): 0-δ/Ͽ/γ, 1-Ѿ/ */

#define	BIT_INFO_HW_ID		0x03		/* Ӳʶλ: ǳ01, ˵Ӳ */
#define	BIT_INFO_USB_DM		0x04		/* USBHUB0UD-ŵ߼ƽ״̬: 0-͵ƽ, 1-ߵƽ */
#define	BIT_INFO_USB_DP		0x08		/* USBHUB0UD+ŵ߼ƽ״̬: 0-͵ƽ, 1-ߵƽ */
#define	BIT_INFO_CLK_8KHZ	0x10		/* Ӳ8KHzʱλ */
#define	BIT_INFO_SOF_PRES	0x20		/* Ӳ1mSʱ״̬,USB, 1˵ҪSOF */
#define	BIT_INFO_WAKE_UP	0x40		/* оƬ״̬: 0-˯߻ѹ, 1-ѻ */
#define	BIT_INFO_POWER_RST	0x80		/* Ӳϵ縴λ״̬: 0-ڸλ, 1-λ */

#define	BIT_CTRL_OSCIL_OFF	0x01		/* ʱ: 0-, 1-ֹͣ */
#define	BIT_CTRL_CLK_12MHZ	0x02		/* ʱƵѡ: 0-24MHz, 1-12MHz */
#define	BIT_CTRL_USB_POWER	0x04		/* V3ŵUSBԴ: 0-, 1- */
#define	BIT_CTRL_RESET_NOW	0x08		/* оƬλ: 0-λ, 1-λ */
#define	BIT_CTRL_WATCH_DOG	0x10		/* RSTźRST#ŵĿŹλʹ: 0-, 1- */
#define	BIT_CTRL_INT_PULSE	0x20		/* INT#ŵжʽ: 0-͵ƽж, 1-͵ƽж */
#define	BIT_CTRL_OE_POLAR	0x40		/* UENŵUSBʹܼ: 0-ߵƽʹ, 1-͵ƽʹ */

#define	BIT_SETP_TRANS_EN	0x01		/* USB豸ʽ: USB豸ʹ: 0-ֹ, 1- */
#define	BIT_SETP_PULLUP_EN	0x02		/* USB豸ʽ: USB: 0-, 1- */
#define	BIT_SETP_BUS_CTRL	0x03		/* USBʽ: USB״̬: 00-/, 01-D+D-(߸λ), 10-, 11-D+D-(߻ָ) */
#define	M_SET_USB_BUS_FREE( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x00 )		/* USBʽ: USB߿ */
#define	M_SET_USB_BUS_RESET( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x01 )		/* USBʽ: USB״̬/D+D-(߸λ) */
#define	M_SET_USB_BUS_RESUME( old )		( (old) & ~ BIT_SETP_BUS_CTRL | 0x03 )		/* USBʽ: USB״̬/D+D-(߻ָ) */
#define	BIT_SETP_RAM_MODE	0x0C		/* ûӦ÷ʽ: 00-ñû, 01-ӽջ128ֽ, 10-ڷ͵ڶ, 11-ڽյڶ */
#define	M_SET_RAM_MODE_OFF( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x00 )		/* ûʽ/ñû */
#define	M_SET_RAM_MODE_128( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x04 )		/* ûʽ/ӽջ128ֽ */
#define	M_SET_RAM_MODE_2TX( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x08 )		/* ûʽ/ڷ͵ĵڶ,֧ */
#define	M_SET_RAM_MODE_2RX( old )		( (old) & ~ BIT_SETP_RAM_MODE | 0x0C )		/* ûʽ/ڽյĵڶ,֧ */
#define	BIT_SETP_LOW_SPEED	0x20		/* USBߴٶ: 0-12Mbps, 1-1.5Mbps */
#define	BIT_SETP_USB_SPEED	0x30		/* USB: 00-ȫģʽ/12Mbps, 11-ģʽ/1.5Mbps */
#define	BIT_SETP_LED_ACT	0x40		/* USB豸ʽ: ACT#ŵ͵ƽļ¼: 0-շ, 1-USB */
#define	BIT_SETP_AUTO_SOF	0x40		/* USBʽ: ԶSOFʹ: 0-ֹ, 1- */
#define	BIT_SETP_HOST_MODE	0x80		/* USBӷʽѡ: 0-豸ʽ, 1-ʽ */

#define	BIT_IE_TRANSFER		0x01		/* USBжʹ, 1Ч */
#define	BIT_IE_BUS_RESET	0x02		/* USB豸ʽ: USB߸λжʹ, 1Ч */
#define	BIT_IE_DEV_DETECT	0x02		/* USBʽ: USB豸жʹ, 1Ч */
#define	BIT_IE_USB_SUSPEND	0x04		/* USB߹жʹ, 1Ч */
#define	BIT_IE_USB_RESUME	0x08		/* USB߻ָ/жʹ, 1Ч, 0-ʹоƬж, 1-ʹUSB߻ָж */
#define	BIT_IE_CLK_OUT_DIV	0xF0		/* ɱʱӵķƵ: ƵΪ48MHz/(ֵ+1), : 0000-48MHz, 0001-24MHz, 0010-16MHz, 1111-3MHz */
#define	M_SET_CLK_DIV( old, div )		( (old) & ~ BIT_IE_CLK_OUT_DIV | (div) << 4 )	/* ʱƵ */

#define	BIT_ADDR_USB_DEV	0x7F		/* 豸ʽΪΪUSB豸ĵַ, ʽΪǰUSB豸ַ */

#define	BIT_IF_INTER_FLAG	0x0F		/* еUSBжϱ־ */
#define	BIT_IF_TRANSFER		0x01		/* USBжϱ־, 1Ч, λд1־, λÿUSBɺԶ1 */
#define	BIT_IF_BUS_RESET	0x02		/* USB豸ʽ: USB߸λжϱ־, 1Ч, λд1־, λڼ⵽USB߸λʱԶ1 */
#define	BIT_IF_DEV_DETECT	0x02		/* USBʽ: USB豸μжϱ־, 1Ч, λд1־, λڼ⵽USB豸κԶ1 */
#define	BIT_IF_USB_SUSPEND	0x04		/* USB߹жϱ־, 1Ч, λд1־, λڼ⵽USB߹ʱԶ1 */
#define	BIT_IF_WAKE_UP		0x08		/* оƬжϱ־, 1Ч, λд1־, λоƬɺԶ1 */
#define	BIT_IF_USB_RESUME	0x08		/* USB߻ָ/жϱ־, 1Ч, λд1־, λڼ⵽USB߻ָʱԶ1 */
#define	BIT_IF_USB_PAUSE	0x10		/* USBͣ־, 1Ч, λд1־, λÿUSBɺԶ1 */
#define	BIT_IF_DEV_ATTACH	0x20		/* USB豸״̬: 0-δ/Ͽ/γ, 1-һUSB豸Ѿ/ */
#define	BIT_IF_USB_OE		0x40		/* UENŵUSBʹ״̬: 0-UENΪ͵ƽ, 1-UENΪߵƽ */
#define	BIT_IF_USB_DX_IN	0x80		/* HUB0ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */
#define	BIT_HUB0_DX_IN		0x80		/* HUB0ȫʱUD+/ٸʱUD-ŵĲ״̬: 0-͵ƽ,ٶʧ, 1-ߵƽ,ٶƥ */

#define	BIT_STAT_THIS_ENDP	0x03		/* USB豸ʽ: USBĿĶ˵: 00-˵0, 01-˵1, 10-˵2, 11- */
#define	BIT_STAT_THIS_PID	0x0C		/* USB豸ʽ: USB/PID: 00-OUT, 01-, 10-IN, 11-SETUP */
#define	BIT_STAT_PID_ENDP	0x0F		/* USB豸ʽ: USBͶ˵,οUSB_INT_EP* */
#define	BIT_STAT_DEV_RESP	0x0F		/* USBʽ: USB豸ӦPID: XX00=ʱ,ֵ-ͬPID,οUSB_INT_RET_* */
#define	M_IS_HOST_TIMEOUT( status )		( ( (status) & 0x03 ) == 0 )		/* USB״̬ǷΪӦʱ/ */
#define	M_IS_HOST_IN_DATA( status )		( ( (status) & BIT_STAT_DEV_RESP & ~ ( DEF_USB_PID_DATA0 ^ DEF_USB_PID_DATA1 ) ) == ( DEF_USB_PID_DATA0 & DEF_USB_PID_DATA1 ) )	/* Ƿ񷵻DATA0DATA1 */
#define	BIT_STAT_TOG_MATCH	0x10		/* ָʾǰĴǷɹ/ǰյݰǷͬ: 0-ͬ, 1-ͬ */
#define	BIT_STAT_BUS_RESET	0x20		/* ǰUSB߸λ״̬: 0-ûиλ, 1-ڸλ */
#define	BIT_STAT_SUSPEND	0x40		/* ǰUSB߹״̬: 0-л, 1-߹ */
#define	BIT_STAT_SIE_FREE	0x80		/* ǰUSBӿSIE״̬: 0=æ/ڴ, 1=/ȴ */

#define	BIT_EP0_TRAN_RESP	0x0F		/* USB豸ʽ: ˵0Ӧ: 0000~1000-Ӧݳ0~8, 1110-ӦNAK, 1111-ӦSTALL,ֵ- */
#define	M_SET_EP0_TRAN_ACK( old, len )	( (old) & ~ BIT_EP0_TRAN_RESP | (len) & 0x0F )	/* USB豸ʽ: ˵0Ӧ/ӦACK */
#define	M_SET_EP0_TRAN_NAK( old )		( (old) & ~ BIT_EP0_TRAN_RESP | 0x0E )		/* USB豸ʽ: ˵0Ӧ/ӦNAK */
#define	M_SET_EP0_TRAN_STA( old )		( (old) & ~ BIT_EP0_TRAN_RESP | 0x0F )		/* USB豸ʽ: ˵0Ӧ/ӦSTALL */
#define	BIT_EP0_RECV_RESP	0x30		/* USB豸ʽ: ˵0Ӧ: 00-ӦACK, 01-, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP0_RECV_ACK( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x00 )		/* USB豸ʽ: ˵0Ӧ/ӦACK */
#define	M_SET_EP0_RECV_NAK( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x20 )		/* USB豸ʽ: ˵0Ӧ/ӦNAK */
#define	M_SET_EP0_RECV_STA( old )		( (old) & ~ BIT_EP0_RECV_RESP | 0x30 )		/* USB豸ʽ: ˵0Ӧ/ӦSTALL */
#define	BIT_EP0_TRAN_TOG	0x40		/* USB豸ʽ: ˵0ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_EP0_RECV_TOG	0x80		/* USB豸ʽ: ˵0ͬ־: 0-DATA0, 1-DATA1 */

#define	BIT_EP1_TRAN_RESP	0x0F		/* USB豸ʽ: ˵1Ӧ: 0000~1000-Ӧݳ0~8, 1110-ӦNAK, 1111-ӦSTALL,ֵ- */
#define	M_SET_EP1_TRAN_ACK( old, len )	( (old) & ~ BIT_EP1_TRAN_RESP | (len) & 0x0F )	/* USB豸ʽ: ˵1Ӧ/ӦACK */
#define	M_SET_EP1_TRAN_NAK( old )		( (old) & ~ BIT_EP1_TRAN_RESP | 0x0E )		/* USB豸ʽ: ˵1Ӧ/ӦNAK */
#define	M_SET_EP1_TRAN_STA( old )		( (old) & ~ BIT_EP1_TRAN_RESP | 0x0F )		/* USB豸ʽ: ˵1Ӧ/ӦSTALL */
#define	BIT_EP1_RECV_RESP	0x30		/* USB豸ʽ: ˵1Ӧ: 00-ӦACK, 01-, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP1_RECV_ACK( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x00 )		/* USB豸ʽ: ˵1Ӧ/ӦACK */
#define	M_SET_EP1_RECV_NAK( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x20 )		/* USB豸ʽ: ˵1Ӧ/ӦNAK */
#define	M_SET_EP1_RECV_STA( old )		( (old) & ~ BIT_EP1_RECV_RESP | 0x30 )		/* USB豸ʽ: ˵1Ӧ/ӦSTALL */
#define	BIT_EP1_TRAN_TOG	0x40		/* USB豸ʽ: ˵1ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_EP1_RECV_TOG	0x80		/* USB豸ʽ: ˵1ͬ־: 0-DATA0, 1-DATA1 */

#define	BIT_HOST_PID_ENDP	0x0F		/* USBʽ: ĿĶ˵: 0000~1111-˵0~15 */
#define	BIT_HOST_PID_TOKEN	0xF0		/* USBʽ: ָ/PID: 1101-SETUP, 0001-OUT, 1001-IN, 0101-SOF,ֵ- */
#define	M_MK_HOST_PID_ENDP( pid, endp )	( (pid) << 4 | (endp) & BIT_HOST_PID_ENDP )		/* /PIDĿĶ˵USB */

#define	BIT_EP2_TRAN_RESP	0x03		/* USB豸ʽ: ˵2Ӧ: 00-Ӧ, 01-ͬ/ʱ, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP2_TRAN_ACK( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x00 )		/* USB豸ʽ: ˵2Ӧ/ӦACK */
#define	M_SET_EP2_TRAN_ISO( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x01 )		/* USB豸ʽ: ˵2Ӧ/ͬ/ʱ/Ӧ */
#define	M_SET_EP2_TRAN_NAK( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x02 )		/* USB豸ʽ: ˵2Ӧ/ӦNAK */
#define	M_SET_EP2_TRAN_STA( old )		( (old) & ~ BIT_EP2_TRAN_RESP | 0x03 )		/* USB豸ʽ: ˵2Ӧ/ӦSTALL */
#define	BIT_EP2_RECV_RESP	0x30		/* USB豸ʽ: ˵2Ӧ: 00-ӦACK, 01-ͬ/ʱ, 10-ӦNAK, 11-ӦSTALL */
#define	M_SET_EP2_RECV_ACK( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x00 )		/* USB豸ʽ: ˵2Ӧ/ӦACK */
#define	M_SET_EP2_RECV_ISO( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x10 )		/* USB豸ʽ: ˵2Ӧ/ͬ/ʱ/Ӧ */
#define	M_SET_EP2_RECV_NAK( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x20 )		/* USB豸ʽ: ˵2Ӧ/ӦNAK */
#define	M_SET_EP2_RECV_STA( old )		( (old) & ~ BIT_EP2_RECV_RESP | 0x30 )		/* USB豸ʽ: ˵2Ӧ/ӦSTALL */
#define	BIT_EP2_TRAN_TOG	0x40		/* USB豸ʽ: ˵2ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_EP2_RECV_TOG	0x80		/* USB豸ʽ: ˵2ͬ־: 0-DATA0, 1-DATA1 */

#define	BIT_HOST_TRAN_ISO	0x01		/* USBʽ: ͵Ĵ: 0-//жϴ, 1-ͬ/ʱ */
#define	BIT_HOST_START		0x08		/* USBʽ: : 0-ͣ, 1-,ɺԶ0 */
#define	BIT_HOST_RECV_ISO	0x10		/* USBʽ: յĴ: 0-//жϴ, 1-ͬ/ʱ */
#define	BIT_HOST_TRAN_TOG	0x40		/* USBʽ: ͬ־: 0-DATA0, 1-DATA1 */
#define	BIT_HOST_RECV_TOG	0x80		/* USBʽ: ͬ־: 0-DATA0, 1-DATA1 */

/* ״̬ȳ */

#define	CMD_SPI_374READ		0xC0		/* SPI */
#define	CMD_SPI_374WRITE	0x80		/* SPIд */

#define CH374_BLOCK_SIZE		64		/* CH374 maximum data block size, CH374_MAX_DATA_LEN */

/* ********************************************************************************************************************* */
/* USB״̬ */

/* ״̬USB豸ʽ */
/*   λ4ָʾǰյݰǷͬ, 0=ͬ, 1-ͬ */
/*   λ3-λ2ָʾǰ, 00=OUT, 10=IN, 11=SETUP */
/*   λ1-λ0ָʾǰ˵, 00=˵0, 01=˵1, 10=˵2 */
#ifndef	USB_INT_EP0_SETUP
#define	USB_INT_EP0_SETUP	0x0C			/* USB˵0SETUP */
#define	USB_INT_EP0_OUT		0x00			/* USB˵0OUT */
#define	USB_INT_EP0_IN		0x08			/* USB˵0IN */
#define	USB_INT_EP1_OUT		0x01			/* USB˵1OUT */
#define	USB_INT_EP1_IN		0x09			/* USB˵1IN */
#define	USB_INT_EP2_OUT		0x02			/* USB˵2OUT */
#define	USB_INT_EP2_IN		0x0A			/* USB˵2IN */
#endif

/* ״̬USBʽ */
/*   λ4ָʾǰյݰǷͬ, 0=ͬ, 1-ͬ */
/*   λ3-λ0ָʾUSB豸Ӧ: 0010=ACK, 1010=NAK, 1110=STALL, 0011=DATA0, 1011=DATA1, XX00=Ӧ߳ʱӦ */
#ifndef	USB_INT_RET_ACK
#define	USB_INT_RET_ACK		DEF_USB_PID_ACK		/* :OUT/SETUP񷵻ACK */
#define	USB_INT_RET_NAK		DEF_USB_PID_NAK		/* :NAK */
#define	USB_INT_RET_STALL	DEF_USB_PID_STALL	/* :STALL */
#define	USB_INT_RET_DATA0	DEF_USB_PID_DATA0	/* :IN񷵻DATA0 */
#define	USB_INT_RET_DATA1	DEF_USB_PID_DATA1	/* :IN񷵻DATA1 */
#define	USB_INT_RET_TOUT	0x00			/* :Ӧ߳ʱӦ */
#define	USB_INT_RET_TOUT1	0x04			/* :Ӧ߳ʱӦ */
#define	USB_INT_RET_TOUT2	0x08			/* :Ӧ߳ʱӦ */
#define	USB_INT_RET_TOUT3	0x0C			/* :Ӧ߳ʱӦ */
#endif

/* ״̬1XHUSBʽĲ״̬, жֵ, ĶΪ˼CH375 */
#ifndef	USB_INT_SUCCESS
#define	USB_INT_SUCCESS		0x14			/* USBߴɹ */
#define	USB_INT_CONNECT		0x15			/* ⵽USB豸¼ */
#define	USB_INT_DISCONNECT	0x16			/* ⵽USB豸Ͽ¼ */
#define	USB_INT_BUF_OVER	0x17			/* USBƴ̫,  */
#define	USB_INT_DISK_ERR	0x1F			/* USB洢ʧ */
#endif
#ifndef	USB_INT_CONNECT_LS
#define	USB_INT_CONNECT_LS	0x13			/* ⵽USB豸¼ */
#endif

/* ********************************************************************************************************************* */
/* USBṹس */

/* USB */
#ifndef	DEF_USB_REQ_TYPE
#define	DEF_USB_REQ_READ		0x80			/* ƶ */
#define	DEF_USB_REQ_WRITE		0x00			/* д */
#define	DEF_USB_REQ_TYPE		0x60			/*  */
#define	DEF_USB_REQ_STAND		0x00			/* ׼ */
#define	DEF_USB_REQ_CLASS		0x20			/* 豸 */
#define	DEF_USB_REQ_VENDOR		0x40			/*  */
#define	DEF_USB_REQ_RESERVE		0x60			/*  */
#endif

/* USB׼豸, RequestTypeλ6λ5=00(Standard) */
#ifndef	DEF_USB_GET_DESCR
#define	DEF_USB_CLR_FEATURE		0x01
#define	DEF_USB_SET_FEATURE		0x03
#define	DEF_USB_GET_STATUS		0x00
#define	DEF_USB_SET_ADDRESS		0x05
#define	DEF_USB_GET_DESCR		0x06
#define	DEF_USB_SET_DESCR		0x07
#define	DEF_USB_GET_CONFIG		0x08
#define	DEF_USB_SET_CONFIG		0x09
#define	DEF_USB_GET_INTERF		0x0A
#define	DEF_USB_SET_INTERF		0x0B
#define	DEF_USB_SYNC_FRAME		0x0C
#endif

/*  */
#ifndef	USB_DEVICE_DESCR_TYPE
#define	USB_DEVICE_DESCR_TYPE		0x01
#define	USB_CONFIG_DESCR_TYPE		0x02
#define	USB_STRING_DESCR_TYPE		0x03
#define	USB_INTERF_DESCR_TYPE		0x04
#define	USB_ENDP_DESCR_TYPE			0x05
#define	USB_POWER_DESCR_TYPE		0x06
#define	USB_HID_DESCR_TYPE			0x21
#define	USB_REPORT_DESCR_TYPE		0x22
#define	USB_PHYSIC_DESCR_TYPE		0x23
#endif

/* ˵ͺ */
#ifndef	USB_ENDP_TYPE_MASK
#define USB_ENDP_DIR_MASK			0x80
#define USB_ENDP_TYPE_MASK			0x03
#define USB_ENDP_TYPE_CTRL			0x00
#define USB_ENDP_TYPE_ISOCH			0x01
#define USB_ENDP_TYPE_BULK			0x02
#define	USB_ENDP_TYPE_INTER			0x03
#endif

/* 豸 */
#ifndef	USB_DEV_CLASS_HUB
#define	USB_DEV_CLASS_RESERVED		0x00
#define	USB_DEV_CLASS_AUDIO			0x01
#define	USB_DEV_CLASS_COMMUNIC		0x02
#define	USB_DEV_CLASS_HUMAN_IF		0x03
#define	USB_DEV_CLASS_MONITOR		0x04
#define	USB_DEV_CLASS_PHYSIC_IF		0x05
#define	USB_DEV_CLASS_POWER			0x06
#define	USB_DEV_CLASS_PRINTER		0x07
#define	USB_DEV_CLASS_STORAGE		0x08
#define	USB_DEV_CLASS_HUB			0x09
#define	USB_DEV_CLASS_VEN_SPEC		0xFF
#endif

#define	DEFAULT_ENDP0_SIZE	8				/* ĬϵĶ˵0 */

/* ********************************************************************************************************************* */

/* FILE: CH374HF.H */

#ifdef __CX51__
#ifndef __C51__
#define __C51__		1
#endif
#endif

#ifdef __C51__
typedef bit bdata                    BOOL1;
#else
#define data
#define idata
#define xdata
typedef unsigned char                BOOL1;
#endif

#ifndef UINT8
typedef unsigned char                UINT8;
#endif
#ifndef UINT16
typedef unsigned short               UINT16;
#endif
#ifndef UINT32
typedef unsigned long                UINT32;
#endif
#ifndef UINT8D
typedef unsigned char  data          UINT8D;
#endif
#ifndef UINT16D
typedef unsigned short data          UINT16D;
#endif
#ifndef UINT32D
typedef unsigned long  data          UINT32D;
#endif
#ifndef UINT8I
typedef unsigned char  idata         UINT8I;
#endif
#ifndef UINT16I
typedef unsigned short idata         UINT16I;
#endif
#ifndef UINT32I
typedef unsigned long  idata         UINT32I;
#endif
#ifndef UINT8X
typedef unsigned char  xdata         UINT8X;
#endif
#ifndef UINT16X
typedef unsigned short xdata         UINT16X;
#endif
#ifndef UINT32X
typedef unsigned long  xdata         UINT32X;
#endif
#ifndef PUINT8
typedef unsigned char               *PUINT8;
#endif
#ifndef PUINT16
typedef unsigned short              *PUINT16;
#endif
#ifndef PUINT32
typedef unsigned long               *PUINT32;
#endif
#ifndef PUINT8I
typedef unsigned char  idata        *PUINT8I;
#endif
#ifndef PUINT16I
typedef unsigned short idata        *PUINT16I;
#endif
#ifndef PUINT32I
typedef unsigned long  idata        *PUINT32I;
#endif
#ifndef PUINT8X
typedef unsigned char  xdata        *PUINT8X;
#endif
#ifndef PUINT16X
typedef unsigned short xdata        *PUINT16X;
#endif
#ifndef PUINT32X
typedef unsigned long  xdata        *PUINT32X;
#endif
#ifndef PUINT8C
typedef const unsigned char  code   *PUINT8C;
#endif
#ifndef UINT8V
typedef unsigned char volatile       UINT8V;
#endif
#ifndef UINT8DV
typedef unsigned char volatile data  UINT8DV;
#endif
#ifndef UINT8XV
typedef unsigned char volatile xdata UINT8XV;
#endif

/*  */
#define ERR_SUCCESS				0x00	/* ɹ */
#define ERR_CH374_ERROR			0x81	/* CH374Ӳ,ҪλCH374 */
#define ERR_DISK_DISCON			0x82	/* δ,ܴѾϿ */
#define ERR_STATUS_ERR			0x83	/* ״̬,ӻ߶Ͽ */
#define ERR_HUB_PORT_FREE		0x84	/* USB-HUBѾӵHUB˿δӴ,ܴѾϿ */
#define ERR_MBR_ERROR			0x91	/* ̵¼Ч,ܴδδʽ */
#define ERR_TYPE_ERROR			0x92	/* ̷Ͳ֧,ֻ֧FAT12/FAT16/BigDOS/FAT32,Ҫɴ̹· */
#define ERR_BPB_ERROR			0xA1	/* δʽ,߲,ҪWINDOWSĬϲ¸ʽ */
#define ERR_TOO_LARGE			0xA2	/* ̷ʽ4GB,250GB,ҪWINDOWSĬϲ¸ʽ */
#define ERR_FAT_ERROR			0xA3	/* ̵ļϵͳ֧,ֻ֧FAT12/FAT16/FAT32,ҪWINDOWSĬϲ¸ʽ */
#define ERR_DISK_FULL			0xB1	/* ļ̫,ʣռ̫ٻѾû,Ҫ */
#define ERR_FDT_OVER			0xB2	/* Ŀ¼ļ̫,ûпеĿ¼,FAT12/FAT16Ŀ¼µļӦ500,Ҫ */
#define ERR_MISS_DIR			0xB3	/* ָ·ĳĿ¼ûҵ,Ŀ¼ƴ */
#define ERR_FILE_CLOSE			0xB4	/* ļѾر,Ҫʹ,Ӧ´ļ */
#define ERR_OPEN_DIR			0x41	/* ָ·Ŀ¼ */
#define ERR_MISS_FILE			0x42	/* ָ·ļûҵ,ļƴ */
#define ERR_FOUND_NAME			0x43	/* ͨƥļ,ļ·,Ҫʹ,Ӧô򿪸ļ */
/* 2XH-3XHUSBʽͨѶʧܴ,CH374ӳģCH375ķ */
/* 1XHUSBʽĲ״̬,CH374ӳģCH375ķ */
#define	ERR_USB_CONNECT_LS		0x13	/* ⵽USB豸¼ */
#define	ERR_USB_CONNECT			0x15	/* ⵽USB豸¼,Ѿ */
#define	ERR_USB_DISCON			0x16	/* ⵽USB豸Ͽ¼,ѾϿ */
#define	ERR_USB_DISK_ERR		0x1F	/* USB洢ʧ,ڳʼʱUSB洢֧,ڶдпǴ𻵻ѾϿ */
/* ״̬Ϊ¼ж */
#define	USB_INT_USB_SUSPEND		0x05	/* USB߹¼ */
#define	USB_INT_WAKE_UP			0x06	/* ˯б¼ */

/* ̼ļ״̬ */
#define DISK_UNKNOWN			0x00	/* δʼ,δ֪״̬ */
#define DISK_DISCONNECT			0x01	/* ûӻѾϿ */
#define DISK_CONNECT			0x02	/* Ѿ,δʼ޷ʶô */
#define DISK_MOUNTED			0x03	/* Ѿʼɹ,δļϵͳļϵͳ֧ */
#define DISK_READY				0x10	/* Ѿ̵ļϵͳܹ֧ */
#define DISK_OPEN_ROOT			0x12	/* Ѿ򿪸Ŀ¼,ģʽ,ֻΪλдĿ¼,ʹúر,עFAT12/FAT16Ŀ¼ǹ̶ */
#define DISK_OPEN_DIR			0x13	/* ѾĿ¼,ģʽ,ֻΪλдĿ¼ */
#define DISK_OPEN_FILE			0x14	/* Ѿļ,ģʽ,Ϊλݶд */
#define DISK_OPEN_FILE_B		0x15	/* Ѿļ,ֽģʽ,ֽΪλݶд */

/* FATͱ־ */
#define DISK_FS_UNKNOWN			0		/* δ֪ļϵͳ */
#define DISK_FAT12				1		/* FAT12ļϵͳ */
#define DISK_FAT16				2		/* FAT16ļϵͳ */
#define DISK_FAT32				3		/* FAT32ļϵͳ */

/* FATļĿ¼Ϣ */
typedef struct _FAT_DIR_INFO {
	UINT8	DIR_Name[11];				/* 00H,ļ,11ֽ,㴦ո */
	UINT8	DIR_Attr;					/* 0BH,ļ,οǰ˵ */
	UINT8	DIR_NTRes;					/* 0CH */
	UINT8	DIR_CrtTimeTenth;			/* 0DH,ļʱ,0.1뵥λ */
	UINT16	DIR_CrtTime;				/* 0EH,ļʱ */
	UINT16	DIR_CrtDate;				/* 10H,ļ */
	UINT16	DIR_LstAccDate;				/* 12H,һδȡ */
	UINT16	DIR_FstClusHI;				/* 14H */
	UINT16	DIR_WrtTime;				/* 16H,ļ޸ʱ,οǰĺMAKE_FILE_TIME */
	UINT16	DIR_WrtDate;				/* 18H,ļ޸,οǰĺMAKE_FILE_DATA */
	UINT16	DIR_FstClusLO;				/* 1AH */
	UINT32	DIR_FileSize;				/* 1CH,ļ */
} FAT_DIR_INFO;							/* 20H */

typedef FAT_DIR_INFO xdata *P_FAT_DIR_INFO;

/* ļ */
#define ATTR_READ_ONLY			0x01	/* ļΪֻ */
#define ATTR_HIDDEN				0x02	/* ļΪ */
#define ATTR_SYSTEM				0x04	/* ļΪϵͳ */
#define ATTR_VOLUME_ID			0x08	/*  */
#define ATTR_DIRECTORY			0x10	/* Ŀ¼ */
#define ATTR_ARCHIVE			0x20	/* ļΪ浵 */
#define ATTR_LONG_NAME			( ATTR_READ_ONLY | ATTR_HIDDEN | ATTR_SYSTEM | ATTR_VOLUME_ID )
/* ļ UINT8 */
/* bit0 bit1 bit2 bit3 bit4 bit5 bit6 bit7 */
/*  ֻ      ϵ      Ŀ      δ   */
/*        ͳ      ¼               */
/* ļʱ UINT16 */
/* Time = (Hour<<11) + (Minute<<5) + (Second>>1) */
#define MAKE_FILE_TIME( h, m, s )	( (h<<11) + (m<<5) + (s>>1) )	/* ָʱļʱ */
/* ļ UINT16 */
/* Date = ((Year-1980)<<9) + (Month<<5) + Day */
#define MAKE_FILE_DATE( y, m, d )	( ((y-1980)<<9) + (m<<5) + d )	/* ָյļ */

/* ļ */
#define PATH_WILDCARD_CHAR		0x2A	/* ·ͨ '*' */
#define PATH_SEPAR_CHAR1		0x5C	/* ·ķָ '\' */
#define PATH_SEPAR_CHAR2		0x2F	/* ·ķָ '/' */
#ifndef MAX_PATH_LEN
#define MAX_PATH_LEN			30		/* ·,бָܷСԼ·00H */
#endif
#ifndef MAX_BYTE_IO
#define MAX_BYTE_IO		( MAX_PATH_LEN - 1 )	/* ֽΪλζдļʱ󳤶,óȿԷֶζд */
#endif

/* ⲿ */
typedef union _CMD_PARAM {
	struct {
		UINT8	mBuffer[ MAX_PATH_LEN ];
	} Other;
	struct {
		UINT32	mReserved;
		UINT32	mTotalSector;			/* : ǰ߼̵ */
		UINT32	mFreeSector;			/* : ǰ߼̵ʣ */
		UINT8	mDiskFat;				/* : ǰ߼̵FAT */
	} Query;							/* CMD_DiskQuery, ѯϢ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Open;								/* CMD_FileOpen, ļ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ(ͨ*)...,ö], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILE*",00H */
	} Enumer;							/* CMD_FileEnumer, öļ,ļ */
	struct {
		UINT8	mUpdateLen;				/* : Ƿ³: 0ֹ,1 */
	} Close;							/* CMD_FileClose, رյǰļ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Create;							/* CMD_FileCreate, ½ļ,ļѾɾ½ */
	struct {
		UINT8	mPathName[ MAX_PATH_LEN ];	/* : ·: [̷,ð,б,Ŀ¼ļչ...,00H], ̷ðſʡ, "C:\DIR1.EXT\DIR2\FILENAME.EXT",00H */
	} Erase;							/* CMD_FileErase, ɾļر */
	struct {
		UINT32	mFileSize;				/* : µļ,Ϊ0FFFFFFFFH޸, : ԭ */
		UINT16	mFileDate;				/* : µļ,Ϊ0FFFFH޸, : ԭ */
		UINT16	mFileTime;				/* : µļʱ,Ϊ0FFFFH޸, : ԭʱ */
		UINT8	mFileAttr;				/* : µļ,Ϊ0FFH޸, : ԭ */
	} Modify;							/* CMD_FileQuery, ѯǰļϢ; CMD_FileModify, ѯ޸ĵǰļϢ */
	struct {
		UINT32	mSectorOffset;			/* : ƫ,0ƶļͷ,0FFFFFFFFHƶļβ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
	} Locate;							/* CMD_FileLocate, ƶǰļָ */
	struct {
		UINT8	mSectorCount;			/* : ȡ, : ʵʶȡ */
	} Read;								/* CMD_FileRead, ӵǰļȡ */
	struct {
		UINT8	mSectorCount;			/* : д, : ʵд */
	} Write;							/* CMD_FileWrite, ǰļд */
	struct {
		UINT8	mSectorCount;			/* : ȡ, : ʵʶȡ */
		UINT8	mReserved;
		UINT8	mLbaCount;
		UINT8	mReserved5[5];
		PUINT8X	mDataBuffer;			/* : ʼַ, : ǰַ */
	} ReadX;							/* CMD_FileReadX, ӵǰļȡݵָ */
	struct {
		UINT8	mSectorCount;			/* : д, : ʵд */
		UINT8	mReserved;
		UINT8	mLbaCount;
		UINT8	mReserved5[5];
		PUINT8X	mDataBuffer;			/* : ʼַ, : ǰַ */
	} WriteX;							/* CMD_FileWriteX, ǰļдָ */
	struct {
		UINT32	mDiskSizeSec;			/* : ̵ */
	} DiskSize;							/* CMD_DiskSize, ѯ */
	struct {
		UINT32	mByteOffset;			/* : ֽΪλƫ, ֽΪλļָ, : ǰļָӦľ, 0FFFFFFFFHѵļβ */
	} ByteLocate;						/* CMD_ByteLocate, ֽΪλƶǰļָ */
	struct {
		UINT8	mByteCount;				/* : ׼ȡֽ,ôMAX_BYTE_IO, : ʵʶֽ */
		UINT8	mByteBuffer[ MAX_BYTE_IO ];	/* : ݿ */
	} ByteRead;							/* CMD_ByteRead, ֽΪλӵǰļȡݿ */
	struct {
		UINT8	mByteCount;				/* : ׼дֽ,ôMAX_BYTE_IO, : ʵдֽ */
		UINT8	mByteBuffer[ MAX_BYTE_IO ];	/* : ׼дݿ */
	} ByteWrite;						/* CMD_ByteWrite, ֽΪλǰļдݿ */
	struct {
		UINT8	mSaveVariable;			/* : Ϊ0ָU̵ı,Ϊ0x80ָU̵ı,ֵ򱸷/ */
		UINT8	mReserved[3];
		PUINT8X	mBuffer;				/* : ָӳııݻ,ȲС80ֽ */
	} SaveVariable;						/* CMD_SaveVariable, //ָӳı */
} CMD_PARAM;

typedef CMD_PARAM idata CMD_PARAM_I;
typedef CMD_PARAM data *P_CMD_PARAM;

/* SCSI */
#define SPC_CMD_INQUIRY			0x12
#define SPC_CMD_READ_CAPACITY	0x25
#define SPC_CMD_READ10			0x28
#define SPC_CMD_WRITE10			0x2A
#define SPC_CMD_TEST_READY		0x00
#define SPC_CMD_REQUEST_SENSE	0x03
#define SPC_CMD_MODESENSE6		0x1A
#define SPC_CMD_MODESENSE10		0x5A
#define SPC_CMD_START_STOP		0x1B

/* BOC */
typedef union _BULK_ONLY_CMD {
	struct {
/*		UINT32	mCBW_Sig;*/
/*		UINT32	mCBW_Tag;*/
		UINT8	mCBW_DataLen0;			/* : ݴ䳤,Чֵ065535 */
		UINT8	mCBW_DataLen1;
		UINT16	mCBW_DataLen2;
		UINT8	mCBW_Flag;				/* : ䷽ȱ־ */
		UINT8	mCBW_LUN;
		UINT8	mCBW_CB_Len;			/* : ĳ,Чֵ116 */
		UINT8	mCBW_CB_Buf[10];		/* : ,ûΪ16ֽ */
	} mCBW;								/* BulkOnlyЭ, CBWṹ */
	struct {
		UINT32	mCSW_Sig;
		UINT32	mCSW_Tag;
		UINT32	mCSW_Residue;			/* : ʣݳ */
		UINT8	mCSW_Status;			/* : ִн״̬ */
		UINT8	mReserved;
	} mCSW;								/* BulkOnlyЭ״̬, CSWṹ */
} BULK_ONLY_CMD;						/* CMD_BulkOnlyCmd, ִлBulkOnlyЭ, ݴôpDISK_BASE_BUF */

typedef BULK_ONLY_CMD xdata BULK_ONLY_CMD_X;

/* FILE: CH374HF?.C */

#define EN_DISK_WRITE			1
#define EN_DISK_FAT12			1
#define EN_DISK_FAT32			1
#define EN_BYTE_ACCESS			1
#define EN_SAVE_VARIABLE		1
#define EN_HUB_DISK				1
#define EN_SEC_SIZE_AUTO		1

#ifndef LIB_CFG_NO_DLY
#define LIB_CFG_NO_DLY			0		/* Ĭ,дʱʽΪ"дʱ" */
#endif
#ifndef LIB_CFG_INT_EN
#define LIB_CFG_INT_EN			0		/* Ĭ,CH374INT#ӷʽΪ"ѯʽ" */
#endif
#ifndef DISK_BASE_BUF_LEN
#define DISK_BASE_BUF_LEN		512		/* ĬϵĴݻСΪ512ֽ,ѡΪ20484096֧ĳЩU,Ϊ0ֹ.Hļж建ӦópDISK_BASE_BUFָ */
#endif

/* ӳṩı */
extern UINT8DV	CH374IntStatus;			/* CH374ж״̬ */
extern UINT8DV	CH374DiskStatus;		/* ̼ļ״̬ */
extern UINT8D	CH374vDiskFat;			/* ߼̵FAT־:1=FAT12,2=FAT16,3=FAT32 */
extern UINT8D	CH374vSecPerClus;		/* ߼̵ÿ */
extern UINT32D	CH374vStartCluster;		/* ǰļĿ¼ʼغ */
extern UINT32D	CH374vFileSize;			/* ǰļĳ */
extern UINT32D	CH374vCurrentOffset;	/* ǰļָ,ǰдλõֽƫ */
extern UINT32X	CH374vDiskRoot;			/* FAT16ΪĿ¼ռ,FAT32ΪĿ¼ʼغ */
extern UINT32X	CH374vDataStart;		/* ߼̵ʼLBA */
extern UINT32X	CH374vFdtLba;			/* ǰFDTڵLBAַ */
extern UINT16D	CH374vFdtOffset;		/* ǰFDTڵƫƵַ */
extern UINT8D	CH374vRetryCount;		/* λ7Ϊ1NAK,Ϊ0NAK,λ5Ϊ1USB洢豸Ϊ6,Ϊ0Ϊ6,λ3λ0ΪԴ */
extern BOOL1	CH374vUsbPidIn;			/* ǰUSBPIDǷΪIN:1=IN,0=OUTSETUP */
extern UINT8D	CH374vDevEndpTog;		/* USB洢豸Ķ˵ͬ־:λ7ӦBIT_HOST_RECV_TOG,λ6ӦBIT_HOST_TRAN_TOG,λ3Ϊ1,λΪ0 */
extern UINT8X	CH374vCurrentLun;		/* USB洢豸ĵǰ߼Ԫ */
extern UINT8D	CH374vDiskRetry;		/* USB洢豸дʧܺԼ,λ7Ϊ1ô̴ȡⲿӿ */
extern UINT8X	CH374vEmbHubIndex;		/* CH374HUBĵǰ˿ں,Ϊ0ڲHUB,Ϊ˿ں */
#ifdef EN_HUB_DISK
extern UINT8X	CH374vHubPortCount;		/* HUBϵĶ˿,Ϊ0ûHUB */
extern UINT8X	CH374vHubPortIndex;		/* HUBϵĵǰ˿ں,λ7Ϊ0Զѯ,Ϊ1ָ˿ں */
#endif
#ifdef EN_SEC_SIZE_AUTO
extern UINT16X	CH374vSectorSize;		/* ̵С */
#else
#define	CH374vSectorSize	512			/* ̵С */
#endif
extern PUINT8X	data	pDISK_BASE_BUF;			/* ָⲿRAMĴݻ,ȲСCH374vSectorSize,Ӧóʼ */
extern UINT32X	CH374v03;				/* ǰ߼̵ʼLBA */

extern UINT8	CH374ReadBlock( void );		/* Ӵ̶ȡݵⲿӿڽ */
#ifdef EN_DISK_WRITE
extern UINT8	CH374WriteBlock( void );	/* ⲿӿڽĶݿд */
#endif

/* ӳṩӳ */
/* ӳ, ļӳCH374File*ʹ̲ѯӳCH374DiskQueryܻõݻpDISK_BASE_BUF,
   пpDISK_BASE_BUFб˴Ϣ, Ա뱣֤pDISK_BASE_BUF;,
   RAM, ҪpDISK_BASE_BUFʱ;, ôʱCH374DirtyBuffer̻ */
extern UINT8	CH374GetVer( void );		/* ȡǰӳİ汾 */
extern UINT8	CH374Init( void );			/* ʼCH374 */
extern void		CH374DelaymS( UINT8 iDelay );	/* ʱָ,255 */
extern UINT8	CH374DiskConnect( void );	/* ǷӲ´״̬ */
extern UINT8	CH374DiskReady( void );		/* ѯǷ׼ */
extern void		CH374DirtyBuffer( void );	/* ̻ */
extern UINT8	CH374FileOpen( void );		/* ļöļ */
extern UINT8	CH374FileClose( void );		/* رյǰļ */
#ifdef EN_DISK_WRITE
extern UINT8	CH374FileErase( void );		/* ɾļر */
extern UINT8	CH374FileCreate( void );	/* ½ļ,ļѾɾ½ */
#endif
extern UINT8	CH374FileModify( void );	/* ѯ޸ĵǰļϢ */
extern UINT8	CH374FileLocate( void );	/* ƶǰļָ */
extern UINT8	CH374FileReadX( void );		/* ӵǰļȡݵָ */
#ifdef EN_DISK_WRITE
extern UINT8	CH374FileWriteX( void );	/* ǰļдָ */
#endif
#ifdef EN_BYTE_ACCESS
extern UINT8	CH374ByteLocate( void );	/* ֽΪλƶǰļָ */
extern UINT8	CH374ByteRead( void );		/* ֽΪλӵǰλöȡݿ */
#ifdef EN_DISK_WRITE
extern UINT8	CH374ByteWrite( void );		/* ֽΪλǰλдݿ */
#endif
#endif
extern UINT8	CH374DiskSize( void );		/* ѯ */
extern UINT8	CH374DiskQuery( void );		/* ѯϢ */
#ifdef EN_SAVE_VARIABLE
extern void		CH374SaveVariable( void );	/* //ָӳı,ӳڶCH374оƬ֮л */
#endif
extern UINT8	CH374BulkOnlyCmd( void );	/* ִлBulkOnlyЭ */
extern UINT8	CH374HostTransact( void );	/* ,ԤCH374UsbPidIn,PID+ĿĶ˵ַ,ͬ־,ͬCH375(USB_INT_SUCCESSΪERR_SUCCESS),NAK */
extern UINT8	CH374CtrlTransfer( void );	/* ִпƴ,Ԥд8ֽ,շpDISK_BASE_BUF */
extern UINT8	CH374EmbHubAttach( void );  /* 鵱ǰHUB˿ǷUSB豸,:0豸,0豸,( BIT_HUB0_ATTACH | BIT_HUB0_EN )豸δ仯 */
extern void		CH374EmbHubEnable( void );	/* HUB˿, : CH374vEmbHubIndex HUBĲ˿ں */

extern UINT8	CH374_READ_REGISTER( UINT8 mAddr );					/* ָĴȡ */
extern void		CH374_WRITE_REGISTER( UINT8 mAddr, UINT8 mData );	/* ָĴд */
extern void		CH374_READ_BLOCK( UINT8 mAddr, UINT8 mLen, PUINT8X mBuf );	/* ָʼַݿ */
extern void		CH374_WRITE_BLOCK( UINT8 mAddr, UINT8 mLen, PUINT8X mBuf );	/* ָʼַдݿ */
extern PUINT8X	CH374_READ_BLOCK64( UINT8 mAddr, PUINT8X mBuf );	/* ˫64ֽڵݿ,صǰַ */
#ifdef EN_DISK_WRITE
extern PUINT8X	CH374_WRITE_BLOCK64( UINT8 mAddr, PUINT8X mBuf );	/* ˫д64ֽڵݿ,صǰַ */
#endif
extern void		CH374_WRITE_BLOCK_C( UINT8 mLen, PUINT8C mBuf );	/* RAM_HOST_TRANд볣ݿ */

/* ͷļΪCH374ӳҪI/OڴԴ,ҪӲйصĿ,
   ļǱĿĶԴΪͷļ,ôӦֻһͷļԴͲ,
   ֮ͷļӦñȶCH374HF_NO_CODE,ӶֹͷļظĿ,:
#define		CH374HF_NO_CODE		1
#include	CH374HF?.H
*/
#ifdef CH374HF_NO_CODE

extern UINT8XV CH374_IDX_PORT;				/* CH374˿ڵI/Oַ */
extern UINT8XV CH374_DAT_PORT;				/* CH374ݶ˿ڵI/Oַ */
extern CMD_PARAM_I mCmdParam;				/*  */
extern BULK_ONLY_CMD_X mBOC;				/* BOЭ */
#if DISK_BASE_BUF_LEN
extern UINT8X  DISK_BASE_BUF[ DISK_BASE_BUF_LEN ];	/* ⲿRAMĴݻ,Ϊһĳ */
#endif
#ifdef FILE_DATA_BUF_LEN
extern UINT8X  FILE_DATA_BUF[ FILE_DATA_BUF_LEN ];	/* ⲿRAMļݻ,ȲСһζдݳ */
extern UINT8	CH374FileRead( void );		/* ӵǰļȡ */
#ifdef EN_DISK_WRITE
extern UINT8	CH374FileWrite( void );		/* ǰļд */
#endif
#endif
#ifndef NO_DEFAULT_CH374_F_ENUM
extern UINT8	CH374FileEnumer( void );	/* öļ */
#endif
#ifndef NO_DEFAULT_CH374_F_QUERY
extern UINT8	CH374FileQuery( void );		/* ѯǰļϢ */
#endif
#ifndef NO_DEFAULT_CH374_RESET
extern void		CH374Reset( void );			/* λCH374 */
#endif
extern void xQueryInterrupt( void );		/* ⲿıCH374õӳ,ѯCH374ж */
#ifdef EN_DISK_WRITE
extern void xDelayAfterWrite( void );		/* ⲿıCH374õӳ,дʱ */
#endif
extern void xFileNameEnumer( void );		/* ⲿıCH374õӳ,ļöٻصӳ */
extern UINT8 CH374LibInit( void );			/* ʼCH374CH374оƬ,ɹ0 */

#else

UINT8XV CH374_IDX_PORT _at_ CH374_IDX_PORT_ADDR;	/* CH374˿ڵI/Oַ */
UINT8XV CH374_DAT_PORT _at_ CH374_DAT_PORT_ADDR;	/* CH374ݶ˿ڵI/Oַ */
CMD_PARAM_I mCmdParam;					/*  */
BULK_ONLY_CMD_X mBOC;					/* BOЭ */
#if DISK_BASE_BUF_LEN
#ifdef DISK_BASE_BUF_ADDR
UINT8X  DISK_BASE_BUF[ DISK_BASE_BUF_LEN ] _at_ DISK_BASE_BUF_ADDR;	/* ⲿRAMĴݻ,Ϊһĳ */
#else
UINT8X  DISK_BASE_BUF[ DISK_BASE_BUF_LEN ];	/* ⲿRAMĴݻ,Ϊһĳ */
#endif
#endif
#ifdef FILE_DATA_BUF_LEN
#ifdef FILE_DATA_BUF_ADDR
UINT8X  FILE_DATA_BUF[ FILE_DATA_BUF_LEN ] _at_ FILE_DATA_BUF_ADDR;	/* ⲿRAMļݻ,ȲСһζдݳ */
#else
UINT8X  FILE_DATA_BUF[ FILE_DATA_BUF_LEN ];	/* ⲿRAMļݻ,ȲСһζдݳ */
#endif
UINT8	CH374FileRead( void )		/* ӵǰļȡ */
{
	mCmdParam.ReadX.mDataBuffer = &FILE_DATA_BUF[0];  /* ָļݻ */
	return( CH374FileReadX( ) );
}
#ifdef EN_DISK_WRITE
UINT8	CH374FileWrite( void )		/* ǰļд */
{
	mCmdParam.WriteX.mDataBuffer = &FILE_DATA_BUF[0];  /* ָļݻ */
	return( CH374FileWriteX( ) );
}
#endif
#endif

/* ³ԸҪ޸ */

#ifndef NO_DEFAULT_CH374_IO			/* ӦóжNO_DEFAULT_CH374_IOԽֹĬϵCH374ӿڳ,Ȼбдĳ */
#define CH374_WRITE_INDEX( c )		{ CH374_IDX_PORT = ( c ); }	/* дַ */
#define CH374_WRITE_DATA( c )		{ CH374_DAT_PORT = ( c ); }	/* дҵַ */
#define CH374_READ_DATA( )			( CH374_DAT_PORT )			/* ҵַ */
#define CH374_READ_DATA0( )			( CH374_IDX_PORT )			/* ҵַ */
#endif

#ifndef NO_DEFAULT_CH374_F_ENUM			/* ӦóжNO_DEFAULT_CH374_F_ENUMԽֹĬϵöļ,Ȼбдĳ */
UINT8	CH374FileEnumer( void )			/* öļ */
{
	UINT8	status;
	status = CH374FileOpen( );
	if ( status == ERR_FOUND_NAME ) status = ERR_SUCCESS;  /* ɹ */
	return( status );
}
#endif

#ifndef NO_DEFAULT_CH374_F_QUERY		/* ӦóжNO_DEFAULT_CH374_F_QUERYԽֹĬϵĲѯǰļϢ,Ȼбдĳ */
UINT8	CH374FileQuery( void )			/* ѯǰļϢ */
{
	PUINT8I	buf;
	UINT8	count;
	buf = (PUINT8I)( & mCmdParam.Modify.mFileSize );
	for ( count = sizeof( mCmdParam.Modify ); count != 0; count -- ) {
		*buf = 0xFF;  /* ȫЧ,ѯ޸ */
		buf ++;
	}
	return( CH374FileModify( ) );
}
#endif

#ifndef NO_DEFAULT_CH374_RESET			/* ӦóжNO_DEFAULT_CH374_RESETԽֹĬϵCH374λ,Ȼбдĳ */
void	CH374Reset( void )				/* λCH374,ӲλCH374InitCH374LibInit³ʼ */
{
	CH374_WRITE_REGISTER( REG_SYS_CTRL, 0 );  /* ƼĴ */
	CH374_WRITE_REGISTER( REG_SYS_CTRL, BIT_CTRL_RESET_NOW );  /* оƬλ */
	CH374DelaymS( 5 );  /* ʱ5 */
	CH374_WRITE_REGISTER( REG_SYS_CTRL, 0 );  /* λ */
	CH374DelaymS( 5 );  /* ʱ5 */
}
#endif

#ifndef NO_DEFAULT_CH374_INT			/* ӦóжNO_DEFAULT_CH374_INTԽֹĬϵжϴ,Ȼбдĳ */
#if LIB_CFG_INT_EN == 0					/* CH374INT#ӷʽΪ"ѯʽ" */
void xQueryInterrupt( void )			/* ѯCH374ж */
{
#ifdef CH374_INT_WIRE					/* CH374ж */
	while ( CH374_INT_WIRE );  /* CH374жߵƽȴ */
#else									/* δCH374ж */
	while ( ( CH374_READ_REGISTER( REG_INTER_FLAG ) & ( BIT_IF_DEV_DETECT | BIT_IF_TRANSFER ) ) == 0 );  /* ѯжϱ־Ĵ */
#endif
}
#else									/* LIB_CFG_INT_EN != 0, CH374INT#ӷʽΪ"жϷʽ" */
void xQueryInterrupt( void )			/* ѯж״̬,ȴӲж */
{
	while ( CH374IntStatus == 0 );  /* ӳøӳ֮ǰCH374IntStatus=0,ӲжϺ,жϷΪ0ʵж״̬󷵻 */
}
void	CH374Interrupt( void ) interrupt CH374_INT_NO using 1	/* CH374жϷ,ʹüĴ1,CH374INT#ĵ͵ƽ½شƬж */
{
	CH374IntStatus = 1;  /* ѽյCH374жñ־ */
#ifdef CLEAR_INT_MARK
	CLEAR_INT_MARK( );  /* ĳЩƬҪжϱ־ */
#endif
}
#endif
#endif

#ifdef EN_DISK_WRITE
#ifndef NO_DEFAULT_DELAY_WRITE			/* ӦóжNO_DEFAULT_DELAY_WRITEԽֹĬϵдʱ,Ȼбдĳ */
void xDelayAfterWrite( void )			/* дʱ */
{
#if LIB_CFG_NO_DLY == 0					/* дʱ */
	UINT8	count;
	for ( count = 250; count != 0; count -- );  /* ʱ200uS,2x333nS@36MHz&12T */
#endif
}
#endif
#endif

#ifndef NO_DEFAULT_FILE_ENUMER			/* ӦóжNO_DEFAULT_FILE_ENUMERԽֹĬϵļöٻص,Ȼбдĳ */
void xFileNameEnumer( void )			/* ļöٻصӳ */
{
/* ָöCH374vFileSizeΪ0xFFFFFFFFFileOpenôÿһļFileOpenñص
   صxFileNameEnumerغFileOpenݼCH374vFileSizeöֱļĿ¼ǣ
   ڵFileOpen֮ǰһȫֱΪ0FileOpenص󣬱CH374vFdtOffsetõṹFAT_DIR_INFO
   ṹеDIR_AttrԼDIR_NameжǷΪļĿ¼¼Ϣȫֱ
   FileOpenغжϷֵERR_MISS_FILEERR_FOUND_NAMEΪɹȫֱΪЧļ
   ڱصxFileNameEnumerнCH374vFileSizeΪ1ô֪ͨFileOpenǰǻص */
#if 0
#ifdef FILE_DATA_BUF_LEN
	UINT8			i;
	UINT16			FileCount;
	P_FAT_DIR_INFO	pFileDir;
	PUINT8X			NameBuf;
	pFileDir = (P_FAT_DIR_INFO)( pDISK_BASE_BUF + CH374vFdtOffset );  /* ǰFDTʼַ */
	FileCount = (UINT16)( 0xFFFFFFFF - CH374vFileSize );  /* ǰļö,CH374vFileSizeֵ0xFFFFFFFF,ҵļݼ */
	if ( FileCount < FILE_DATA_BUF_LEN / 12 ) {  /* 黺Ƿ㹻,ٶÿļռ12ֽڴ */
		NameBuf = & FILE_DATA_BUF[ FileCount * 12 ];  /* 㱣浱ǰļĻַ */
		for ( i = 0; i < 11; i ++ ) NameBuf[ i ] = pFileDir -> DIR_Name[ i ];  /* ļ,Ϊ11ַ,δո */
		if ( pFileDir -> DIR_Attr & ATTR_DIRECTORY ) NameBuf[ i ] = 1;  /* жĿ¼ */
		NameBuf[ i ] = 0;  /* ļ */
	}
#endif
#endif
}
#endif

#ifdef EXT_SEC_INTERFACE
UINT8 xDiskSectorAccess( PUINT32I mLba, UINT8 mMode )	/* ӳCH374ӳ,Ϊλȡ */
{
#if 0
	UINT8	SectCnt;
	UINT8	OpCmd;
	UINT32	StartLba;
	PUINT8X	DataBuf;
	StartLba = *mLba;  /* дʼ */
	switch ( mMode ) {
		case 0:  /* һpDISK_BASE_BUF */
			SectCnt = 1;
			DataBuf = pDISK_BASE_BUF;
			OpCmd = CMD_READ_SECTOR;
/* ʧܱCH374DirtyBuffer( ) */
			break;
		case 1:  /* pDISK_BASE_BUFдһ */
			SectCnt = 1;
			DataBuf = pDISK_BASE_BUF;
			OpCmd = CMD_WRITE_SECTOR;
/* ʧܱCH374DirtyBuffer( ) */
			break;
		case 2:  /* mCmdParam.ReadX.mLbaCountmCmdParam.ReadX.mDataBuffer */
			SectCnt = mCmdParam.ReadX.mLbaCount;
			DataBuf = mCmdParam.ReadX.mDataBuffer;
			OpCmd = CMD_READ_SECTOR;
/* mCmdParam.ReadX.mDataBuffer(ۼƻַ)CH374vCurrentOffset(ۼļָ)mCmdParam.ReadX.mSectorCount(ۼ) */
			break;
		case 3:  /* mCmdParam.WriteX.mDataBufferдmCmdParam.WriteX.mLbaCount */
			SectCnt = mCmdParam.WriteX.mLbaCount;
			DataBuf = mCmdParam.WriteX.mDataBuffer;
			OpCmd = CMD_WRITE_SECTOR;
/* mCmdParam.WriteX.mDataBuffer(ۼƻַ)CH374vCurrentOffset(ۼļָ)mCmdParam.WriteX.mSectorCount(ۼ) */
			break;
		default:
			return( ERR_CH374_ERROR );  /* δ֪ */
	}
/* Ϊλжд,ʼΪStartLba,ΪSectCnt,ΪDataBuf */
#else
	mLba++;
	mMode++;
#endif
	return( ERR_SUCCESS );
}
#endif

UINT8	CH374LibInit( void )  /* ʼCH374CH374оƬ,ɹ0 */
{
	if ( SP > 0xEE ) return( 0xFC );  /* ƬĶջռ䲻,CH374ӳ7ӳ,ѯʽҪ14ֽڵĶջռ,ṩ */
	if ( CH374GetVer( ) < CH374_LIB_VER ) return( 0xFF );  /* ȡǰӳİ汾,汾̫򷵻ش */
#if DISK_BASE_BUF_LEN
	pDISK_BASE_BUF = & DISK_BASE_BUF[0];  /* ָⲿRAMĴݻ */
#endif
	return( CH374Init( ) );  /* ʼCH374 */
}

#endif

#ifdef __cplusplus
}
#endif

#endif
