// I1APLAY.C
// This program reads in _BUFFER_SIZE bytes from _FILE_NAME.
// A request is made to int 1Ah to play the sound data from
// _FILE_NAME.
// 
// NOTE : Before this program can be executed, INT1ATSR.EXE
//        must be loaded into memory.
//
#include <dos.h>
#include <fcntl.h>
#include <errno.h>
#include "cvxutil.h"

#define _FILE_NAME    "TEST1.V8" // Sound data file.
#define _BUFFER_SIZE  0x8000     // Bytes to read from file.

BYTE    buffer[_BUFFER_SIZE];    // Buffer to store data
                                 // read from _FILE_NAME.

VOID main( VOID )
{
   WORD   fileHandle;
   LONG   bytesRead;
   BYTE   carryFlag;

   // Prompt user to hit a key to begin playback.
   printf( "Hit any key to begin playback.\n" );
         
   // Wait for keystroke.
   while( !kbhit() );
         
   // Clear keystroke(s) from keyboard buffer.
   while( kbhit() )
      getch();
         
   // Notify user that playback has begun.
   printf( "Playing sound file ..." );

   // Open file containing sound data.
   if( cvxFileOpen( _FILE_NAME, _OPEN_R_ONLY, &fileHandle) )
   {
      printf(" ERROR : file %s not found\n", _FILE_NAME );
      exit(0);
   }

   // Read sound data from file.
   cvxFileRead( fileHandle, buffer,
                ( LONG )_BUFFER_SIZE, &bytesRead );

   do
   {
      _asm   mov   bx, SEG buffer             // Load ES:BX with 
      _asm   mov   es, bx                     // segment and offset
      _asm   mov   bx, OFFSET buffer          // of buffer.
   
      _asm   mov   cx, word ptr bytesRead     // Set buffer length.
   
      _asm   mov   dx, 9622                   // Set sample rate.
   
      _asm   mov   al, 4                      // Set volume.
                                            
      _asm   mov   ah, 83h                    // Output sound.
      _asm   int   1Ah                        //
   
      _asm   lahf                             // Get carry flag state.
      _asm   and   ah, 1                      // If CF = 1 we need to
      _asm   mov   carryFlag, ah              // try request again.

   }while( carryFlag );

   // Loop here until all output is completed.
   do
   {
      _asm   mov   ah, 81h                    // Check sound status.
      _asm   int   1Ah               

      _asm   lahf                             // Get carry flag state.
      _asm   and   ah, 1                      //
      _asm   mov   carryFlag, ah              //

   }while( carryFlag );
   
   // Notify user that playback has completed.
   printf( " complete.\n" );
    
   // Uninitialize the sound i/o facility.
   //
   _asm     mov   ah, 84h         
   _asm     int   1Ah


   // Close sound file.
   cvxFileClose( fileHandle );

}



