// MIDIFTCH.C
// This program initializes the Covox MIDI system, retrieves a
// byte from the MIDI queue using the midiFetchByte function, 
// then calls the midiUninit function when finished.

#include "cvxmidi.h"

extern BYTE midiByteReady;
extern WORD midiBytesInQueue;

VOID main( VOID )
{
   // Set up the MIDI system with the default port and IRQ channel values.
   midiInit( _MIDI_PORT_A, _IRQ_2 );

   // Wait for a keypress to terminate routine.
   while( !kbhit() )
   {
      // If a byte is ready, print out the byte and the number 
      // of bytes in the queue.
      if( midiByteReady )
         printf( "MIDI Byte: %x Number Of Bytes In Queue: %x\n", midiFetchByte(), midiBytesInQueue );
   }

   // Uninitialize the MIDI system.
   midiUninit();
}





