// RECORD3S.C
// This program uses the non-DMA record3s function. Memory is 
// allocated for the record, the recording is performed, and the
// recorded buffer is written to a file. The memory allocated for
// the record buffer is freed.

#include <stdio.h>
#include <conio.h>
#include "cvxdigi.h"
#include "cvxutil.h"

#define _BUFFER_SIZE      0x8000
#define _SOUND_FILE      "TEST1.V3S"

VOID main( VOID )
{
   LONG      bytesRecorded;
   HANDLE    fileHandle;
   LONG      bytesWritten;
   LONG      bytesAvailable;
   LPSTR     recordBuffer;

   // Allocate memory for recording buffer. Segment of
   // allocated memory is returned in bufferSegment.
   recordBuffer = cvxBufferAlloc( ( LONG )_BUFFER_SIZE, &bytesAvailable );

   if( recordBuffer == _NULL )
      printf( "ERROR : Cannot Allocate Memory!!\n" );
   else
   {
      // Prompt user to hit a key to begin recording.
      printf( "Hit any key to begin recording\n" );
      
      // Wait for keystroke.
      while( !kbhit() );

      // Clear keystroke(s) from keyboard buffer.
      while( kbhit() )
         getch();
      
      // Notify user that recording has begun.
      printf( "Recording ..." );

      // Record a file of length _BUFFER_SIZE.
      if( record3s( recordBuffer, ( LONG )_BUFFER_SIZE,
                    _CVX_RATE_DEFAULT, _CVX_VM0,
                    _SILENCE_3, &bytesRecorded ) )
      {
         // Notify user that an error occured during record.
         printf( " aborted. Error during record3s()\n" );
      }
      else
      {
         // Notify user that recording has completed.
         printf( " complete.\n" );
      }

      // If bytesRecorded is not zero, no error was encountered.
      if( bytesRecorded )
      {
         // Open a new file to write sound data into.
         if(cvxFileCreate( _SOUND_FILE, _CREATE_NORMAL, &fileHandle ) )
         {
            printf( "ERROR : Cannot create file.\n" );
            printf( "        Sound data lost.\n" );
         }
         else
         {
            // Write sound data to file.
            cvxFileWrite( fileHandle, recordBuffer, 
                          bytesRecorded, &bytesWritten );

            // Close file containing sound data.
            cvxFileClose( fileHandle );
         }
      }
      else
         printf( "ERROR : Recording failed!\n" );
      
      // Free memory used by buffer.
      if( cvxBufferFree( recordBuffer ) )
         printf( "ERROR : Cannot Free Memory!!\n" );
   }
}




