// UTILBUFR.C
// This program creates a buffer of size _BUFFER_SIZE.
// If the buffer can be created no error message is 
// printed to the screen.

#include <stdio.h>
#include "cvxutil.h"

#define  _BUFFER_SIZE   300000

VOID main( VOID )
{
   LPSTR  bufferStart;
   LONG   bytesAvailable;

   // Allocate memory for buffer.
   bufferStart = cvxBufferAlloc( _BUFFER_SIZE, &bytesAvailable );

   // Make sure no error has occured.
   if( bufferStart == _NULL  )
   {
      printf( "ERROR : requested buffer size larger than" );
      printf( "        available memory.\n\n" );
   }
   else
   {
      printf( "Memory requested = %ld\n", _BUFFER_SIZE );
      printf( "Memory available = %ld\n", bytesAvailable );

      // Free memory
      if( cvxBufferFree( bufferStart ) )
         printf( "ERROR : Memory de-allocation failed.\n" );
   }
}



