// UTILRW.C
// This program writes the contents of one file (_FILE_1)
// into a newly created file (_FILE_2) using the functions
// cvxFileRead() and cvxFileWrite().  The file being copied cannot
// be larger than the available system memory.
// Memory is allocated with the function cvxBufferAlloc.
 
#include <io.h>
#include <dos.h>
#include <errno.h>
#include <stdio.h>
#include <fcntl.h>
#include "cvxutil.h"

#define  _FILE_1      "TEST1.V8"
#define  _FILE_2      "TEST2.V8"

VOID main( VOID )
{
   LPSTR  bufferStart;
   LONG   bufferSize;
   HANDLE handle1, handle2;
   LONG   bytesRead, bytesWritten;
   LONG   bytesAvailable;

   // Open file containing sound data.
   if( cvxFileOpen( _FILE_1, _OPEN_R_ONLY, &handle1 ) )
   {
      printf( "ERROR : file %s not found.\n", _FILE_1 );
      exit( 0 );
   }

   // Set number of bytes to allocate.
   bufferSize = filelength( handle1 );

   // Allocate memory for buffer.
   bufferStart = cvxBufferAlloc( bufferSize, &bytesAvailable );

   // Error handling.
   if( bufferStart == _NULL  )
   {
      printf( "Error allocating memory.\n" );
      printf( "Memory available = %ld\n", bytesAvailable );
      printf( "Memory requested = %ld\n", bufferSize     );
      exit( 0 );
   }

   // Read from file. 
   if( cvxFileRead( handle1, bufferStart, bufferSize, &bytesRead ) )
      printf( "ERROR : Cannot read %s.\n", _FILE_1 );
   else
   {
      // Create new file.
      if( cvxFileCreate( _FILE_2, _CREATE_NORMAL, &handle2 ) )
         printf( "ERROR : Cannot create %s.\n", _FILE_2 );
      else
      {
         // Write to new file.
         if( cvxFileWrite( handle2, bufferStart, bytesRead, 
                        &bytesWritten ) )
            printf( "ERROR : Cannot write to %s.\n", _FILE_2 );
         
         cvxFileClose( handle2 );
      }
   }

   cvxFileClose( handle1 );

   // Free memory used by bufferStart.
   if( cvxBufferFree( bufferStart ) )
      printf( "Error de-allocating memory.\n" );
}





