//*****************************************************************************
//  File              : CVXDIGI.H
//  Date              : January 10, 1992
//  Description       : Covox developers support library header file for
//                      play/record, pack/unpack, dmaPlay/dmaRecord and
//                      tsrplay functions.
//
//  Last update       : March 11, 1992
//  Additional Notes  :
//*****************************************************************************
//             Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          
//*****************************************************************************

#ifndef  _CVXDIGI_DEFINED
#define  _CVXDIGI_DEFINED

#include "cvxdefs.h"

//*****************************************************************************
//   If compiled with Borland C, the header file CVXBRLND.H will be 
//   automatically included.
//*****************************************************************************
#if defined(__TURBOC__)
#include "cvxbrlnd.h"
#endif

//*****************************************************************************
//covox logical port identifiers
//*****************************************************************************
#define _CVX_VM0                0     // Port 0x22X
#define _CVX_VM1                1     // Port 0x24X
#define _CVX_VM2                2     // Port 0x28X
#define _CVX_VM3                3     // Port 0x2CX
#define _CVX_LPT1               4     // LPT 1
#define _CVX_LPT2               5     // LPT 2
#define _CVX_LPT3               6     // LPT 3
#define _CVX_ISP                8     // Internal speaker

//****************************************************************************
//  Enumeration of constants used to sepcify silence range for record and
//  play functions.
//****************************************************************************
enum
{
   _SILENCE_0,                        // No silence encoding.
   _SILENCE_1,                        // For relatively quite environments.
   _SILENCE_2,   
   _SILENCE_3,                        // The default value.
   _SILENCE_4,
   _SILENCE_5                         // For relatively noisy environments. Some
};                                    //     clipping will result at this level.

//****************************************************************************
// play - record format identifiers
//****************************************************************************
#define _FORMAT_V2S             0x82  // 2 bit ADPCM with silence encoding.
#define _FORMAT_V3S             0x83  // 3 bit ADPCM with silence encoding.
#define _FORMAT_V4S             0x84  // 4 bit ADPCM with silence encoding.
#define _FORMAT_V8S             0x88  // 8 bit PCM with silence encoding.
#define _FORMAT_V8              0x08  // 8 bit PCM
#define _FORMAT_VMF             0xFE  // 8 bit PCM old Covox file format.
#define _FORMAT_VOC             0xFF  // .VOC file format.

//*****************************************************************************
//covox sound file header ionformation.
//*****************************************************************************
#define  _HEADER_LENGTH          16   // Length of Covox sound file header.
#define  _HEADER_FORMAT_OFFSET    8   // Offset of format in Covox sound files.
#define  _HEADER_RATE_OFFSET      9   // Offset of rate in Covox sound files.

#define  _HEADER_LENGTH_VMF     132   // Length of VMF file header.
#define  _HEADER_RATE_VMF_OFFSET  4   // Offset of rate in VMF header.
#define  _HEADER_ID_VMF_OFFSET  119   // Offset of VMF ID.

#define  _HEADER_LENGTH_VOC      26   // Length of VOC sound file header.
#define  _VOC_BLOCK_0_LENGTH      1   // Terminator block ID length.
#define  _VOC_BLOCK_1_LENGTH      6   // Voice data block ID length.
#define  _VOC_BLOCK_2_LENGTH      4   // Voice continuation block ID length.
#define  _VOC_BLOCK_3_LENGTH      7   // Silence block ID length.
#define  _VOC_BLOCK_4_LENGTH      6   // Marker block ID length.
#define  _VOC_BLOCK_5_LENGTH      4   // ASCII text block ID length.
#define  _VOC_BLOCK_6_LENGTH      6   // Repeat loop block ID length.
#define  _VOC_BLOCK_7_LENGTH      4   // End Repeat loop block ID length.

#define  _VOC_TERMINATOR          0
#define  _VOC_VOICE_DATA          1
#define  _VOC_VOICE_CONTINUE      2
#define  _VOC_SILENCE             3
#define  _VOC_MARKER              4
#define  _VOC_ASCII_TEXT          5
#define  _VOC_REPEAT              6
#define  _VOC_END_REPEAT          7
#define  _VOC_INVALID_BLOCK_ID    0xFF

#define  _CVX_RATE_DEFAULT      132   // Default I/O rate. (9,622 Hz)
#define  _CVX_RATE_IN_MAXIMUM   209   // Maximum record rate. (25,386 Hz)
#define  _CVX_RATE_OUT_MAXIMUM  229   // Maximum playback rate (44,191 Hz)

#define  _DMA_MAX_IN_QUEUE      4     // Maximum number allowed in DMA queue.

//*****************************************************************************
//   DMA channel identifiers
//*****************************************************************************
#define _DMA_CHANNEL_1          0x01  // Channel 1 identifier
#define _DMA_CHANNEL_3          0x03  // Channel 3 identifier

//*****************************************************************************
// IRQ vector identifiers
//*****************************************************************************
#define _IRQ_2                  0x02  // IRQ 2 identifier 
#define _IRQ_3                  0x03  // IRQ 3 identifier 
#define _IRQ_4                  0x04  // IRQ 4 identifier 
#define _IRQ_5                  0x05  // IRQ 5 identifier 
#define _IRQ_7                  0x07  // IRQ 7 identifier 

//*****************************************************************************
//   Constant used by dmaInit for auto-detection of Port, IRQ, and DMA channel.
//*****************************************************************************
#define _AUTODETECT             -1    

//*****************************************************************************
// DMA (and IRQ) related port offsets 
//*****************************************************************************
#define _DMA_MASK_REGISTER      0x0A  // Used to enable or disable specific
                                      //     DMA channels.
#define _DMA_MODE_REGISTER      0x0B  // Used to setup the DMA transfer.
#define _DMA_CLEAR_REGISTER     0x0C  // Used to reset DMA controller to
                                      //     LSB/MSB format.
#define _DMA_STATUS_REGISTER    0x08  // Used to determine which DMA channel
                                      //     is serviced during testing.
#define _DMA_RESET_REGISTER     0x0D  // DMA controller master reset port.
#define _DMA_CH1_PAGE_REGISTER  0x83  // DMA channel 1 page address register.
#define _DMA_CH1_ADDR_REGISTER  0x02  // DMA channel 1 address register.
#define _DMA_CH1_COUNT_REGISTER 0x03  // DMA channel 1 word count register.
#define _DMA_CH3_PAGE_REGISTER  0x82  // DMA channel 3 page address register.
#define _DMA_CH3_ADDR_REGISTER  0x06  // DMA channel 3 address register.
#define _DMA_CH3_COUNT_REGISTER 0x07  // DMA channel 3 word count register.
#define _IRQ_COMMAND_REGISTER   0x20  // Used to acknowledge interrupts.
#define _IRQ_MASK_REGISTER      0x21  // Used to enable or disable specific.
                                      //     interrupt sources.
#define _COM2_CONTROL_REGISTER  0x04  // Offset from base com2 port for modem
                                      //     control register.
#define _LPT1_CONTROL_REGISTER  0x02  // Offset from base lpt1 port for control
                                      //     register .

//*****************************************************************************
// DMA (and IRQ) related masks and vector numbers
//*****************************************************************************
#define _DMA_MODE_ENABLE        0x48  // Used to set the DMA transfer mode.
#define _DMA_DISABLE_MASK       0x04  // use to disable a DMA channel.
#define _IRQ3_VECTOR            0x0B  // IRQ 3 vector number. 
#define _IRQ4_VECTOR            0x0C  // IRQ 4 vector number.  
#define _IRQ5_VECTOR            0x0D  // IRQ 5 vector number.  
#define _IRQ7_VECTOR            0x0F  // IRQ 7 vector number. 
#define _IRQ3_MASK              0x08  // Determines if IRQ3 is the interrupt.
#define _IRQ4_MASK              0x10  // Determines if IRQ4 is the interrupt.
#define _IRQ5_MASK              0x20  // Determines if IRQ5 is the interrupt.
#define _IRQ7_MASK              0x80  // Determines if IRQ7 is the interrupt.
#define _IRQ3_ENABLE_MASK       0xF7  // For enabling IRQ 3 via 8259 mask reg.
#define _IRQ4_ENABLE_MASK       0xEF  // For enabling IRQ 4 via 8259 mask reg.
#define _IRQ5_ENABLE_MASK       0xD7  // For enabling IRQ 5 via 8259 mask reg.
#define _IRQ7_ENABLE_MASK       0x7F  // For enabling IRQ 7 via 8259 mask reg.
#define _IRQ3_DISABLE_MASK      0x08  // For disabling IRQ 3 via 8259 mask reg.
#define _IRQ4_DISABLE_MASK      0x10  // For disabling IRQ 4 via 8259 mask reg.
#define _IRQ5_DISABLE_MASK      0x20  // For disabling IRQ 5 via 8259 mask reg.
#define _IRQ7_DISABLE_MASK      0x80  // For disabling IRQ 7 via 8259 mask reg.
#define _COM2_DISABLE_MASK      0xF7  // For disabling interrupts from COM 2.
#define _LPT1_DISABLE_MASK      0xEf  // For disabling interrupts from LPT 1.


//****************************************************************************
// Error codes for play and record functions.
//*****************************************************************************
#undef  _ERROR_NONE
#define _ERROR_NONE  0

// NOTE : Starting offset for all play and record functions errors is 1000.
enum
{
   _ERROR_PORT_INIT_FAILED = 1000,    // Unable to find specified port.
   _ERROR_INVALID_BUFFER_SIZE,        // bufferSize was found to be zero or
                                      //    less than 16.
   _ERROR_INVALID_FORMAT,             // Buffer format different from play call.
   _ERROR_PLAY8_BUSY                  // play8 function already active.
};

//****************************************************************************
//  Prototypes for low level routines used by all Play and Record routines.
//****************************************************************************
#ifdef __cplusplus
extern "C" {
#endif

WORD   playByteInit      ( WORD, BYTE, BOOL, WORD );
WORD   recordByteInit    ( WORD, BYTE, BOOL );
VOID   playByte          ( BYTE );
BYTE   recordByte        ( VOID );
WORD   playUninit        ( VOID );
WORD   recordUninit      ( VOID );

//****************************************************************************
//  Prototypes for all Play and Record routines.
//****************************************************************************
WORD   play2s            ( LPSTR, LONG, BYTE, WORD, BOOL, BOOL );
WORD   play3s            ( LPSTR, LONG, BYTE, WORD, BOOL, BOOL );
WORD   play4s            ( LPSTR, LONG, BYTE, WORD, BOOL, BOOL );
WORD   play8             ( LPSTR, LONG, BYTE, WORD, BOOL );
WORD   play8s            ( LPSTR, LONG, BYTE, WORD, BOOL, BOOL );
WORD   playAny           ( LPSTR, LONG, BYTE, WORD, BOOL, BOOL );

WORD   record2s          ( LPSTR, LONG, BYTE, WORD, WORD, LONG * );
WORD   record3s          ( LPSTR, LONG, BYTE, WORD, WORD, LONG * );
WORD   record4s          ( LPSTR, LONG, BYTE, WORD, WORD, LONG * );
WORD   record8           ( LPSTR, LONG, BYTE, WORD, LONG * );
WORD   record8s          ( LPSTR, LONG, BYTE, WORD, WORD, LONG * );



WORD   playFile          ( HANDLE fileHandle, BYTE fileFormat, BYTE playbackRate,
                           WORD   portOut,    BOOL noiseFlag,  BOOL trebleFlag,
                           BOOL   hookKBFlag, LONG bufferSize );


WORD   recordFile        ( HANDLE fileHandle,   BYTE fileFormat, BYTE recordRate,  
                           WORD   silenceRange, BOOL hookKBFlag,
                           WORD   portIn,       LONG bufferSize );

WORD   playVoc           ( HANDLE fileHandle, BYTE fileFormat, BYTE playbackRate,
                           WORD   portOut,    BOOL noiseFlag,  BOOL trebleFlag,
                           BOOL   hookKBFlag, LONG bufferSize );

#ifdef __cplusplus
}
#endif

//****************************************************************************
//  Data structure and prototypes for unpackFirst and unpackNext
//****************************************************************************
//****************************************************************************
// Error codes for DMA functions.
//*****************************************************************************
// NOTE : Starting offset for pack/unpack functions errors is 2000.
enum
{
   _ERROR_DURING_UNPACK_FIRST = 2000,
   _ERROR_DURING_UNPACK_NEXT,
   _ERROR_DURING_PACK_FIRST,
   _ERROR_DURING_PACK_NEXT
};

typedef struct _tagCovertDataStruct
{
   LPSTR    sourcePointer;     
   LONG     sourceLength;        
   LONG     sourceUsed;        
   LPSTR    destinationPointer;
   LONG     destinationLength; 
   LONG     destinationFilled;  
   WORD     bufferFormat;              
   BYTE     sampleRate;                 
   WORD     silenceRange;              
   BOOL     trebleFlag;              
   BOOL     noiseFlag;           
} _CONVERT_DATA;

#ifdef __cplusplus
extern "C" {
#endif

WORD   unpackFirst       ( _CONVERT_DATA far * );
WORD   unpackNext        ( _CONVERT_DATA far * );
WORD   packFirst         ( _CONVERT_DATA far * );
WORD   packNext          ( _CONVERT_DATA far * );


#ifdef __cplusplus
}
#endif

//****************************************************************************
// Error codes for DMA functions.
//*****************************************************************************
// NOTE : Starting offset for all DMA functions errors is 3000.
enum
{
   _ERROR_DMA_DETECT_FAILED = 3000,   // VM port, IRQ and channel not found.
   _ERROR_DMA_ALREADY_INITIALIZED,    // dmaInit called more than once.
   _ERROR_DMA_NOT_INITIALIZED,        // dmaInit not called first or DMA could
                                      //    not be initialized. 
   _ERROR_QUEUE_FULL                  // No room in queue for DMA I/O request.
};


//****************************************************************************
//  Prototypes for DMA play and record routines.
//****************************************************************************
#ifdef __cplusplus
extern "C" {
#endif

WORD   dmaPlay           ( LPSTR, LONG, BYTE, WORD );
WORD   dmaRecord         ( LPSTR, LONG, BYTE );

WORD   dmaRecordFile     ( HANDLE fileHandle,   BYTE fileFormat, BYTE recordRate,
                           WORD   portIn,       WORD channel,  WORD irqNumber,
                           BOOL   silenceRange, BOOL hookKBFlag,
                           LONG   bufferSize,   WORD bufferCount );

WORD   dmaPlayFile       ( HANDLE fileHandle, BYTE fileFormat, BYTE playbackRate,
                           WORD   portOut,    WORD channel,    WORD irqNumber,  
                           BOOL   noiseFlag,  BOOL trebleFlag, BOOL hookKBFlag,
                           LONG   bufferSize, WORD bufferCount );

WORD   dmaPlayVoc       (  HANDLE fileHandle, BYTE fileFormat,  BYTE playbackRate,
                           WORD   portOut,    WORD channel,     WORD irqNumber,  
                           BOOL   noiseFlag,  BOOL trebleFlag,  BOOL hookKBFlag,
                           LONG   bufferSize, WORD bufferCount );


WORD   dmaSetRate        ( BYTE );
WORD   dmaIRQReset       ( VOID );
WORD   dmaEnable         ( VOID );
WORD   dmaDisable        ( VOID );
WORD   dmaInit           ( WORD, WORD, WORD, WORD * );
WORD   dmaUninit         ( VOID );
BOOL   dmaPause          ( VOID );
BOOL   dmaUnpause        ( VOID );

//  Voice Master and Sound Master II port detection functions.
WORD   dmaPortDetect     ( WORD );

// Functions called after dmaInit to find active DMA settings
WORD   dmaGetPort        ( WORD * );
WORD   dmaGetChannel     ( WORD * );
WORD   dmaGetIRQNumber   ( WORD * );

//  I/O Queue Management
WORD   dmaNumberInQueue  ( VOID );
WORD   dmaBytesRemaining ( VOID );
WORD   dmaFlushQueue     ( VOID );

#ifdef __cplusplus
}
#endif

//****************************************************************************
// TSRPLAY header information
//****************************************************************************
//
#define _BUFFER_SIZE_MIN      1       // Minimum and maximum size in K bytes 
#define _BUFFER_SIZE_MAX      64      //     allowed for each TSRPLAY buffer.
#define _BUFFER_COUNT_MIN     2       // Minimum number of  DMA buffers.
#define _BUFFER_COUNT_MAX     5       // Maximum number of DMA buffers.
#define _FILE_REPEAT_MAX      255     // Maximum value for the
                                      //     variable fileRepeatCount.
#define _RATE_MINIMUM         4679    // Minimum and maximum rate setting 
#define _RATE_MAXIMUM         44191   //     allowed in the array fileRate[].
#define _FILE_COUNT_MAX       35      // This constant specifies the maximum
                                      //     for playback in TSRPLAY.
#define _FILE_PATH_LENGTH     80      // Maximum length of file and path.

//****************************************************************************
// Error codes for TSRPLAY
//*****************************************************************************
// NOTE : Starting offset for all TSRPLAY errors is 4000.
enum
{
   _ERROR_ALREADY_RESIDENT = 4000, // A call was made to tsrStart after
                                   //     TSRPLAY had been previously installed.
   _ERROR_FILE_COUNT,              // _TSRPLAY_INFO.fileCount is out of range.
   _ERROR_OPENING_FILE,            // _TSRPLAY_INFO.fileName not found or 
                                   //     error opening file.
   _ERROR_ILLEGAL_BUFFER_SIZE,     // _TSRPLAY_INFO.bufferSize is out of range.
   _ERROR_ILLEGAL_BUFFER_COUNT,    // _TSRPLAY_INFO.bufferCount is out of range.
   _ERROR_ILLEGAL_PORT,            // _TSRPLAY_INFO.dmaPort is not valid.
   _ERROR_ILLEGAL_DMA_CHANNEL,     // _TSRPLAY_INFO.dmaChannel is not valid.
   _ERROR_ILLEGAL_IRQ,             // _TSRPLAY_INFO.dmaIRQNumber is not valid.
   _ERROR_DMA_INIT_FAILED,         // Initialization of DMA failed.
   _ERROR_DMA_UNINIT_FAILED,       // Uninitialization of DMA failed.
   _ERROR_DMA_PLAY_FAILED,         // Insert DMA queue playback request failed.
   _ERROR_WRONG_DOS_VERSION        // DOS version is less than 3.1
};

//**********************************************************************
// Structure containing all information needed to call TSRPLAY interface
// functions.
//
typedef struct _tagtsrPlayInfo
{
   WORD    fileCount;                   // Number of files queued for playback.

   BYTE    fileName[ _FILE_COUNT_MAX ][ _FILE_PATH_LENGTH ]; // Playback files.

   WORD    fileRate[_FILE_COUNT_MAX];   // Rate for each file in fileName.
   WORD    fileRepeat[_FILE_COUNT_MAX]; // Stores the number of times to 
                                        //    playback list of files.
   WORD    bufferSize;                  // Size of each buffer to be queued up 
                                        //    for DMA playback.
   WORD    bufferCount;                 // Number of buffers to be queued for 
                                        // DMA playback at one time.
   WORD    dmaPort;                     // Variables for DMA i/o of PCM data.
   WORD    dmaChannel;                  //
   WORD    dmaIRQNumber;                //
} _TSRPLAY_INFO;

extern _TSRPLAY_INFO _tsrPlayInfo;

//**********************************************************************
// TSRPLAY interface function prototypes.
//
#ifdef __cplusplus
extern "C" {
#endif

WORD   tsrStart            ( VOID );
BOOL   tsrResident         ( VOID );
VOID   tsrRemoveSystem     ( VOID );
VOID   tsrPause            ( VOID );
VOID   tsrUnpause          ( VOID );
VOID   tsrFlushFiles       ( VOID );
VOID   tsrSetupNewFiles    ( VOID );
PSTR   tsrGetVersionString ( VOID );
PSTR   tsrGetProgramID     ( VOID );

#ifdef __cplusplus
}
#endif

#endif
//*****************************************************************************
//  end         CVXDIGI.H
//*****************************************************************************
