//****************************************************************************
//  File              : CVXMIDI.H
//  Date              : January 10, 1992
//  Description       : Header file for the MIDI libraries.
//
//  Last update       : March 11, 1992
//  Additional Notes  :
//*****************************************************************************
//             Copyright (c) 1992,  Covox, Inc.  All Rights Reserved          
//*****************************************************************************

#ifndef  _CVXMIDI_DEFINED
#define  _CVXMIDI_DEFINED

#include "cvxdefs.h"

//*****************************************************************************
//   If compiled with Borland C, the header file CVXBRLND.H will be 
//   automatically included.
//*****************************************************************************
#if defined(__TURBOC__)
#include "cvxbrlnd.h"
#endif

#define  _MIDI_PORT_A   0x330 // The valid MIDI ports on the MIDI Maestro and
#define  _MIDI_PORT_B   0x338 // Sound Master II.

#define  _IRQ_2         2     // The available IRQ channels.
#define  _IRQ_3         3     //
#define  _IRQ_5         5     // (only on Sound Master II)
#define  _IRQ_7         7     // (only on Sound Master II)

//*****************************************************************************
//  Prototypes for all Covox MIDI functions.
//*****************************************************************************
#ifdef __cplusplus
extern "C" {
#endif

VOID  midiInit            ( WORD, BYTE );
BYTE  midiFetchByte       ( VOID );
VOID  midiByteOut         ( BYTE );
VOID  midiUninit          ( VOID );

#ifdef __cplusplus
}
#endif

#endif
//*****************************************************************************
//  end         CVXMIDI.H
//*****************************************************************************
